/* march.h      Distribution 1.1   89/3/30   Scry */

/*   The Scry system is copyright (C) 1988, 1989, Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof.     */

#include <stdio.h>
#include <sys/types.h>
#include <memory.h>
#include <math.h>
#ifndef VAX
#include <malloc.h>
#endif

/*#define DEBUG			/* Report diagnostics of each step */
/*#define CHECKMALLOC		/* Use extra malloc diagnostics */
/*#define PARANOIA		/* Get rid of holes that appear */

/* Shut lint up about a few things */
#define Calloc(x,y) (y *)calloc((unsigned)(x), sizeof(y))
#define Fread(a,b,c,d) fread((char *)(a), b, (int)(c), d)
#define Fwrite(a,b,c,d) fwrite((char *)(a), b, (int)(c), d)
#define Fseek(x,y,z) fseek(x, (long)(y), z)
#define Memset(a,b,c) memset((char *)(a), b, (int)(c))
#define Cfree(x) cfree((char *)(x))

#define BIT(n) (1 << (n))
#define EX 00
#define EY 01
#define EZ 02
#define MAXTRIANGLES 4

/* char:  0-127		Booleans, very small integers
 * short: 0-65535	Data dimensions
 * long:  0-2147483647	Numbers of triangles/edges
 */
typedef unsigned char Bool;	/* Boolean */
typedef unsigned char Vectors;	/* Only using lower 4 bits */
/* Collapsing boolean arrays into single data objects:
 */
typedef unsigned long Pix;	/* Boolean flags per cube in data array */
typedef unsigned char Cube;	/* 8 corners/cube ==> 8 bits ==> char */
typedef unsigned short Edges;	/* 12 edges/cube ==> 12 bits ==> short */

struct cube {
    unsigned  cube:8;		/* Eight vertices */
    unsigned  y:9;		/* 512 wide */
    unsigned  z:9;		/* 512 high */
#ifdef PARANOIA
    unsigned  hole:1;		/* Trouble */
    unsigned  dir:3;		/* Which way the hole goes */
    unsigned  side:1;		/* Which side the hole is on */
#endif
};

extern long march(), process_array(), gouraud_tess(), constant_tess(), fake_tess();
extern int render();

/* From data.c:  all the marching cubes nitty gritty. */
extern int initialization_done;
extern Edges cubedges[256][MAXTRIANGLES];
extern Vectors edgenums[15][3];
extern Vectors numtri[256];
extern Vectors numedg[256];
extern Vectors edgecorns[256];
extern Vectors edgecornsi[256];
extern Vectors edgecornsj[256];
extern Vectors edgecornsk[256];
extern Vectors edgecornst[256];
#ifdef PARANOIA
extern Vectors pattern[256];
extern Vectors morebits[256];
#endif
