#include <stdio.h>
#include <Sender.h>
#include <Receiver.h>
#include <sys/socket.h>
#include <errno.h>

/* This program is intended to test if another application as still "alive".
   It takes two arguments:  the hostName on which the remote application is
   supposed to be, and the portNumber on which that application should be
   listening.

   Written by George Drapeau on September 13th, 1990
*/


main(int argc, char** argv)
{
  Sender*	sender;
  Sender*	sender1;
  Receiver*	receiver;
  Selection	select;
  Selection	select1;
  Port		senderPort, testPort;
  char*		filename;
  int		result = 0;
  struct sockaddr	peerStruct;
  int		peerLength;
  
  select.start = 2;
  select.end = 2;
  printf("Starting the test.\n");
  printf("Port number to connect to is %d.\n",atoi(argv[2]));
  senderPort.hostName = argv[1];				    /* Get hostname passed in as argument */
  senderPort.portNumber = PortMgrPortNumber;
  sender = NewSender(&senderPort);				    /* Create a Sender to communicate with the Port Manager */
  receiver = NewReceiver(sender,argv[0],AnyPort);		    /* Register with the Port Manager */
  printf("Connected with the Port Manager.\n");
  
  testPort.hostName = argv[1];					    /* Get the hostname passed in as argument  */
  testPort.portNumber = atoi(argv[2]);				    /* Get the port number for the remote app being tested for */
  sender1 = NewSender(&testPort);				    /* Create a new Sender to send messages to the remote app. */
  SenderGetCurrentDocName(sender1, &filename);			    /* Send a message to the remote app */
  printf ("now out of get current doc \n");			    /* Print the results of the message */
  printf ("current doc = %s\n", filename);
  
  peerLength = sizeof(peerStruct);
  result = getpeername(sender1->clientSocket,&peerStruct,	    /* Use "getpeername()" to see if the remote app is "alive" */
		       &peerLength);
  if (result == -1)						    /* Did the getpeername() call succeed? */
    {								    /* No, print an error message and exit */
    printf("Remote app doesn't seem to be running.\n");
    switch(errno)
      {
    case EBADF:
      printf("EBADF error.\n");
    break;
    case EFAULT:
      printf("EFAULT error.\n");
      break;
    case ENOBUFS:
      printf("ENOBUFS error.\n");
      break;
    case ENOTCONN:
      printf("ENOTCONN error.\n");
      break;
    case ENOTSOCK:
      printf("ENOTSOCK error.\n");
      break;
      }								    /* end switch */
    SenderDisconnectFromPortMgr(sender,&(receiver->receivePort));   /* Disconnect from the Port Manager */
    exit(result);
    }
  else
    {								    /* Yes, print a success message and exit */
    printf("Remote app seems to be running okay.\n");
    SenderDisconnectFromPortMgr(sender,&(receiver->receivePort));   /* Disconnect from the Port Manager */
    exit(result);
    }
}
