/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/vcrEdit/RCS/vcrEditPreview.c,v 0.17 92/09/29 18:07:11 drapeau Exp $ */
/* $Log:	vcrEditPreview.c,v $
 * Revision 0.17  92/09/29  18:07:11  drapeau
 * Minor cosmetic changes to enhance readability and ANSI compliance.
 * 
 * Revision 0.16  92/05/14  00:06:16  drapeau
 * * When previewing an edit, no longer disconnects from and
 *   reconnects with the Port Manager.  Previously, this was done because
 *   of the way the Port Manager tested its communications link with
 *   applications (it did so by trying to send a SenderPing() message,
 *   which would block until the receiving application could reply to
 *   the message).  Now, the Port Manager simply tries to create a
 *   new Sender, which does not require a reply from the receiving application.
 * * Made a number of formatting changes, to conform to coding standards.
 * 
 * Revision 0.15  91/09/26  12:34:14  lim
 * Did casting for xv_get's, etc.
 * 
 * Revision 0.14  91/08/24  18:00:10  lim
 * Implemented PrintDiagnostics. With command line flag '-d', the 
 * app will launch such that it prints all diag messages.
 * 
 * Revision 0.13  91/08/16  12:35:54  lim
 * PlayEdit() will call SenderDisconnectFromPortMgr() and SenderConnectWith
 * PortMgr() if it is a search (start == end).
 * 
 * Revision 0.12  91/08/08  16:34:28  lim
 * 1. Added instance pointer to each public videoObject function call.
 * 2. speedStg is now an array of integers.
 * 3. Duration depends on speed of edit.
 * 
 * Revision 0.11  91/07/20  11:44:16  lim
 * Added PlayEdit, which sets audio and speed before calling
 * DevPlayFromTo.
 * 
 * 
 * Revision 0.10  91/07/16  16:17:20  lim
 * Initial revision.
 *  */

#include "vcrEdit.h"
static char prevrcsid[] = "$Header: /Source/Media/collab/vcrEdit/RCS/vcrEditPreview.c,v 0.17 92/09/29 18:07:11 drapeau Exp $";

/* 	EDIT PREVIEW FUNCTIONS (POPUP WINDOW 3)	*/

/* Plays edit from `start' to `end' using correct settings' */
void PlayEdit(int start, int end)
{
  int speed;
 
  DevSetAudio(myVideo, 3 - currentAudio);			    /* Set audio */
  speed =  xv_get(vcrEdit_editPopup->editSpeedTxt, PANEL_VALUE);
  DevPlayFromTo(myVideo, start, end, speed);			    /* Play segment at set speed */
  return;
}								    /* end function PlayEdit */



/*
 * Menu handler for `previewMenu (Play entire edit)'.
 * Default : Play the current selection from start to end.
 */
Menu_item
  PreviewStartEnd(Menu_item item, Menu_generate op)
{
  int result;
  int start;
  int starthr;
  int startmin; 
  int startsec; 
  int startfr;
  int end;
  int endhr;
  int endmin;
  int endsec;
  int endfr;
  
  switch (op) 
  {
   case MENU_DISPLAY:
    break;
    
   case MENU_DISPLAY_DONE:
    break;
    
   case MENU_NOTIFY:
    if (!SetDuration())						    /* Get start and end frames */
      return item;
    startfr = atoi((char*) xv_get(vcrEdit_editPopup->editStartTxt4, 
				  PANEL_VALUE));
    endfr = atoi((char*) xv_get(vcrEdit_editPopup->editEndTxt4, PANEL_VALUE));
    
    starthr = atoi((char*) xv_get(vcrEdit_editPopup->editStartTxt1, PANEL_VALUE));
    startmin = atoi((char*) xv_get(vcrEdit_editPopup->editStartTxt2, PANEL_VALUE));
    startsec = atoi((char*) xv_get(vcrEdit_editPopup->editStartTxt3, PANEL_VALUE));
    start = ConvertToAddress(starthr, startmin, startsec, startfr);
    
    endhr = atoi((char*) xv_get(vcrEdit_editPopup->editEndTxt1, PANEL_VALUE));
    endmin = atoi((char*) xv_get(vcrEdit_editPopup->editEndTxt2, PANEL_VALUE));
    endsec = atoi((char*) xv_get(vcrEdit_editPopup->editEndTxt3, PANEL_VALUE));
    end = ConvertToAddress(endhr, endmin, endsec, endfr);
    
    result = CheckSelection(start, end);			    /* Check if selection is valid */
    if (result == -1)
      return(item);
    PlayEdit(start, end);
    break;
    
   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}								    /* end function PreviewStartEnd */


/*
 * Notify callback function for `previewPlayFirstButton'.
 * Play the first x seconds of the current selection.
 */
void
  PreviewStart(Panel_item item, Event* event)
{
  int start; 
  int end; 
  int duration;
  int result;
  int starthr; 
  int startmin; 
  int startsec;
  int startfr;
  int endhr; 
  int endmin; 
  int endsec; 
  int endfr;
  int speed;
  
  starthr = atoi((char*) xv_get(vcrEdit_editPopup->editStartTxt1,   /* Get start and end frames */
				PANEL_VALUE));
  startmin = atoi((char*) xv_get(vcrEdit_editPopup->editStartTxt2,
				 PANEL_VALUE));
  startsec = atoi((char*) xv_get(vcrEdit_editPopup->editStartTxt3,
				 PANEL_VALUE));
  startfr = atoi((char*) xv_get(vcrEdit_editPopup->editStartTxt4,
				PANEL_VALUE));
  start = ConvertToAddress(starthr, startmin, startsec, startfr);
  
  endhr = atoi((char*) xv_get(vcrEdit_editPopup->editEndTxt1, PANEL_VALUE));
  endmin = atoi((char*) xv_get(vcrEdit_editPopup->editEndTxt2, PANEL_VALUE));
  endsec = atoi((char*) xv_get(vcrEdit_editPopup->editEndTxt3, PANEL_VALUE));
  endfr = atoi((char*) xv_get(vcrEdit_editPopup->editEndTxt4, PANEL_VALUE));
  end = ConvertToAddress(endhr, endmin, endsec, endfr);
  
  speed = xv_get(vcrEdit_editPopup->editSpeedTxt, PANEL_VALUE);
  result = CheckSelection(start, end);				    /* Check if selection is valid */
  if (result == -1)
    return; 
  duration = xv_get(vcrEdit_previewPopup->previewPlayFirstTxt,	    /* Get the duration to be played */
		    PANEL_VALUE);
  if (end > (start + duration*speed))
    end = start + duration*speed;
  PlayEdit(start, end);
}								    /* end function PreviewStart */



/*
 * Notify callback function for `previewPlayFirstTxt'.
 */
Panel_setting
PreviewStartTxt(item, event)
     Panel_item	item;
     Event		*event;
{
  
  if (event_action(event) != '\r')
    return PANEL_NONE;
  
  if (search == 1)
    search = 0;
  else {
    PreviewStart(item, event);
    search = 1;
  }
}



/* Notify callback function for `previewPlayLastButton'.
 * Play the last x seconds of the current selection.
 */
void
  PreviewEnd(item, event)
Panel_item      item;
Event           *event;
{
  int start;
  int end;
  int duration;
  int result;
  int starthr; 
  int startmin;
  int startsec; 
  int startfr;
  int endhr;
  int endmin; 
  int endsec; 
  int endfr;
  int speed;

  starthr = atoi((char*) xv_get(vcrEdit_editPopup->editStartTxt1,   /* Get start and end frame numbers */
				PANEL_VALUE));
  startmin = atoi((char*) xv_get(vcrEdit_editPopup->editStartTxt2,
				 PANEL_VALUE));
  startsec = atoi((char*) xv_get(vcrEdit_editPopup->editStartTxt3,
				 PANEL_VALUE));
  startfr = atoi((char*) xv_get(vcrEdit_editPopup->editStartTxt4,
				PANEL_VALUE));
  start = ConvertToAddress(starthr, startmin, startsec, startfr);
  
  endhr = atoi((char*) xv_get(vcrEdit_editPopup->editEndTxt1, PANEL_VALUE));
  endmin = atoi((char*) xv_get(vcrEdit_editPopup->editEndTxt2, PANEL_VALUE));
  endsec = atoi((char*) xv_get(vcrEdit_editPopup->editEndTxt3, PANEL_VALUE));
  endfr = atoi((char*) xv_get(vcrEdit_editPopup->editEndTxt4, PANEL_VALUE));
  end = ConvertToAddress(endhr, endmin, endsec, endfr);
  
  speed = xv_get(vcrEdit_editPopup->editSpeedTxt, PANEL_VALUE);
  result = CheckSelection(start, end);				    /* Check if selection is valid */
  if (result == -1)						    /* Error in selection */
    return;
  duration = xv_get (vcrEdit_previewPopup->previewPlayLastTxt,	    /* Get the duration to be played */
		     PANEL_VALUE);
  if (start < (end - duration*speed))
    start = end - duration*speed;
  
  PlayEdit(start, end);
}								    /* end function PreviewEnd */




/*
 * Notify callback function for `previewPlayLastTxt'.
 */
Panel_setting
PreviewEndTxt(item, event)
     Panel_item	item;
     Event		*event;
{
  
  if (event_action(event) != '\r')
    return PANEL_NONE;
  
  if (search == 1)
    search = 0;
  else {
    PreviewEnd(item, event);
    search = 1;
  }
}


/*
 * Notify callback function for `previewDoneButton'.
 * Close the preview popup window
 */
void
PreviewDone(item, event)
     Panel_item      item;
     Event           *event;
{
  xv_set(vcrEdit_previewPopup->previewPopup, FRAME_CMD_PUSHPIN_IN, FALSE, NULL);
  xv_set(vcrEdit_previewPopup->previewPopup, XV_SHOW, FALSE, NULL);

}

