;GIL-3
(
(
	:type                   :menu
	:name                   DisplayTimeMenu
	:help                   ""
	:columns                1
	:menu-type              :exclusive
	:menu-handler           nil
	:menu-title             "Display Time"
	:menu-item-labels       ("Relative" "Absolute" )
	:menu-item-label-types  (:string :string )
	:menu-item-states       (:active :active )
	:menu-item-defaults     (nil nil )
	:initial-selections     (nil nil )
	:menu-item-handlers     (RelativeTimeHandler AbsoluteTimeHandler )
	:menu-item-menus        (nil nil )
	:menu-item-colors       ("Black" "Black" )
	:pinnable               nil
	:user-data              ()
	:actions                (
		(
		:from                   (DisplayTimeMenu "Relative")
		:when                   (Notify )
		:to                     (DisplayTimeMenu "Relative")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (RelativeTimeHandler)
		)
		(
		:from                   (DisplayTimeMenu "Absolute")
		:when                   (Notify )
		:to                     (DisplayTimeMenu "Absolute")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (AbsoluteTimeHandler)
		)
	)
)
(
	:type                   :menu
	:name                   OptionsMenu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             "Options"
	:menu-item-labels       ("About cdEdit ..." "Connect with new Port Manager ..." "Display time" )
	:menu-item-label-types  (:string :string :string )
	:menu-item-states       (:active :active :active )
	:menu-item-defaults     (t nil nil )
	:initial-selections     (nil nil nil )
	:menu-item-handlers     (InfoHandler ConnectPortManagerHandler nil )
	:menu-item-menus        (nil nil DisplayTimeMenu )
	:menu-item-colors       ("Black" "Black" "Black" )
	:pinnable               t
	:user-data              ()
	:actions                (
		(
		:from                   (OptionsMenu "About cdEdit ...")
		:when                   (Notify )
		:to                     (OptionsMenu "About cdEdit ...")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (InfoHandler)
		)
		(
		:from                   (OptionsMenu "Connect with new Port Manager ...")
		:when                   (Notify )
		:to                     (OptionsMenu "Connect with new Port Manager ...")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ConnectPortManagerHandler)
		)
	)
)
(
	:type                   :menu
	:name                   DocumentMenu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             "Document"
	:menu-item-labels       ("Open" "Save" "Save as ... " "Close" "Close this window" )
	:menu-item-label-types  (:string :string :string :string :string )
	:menu-item-states       (:active :active :active :active :active )
	:menu-item-defaults     (nil nil nil nil nil )
	:initial-selections     (nil nil nil nil nil )
	:menu-item-handlers     (OpenFileHandler SaveFileHandler SaveAsFileHandler CloseFileHandler CloseEditPopupHandler )
	:menu-item-menus        (nil nil nil nil nil )
	:menu-item-colors       ("Black" "Black" "Black" "Black" "Black" )
	:pinnable               t
	:user-data              ()
	:actions                (
		(
		:from                   (DocumentMenu "Open")
		:when                   (Notify )
		:to                     (DocumentMenu "Open")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (OpenFileHandler)
		)
		(
		:from                   (DocumentMenu "Save")
		:when                   (Notify )
		:to                     (DocumentMenu "Save")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (SaveFileHandler)
		)
		(
		:from                   (DocumentMenu "Save as ... ")
		:when                   (Notify )
		:to                     (DocumentMenu "Save as ... ")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (SaveAsFileHandler)
		)
		(
		:from                   (DocumentMenu "Close")
		:when                   (Notify )
		:to                     (DocumentMenu "Close")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (CloseFileHandler)
		)
		(
		:from                   (DocumentMenu "Close this window")
		:when                   (Notify )
		:to                     (DocumentMenu "Close this window")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (CloseEditPopupHandler)
		)
	)
)
(
	:type                   :menu
	:name                   PreviewMenu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             "Preview"
	:menu-item-labels       ("Play whole edit" "Play part of edit ..." )
	:menu-item-label-types  (:string :string )
	:menu-item-states       (:active :active )
	:menu-item-defaults     (t nil )
	:initial-selections     (nil nil )
	:menu-item-handlers     (PlayWholeEditHandler PlayPartialEditHandler )
	:menu-item-menus        (nil nil )
	:menu-item-colors       ("Black" "Black" )
	:pinnable               t
	:user-data              ()
	:actions                (
		(
		:from                   (PreviewMenu "Play whole edit")
		:when                   (Notify )
		:to                     (PreviewMenu "Play whole edit")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (PlayWholeEditHandler)
		)
		(
		:from                   (PreviewMenu "Play part of edit ...")
		:when                   (Notify )
		:to                     (PreviewMenu "Play part of edit ...")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (PlayPartialEditHandler)
		)
	)
)
(
	:type                   :base-window
	:name                   window1
	:owner                  nil
	:width                  238
	:height                 386
	:background-color       "Black"
	:foreground-color       ""
	:label                  "cdEdit"
	:label-type             :string
	:initial-state          :open
	:show-footer            t
	:resizable              nil
	:icon-file              "icons/cdEditIcon"
	:icon-label             ""
	:icon-mask-file         ""
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   MainControl
	:owner                  window1
	:help                   ""
	:x                      0
	:y                      0
	:width                  237
	:height                 386
	:background-color       "Light Gray"
	:foreground-color       "Black"
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   OpenOptionsPopupButton
	:owner                  MainControl
	:help                   ""
	:x                      12
	:y                      12
	:width                  80
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "Options"
	:label-type             :string
	:initial-state          :active
	:menu                   OptionsMenu
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   OpenEditPopupButton
	:owner                  MainControl
	:help                   ""
	:x                      104
	:y                      12
	:width                  55
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  " Edit..."
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         Edit
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 OpenEditPopupButton)
		:when                   (Notify )
		:to                     (window1 OpenEditPopupButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Edit)
		)
	)
)
(
	:type                   :button
	:name                   QuitButton
	:owner                  MainControl
	:help                   ""
	:x                      168
	:y                      12
	:width                  57
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  " Quit  "
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         Quit
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 QuitButton)
		:when                   (Notify )
		:to                     (window1 QuitButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Quit)
		)
	)
)
(
	:type                   :message
	:name                   TotalTracksMsg
	:owner                  MainControl
	:help                   ""
	:x                      20
	:y                      48
	:width                  112
	:height                 13
	:foreground-color       "Black"
	:label                  "Total Tracks : 00"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   TimeMsg
	:owner                  MainControl
	:help                   ""
	:x                      140
	:y                      48
	:width                  81
	:height                 13
	:foreground-color       "Black"
	:label                  "Time : 00:00"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   OneButton
	:owner                  MainControl
	:help                   ""
	:x                      16
	:y                      80
	:width                  58
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "    1    "
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         One
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 OneButton)
		:when                   (Notify )
		:to                     (window1 OneButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (One)
		)
	)
)
(
	:type                   :button
	:name                   TwoButton
	:owner                  MainControl
	:help                   ""
	:x                      88
	:y                      80
	:width                  58
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "    2    "
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         Two
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 TwoButton)
		:when                   (Notify )
		:to                     (window1 TwoButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Two)
		)
	)
)
(
	:type                   :button
	:name                   ThreeButton
	:owner                  MainControl
	:help                   ""
	:x                      160
	:y                      80
	:width                  58
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "    3    "
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         Three
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 ThreeButton)
		:when                   (Notify )
		:to                     (window1 ThreeButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Three)
		)
	)
)
(
	:type                   :button
	:name                   FourButton
	:owner                  MainControl
	:help                   ""
	:x                      16
	:y                      104
	:width                  58
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "    4    "
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         Four
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 FourButton)
		:when                   (Notify )
		:to                     (window1 FourButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Four)
		)
	)
)
(
	:type                   :button
	:name                   FiveButton
	:owner                  MainControl
	:help                   ""
	:x                      88
	:y                      104
	:width                  58
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "    5    "
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         Five
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 FiveButton)
		:when                   (Notify )
		:to                     (window1 FiveButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Five)
		)
	)
)
(
	:type                   :button
	:name                   SixButton
	:owner                  MainControl
	:help                   ""
	:x                      160
	:y                      104
	:width                  58
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "    6    "
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         Six
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 SixButton)
		:when                   (Notify )
		:to                     (window1 SixButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Six)
		)
	)
)
(
	:type                   :button
	:name                   SevenButton
	:owner                  MainControl
	:help                   ""
	:x                      16
	:y                      128
	:width                  58
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "    7    "
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         Seven
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 SevenButton)
		:when                   (Notify )
		:to                     (window1 SevenButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Seven)
		)
	)
)
(
	:type                   :button
	:name                   EightButton
	:owner                  MainControl
	:help                   ""
	:x                      88
	:y                      128
	:width                  58
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "    8    "
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         Eight
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 EightButton)
		:when                   (Notify )
		:to                     (window1 EightButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Eight)
		)
	)
)
(
	:type                   :button
	:name                   NineButton
	:owner                  MainControl
	:help                   ""
	:x                      160
	:y                      128
	:width                  58
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "    9    "
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         Nine
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 NineButton)
		:when                   (Notify )
		:to                     (window1 NineButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Nine)
		)
	)
)
(
	:type                   :button
	:name                   ZeroButton
	:owner                  MainControl
	:help                   ""
	:x                      88
	:y                      152
	:width                  58
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "    0    "
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         Zero
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 ZeroButton)
		:when                   (Notify )
		:to                     (window1 ZeroButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Zero)
		)
	)
)
(
	:type                   :button
	:name                   SearchButton
	:owner                  MainControl
	:help                   ""
	:x                      16
	:y                      176
	:width                  58
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "Search"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         Search
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 SearchButton)
		:when                   (Notify )
		:to                     (window1 SearchButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Search)
		)
	)
)
(
	:type                   :text-field
	:name                   SearchTrackText
	:owner                  MainControl
	:help                   ""
	:x                      76
	:y                      180
	:width                  141
	:height                 15
	:value-x                146
	:value-y                180
	:value-length           2
	:stored-length          2
	:rows                   3
	:foreground-color       "Black"
	:text-type              :numeric
	:label                  " for track"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:max-value              99
	:min-value              0
	:initial-value          0
	:initial-state          :active
	:read-only              nil
	:notify-handler         SearchKbd
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 SearchTrackText)
		:when                   (Notify )
		:to                     (window1 SearchTrackText)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (SearchKbd)
		)
	)
)
(
	:type                   :message
	:name                   DurationLabelMsg
	:owner                  MainControl
	:help                   ""
	:x                      48
	:y                      200
	:width                  90
	:height                 13
	:foreground-color       "Black"
	:label                  "Track Duration"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   DurationTimeMsg
	:owner                  MainControl
	:help                   ""
	:x                      144
	:y                      200
	:width                  35
	:height                 13
	:foreground-color       "Black"
	:label                  "00:00"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   TempDurationMsg
	:owner                  MainControl
	:help                   ""
	:x                      104
	:y                      216
	:width                  35
	:height                 13
	:foreground-color       "Black"
	:label                  "00:00"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :slider
	:name                   DurationSlider
	:owner                  MainControl
	:help                   ""
	:x                      0
	:y                      232
	:width                  226
	:height                 26
	:value-x                0
	:value-y                232
	:slider-width           210
	:ticks                  5
	:foreground-color       "Black"
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:orientation            :horizontal
	:show-endboxes          nil
	:show-range             nil
	:show-value             nil
	:min-value              0
	:max-value              100
	:min-value-string       ""
	:max-value-string       ""
	:min-tick-string        ""
	:max-tick-string        ""
	:initial-value          0
	:initial-state          :active
	:notify-handler         Duration
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 DurationSlider)
		:when                   (Notify )
		:to                     (window1 DurationSlider)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Duration)
		)
	)
)
(
	:type                   :button
	:name                   PauseButton
	:owner                  MainControl
	:help                   ""
	:x                      20
	:y                      260
	:width                  42
	:height                 25
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "icons/pauseIcon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         Pause
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 PauseButton)
		:when                   (Notify )
		:to                     (window1 PauseButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Pause)
		)
	)
)
(
	:type                   :button
	:name                   StopButton
	:owner                  MainControl
	:help                   ""
	:x                      96
	:y                      260
	:width                  42
	:height                 25
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "icons/stopIcon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         Stop
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 StopButton)
		:when                   (Notify )
		:to                     (window1 StopButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Stop)
		)
	)
)
(
	:type                   :button
	:name                   PlayButton
	:owner                  MainControl
	:help                   ""
	:x                      168
	:y                      260
	:width                  42
	:height                 25
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "icons/playIcon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         Play
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 PlayButton)
		:when                   (Notify )
		:to                     (window1 PlayButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Play)
		)
	)
)
(
	:type                   :button
	:name                   ReverseSkipButton
	:owner                  MainControl
	:help                   ""
	:x                      20
	:y                      292
	:width                  42
	:height                 22
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "icons/rSkipIcon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         ReverseSkip
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 ReverseSkipButton)
		:when                   (Notify )
		:to                     (window1 ReverseSkipButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ReverseSkip)
		)
	)
)
(
	:type                   :button
	:name                   EjectButton
	:owner                  MainControl
	:help                   ""
	:x                      96
	:y                      292
	:width                  42
	:height                 22
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "icons/ejectIcon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         Eject
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 EjectButton)
		:when                   (Notify )
		:to                     (window1 EjectButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Eject)
		)
	)
)
(
	:type                   :button
	:name                   ForwardSkipButton
	:owner                  MainControl
	:help                   ""
	:x                      168
	:y                      292
	:width                  42
	:height                 22
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "icons/fSkipIcon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         ForwardSkip
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 ForwardSkipButton)
		:when                   (Notify )
		:to                     (window1 ForwardSkipButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ForwardSkip)
		)
	)
)
(
	:type                   :slider
	:name                   VolumeSlider
	:owner                  MainControl
	:help                   ""
	:x                      8
	:y                      324
	:width                  221
	:height                 26
	:value-x                68
	:value-y                324
	:slider-width           140
	:ticks                  3
	:foreground-color       "Black"
	:label                  "Volume  "
	:label-type             :string
	:layout-type            :horizontal
	:orientation            :horizontal
	:show-endboxes          nil
	:show-range             nil
	:show-value             nil
	:min-value              110
	:max-value              250
	:min-value-string       ""
	:max-value-string       ""
	:min-tick-string        ""
	:max-tick-string        ""
	:initial-value          0
	:initial-state          :active
	:notify-handler         Volume
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 VolumeSlider)
		:when                   (Notify )
		:to                     (window1 VolumeSlider)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Volume)
		)
	)
)
(
	:type                   :slider
	:name                   BalanceSlider
	:owner                  MainControl
	:help                   ""
	:x                      8
	:y                      352
	:width                  223
	:height                 26
	:value-x                70
	:value-y                352
	:slider-width           140
	:ticks                  3
	:foreground-color       "Black"
	:label                  "Balance  "
	:label-type             :string
	:layout-type            :horizontal
	:orientation            :horizontal
	:show-endboxes          nil
	:show-range             nil
	:show-value             nil
	:min-value              -15
	:max-value              15
	:min-value-string       ""
	:max-value-string       ""
	:min-tick-string        ""
	:max-tick-string        ""
	:initial-value          0
	:initial-state          :active
	:notify-handler         Balance
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 BalanceSlider)
		:when                   (Notify )
		:to                     (window1 BalanceSlider)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Balance)
		)
	)
)
(
	:type                   :popup-window
	:name                   EditPopup
	:owner                  window1
	:width                  496
	:height                 448
	:background-color       "Black"
	:foreground-color       ""
	:label                  "CD Edit"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            t
	:resizable              nil
	:pinned                 t
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   EditFileControl
	:owner                  EditPopup
	:help                   ""
	:x                      0
	:y                      0
	:width                  496
	:height                 48
	:background-color       "Light Gray"
	:foreground-color       "Black"
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   DocumentButton
	:owner                  EditFileControl
	:help                   ""
	:x                      24
	:y                      16
	:width                  94
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "Document"
	:label-type             :string
	:initial-state          :active
	:menu                   DocumentMenu
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   DiscLabelText
	:owner                  EditFileControl
	:help                   ""
	:x                      136
	:y                      16
	:width                  347
	:height                 15
	:value-x                227
	:value-y                16
	:value-length           32
	:stored-length          256
	:rows                   3
	:foreground-color       "Black"
	:text-type              :alphanumeric
	:label                  "Disc Label : "
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   EditListControl
	:owner                  EditPopup
	:help                   ""
	:x                      0
	:y                      49
	:width                  496
	:height                 215
	:background-color       "Light Gray"
	:foreground-color       "Black"
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   EditListMainHeaderMsg
	:owner                  EditListControl
	:help                   ""
	:x                      220
	:y                      12
	:width                  56
	:height                 13
	:foreground-color       "Black"
	:label                  "Edit List"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   EditListNumEditsMsg
	:owner                  EditListControl
	:help                   ""
	:x                      372
	:y                      12
	:width                  88
	:height                 13
	:foreground-color       "Black"
	:label                  "No. of Edits : 0"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   EditListHeaderMsg1
	:owner                  EditListControl
	:help                   ""
	:x                      32
	:y                      36
	:width                  192
	:height                 13
	:foreground-color       "Black"
	:label                  "  Edit #                          Label   "
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   EditListHeaderMsg2
	:owner                  EditListControl
	:help                   ""
	:x                      312
	:y                      36
	:width                  112
	:height                 13
	:foreground-color       "Black"
	:label                  "Start               End"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :scrolling-list
	:name                   EditList
	:owner                  EditListControl
	:help                   ""
	:x                      8
	:y                      56
	:width                  460
	:height                 146
	:value-x                8
	:value-y                56
	:rows                   7
	:foreground-color       "Black"
	:label                  ""
	:title                  ""
	:label-type             :string
	:layout-type            :horizontal
	:read-only              nil
	:multiple-selections    nil
	:selection-required     nil
	:initial-state          :active
	:droppable              nil
	:default-drop-site      nil
	:menu                   nil
	:notify-handler         List
	:event-handler          nil
	:initial-list-values    ()
	:initial-list-glyphs    ()
	:initial-selections     ()
	:user-data              ()
	:actions                (
		(
		:from                   (EditPopup EditList)
		:when                   (Notify )
		:to                     (EditPopup EditList)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (List)
		)
	)
)
(
	:type                   :control-area
	:name                   EditCurrentSelectionControl
	:owner                  EditPopup
	:help                   ""
	:x                      0
	:y                      265
	:width                  496
	:height                 183
	:background-color       "Light Gray"
	:foreground-color       "Black"
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   CurrentSelectionMsg
	:owner                  EditCurrentSelectionControl
	:help                   ""
	:x                      168
	:y                      12
	:width                  165
	:height                 13
	:foreground-color       "Black"
	:label                  "Current Selection : None"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   CurrentSelectionTimeMsg
	:owner                  EditCurrentSelectionControl
	:help                   ""
	:x                      64
	:y                      36
	:width                  190
	:height                 13
	:foreground-color       "Black"
	:label                  "Track      Min       Sec      Frame"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   EditPopupStartTrackText
	:owner                  EditCurrentSelectionControl
	:help                   ""
	:x                      16
	:y                      52
	:width                  83
	:height                 15
	:value-x                63
	:value-y                52
	:value-length           2
	:stored-length          2
	:rows                   3
	:foreground-color       "Black"
	:text-type              :alphanumeric
	:label                  "Start :"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   TimeColonMsg4
	:owner                  EditCurrentSelectionControl
	:help                   ""
	:x                      104
	:y                      52
	:width                  3
	:height                 13
	:foreground-color       "Black"
	:label                  ":"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   EditPopupStartMinText
	:owner                  EditCurrentSelectionControl
	:help                   ""
	:x                      104
	:y                      52
	:width                  36
	:height                 15
	:value-x                104
	:value-y                52
	:value-length           2
	:stored-length          2
	:rows                   3
	:foreground-color       "Black"
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   TimeColonMsg6
	:owner                  EditCurrentSelectionControl
	:help                   ""
	:x                      156
	:y                      52
	:width                  3
	:height                 13
	:foreground-color       "Black"
	:label                  ":"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   EditPopupStartSecText
	:owner                  EditCurrentSelectionControl
	:help                   ""
	:x                      156
	:y                      52
	:width                  36
	:height                 15
	:value-x                156
	:value-y                52
	:value-length           2
	:stored-length          2
	:rows                   3
	:foreground-color       "Black"
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   TimeColonMsg2
	:owner                  EditCurrentSelectionControl
	:help                   ""
	:x                      208
	:y                      52
	:width                  3
	:height                 13
	:foreground-color       "Black"
	:label                  ":"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   EditPopupStartFrameText
	:owner                  EditCurrentSelectionControl
	:help                   ""
	:x                      208
	:y                      52
	:width                  36
	:height                 15
	:value-x                208
	:value-y                52
	:value-length           2
	:stored-length          2
	:rows                   3
	:foreground-color       "Black"
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   GetStartButton
	:owner                  EditCurrentSelectionControl
	:help                   ""
	:x                      264
	:y                      52
	:width                  34
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "<-"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         GetStart
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (EditPopup GetStartButton)
		:when                   (Notify )
		:to                     (EditPopup GetStartButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (GetStart)
		)
	)
)
(
	:type                   :message
	:name                   GetTimeMsg1
	:owner                  EditCurrentSelectionControl
	:help                   ""
	:x                      304
	:y                      60
	:width                  101
	:height                 13
	:foreground-color       "Black"
	:label                  "Get current time"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   EditPopupEndTrackText
	:owner                  EditCurrentSelectionControl
	:help                   ""
	:x                      16
	:y                      76
	:width                  84
	:height                 15
	:value-x                64
	:value-y                76
	:value-length           2
	:stored-length          2
	:rows                   3
	:foreground-color       "Black"
	:text-type              :alphanumeric
	:label                  "End   :"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   TimeColonMsg5
	:owner                  EditCurrentSelectionControl
	:help                   ""
	:x                      104
	:y                      76
	:width                  3
	:height                 13
	:foreground-color       "Black"
	:label                  ":"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   EditPopupEndMinText
	:owner                  EditCurrentSelectionControl
	:help                   ""
	:x                      104
	:y                      76
	:width                  36
	:height                 15
	:value-x                104
	:value-y                76
	:value-length           2
	:stored-length          2
	:rows                   3
	:foreground-color       "Black"
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   TimeColonMsg1
	:owner                  EditCurrentSelectionControl
	:help                   ""
	:x                      156
	:y                      76
	:width                  3
	:height                 13
	:foreground-color       "Black"
	:label                  ":"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   EditPopupEndSecText
	:owner                  EditCurrentSelectionControl
	:help                   ""
	:x                      156
	:y                      76
	:width                  36
	:height                 15
	:value-x                156
	:value-y                76
	:value-length           2
	:stored-length          2
	:rows                   3
	:foreground-color       "Black"
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   TimeColonMsg3
	:owner                  EditCurrentSelectionControl
	:help                   ""
	:x                      208
	:y                      76
	:width                  3
	:height                 13
	:foreground-color       "Black"
	:label                  ":"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   EditPopupEndFrameText
	:owner                  EditCurrentSelectionControl
	:help                   ""
	:x                      208
	:y                      76
	:width                  36
	:height                 15
	:value-x                208
	:value-y                76
	:value-length           2
	:stored-length          2
	:rows                   3
	:foreground-color       "Black"
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   GetEndButton
	:owner                  EditCurrentSelectionControl
	:help                   ""
	:x                      264
	:y                      76
	:width                  34
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "<-"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         GetEnd
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (EditPopup GetEndButton)
		:when                   (Notify )
		:to                     (EditPopup GetEndButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (GetEnd)
		)
	)
)
(
	:type                   :message
	:name                   GetTimeMsg2
	:owner                  EditCurrentSelectionControl
	:help                   ""
	:x                      324
	:y                      76
	:width                  57
	:height                 13
	:foreground-color       "Black"
	:label                  "from disc"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   EditPopupLabelText
	:owner                  EditCurrentSelectionControl
	:help                   ""
	:x                      16
	:y                      100
	:width                  253
	:height                 15
	:value-x                69
	:value-y                100
	:value-length           25
	:stored-length          256
	:rows                   3
	:foreground-color       "Black"
	:text-type              :alphanumeric
	:label                  "Label :"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         LabelText
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (EditPopup EditPopupLabelText)
		:when                   (Notify )
		:to                     (EditPopup EditPopupLabelText)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (LabelText)
		)
	)
)
(
	:type                   :button
	:name                   OpenPreviewPopupButton
	:owner                  EditCurrentSelectionControl
	:help                   ""
	:x                      376
	:y                      112
	:width                  57
	:height                 19
	:constant-width         t
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "Preview"
	:label-type             :string
	:initial-state          :active
	:menu                   PreviewMenu
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   EditPopupDurationText
	:owner                  EditCurrentSelectionControl
	:help                   ""
	:x                      16
	:y                      124
	:width                  228
	:height                 15
	:value-x                180
	:value-y                124
	:value-length           8
	:stored-length          80
	:rows                   3
	:foreground-color       "Black"
	:text-type              :alphanumeric
	:label                  "Approximate duration :"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              t
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   DurationMsg
	:owner                  EditCurrentSelectionControl
	:help                   ""
	:x                      252
	:y                      124
	:width                  48
	:height                 13
	:foreground-color       "Black"
	:label                  "seconds"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   AddButton
	:owner                  EditCurrentSelectionControl
	:help                   ""
	:x                      32
	:y                      152
	:width                  57
	:height                 19
	:constant-width         t
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "    Add"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         EditAdd
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (EditPopup AddButton)
		:when                   (Notify )
		:to                     (EditPopup AddButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (EditAdd)
		)
	)
)
(
	:type                   :button
	:name                   ModifyButton
	:owner                  EditCurrentSelectionControl
	:help                   ""
	:x                      144
	:y                      152
	:width                  57
	:height                 19
	:constant-width         t
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "  Modify"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         EditModify
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (EditPopup ModifyButton)
		:when                   (Notify )
		:to                     (EditPopup ModifyButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (EditModify)
		)
	)
)
(
	:type                   :button
	:name                   DeleteButton
	:owner                  EditCurrentSelectionControl
	:help                   ""
	:x                      264
	:y                      152
	:width                  57
	:height                 19
	:constant-width         t
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "  Delete"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         EditDelete
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (EditPopup DeleteButton)
		:when                   (Notify )
		:to                     (EditPopup DeleteButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (EditDelete)
		)
	)
)
(
	:type                   :button
	:name                   DeleteAllButton
	:owner                  EditCurrentSelectionControl
	:help                   ""
	:x                      376
	:y                      152
	:width                  65
	:height                 19
	:constant-width         t
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "Delete All"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         EditDeleteAll
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (EditPopup DeleteAllButton)
		:when                   (Notify )
		:to                     (EditPopup DeleteAllButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (EditDeleteAll)
		)
	)
)
(
	:type                   :popup-window
	:name                   PreviewPopup
	:owner                  window1
	:width                  188
	:height                 115
	:background-color       ""
	:foreground-color       ""
	:label                  "CD Preview"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            t
	:resizable              nil
	:pinned                 nil
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   PreviewControl
	:owner                  PreviewPopup
	:help                   ""
	:x                      0
	:y                      0
	:width                  188
	:height                 115
	:background-color       "Light Gray"
	:foreground-color       "Black"
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   PreviewStartButton
	:owner                  PreviewControl
	:help                   ""
	:x                      12
	:y                      16
	:width                  81
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "Play first  "
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         PreviewStart
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (PreviewPopup PreviewStartButton)
		:when                   (Notify )
		:to                     (PreviewPopup PreviewStartButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (PreviewStart)
		)
	)
)
(
	:type                   :text-field
	:name                   PreviewTimeText
	:owner                  PreviewControl
	:help                   ""
	:x                      100
	:y                      24
	:width                  71
	:height                 32
	:value-x                100
	:value-y                41
	:value-length           2
	:stored-length          2
	:rows                   3
	:foreground-color       "Black"
	:text-type              :numeric
	:label                  "seconds"
	:label-type             :string
	:layout-type            :vertical
	:value-underlined       t
	:max-value              60
	:min-value              0
	:initial-value          0
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   PreviewEndButton
	:owner                  PreviewControl
	:help                   ""
	:x                      12
	:y                      48
	:width                  82
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "Play last   "
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         PreviewEnd
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (PreviewPopup PreviewEndButton)
		:when                   (Notify )
		:to                     (PreviewPopup PreviewEndButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (PreviewEnd)
		)
	)
)
(
	:type                   :button
	:name                   ClosePreviewPopupButton
	:owner                  PreviewControl
	:help                   ""
	:x                      72
	:y                      84
	:width                  49
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "Done"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         PreviewDone
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (PreviewPopup ClosePreviewPopupButton)
		:when                   (Notify )
		:to                     (PreviewPopup ClosePreviewPopupButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (PreviewDone)
		)
	)
)
(
	:type                   :popup-window
	:name                   InfoPopup
	:owner                  window1
	:width                  477
	:height                 263
	:background-color       ""
	:foreground-color       ""
	:label                  "Info"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            t
	:resizable              nil
	:pinned                 nil
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   InfoControl
	:owner                  InfoPopup
	:help                   ""
	:x                      0
	:y                      0
	:width                  477
	:height                 263
	:background-color       "Light Gray"
	:foreground-color       "Black"
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   InfoTitleMsg
	:owner                  InfoControl
	:help                   ""
	:x                      168
	:y                      8
	:width                  145
	:height                 13
	:foreground-color       "Black"
	:label                  "CD Edit   Version 2.10"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   VersionMsg
	:owner                  InfoControl
	:help                   ""
	:x                      71
	:y                      36
	:width                  335
	:height                 13
	:foreground-color       "Black"
	:label                  "An application for annotating music from compact disc"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   InfoByMsg
	:owner                  InfoControl
	:help                   ""
	:x                      23
	:y                      56
	:width                  430
	:height                 13
	:foreground-color       "Black"
	:label                  "designed for use with the MAEstro Multimedia Authoring Environment"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   InfoNameMsg
	:owner                  InfoControl
	:help                   ""
	:x                      177
	:y                      96
	:width                  122
	:height                 13
	:foreground-color       "Black"
	:label                  "by Teck-Joo Chua"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   InfoCopyrightMsg
	:owner                  InfoControl
	:help                   ""
	:x                      8
	:y                      136
	:width                  457
	:height                 13
	:foreground-color       "Black"
	:label                  "Copyright (C) 1990, 1991, 1992 Libraries and Information Resources (L&IR)"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   InfoStanfordMsg
	:owner                  InfoControl
	:help                   ""
	:x                      176
	:y                      168
	:width                  122
	:height                 13
	:foreground-color       "Black"
	:label                  " Stanford University"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   InfoEmailMsg
	:owner                  InfoControl
	:help                   ""
	:x                      179
	:y                      184
	:width                  119
	:height                 13
	:foreground-color       "Black"
	:label                  "Stanford, California"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   moreinfoMessage
	:owner                  InfoControl
	:help                   ""
	:x                      84
	:y                      204
	:width                  309
	:height                 13
	:foreground-color       ""
	:label                  "For more info, contact maestro@sioux.stanford.edu"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   CloseInfoPopupButton
	:owner                  InfoControl
	:help                   ""
	:x                      220
	:y                      240
	:width                  36
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "OK"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         InfoDone
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (InfoPopup CloseInfoPopupButton)
		:when                   (Notify )
		:to                     (InfoPopup CloseInfoPopupButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (InfoDone)
		)
	)
)
)
