/*
 * Copyright (c) 1990, 1991, 1992 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/VideoObject/RCS/Sony1550Driver.h,v 1.7 92/09/01 17:11:10 drapeau Exp $ */
/* $Log:	Sony1550Driver.h,v $
 * Revision 1.7  92/09/01  17:11:10  drapeau
 * Updated copyright notice.
 * Also, added function prototypes to function definitions for better
 * ANSI compliance.
 * 
 * Revision 1.6  92/01/03  16:55:21  drapeau
 * Removed inclusion of string.h so as not to conflict with other files
 * that use this driver.
 * 
 * Revision 1.5  91/09/30  17:08:28  lim
 * Added Sony1550Ping.
 * 
 * Revision 1.4  91/08/24  13:39:18  lim
 * 1. Updated to use status codes in new PlayerStatus.h
 * 2. Clear Marker() removed as part of video object.
 * 
 * Revision 1.3  91/08/07  13:46:59  lim
 * *** empty log message ***
 * 
 * Revision 1.2  91/08/07  13:18:08  lim
 * 1. Included "videoObj.h" and "PlayerStatus.h"
 * 
 * Revision 1.1  91/07/29  22:22:01  lim
 * Initial revision
 * 
 * Revision 0.10  91/07/02  13:32:05  lim
 * Initial revision.
 *  */

#include <ctype.h>
#include <fcntl.h>
#include <sys/termio.h>
#include <stdio.h>
#include "PlayerStatus.h"
#include "videoObj.h"

/*
  All positive numbers are player return code (except zero) or player
  commands

  Negative numbers are error codes
*/

static char vhrcsid[] = "$Header: /Source/Media/collab/VideoObject/RCS/Sony1550Driver.h,v 1.7 92/09/01 17:11:10 drapeau Exp $";


int Sony1550Play			(VideoObject*);
int Sony1550PlayFromTo			(VideoObject*, int, int, int);
int Sony1550FastForward			(VideoObject*);
int Sony1550Reverse			(VideoObject*);
int Sony1550CalcSpeed			(VideoObject*, int, int);
int Sony1550PlayAtSpeedDir		(VideoObject*, int, enum Direction);
int Sony1550Step			(VideoObject*, enum Direction);
int Sony1550Still			(VideoObject*);
int Sony1550Stop			(VideoObject*);
int Sony1550SetDefaults			(VideoObject*, int, int, int, int);
int Sony1550SetAudio			(VideoObject*, int);
int Sony1550SetVideo			(VideoObject*, int);
int Sony1550SetAddMode			(VideoObject*, int);
int Sony1550SetAddressDisplay		(VideoObject*, int, int);
int Sony1550Eject			(VideoObject*);
int Sony1550Power			(VideoObject*, int);
int Sony1550QueryFrame			(VideoObject*);
int Sony1550QueryChapter		(VideoObject*);
int Sony1550QueryAudio			(VideoObject*);
int Sony1550QueryVideo			(VideoObject*);
int Sony1550QueryMedium			(VideoObject*, char*);
int Sony1550QueryStatus			(VideoObject*);
int Sony1550Ping			(VideoObject*);
void Sony1550ErrorDecode		(VideoObject*, int, char*);

