/*
 * Copyright (c) 1992 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/drapeau/VideoFrame/RCS/xvideo.c,v 1.1 92/07/14 14:36:22 drapeau Exp $ */
/* $Log:	xvideo.c,v $
 * Revision 1.1  92/07/14  14:36:22  drapeau
 * Initial revision
 *  */

#include "VideoFrame.h"

static char xvideoRcsid[] = "$Header: /Source/Media/drapeau/VideoFrame/RCS/xvideo.c,v 1.1 92/07/14 14:36:22 drapeau Exp $";


void InitXVideoCanvases()
{
  Rect	tempRect;
  int	tempValue;
  
  videoIn1 = xv_create(VideoFrame_inputWindow1->inputWindow1,	    /* Try to create the first XVideo input object */
		       VIDEO_IN,
		       VIDEO_CHANNEL, VIDEO_IN_ONE,
		       VIDEO_LIVE, TRUE,
		       VIDEO_SQUEEZE, TRUE,
		       XV_X, 0,
		       NULL);
  if (videoIn1 == (VideoIn)NULL)				    /* Did initialization fail? */
  {								    /* Yes, determine why and print the error message */
    if (Xv_VideoStatus == VIDEO_CHANNEL_IN_USE)
    {
      fprintf(stderr,"Channel 1 is already in use.\n");
    }
    else if (Xv_VideoStatus == VIDEO_NO_MORE_CHANNELS)
    {
      fprintf(stderr,"Requested channel is not available.\n");
    }
    else
    {
      fprintf(stderr,"Could not initialize Video Input 1.\n");
    }
    xv_set(VideoFrame_mainWindow->input1ShownChoice, PANEL_VALUE, 1, NULL);
    currentSelection.input1.shown = False;
  }
  else								    /* Intitialization succeeded; get initial values */
  {
    frame_get_rect(VideoFrame_inputWindow1->inputWindow1, &tempRect); /* Get the size of the 1st video input window */
    currentSelection.input1.x = tempRect.r_left;
    currentSelection.input1.y = tempRect.r_top;
    currentSelection.input1.width = tempRect.r_width;
    currentSelection.input1.height = tempRect.r_height;
    
    xv_set(VideoFrame_mainWindow->input1ShownChoice, PANEL_VALUE, 0, NULL);
    currentSelection.input1.shown = True;
    if (xv_get(videoIn1, VIDEO_SQUEEZE) == TRUE)
    {
      currentSelection.input1.cropped = False;
      xv_set(VideoFrame_mainWindow->input1CroppedChoice, PANEL_VALUE, 1, NULL);
    }
    else
    {
      currentSelection.input1.cropped = True;
      xv_set(VideoFrame_mainWindow->input1CroppedChoice, PANEL_VALUE, 0, NULL);
    }
    if (xv_get(videoIn1, VIDEO_NORMAL_ASPECT) == FALSE)
    {
      currentSelection.input1.aspectRatio = Any;
      xv_set(VideoFrame_mainWindow->input1AspectChoice, PANEL_VALUE, 0, NULL);
    }
    else
    {
      currentSelection.input1.aspectRatio = Fixed;
      xv_set(VideoFrame_mainWindow->input1AspectChoice, PANEL_VALUE, 1, NULL);
    }

    tempValue = xv_get(videoIn1, VIDEO_BRIGHTNESS);
    xv_set(VideoFrame_mainWindow->input1BrightSlider,
	   PANEL_VALUE, tempValue, NULL);
    currentSelection.input1.brightness = tempValue;

    tempValue = xv_get(videoIn1, VIDEO_CONTRAST);
    xv_set(VideoFrame_mainWindow->input1ContrastSlider,
	   PANEL_VALUE, tempValue, NULL);
    currentSelection.input1.contrast = tempValue;

    tempValue = xv_get(videoIn1, VIDEO_SATURATION);
    xv_set(VideoFrame_mainWindow->input1SaturationSlider,
	   PANEL_VALUE, tempValue, NULL);
    currentSelection.input1.saturation = tempValue;
    
    tempValue = xv_get(videoIn1, VIDEO_HUE);
    xv_set(VideoFrame_mainWindow->input1HueSlider,
	   PANEL_VALUE, tempValue, NULL);
    currentSelection.input1.hue = tempValue;
  }
  videoIn2 = xv_create(VideoFrame_inputWindow2->inputWindow2,	    /* Try to create the second XVideo input object */
		       VIDEO_IN,
		       VIDEO_CHANNEL, VIDEO_IN_TWO,
		       VIDEO_LIVE, TRUE,
		       VIDEO_SQUEEZE, TRUE,
		       XV_X, 0,
		       NULL);
  if (videoIn2 == (VideoIn)NULL)				    /* Did initialization fail? */
  {								    /* Yes, determine why and print the error message */
    if (Xv_VideoStatus == VIDEO_CHANNEL_IN_USE)
    {
      fprintf(stderr,"Channel 2 is already in use.\n");
    }
    else if (Xv_VideoStatus == VIDEO_NO_MORE_CHANNELS)
    {
      fprintf(stderr,"Requested channel is not available.\n");
    }
    else
    {
      fprintf(stderr,"Could not initialize Video Input 2.\n");
    }
    xv_set(VideoFrame_mainWindow->input2ShownChoice, PANEL_VALUE, 1, NULL);
  }
  else								    /* Intitialization succeeded; get initial values */
  {
    frame_get_rect(VideoFrame_inputWindow2->inputWindow2, &tempRect); /* Get the size of the 2nd video input window */
    currentSelection.input2.x = tempRect.r_left;
    currentSelection.input2.y = tempRect.r_top;
    currentSelection.input2.width = tempRect.r_width;
    currentSelection.input2.height = tempRect.r_height;
    
    xv_set(VideoFrame_mainWindow->input2ShownChoice, PANEL_VALUE, 0, NULL);
    currentSelection.input2.shown = True;
    if (xv_get(videoIn2, VIDEO_SQUEEZE) == TRUE)
    {
      currentSelection.input2.cropped = False;
      xv_set(VideoFrame_mainWindow->input2CroppedChoice, PANEL_VALUE, 1, NULL);
    }
    else
    {
      currentSelection.input2.cropped = True;
      xv_set(VideoFrame_mainWindow->input2CroppedChoice, PANEL_VALUE, 0, NULL);
    }
    if (xv_get(videoIn2, VIDEO_NORMAL_ASPECT) == FALSE)
    {
      currentSelection.input2.aspectRatio = Any;
      xv_set(VideoFrame_mainWindow->input2AspectChoice, PANEL_VALUE, 0, NULL);
    }
    else
    {
      currentSelection.input2.aspectRatio = Fixed;
      xv_set(VideoFrame_mainWindow->input2AspectChoice, PANEL_VALUE, 1, NULL);
    }

    tempValue = xv_get(videoIn2, VIDEO_BRIGHTNESS);
    xv_set(VideoFrame_mainWindow->input2BrightSlider,
	   PANEL_VALUE, tempValue, NULL);
    currentSelection.input2.brightness = tempValue;

    tempValue = xv_get(videoIn2, VIDEO_CONTRAST);
    xv_set(VideoFrame_mainWindow->input2ContrastSlider,
	   PANEL_VALUE, tempValue, NULL);
    currentSelection.input2.contrast = tempValue;

    tempValue = xv_get(videoIn2, VIDEO_SATURATION);
    xv_set(VideoFrame_mainWindow->input2SaturationSlider,
	   PANEL_VALUE, tempValue, NULL);
    currentSelection.input2.saturation = tempValue;
    
    tempValue = xv_get(videoIn2, VIDEO_HUE);
    xv_set(VideoFrame_mainWindow->input2HueSlider,
	   PANEL_VALUE, tempValue, NULL);
    currentSelection.input2.hue = tempValue;
  }
  return;
}								    /* end function InitXVideoCanvases */
