/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/VideoEdit/RCS/VideoEditOptions.c,v 0.30 92/06/15 14:35:52 drapeau Exp $ */
/* $Log:	VideoEditOptions.c,v $
 * Revision 0.30  92/06/15  14:35:52  drapeau
 * Minor change, removed declaration of "chosenHost[]" since it is already
 * declared in VideoEdit.h.
 * 
 * Revision 0.29  92/05/13  00:23:10  drapeau
 * Several changes:
 * * Removed function "SetPlayer()", replaced it with function
 *   "SetPlayerHandler()" which is almost identical in function.  This was
 *   done in order to reflect a simplification in the user interface, in
 *   the way a player and serial port are chosen.
 * * Removed function "optionsSetPort()", as the user interface
 *   simplification mentioned above obviates the need for this function.
 * * Minor formatting changes to conform to coding standards.
 * 
 * Revision 0.28  92/01/03  15:47:51  drapeau
 * Modified Audio(): deleted unused variable, and added statements
 * to use defined constants "PlayerAudioMute", etc., from the
 * VideoObject library.  Used these constants to make the code
 * clearer as to its purpose.
 * 
 * Revision 0.27  91/09/29  16:07:02  lim
 * When initialization of player fails or is terminated in any way,
 * player setting is reset to "None".
 * When using default port, the actual setting will be reflected
 * on the port setting after connection is established.
 * 
 * Revision 0.26  91/09/29  14:32:11  lim
 * In setting player, we now check that the player/serial line are chosen
 * correctly.
 * If the initialization returns a NULL video object, the user gets a 
 * notice prompt asking him to check the player/serial line.
 * Also, with the additional choice of 'Default' in the serial line
 * option, the variable 'mySerialPort' is removed.
 * 
 * Revision 0.25  91/09/27  16:53:33  lim
 * 1. Added "None" as default item on optionsPlayerStg.
 * 2. Added notice prompt when player is selected.
 * 
 * Revision 0.24  91/09/26  11:58:24  lim
 * Changed name of currently selected network host from
 * 'host' to 'chosenHost'. Made a global.
 * Changed initialization of 'chosenHost'.
 * 
 * Revision 0.23  91/09/24  21:36:39  lim
 * Changed 'vEdit' to 'VideoEdit' everywhere.
 * 
 * Revision 0.22  91/09/03  10:33:54  lim
 * Checked for valid Sender & Receiver before disconnecting in SetNetworkHost.
 * 
 * Revision 0.21  91/08/29  12:11:27  lim
 * Added 'Default' to serial port.
 * 
 * Revision 0.20  91/08/28  17:06:03  lim
 * Updated status codes.
 * 
 * Revision 0.19  91/08/28  17:03:43  lim
 * Hitting done will also set network host if not already set.
 * 
 * Revision 0.18  91/08/24  17:55:40  lim
 * Implemented PrintDiagnostics. 
 * Using command line flag '-d', the user can choose to launch the
 * app with diagnostic messages. Otherwise, no diag messages will
 * be printed.
 * 
 * Revision 0.17  91/08/21  10:52:13  lim
 * *** empty log message ***
 * 
 * Revision 0.16  91/08/21  10:48:01  lim
 * Fixed bug concerning serial ports. 'mySerialPort' is set whenever the
 * video object has yet to be initialized, so that only upon initialization
 * is SetSerialLine called.
 * This setting overrides both the ~/.Xdefaults setting AND the setting
 * coded in the video library.
 * 
 * Revision 0.15  91/08/16  13:11:08  lim
 * 1. Serial port setting reflected in panel.
 * 2. optionsNetworkHost added so that we are able to choose the Port Manager
 * after app is launched.
 * 3. Info button and function moved here.
 * 
 * Revision 0.14  91/08/07  13:28:33  lim
 * 1. Added instance pointer, "theObject" to all public function calls.
 * 
 * Revision 0.13  91/08/02  13:00:07  lim
 * 1. allDevices has been changed from an array of device configurations to
 * an array of names of all devices supported.
 * 2. GetDeviceMaxSpeed() used to get maximum speed possible with current
 * device.
 * 3. DevSetDefaults called with 4 parameters.
 * 4. CheckImplemented is used to decide what buttons to set inactive.
 * 5. SetSerialLine changed to take in device configuration structure rather
 * than deviceName.
 * 
 * Revision 0.12  91/07/23  15:57:01  lim
 * Added SetPlayer() which allows drivers to be chosen for the app.
 * 
 * Revision 0.11  91/07/17  22:53:41  lim
 * Replaced DevSetSerialPort with SetSerialPort (a call from the
 * videoObject package) in optionsSetPort.
 * 
 * Revision 0.10  91/07/12  16:20:26  lim
 * Initial revision implementing VideoObject.
 *  */

#include "VideoEdit.h"

static char optrcs[] = "$Header: /Source/Media/collab/VideoEdit/RCS/VideoEditOptions.c,v 0.30 92/06/15 14:35:52 drapeau Exp $";


/* 	OPTIONS FOR CONTROLLING DISPLAY, SEARCH MODE, AUDIO (POPUP WINDOW 1) 	*/


/*
 * Notify callback function for `setPlayerButton'.
 */
void
  SetPlayerHandler(Panel_item item, Event *event)
{
  int		maxSpeed;
  int		choice;
  int		portSelection;
  int		value;
  char		chosenPlayerMsg[27+MaxNameLength];
  char		chosenPortMsg[29];
  char*		playPort;
  Display*	display;
  
  value = xv_get(VideoEdit_optionsPopup->optionsPlayerStg, PANEL_VALUE); /* Determine currently-selected player, if any */
  if (value == 0)						    /* Chose "None" => Return immediately */
    return;
  
  sprintf(chosenPlayerMsg, "You have chosen the %s player", 
	  allDevices[value-1]);
  portSelection = (int) xv_get(VideoEdit_optionsPopup->optionsPortStg,
			       PANEL_VALUE);
  switch (portSelection)
  {
   case 0:
    strcpy(chosenPortMsg, "and the default serial port.");
    break;
   case 1:
    strcpy(chosenPortMsg, "and serial port A.");
    break;
   case 2:
    strcpy(chosenPortMsg, "and serial port B.");
    break;
  }
  choice = notice_prompt(VideoEdit_optionsPopup->optionsPopup,	    /* Let user confirm player and serial port */
			 NULL, 
			 NOTICE_MESSAGE_STRINGS, chosenPlayerMsg,
			 chosenPortMsg,
			 "Please confirm player and",
			 "serial port selections.",
			 NULL,
			 NOTICE_BUTTON_YES, "Cancel",
			 NOTICE_BUTTON_NO, "OK", 
			 NULL);
  if (choice == NOTICE_YES)
  {
    xv_set(VideoEdit_optionsPopup->optionsPlayerStg, PANEL_VALUE, 0, NULL); /* Set player back to "None" */
    return;
  }
  
  strcpy(deviceName, allDevices[value-1]);			    /* The 0th item is "None" */
  switch (portSelection)
  {
   case 0:
    myVideo = DevInit(deviceName, NULL);
    break;
   case 1:
    myVideo = DevInit(deviceName, "/dev/ttya");
    break;
   case 2:
    myVideo = DevInit(deviceName, "/dev/ttyb");
    break;
  }
  
  if (myVideo)
  {
    maxSpeed = GetDeviceMaxSpeed(myVideo);			    /* Get max speed for current device */
    xv_set(VideoEdit_window1->speedSlider,			    /* Set slider values to correspond exactly to the ... */
	   PANEL_MIN_VALUE, -(maxSpeed),			    /* ... maximum number of frames per second the player ... */
	   PANEL_MAX_VALUE, maxSpeed,				    /* ... can play */
	   NULL);
    
    DevSetDefaults(myVideo, 3, PlayerFrameMode, FeatureOn,
		   DisplayFrameAndChapter);			    /* Set device to default settings */
    
    if (CheckImplemented(myVideo, SetAddModeFunction) == No)	    /* Set appropriate buttons off */
    {
      xv_set(VideoEdit_optionsPopup->optionsSearchStg, PANEL_INACTIVE, TRUE, NULL);
      xv_set(VideoEdit_window1->revSkipButton, PANEL_INACTIVE, TRUE, NULL);
      xv_set(VideoEdit_window1->fwdSkipButton, PANEL_INACTIVE, TRUE, NULL);
    }
    
    if (portSelection == 0)					    /* Using default serial port */
    {
      display =  (Display*) xv_get(VideoEdit_window1->window1, XV_DISPLAY);	
      playPort = XGetDefault(display, deviceName, "serialPort");
      
      if (playPort == NULL)					    /* There are no Xdefault settings */
      {
	if ((strcmp(myVideo->DevConfig->serialPort, "/dev/ttya") == 0) || 
	    (strcmp(myVideo->DevConfig->serialPort, "na") == 0))    /* Defaults to /dev/ttya */
	  xv_set(VideoEdit_optionsPopup->optionsPortStg, PANEL_VALUE, 1, NULL); 
	else 
	  if (strcmp(myVideo->DevConfig->serialPort, "/dev/ttyb") == 0)
	    xv_set(VideoEdit_optionsPopup->optionsPortStg, PANEL_VALUE, 2, NULL); 
      }
      else
	if (strcmp(playPort, "/dev/ttya") == 0)
	  xv_set(VideoEdit_optionsPopup->optionsPortStg, PANEL_VALUE, 1, NULL); 
	else
	  xv_set(VideoEdit_optionsPopup->optionsPortStg, PANEL_VALUE, 2, NULL); 
    }
  }
  else
  {
    notice_prompt(VideoEdit_optionsPopup->optionsPopup,		    /* Player has not responded */
		  NULL, 
		  NOTICE_MESSAGE_STRINGS, "The player has failed to respond.", " ",
		  "Please check that :",
		  "1. You have chosen the correct player.                             ",
		  "2. The player is connected at the serial port you selected.",
		  "3. The baud rate and other player attributes are correct.  ",
		  "4. The player is not busy.                                                 ",
		  " ",
		  "and try again.",
		  NULL,
		  NOTICE_BUTTON, "OK", 100,
		  NULL);
    xv_set(VideoEdit_optionsPopup->optionsPlayerStg, PANEL_VALUE, 0, NULL); /* Set player back to "None" */
  }
  
  /* gxv_start_connections DO NOT EDIT THIS SECTION */
  
  /* gxv_end_connections */
  
}								    /* end function SetPlayerHandler */


/*
 * Notify callback function for `optionsNetworkHost'.
 */
void
SetNetworkHost(item, event)
	Panel_item	item;
	Event		*event;
{

  char* tmp;
  Port senderPort;
  char diagMsg[30];
  
  tmp = (char *) xv_get(item, PANEL_VALUE);
  if ((strlen(tmp) == 0) || (chosenHost && (strcmp(tmp, chosenHost) == 0)))
    return;
  else
    strcpy(chosenHost, tmp);

  if (sender && receiver)
    SenderDisconnectFromPortMgr(sender,&(receiver->receivePort));
  sender = NULL;
  receiver = NULL;
  
  senderPort.hostName = chosenHost;
  senderPort.portNumber = PortMgrPortNumber;
  sender = NewSender(&senderPort);
  if (!sender)
  {
    DisplayError("Host name is not valid", " ");
    return;
  }
  receiver = NewReceiver(sender, "VideoEdit", receiverPort);
  sprintf(diagMsg, "Listening on port %d.\n", receiver->transport->xp_port);
  PrintDiagnostics(diagMsg);
  
  return;
}


/*
 * Notify callback function for `optionsInfoButton'.
 * Opens info popup window.
 */
void
Info(item, event)
     Panel_item      item;
     Event           *event;
{
  xv_set(VideoEdit_infoPopup->infoPopup, 
	 FRAME_CMD_PUSHPIN_IN, TRUE, 
	 NULL);
  xv_set(VideoEdit_infoPopup->infoPopup, 
	 XV_SHOW, TRUE, 
	 NULL);
}


/*
 * Notify callback function for `optionsDisplayStg'.
 * Select display on/off
 */
void
DisplaySelect(item, value, event)
     Panel_item	item;
     int		value;
     Event		*event;
{
  
  if (value == 1) 
    xv_set(VideoEdit_window1->window1, 
	   FRAME_LEFT_FOOTER, "Display : On",
	   NULL);
  else 
    xv_set(VideoEdit_window1->window1, 
	   FRAME_LEFT_FOOTER, "Display : Off",
	   NULL);

  DevSetAddressDisplay(myVideo, value, DisplayFrameAndChapter);
}

/*
 * Notify callback function for `optionsSearchStg'.
 * Set search mode to frame or chapter
 */
void
SearchSet(item, value, event)
     Panel_item	item;
     int		value;
     Event		*event;
{
  if (value == 0) 
  {
    xv_set (VideoEdit_window1->frameTxt,
	    PANEL_LABEL_STRING, "Frame: ",
	    NULL);
  }
  else 
  {
    xv_set (VideoEdit_window1->frameTxt,
	    PANEL_LABEL_STRING, "Chapter: ",
	    NULL);
  }
  xv_set (VideoEdit_window1->frameTxt, PANEL_VALUE, 0, NULL);
  
}


/*
 * Notify callback function for `optionsAudioStg'.
 * Select audio setting 
 */
void
Audio(item, value, event)
     Panel_item	item;
     int		value;
     Event		*event;
{
  int	audioSetting = PlayerAudioStereo;
  
  switch (value) 
  {
   case 0 : xv_set(VideoEdit_window1->window1, FRAME_RIGHT_FOOTER, 
		   "Audio : Off", NULL);
    audioSetting = PlayerAudioMute;
    break;
   case 1 : xv_set(VideoEdit_window1->window1, FRAME_RIGHT_FOOTER, 
		   "Audio : Left", NULL);
    audioSetting = PlayerAudioLeft;
    break;
   case 2 : xv_set(VideoEdit_window1->window1, FRAME_RIGHT_FOOTER, 
		   "Audio : Right", NULL);
    audioSetting = PlayerAudioRight;
    break;
   case 3 : xv_set(VideoEdit_window1->window1, FRAME_RIGHT_FOOTER, 
		   "Audio : Stereo", NULL);
    audioSetting = PlayerAudioStereo;
    break;
  }
  DevSetAudio(myVideo, audioSetting);
  return;
}								    /* end function Audio */



/*
 * Notify callback function for `optionsDoneButton'.
 * To close the options popup window
 */
void
Done(item, event)
     Panel_item      item;
     Event           *event;
{
  SetNetworkHost(VideoEdit_optionsPopup->optionsNetworkHost, NULL);
  xv_set(VideoEdit_optionsPopup->optionsPopup, FRAME_CMD_PUSHPIN_IN, FALSE, NULL);
  xv_set(VideoEdit_optionsPopup->optionsPopup, XV_SHOW, FALSE, NULL);
}

