;GIL-3
(
(
	:type                   :menu
	:name                   previewMenu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             "Video Preview"
	:menu-item-labels       ("Play entire edit" "Play part of edit..." )
	:menu-item-label-types  (:string :string )
	:menu-item-states       (:active :active )
	:menu-item-defaults     (t nil )
	:initial-selections     (nil nil )
	:menu-item-handlers     (PreviewStartEnd EditPreview )
	:menu-item-menus        (nil nil )
	:menu-item-colors       ("" "" )
	:pinnable               t
	:user-data              ()
	:actions                (
		(
		:from                   (previewMenu "Play entire edit")
		:when                   (Notify )
		:to                     (previewMenu "Play entire edit")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (PreviewStartEnd)
		)
		(
		:from                   (previewMenu "Play part of edit...")
		:when                   (Notify )
		:to                     (previewMenu "Play part of edit...")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (EditPreview)
		)
	)
)
(
	:type                   :menu
	:name                   editAudioMenu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             "Stereo"
	:menu-item-labels       ("Stereo" "Right" "Left" "Mute" )
	:menu-item-label-types  (:string :string :string :string )
	:menu-item-states       (:active :active :active :active )
	:menu-item-defaults     (t nil nil nil )
	:initial-selections     (nil nil nil nil )
	:menu-item-handlers     (EditAudioStereo EditAudioRight EditAudioLeft EditAudioMute )
	:menu-item-menus        (nil nil nil nil )
	:menu-item-colors       ("" "" "" "" )
	:pinnable               t
	:user-data              ()
	:actions                (
		(
		:from                   (editAudioMenu "Stereo")
		:when                   (Notify )
		:to                     (editAudioMenu "Stereo")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (EditAudioStereo)
		)
		(
		:from                   (editAudioMenu "Right")
		:when                   (Notify )
		:to                     (editAudioMenu "Right")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (EditAudioRight)
		)
		(
		:from                   (editAudioMenu "Left")
		:when                   (Notify )
		:to                     (editAudioMenu "Left")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (EditAudioLeft)
		)
		(
		:from                   (editAudioMenu "Mute")
		:when                   (Notify )
		:to                     (editAudioMenu "Mute")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (EditAudioMute)
		)
	)
)
(
	:type                   :menu
	:name                   DocMenu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             ""
	:menu-item-labels       ("Open" "Save" "Save As..." "Close File" "Close Window" )
	:menu-item-label-types  (:string :string :string :string :string )
	:menu-item-states       (:active :active :active :active :active )
	:menu-item-defaults     (nil nil nil nil nil )
	:initial-selections     (nil nil nil nil nil )
	:menu-item-handlers     (FileLoad FileSave FileSaveAs EditCloseFile EditCloseWindow )
	:menu-item-menus        (nil nil nil nil nil )
	:menu-item-colors       ("" "" "" "" "" )
	:pinnable               t
	:user-data              ()
	:actions                (
		(
		:from                   (DocMenu "Open")
		:when                   (Notify )
		:to                     (DocMenu "Open")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (FileLoad)
		)
		(
		:from                   (DocMenu "Save")
		:when                   (Notify )
		:to                     (DocMenu "Save")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (FileSave)
		)
		(
		:from                   (DocMenu "Save As...")
		:when                   (Notify )
		:to                     (DocMenu "Save As...")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (FileSaveAs)
		)
		(
		:from                   (DocMenu "Close File")
		:when                   (Notify )
		:to                     (DocMenu "Close File")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (EditCloseFile)
		)
		(
		:from                   (DocMenu "Close Window")
		:when                   (Notify )
		:to                     (DocMenu "Close Window")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (EditCloseWindow)
		)
	)
)
(
	:type                   :base-window
	:name                   window1
	:owner                  nil
	:width                  230
	:height                 419
	:background-color       "BG1"
	:foreground-color       ""
	:label                  "Videodisc Remote Controller"
	:label-type             :string
	:initial-state          :open
	:show-footer            t
	:resizable              t
	:icon-file              "icons/VideoEditIcon"
	:icon-label             ""
	:icon-mask-file         ""
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   remoteCtrlControls
	:owner                  window1
	:help                   ""
	:x                      0
	:y                      0
	:width                  230
	:height                 184
	:background-color       "BG1"
	:foreground-color       "Black"
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   optionsButton
	:owner                  remoteCtrlControls
	:help                   "Opens Options popup."
	:x                      12
	:y                      12
	:width                  75
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "Options..."
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         Options
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 optionsButton)
		:when                   (Notify )
		:to                     (window1 optionsButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Options)
		)
	)
)
(
	:type                   :button
	:name                   editButton
	:owner                  remoteCtrlControls
	:help                   "Opens Edit List popup."
	:x                      100
	:y                      12
	:width                  55
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  " Edit..."
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         Edit
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 editButton)
		:when                   (Notify )
		:to                     (window1 editButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Edit)
		)
	)
)
(
	:type                   :button
	:name                   quitButton
	:owner                  remoteCtrlControls
	:help                   "Quits the application."
	:x                      168
	:y                      12
	:width                  57
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  " Quit  "
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         Quit
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 quitButton)
		:when                   (Notify )
		:to                     (window1 quitButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Quit)
		)
	)
)
(
	:type                   :text-field
	:name                   frameTxt
	:owner                  remoteCtrlControls
	:help                   "Shows frame address."
	:x                      48
	:y                      44
	:width                  132
	:height                 15
	:value-x                105
	:value-y                44
	:value-length           5
	:stored-length          5
	:rows                   3
	:foreground-color       "Black"
	:text-type              :numeric
	:label                  "Frame: "
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:max-value              54000
	:min-value              0
	:initial-value          0
	:initial-state          :active
	:read-only              nil
	:notify-handler         SearchKbd
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 frameTxt)
		:when                   (Notify )
		:to                     (window1 frameTxt)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (SearchKbd)
		)
	)
)
(
	:type                   :button
	:name                   Num1
	:owner                  remoteCtrlControls
	:help                   ""
	:x                      16
	:y                      76
	:width                  58
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "    1    "
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         One
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 Num1)
		:when                   (Notify )
		:to                     (window1 Num1)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (One)
		)
	)
)
(
	:type                   :button
	:name                   Num2
	:owner                  remoteCtrlControls
	:help                   ""
	:x                      88
	:y                      76
	:width                  58
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "    2    "
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         Two
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 Num2)
		:when                   (Notify )
		:to                     (window1 Num2)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Two)
		)
	)
)
(
	:type                   :button
	:name                   Num3
	:owner                  remoteCtrlControls
	:help                   ""
	:x                      160
	:y                      76
	:width                  58
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "    3    "
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         Three
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 Num3)
		:when                   (Notify )
		:to                     (window1 Num3)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Three)
		)
	)
)
(
	:type                   :button
	:name                   Num4
	:owner                  remoteCtrlControls
	:help                   ""
	:x                      16
	:y                      100
	:width                  58
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "    4    "
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         Four
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 Num4)
		:when                   (Notify )
		:to                     (window1 Num4)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Four)
		)
	)
)
(
	:type                   :button
	:name                   Num5
	:owner                  remoteCtrlControls
	:help                   ""
	:x                      88
	:y                      100
	:width                  58
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "    5    "
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         Five
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 Num5)
		:when                   (Notify )
		:to                     (window1 Num5)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Five)
		)
	)
)
(
	:type                   :button
	:name                   Num6
	:owner                  remoteCtrlControls
	:help                   ""
	:x                      160
	:y                      100
	:width                  58
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "    6    "
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         Six
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 Num6)
		:when                   (Notify )
		:to                     (window1 Num6)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Six)
		)
	)
)
(
	:type                   :button
	:name                   Num7
	:owner                  remoteCtrlControls
	:help                   ""
	:x                      16
	:y                      124
	:width                  58
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "    7    "
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         Seven
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 Num7)
		:when                   (Notify )
		:to                     (window1 Num7)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Seven)
		)
	)
)
(
	:type                   :button
	:name                   Num8
	:owner                  remoteCtrlControls
	:help                   ""
	:x                      88
	:y                      124
	:width                  58
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "    8    "
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         Eight
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 Num8)
		:when                   (Notify )
		:to                     (window1 Num8)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Eight)
		)
	)
)
(
	:type                   :button
	:name                   Num9
	:owner                  remoteCtrlControls
	:help                   ""
	:x                      160
	:y                      124
	:width                  58
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "    9    "
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         Nine
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 Num9)
		:when                   (Notify )
		:to                     (window1 Num9)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Nine)
		)
	)
)
(
	:type                   :button
	:name                   searchButton
	:owner                  remoteCtrlControls
	:help                   "Searches for the frame address in the
text field above labelled \"Frame\"."
	:x                      16
	:y                      148
	:width                  58
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "Search"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         Search
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 searchButton)
		:when                   (Notify )
		:to                     (window1 searchButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Search)
		)
	)
)
(
	:type                   :button
	:name                   Num0
	:owner                  remoteCtrlControls
	:help                   ""
	:x                      88
	:y                      148
	:width                  58
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "    0    "
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         Zero
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 Num0)
		:when                   (Notify )
		:to                     (window1 Num0)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Zero)
		)
	)
)
(
	:type                   :button
	:name                   currFrameButton
	:owner                  remoteCtrlControls
	:help                   "Gets current frame."
	:x                      160
	:y                      148
	:width                  56
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "    ?    "
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         CurrentFrame
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 currFrameButton)
		:when                   (Notify )
		:to                     (window1 currFrameButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (CurrentFrame)
		)
	)
)
(
	:type                   :control-area
	:name                   remoteIconControls
	:owner                  window1
	:help                   ""
	:x                      0
	:y                      183
	:width                  230
	:height                 235
	:background-color       "BG1"
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   pauseButton
	:owner                  remoteIconControls
	:help                   "Toggles between pause (still video) and
playback."
	:x                      20
	:y                      8
	:width                  42
	:height                 25
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "icons/pauseIcon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         Pause
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 pauseButton)
		:when                   (Notify )
		:to                     (window1 pauseButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Pause)
		)
	)
)
(
	:type                   :button
	:name                   playButton
	:owner                  remoteIconControls
	:help                   "Set device in playback mode."
	:x                      92
	:y                      8
	:width                  42
	:height                 25
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "icons/playIcon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         Play
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 playButton)
		:when                   (Notify )
		:to                     (window1 playButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Play)
		)
	)
)
(
	:type                   :button
	:name                   stopButton
	:owner                  remoteIconControls
	:help                   "Stops playback. Video mutes."
	:x                      160
	:y                      8
	:width                  42
	:height                 25
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "icons/stopIcon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         Stop
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 stopButton)
		:when                   (Notify )
		:to                     (window1 stopButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Stop)
		)
	)
)
(
	:type                   :button
	:name                   scanRevButton
	:owner                  remoteIconControls
	:help                   "Scans reverse."
	:x                      64
	:y                      48
	:width                  42
	:height                 22
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "icons/rwIcon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         ScanReverse
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 scanRevButton)
		:when                   (Notify )
		:to                     (window1 scanRevButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ScanReverse)
		)
	)
)
(
	:type                   :button
	:name                   scanFwdButton
	:owner                  remoteIconControls
	:help                   "Scans forward."
	:x                      124
	:y                      48
	:width                  42
	:height                 22
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "icons/ffIcon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         ScanForward
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 scanFwdButton)
		:when                   (Notify )
		:to                     (window1 scanFwdButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ScanForward)
		)
	)
)
(
	:type                   :button
	:name                   revSkipButton
	:owner                  remoteIconControls
	:help                   "Searches to the start of the current chapter."
	:x                      12
	:y                      96
	:width                  42
	:height                 22
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "icons/rIndexIcon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         ReverseSkip
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 revSkipButton)
		:when                   (Notify )
		:to                     (window1 revSkipButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ReverseSkip)
		)
	)
)
(
	:type                   :button
	:name                   revStepButton
	:owner                  remoteIconControls
	:help                   "Stills video and reverses video by one frame."
	:x                      72
	:y                      96
	:width                  42
	:height                 22
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "icons/rStepIcon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         ReverseStep
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 revStepButton)
		:when                   (Notify )
		:to                     (window1 revStepButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ReverseStep)
		)
	)
)
(
	:type                   :button
	:name                   fwdStepButton
	:owner                  remoteIconControls
	:help                   "Stills video and advances picture by one
frame."
	:x                      120
	:y                      96
	:width                  42
	:height                 22
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "icons/fStepIcon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         ForwardStep
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 fwdStepButton)
		:when                   (Notify )
		:to                     (window1 fwdStepButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ForwardStep)
		)
	)
)
(
	:type                   :button
	:name                   fwdSkipButton
	:owner                  remoteIconControls
	:help                   "Skips to the next chapter."
	:x                      176
	:y                      96
	:width                  42
	:height                 22
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "icons/fIndexIcon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         ForwardSkip
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 fwdSkipButton)
		:when                   (Notify )
		:to                     (window1 fwdSkipButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ForwardSkip)
		)
	)
)
(
	:type                   :text-field
	:name                   speedTxt
	:owner                  remoteIconControls
	:help                   ""
	:x                      32
	:y                      144
	:width                  96
	:height                 15
	:value-x                88
	:value-y                144
	:value-length           5
	:stored-length          5
	:rows                   3
	:foreground-color       "Black"
	:text-type              :alphanumeric
	:label                  "Speed :"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              t
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   speedMsg
	:owner                  remoteIconControls
	:help                   ""
	:x                      132
	:y                      144
	:width                  67
	:height                 13
	:foreground-color       ""
	:label                  "frames/sec"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :slider
	:name                   speedSlider
	:owner                  remoteIconControls
	:help                   "Shuttle-knob behavior for playing at 
different speeds.
Moving the slider to the right means 
forward play, and moving it to the left
means reverse play.
Upon release of the slider, video stills.
"
	:x                      8
	:y                      172
	:width                  216
	:height                 20
	:value-x                8
	:value-y                172
	:slider-width           200
	:ticks                  0
	:foreground-color       "Black"
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:orientation            :horizontal
	:show-endboxes          nil
	:show-range             nil
	:show-value             nil
	:min-value              -240
	:max-value              240
	:min-value-string       ""
	:max-value-string       ""
	:min-tick-string        ""
	:max-tick-string        ""
	:initial-value          0
	:initial-state          :active
	:notify-handler         Speed
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 speedSlider)
		:when                   (Notify )
		:to                     (window1 speedSlider)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Speed)
		)
	)
)
(
	:type                   :button
	:name                   ejectButton
	:owner                  remoteIconControls
	:help                   "Ejects the disc from the device."
	:x                      88
	:y                      200
	:width                  42
	:height                 22
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "icons/ejectIcon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         Eject
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window1 ejectButton)
		:when                   (Notify )
		:to                     (window1 ejectButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Eject)
		)
	)
)
(
	:type                   :popup-window
	:name                   optionsPopup
	:owner                  window1
	:width                  386
	:height                 227
	:background-color       "BG1"
	:foreground-color       ""
	:label                  "Video Options"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            t
	:resizable              t
	:pinned                 t
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   optionsControls
	:owner                  optionsPopup
	:help                   ""
	:x                      0
	:y                      0
	:width                  385
	:height                 224
	:background-color       "BG1"
	:foreground-color       "Black"
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   optionsPlayerStg
	:owner                  optionsControls
	:help                   "Sets the device to be used with this 
application."
	:x                      44
	:y                      12
	:width                  121
	:height                 23
	:value-x                98
	:value-y                12
	:rows                   1
	:columns                0
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  "Player:"
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("None" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   setPlayerButton
	:owner                  optionsControls
	:help                   ""
	:x                      260
	:y                      16
	:width                  79
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Set Player"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         SetPlayerHandler
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (optionsPopup setPlayerButton)
		:when                   (Notify )
		:to                     (optionsPopup setPlayerButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (SetPlayerHandler)
		)
	)
)
(
	:type                   :setting
	:name                   optionsPortStg
	:owner                  optionsControls
	:help                   "Sets the serial port to which the device
is connected."
	:x                      16
	:y                      40
	:width                  190
	:height                 23
	:value-x                98
	:value-y                40
	:rows                   1
	:columns                0
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :exclusive
	:selection-required     t
	:label                  "Serial Port:"
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("Default" "A" "B" )
	:choice-label-types     (:string :string :string )
	:choice-colors          ("" "" "" )
	:initial-selections     (nil nil nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   optionsNetworkHost
	:owner                  optionsControls
	:help                   "Sets network host, with which the application
will register, so as to allow it to 
communicate with other MAEstro applications
registered with the same host."
	:x                      8
	:y                      76
	:width                  346
	:height                 15
	:value-x                114
	:value-y                76
	:value-length           30
	:stored-length          30
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "Network Host :"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         SetNetworkHost
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (optionsPopup optionsNetworkHost)
		:when                   (Notify )
		:to                     (optionsPopup optionsNetworkHost)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (SetNetworkHost)
		)
	)
)
(
	:type                   :setting
	:name                   optionsAudioStg
	:owner                  optionsControls
	:help                   "Sets the audio during device operation."
	:x                      8
	:y                      104
	:width                  243
	:height                 23
	:value-x                74
	:value-y                104
	:rows                   1
	:columns                0
	:layout-type            :horizontal
	:foreground-color       "Black"
	:setting-type           :exclusive
	:selection-required     t
	:label                  "Audio:    "
	:label-type             :string
	:notify-handler         Audio
	:event-handler          nil
	:choices                ("Off" "Left" "Right" "Stereo" )
	:choice-label-types     (:string :string :string :string )
	:choice-colors          ("" "" "" "" )
	:initial-selections     (nil nil nil nil )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (optionsPopup optionsAudioStg)
		:when                   (Notify )
		:to                     (optionsPopup optionsAudioStg)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Audio)
		)
	)
)
(
	:type                   :setting
	:name                   optionsSearchStg
	:owner                  optionsControls
	:help                   "Sets the mode in which search is carried
out."
	:x                      8
	:y                      144
	:width                  184
	:height                 23
	:value-x                73
	:value-y                144
	:rows                   1
	:columns                0
	:layout-type            :horizontal
	:foreground-color       "Black"
	:setting-type           :exclusive
	:selection-required     t
	:label                  "Search:  "
	:label-type             :string
	:notify-handler         SearchSet
	:event-handler          nil
	:choices                ("Frame" "Chapter" )
	:choice-label-types     (:string :string )
	:choice-colors          ("" "" )
	:initial-selections     (nil nil )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (optionsPopup optionsSearchStg)
		:when                   (Notify )
		:to                     (optionsPopup optionsSearchStg)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (SearchSet)
		)
	)
)
(
	:type                   :setting
	:name                   optionsDisplayStg
	:owner                  optionsControls
	:help                   "Toggles address display between on and off."
	:x                      232
	:y                      144
	:width                  134
	:height                 23
	:value-x                296
	:value-y                144
	:rows                   1
	:columns                0
	:layout-type            :horizontal
	:foreground-color       "Black"
	:setting-type           :exclusive
	:selection-required     t
	:label                  "Display:"
	:label-type             :string
	:notify-handler         DisplaySelect
	:event-handler          nil
	:choices                ("Off" "On" )
	:choice-label-types     (:string :string )
	:choice-colors          ("" "" )
	:initial-selections     (nil nil )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (optionsPopup optionsDisplayStg)
		:when                   (Notify )
		:to                     (optionsPopup optionsDisplayStg)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (DisplaySelect)
		)
	)
)
(
	:type                   :button
	:name                   optionsInfoButton
	:owner                  optionsControls
	:help                   "Opens Info popup."
	:x                      72
	:y                      192
	:width                  55
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Info ..."
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         Info
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (optionsPopup optionsInfoButton)
		:when                   (Notify )
		:to                     (optionsPopup optionsInfoButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Info)
		)
	)
)
(
	:type                   :button
	:name                   optionsDoneButton
	:owner                  optionsControls
	:help                   "Closes Options popup."
	:x                      248
	:y                      192
	:width                  49
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "Done"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         Done
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (optionsPopup optionsDoneButton)
		:when                   (Notify )
		:to                     (optionsPopup optionsDoneButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Done)
		)
	)
)
(
	:type                   :popup-window
	:name                   editPopup
	:owner                  window1
	:width                  529
	:height                 500
	:background-color       "BG1"
	:foreground-color       ""
	:label                  "Untitled"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            nil
	:resizable              nil
	:pinned                 t
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   editFileControls
	:owner                  editPopup
	:help                   ""
	:x                      0
	:y                      0
	:width                  528
	:height                 40
	:background-color       "BG1"
	:foreground-color       "Black"
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   editDocButton
	:owner                  editFileControls
	:help                   "Opens Edit List Document and puts it into
the Edit List."
	:x                      28
	:y                      12
	:width                  94
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "Document"
	:label-type             :string
	:initial-state          :active
	:menu                   DocMenu
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   editScrollListControls
	:owner                  editPopup
	:help                   ""
	:x                      0
	:y                      39
	:width                  529
	:height                 235
	:background-color       "BG1"
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   editListMsg
	:owner                  editScrollListControls
	:help                   ""
	:x                      236
	:y                      16
	:width                  56
	:height                 13
	:foreground-color       "Black"
	:label                  "Edit List"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   editNumEditMsg
	:owner                  editScrollListControls
	:help                   ""
	:x                      396
	:y                      17
	:width                  88
	:height                 13
	:foreground-color       "Black"
	:label                  "No. of Edits : 0"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   editTableHeader
	:owner                  editScrollListControls
	:help                   ""
	:x                      24
	:y                      48
	:width                  388
	:height                 13
	:foreground-color       "Black"
	:label                  "  Edit #           Label                         Start         End      Audio "
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   editTableHeader2
	:owner                  editScrollListControls
	:help                   ""
	:x                      436
	:y                      48
	:width                  41
	:height                 13
	:foreground-color       ""
	:label                  "Speed"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :scrolling-list
	:name                   editScrollList
	:owner                  editScrollListControls
	:help                   "Displays edits."
	:x                      4
	:y                      72
	:width                  490
	:height                 146
	:value-x                4
	:value-y                72
	:rows                   7
	:foreground-color       "Black"
	:label                  ""
	:title                  ""
	:label-type             :string
	:layout-type            :horizontal
	:read-only              nil
	:multiple-selections    nil
	:selection-required     nil
	:initial-state          :active
	:droppable              nil
	:default-drop-site      nil
	:menu                   nil
	:notify-handler         List
	:event-handler          nil
	:initial-list-values    ()
	:initial-list-glyphs    ()
	:initial-selections     ()
	:user-data              ()
	:actions                (
		(
		:from                   (editPopup editScrollList)
		:when                   (Notify )
		:to                     (editPopup editScrollList)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (List)
		)
	)
)
(
	:type                   :control-area
	:name                   editSelectionControls
	:owner                  editPopup
	:help                   ""
	:x                      0
	:y                      273
	:width                  529
	:height                 226
	:background-color       "BG1"
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   editNewEditMsg
	:owner                  editSelectionControls
	:help                   ""
	:x                      176
	:y                      16
	:width                  189
	:height                 13
	:foreground-color       "Black"
	:label                  "Current Selection : New Edit"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   editStartTxt
	:owner                  editSelectionControls
	:help                   "Start frame for current selection."
	:x                      16
	:y                      48
	:width                  130
	:height                 15
	:value-x                71
	:value-y                48
	:value-length           5
	:stored-length          5
	:rows                   3
	:foreground-color       "Black"
	:text-type              :numeric
	:label                  "Start  : "
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:max-value              99999
	:min-value              0
	:initial-value          0
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   editGetStartButton
	:owner                  editSelectionControls
	:help                   "Gets the current frame address as the
start of the current selection."
	:x                      160
	:y                      48
	:width                  34
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "<-"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         GetStart
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (editPopup editGetStartButton)
		:when                   (Notify )
		:to                     (editPopup editGetStartButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (GetStart)
		)
	)
)
(
	:type                   :message
	:name                   editInstruct1
	:owner                  editSelectionControls
	:help                   ""
	:x                      204
	:y                      56
	:width                  113
	:height                 13
	:foreground-color       "Black"
	:label                  "Get current frame "
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   editEndTxt
	:owner                  editSelectionControls
	:help                   "End frame of current selection."
	:x                      16
	:y                      76
	:width                  131
	:height                 15
	:value-x                72
	:value-y                76
	:value-length           5
	:stored-length          5
	:rows                   3
	:foreground-color       "Black"
	:text-type              :numeric
	:label                  "End    : "
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:max-value              99999
	:min-value              0
	:initial-value          0
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   editGetEndButton
	:owner                  editSelectionControls
	:help                   "Gets the current frame address as
the end of the current selection."
	:x                      160
	:y                      76
	:width                  34
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "<-"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         GetEnd
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (editPopup editGetEndButton)
		:when                   (Notify )
		:to                     (editPopup editGetEndButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (GetEnd)
		)
	)
)
(
	:type                   :message
	:name                   editInstruct2
	:owner                  editSelectionControls
	:help                   ""
	:x                      208
	:y                      76
	:width                  109
	:height                 13
	:foreground-color       "Black"
	:label                  "number from disc"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   editSpeedTxt
	:owner                  editSelectionControls
	:help                   "Speed setting for current selection.
Whether any particular speed setting
can be performed for segment play depends
on the device."
	:x                      356
	:y                      80
	:width                  123
	:height                 15
	:value-x                408
	:value-y                80
	:value-length           3
	:stored-length          3
	:rows                   3
	:foreground-color       ""
	:text-type              :numeric
	:label                  "Speed:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:max-value              600
	:min-value              0
	:initial-value          0
	:initial-state          :active
	:read-only              nil
	:notify-handler         EditSpeedStg
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (editPopup editSpeedTxt)
		:when                   (Notify )
		:to                     (editPopup editSpeedTxt)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (EditSpeedStg)
		)
	)
)
(
	:type                   :message
	:name                   editSpeedMsg
	:owner                  editSelectionControls
	:help                   ""
	:x                      416
	:y                      104
	:width                  75
	:height                 13
	:foreground-color       ""
	:label                  "(frames/sec)"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   editDurTxt
	:owner                  editSelectionControls
	:help                   "Approximate duration of current selection."
	:x                      16
	:y                      108
	:width                  228
	:height                 15
	:value-x                180
	:value-y                108
	:value-length           8
	:stored-length          80
	:rows                   3
	:foreground-color       "Black"
	:text-type              :alphanumeric
	:label                  "Approximate duration :"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              t
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   editDurSecMsg
	:owner                  editSelectionControls
	:help                   ""
	:x                      252
	:y                      108
	:width                  48
	:height                 13
	:foreground-color       "Black"
	:label                  "seconds"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   editAudioMenuButton
	:owner                  editSelectionControls
	:help                   "Audio settings for current selection.
Whether any particular setting can
be played during segment play depends
on the device."
	:x                      420
	:y                      136
	:width                  70
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Stereo"
	:label-type             :string
	:initial-state          :active
	:menu                   editAudioMenu
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   editLabelTxt
	:owner                  editSelectionControls
	:help                   "Type in label for current selection here."
	:x                      16
	:y                      140
	:width                  229
	:height                 15
	:value-x                69
	:value-y                140
	:value-length           22
	:stored-length          22
	:rows                   3
	:foreground-color       "Black"
	:text-type              :alphanumeric
	:label                  "Label :"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   editAudioMsg
	:owner                  editSelectionControls
	:help                   ""
	:x                      356
	:y                      140
	:width                  42
	:height                 13
	:foreground-color       ""
	:label                  "Audio:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   editAddButton
	:owner                  editSelectionControls
	:help                   "Adds current selection (including audio
and speed settings) to the Edit List."
	:x                      16
	:y                      176
	:width                  60
	:height                 19
	:constant-width         t
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "    Add"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         EditAdd
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (editPopup editAddButton)
		:when                   (Notify )
		:to                     (editPopup editAddButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (EditAdd)
		)
	)
)
(
	:type                   :button
	:name                   editModButton
	:owner                  editSelectionControls
	:help                   "Changes the current selection in the Edit
List."
	:x                      112
	:y                      176
	:width                  60
	:height                 19
	:constant-width         t
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "  Modify"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         EditModify
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (editPopup editModButton)
		:when                   (Notify )
		:to                     (editPopup editModButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (EditModify)
		)
	)
)
(
	:type                   :button
	:name                   editDelButton
	:owner                  editSelectionControls
	:help                   "Deletes current selection from Edit List."
	:x                      216
	:y                      176
	:width                  60
	:height                 19
	:constant-width         t
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "  Delete"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         EditDelete
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (editPopup editDelButton)
		:when                   (Notify )
		:to                     (editPopup editDelButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (EditDelete)
		)
	)
)
(
	:type                   :button
	:name                   editDelAllButton
	:owner                  editSelectionControls
	:help                   "Deletes all edits in Edit List."
	:x                      312
	:y                      176
	:width                  86
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "Delete All..."
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         EditDeleteAll
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (editPopup editDelAllButton)
		:when                   (Notify )
		:to                     (editPopup editDelAllButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (EditDeleteAll)
		)
	)
)
(
	:type                   :button
	:name                   editPreviewButton
	:owner                  editSelectionControls
	:help                   ""
	:x                      420
	:y                      176
	:width                  60
	:height                 19
	:constant-width         t
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "Preview  "
	:label-type             :string
	:initial-state          :active
	:menu                   previewMenu
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :popup-window
	:name                   previewPopup
	:owner                  window1
	:width                  244
	:height                 172
	:background-color       ""
	:foreground-color       ""
	:label                  "Video Preview"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            nil
	:resizable              nil
	:pinned                 nil
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   previewControls
	:owner                  previewPopup
	:help                   ""
	:x                      0
	:y                      0
	:width                  244
	:height                 172
	:background-color       "BG1"
	:foreground-color       "Black"
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   previewMsg
	:owner                  previewControls
	:help                   ""
	:x                      72
	:y                      16
	:width                  108
	:height                 13
	:foreground-color       "Black"
	:label                  "Play Part of Edit"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   previewSecMsg
	:owner                  previewControls
	:help                   ""
	:x                      88
	:y                      36
	:width                  72
	:height                 13
	:foreground-color       ""
	:label                  "(in seconds)"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   previewPlayFirstButton
	:owner                  previewControls
	:help                   "Plays first x seconds of current 
selection."
	:x                      180
	:y                      64
	:width                  38
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Midnight Blue"
	:label                  "<- "
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         PreviewStart
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (previewPopup previewPlayFirstButton)
		:when                   (Notify )
		:to                     (previewPopup previewPlayFirstButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (PreviewStart)
		)
	)
)
(
	:type                   :text-field
	:name                   previewPlayFirstTxt
	:owner                  previewControls
	:help                   "Number of seconds from the start of 
current selection that is to be
previewed."
	:x                      11
	:y                      68
	:width                  153
	:height                 15
	:value-x                93
	:value-y                68
	:value-length           3
	:stored-length          3
	:rows                   3
	:foreground-color       "Black"
	:text-type              :numeric
	:label                  "Play first : "
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:max-value              999
	:min-value              0
	:initial-value          0
	:initial-state          :active
	:read-only              nil
	:notify-handler         PreviewStartTxt
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (previewPopup previewPlayFirstTxt)
		:when                   (Notify )
		:to                     (previewPopup previewPlayFirstTxt)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (PreviewStartTxt)
		)
	)
)
(
	:type                   :button
	:name                   previewPlayLastButton
	:owner                  previewControls
	:help                   "Plays the last x seconds of the
current selection."
	:x                      180
	:y                      96
	:width                  38
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Midnight Blue"
	:label                  "<- "
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         PreviewEnd
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (previewPopup previewPlayLastButton)
		:when                   (Notify )
		:to                     (previewPopup previewPlayLastButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (PreviewEnd)
		)
	)
)
(
	:type                   :text-field
	:name                   previewPlayLastTxt
	:owner                  previewControls
	:help                   "Number of seconds before the end of 
the current selection to be previewed."
	:x                      11
	:y                      100
	:width                  153
	:height                 15
	:value-x                93
	:value-y                100
	:value-length           3
	:stored-length          3
	:rows                   3
	:foreground-color       ""
	:text-type              :numeric
	:label                  "Play last  : "
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:max-value              100
	:min-value              0
	:initial-value          0
	:initial-state          :active
	:read-only              nil
	:notify-handler         PreviewEndTxt
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (previewPopup previewPlayLastTxt)
		:when                   (Notify )
		:to                     (previewPopup previewPlayLastTxt)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (PreviewEndTxt)
		)
	)
)
(
	:type                   :button
	:name                   previewDoneButton
	:owner                  previewControls
	:help                   "Closes Preview popup."
	:x                      68
	:y                      132
	:width                  104
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "Close window"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         PreviewDone
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (previewPopup previewDoneButton)
		:when                   (Notify )
		:to                     (previewPopup previewDoneButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (PreviewDone)
		)
	)
)
(
	:type                   :popup-window
	:name                   infoPopup
	:owner                  window1
	:width                  501
	:height                 291
	:background-color       ""
	:foreground-color       ""
	:label                  "Video Info"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            nil
	:resizable              nil
	:pinned                 nil
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   infoControls
	:owner                  infoPopup
	:help                   ""
	:x                      0
	:y                      0
	:width                  501
	:height                 291
	:background-color       "BG1"
	:foreground-color       "BG1"
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   infoMsg5
	:owner                  infoControls
	:help                   ""
	:x                      170
	:y                      16
	:width                  164
	:height                 13
	:foreground-color       "Black"
	:label                  "Video Edit   Version 1.12"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   infoMsg6
	:owner                  infoControls
	:help                   ""
	:x                      49
	:y                      48
	:width                  398
	:height                 13
	:foreground-color       "Black"
	:label                  "An application for annotating video from videodisc (or videotape)"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   infoMsg7
	:owner                  infoControls
	:help                   ""
	:x                      32
	:y                      68
	:width                  430
	:height                 13
	:foreground-color       ""
	:label                  "designed for use with the MAEstro Multimedia Authoring Environment"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   infoMsg1
	:owner                  infoControls
	:help                   ""
	:x                      192
	:y                      112
	:width                  111
	:height                 13
	:foreground-color       "Black"
	:label                  "by Wee-Lee Lim"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   infoMsg3
	:owner                  infoControls
	:help                   ""
	:x                      20
	:y                      152
	:width                  457
	:height                 13
	:foreground-color       "Black"
	:label                  "Copyright (C) 1990, 1991, 1992 Libraries and Information Resources (L&IR)"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   infoMsg2
	:owner                  infoControls
	:help                   ""
	:x                      187
	:y                      176
	:width                  122
	:height                 13
	:foreground-color       "Black"
	:label                  " Stanford University"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   infoMsg4
	:owner                  infoControls
	:help                   ""
	:x                      192
	:y                      196
	:width                  119
	:height                 13
	:foreground-color       "Black"
	:label                  "Stanford, California"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   infoMsg8
	:owner                  infoControls
	:help                   ""
	:x                      94
	:y                      232
	:width                  309
	:height                 13
	:foreground-color       ""
	:label                  "For more info, contact maestro@sioux.stanford.edu"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   infoOkButton
	:owner                  infoControls
	:help                   "Closes Info Popup."
	:x                      230
	:y                      264
	:width                  36
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "OK"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         InfoDone
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (infoPopup infoOkButton)
		:when                   (Notify )
		:to                     (infoPopup infoOkButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (InfoDone)
		)
	)
)
)
