/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/TimeLine/RCS/main.h,v 1.12 92/10/07 15:15:42 drapeau Exp $ */
/* $Log:	main.h,v $
 * Revision 1.12  92/10/07  15:15:42  drapeau
 * New version of TimeLine adds two command-line options: "-autoPlay" and
 * "-autoQuit".  "-autoPlay" indicates that TimeLine should immediately begin
 * performance of the document given on the command line (if there is one).
 * "-autoQuit" indicates that TimeLine should quit immediately after
 * completion of performance of the document given on the command line.
 * The "-autoQuit" flag is only valid if "-autoPlay" is also specified.
 * These two options were added to support automated demos using TimeLine.
 * 
 * Revision 1.11  92/09/24  17:13:15  drapeau
 * Added code to support synchronization information when available:
 * * Defined three new constants to indicate whether a document has
 *   synchronization information available (a.k.a., "sync hints") or not,
 *   or whether the document is currently generating sync hints (as when the
 *   author chooses "Synchronize This Document" from the TimeLine's Play menu).
 * * Added a field to the "TimeLineFrame" structure: the "syncHints" field
 *   is set to one of the defined constants just mentioned.
 * Other changes are cosmetic to improve readability and better conform to
 * ANSI-C standards.
 * 
 * Revision 1.1  92/01/03  17:33:14  drapeau
 * Removed inclusion of string.h, letting the XView headers
 * include the proper definitions.
 * 
 * Revision 1.0  91/09/30  17:03:42  chua
 * Update to version 1.0
 * 
 * Added a new element to the tlFrame data structure : TimeLinePort.
 * 
 * Revision 0.85  91/09/25  14:05:20  chua
 * Changed InitInstInfoWindow to InitEditInfoWindow.
 * 
 * Revision 0.84  91/09/25  13:43:36  chua
 * Changed the name InstrumentInfo to EditInfo
 * 
 * Revision 0.83  91/09/23  17:22:34  chua
 * Introduced a new element, noteInstrument to the tlFrame structure.
 * This keeps track of which instrument has the currently selected note.
 * 
 * Revision 0.82  91/09/20  15:04:47  chua
 * Added the extern declarations of the functions in cursor.c
 * 
 * Revision 0.81  91/09/19  17:28:52  chua
 * Make sure that variables are initialized properly.  Change formatting slightly,
 * so that (if, for, while) statements with only one statement in them will not have
 * braces.
 * 
 * Revision 0.80  91/09/17  17:20:35  chua
 * Renamed Region to tlRegion.
 * 
 * Revision 0.79  91/09/16  15:15:35  chua
 * 
 * Deleted the include line for Browse.h (it is now only included in the files that
 * require it).
 * 
 * Revision 0.78  91/09/09  15:03:43  chua
 * Include the extern declarations of AlertMessage and GetUnknownIcon.
 * 
 * Revision 0.77  91/09/04  15:14:16  chua
 * Deleted the TimeLineHome variable and added a new Server_image variable,
 * unknownIcon, which stores the server image for the unknown icon.
 * 
 * Revision 0.76  91/08/26  14:22:16  chua
 * Removed the actualApps variable from the tlFrame structure.
 * 
 * Revision 0.75  91/08/21  16:54:47  chua
 * Defined 3 new constants: 
 * PingTimes - number of times to ping an application to see if it is responding
 * TimeThreshold - the time between a double click
 * DistanceThreshold - the amount of distance a mouse can move while detecting a
 * 			double click or positioning the playback head.
 * 
 * Revision 0.74  91/08/20  16:16:58  chua
 * Make the startApp and numApps variable previously declared as static in play.c global.
 * This is to allow their usage by the functions in stop.c
 * 
 * Revision 0.73  91/08/16  17:07:59  chua
 * Changed the OpenPanel include file to Browse.
 * 
 * Revision 0.72  91/08/16  13:52:59  chua
 * Introduced a new constant, Waiting, which is used to determine the type of 
 * application icon to be drawn (with a red background).
 * 
 * Move the function DrawPlaybackHead to drawCanvas.c and the PauseResumeHandler to
 * stop.c
 * 
 * Revision 0.71  91/08/12  15:17:14  chua
 * Added a CloseFile definition for the optypes used for checking if changes
 * have been made.
 * 
 * Revision 0.70  91/08/09  15:09:00  chua
 * The AppCanvasRepaintHandler extern function now belongs to a new file, appCanvas.c
 * 
 * Revision 0.69  91/08/08  14:19:06  chua
 * Added a new extern function declaration for CheckAppOpen in mute.c
 * 
 * Revision 0.68  91/08/05  12:58:12  chua
 * Changed the extern function ScrollToMiddle to ScrollToFirstQuarter
 * 
 * Revision 0.67  91/08/02  11:38:02  chua
 * Included two more extern function declarations for note.c:
 * InsertNewNote and DrawMoveNote
 * 
 * Revision 0.66  91/07/30  11:27:18  chua
 * Include the OpenPanel.h header file which contains the definitions for the
 * file browser  
 * 
 * Revision 0.65  91/07/26  17:18:57  chua
 * Added a few variables in the TimeLine data structure to deal with annotated
 * regions.
 * 
 * Also declare as externs the functions in region.c that are called by other
 * functions in other files.
 * 
 * Revision 0.64  91/07/24  10:56:41  chua
 * Define MaxLabelLength to be 256 (maximum label length for a note).
 * Also declare as externs the functions in pause.c that are called by functions in other
 * files.
 * 
 * Revision 0.63  91/07/22  15:24:10  chua
 * Added a few variables in the TimeLine data structure to deal with the pause markers.
 * 
 * Revision 0.62  91/07/18  15:02:45  chua
 * Added a new variable, gridSpacing, to the TimeLine data structure to keep track of the
 * grid spacing currently in use.
 * 
 * Revision 0.61  91/07/17  16:27:21  chua
 * In the TimeLine data structure, include a pointer to the Info popup window.
 * 
 * Revision 0.60  91/07/17  10:08:49  chua
 * Included a new variable in the TimeLine structure, canvasStart, which indicates
 * the starting position (in pixels) with relation to the whole TimeLine.
 * 
 * Added a new file, moveCanvas.c, and defined its functions :
 * ShowNewCanvas, CheckHorizontalScrolling, CheckVerticalScrolling,
 * HorizontalScrollHandler, VerticalScrollHandler.
 * 
 * Revision 0.59  91/07/09  16:58:19  chua
 * Added the extern definitions of functions which are called by other program
 * modules.
 * 
 * Revision 0.58  91/06/27  11:50:32  chua
 * Added a new constant ResumeSelectedMode, to aid with keeping track of states during
 * pause and resume.
 * 
 * Revision 0.57  91/06/26  16:42:51  chua
 * Added a new field, zoomLevel to the TimeLineFrame structure.  This indicates the current zoom
 * display level.
 * Also added new constants, PauseMode, PauseSelectedMode, ResumeMode.
 * Another new variable is ReceiverPortNumber, which will not be used at the moment.
 * 
 * Revision 0.56  91/06/05  16:24:53  chua
 * Delete the startUp variable from the TimeLineFrame structure as it is no longer needed.
 * 
 * Revision 0.55  91/06/04  17:37:18  chua
 * Added the copyright comments in the beginning of the file.
 * 
 * Revision 0.54  91/06/04  17:27:18  chua
 * Added a new variable, numberOfWindows, to indicate how many Document windows are 
 * currently open.
 * 
 * Revision 0.53  91/06/04  10:42:31  chua
 * Added a new array WindowFree to keep track of which TimeLine window is
 * currently open.
 * 
 * Revision 0.52  91/06/03  11:12:46  chua
 * Revamped the data structure so that all the data structures pertaining to
 * the control of the TimeLine is encapsulated in a struct.  This allows
 * multiple documents to be created by having an array of this struct.
 * 
 * Revision 0.51  91/05/28  12:11:02  chua
 * 
 * 
 * Revision 0.50  91/05/24  16:37:05  chua
 * *** empty log message ***
 * 
 * Revision 0.49  91/05/23  17:39:24  chua
 * Added the object handler for the Insert Blank Time popup window XView objects.
 * 
 * Revision 0.48  91/05/22  16:40:19  chua
 * 
 * 
 * Revision 0.47  91/05/22  13:56:16  chua
 * 
 * 
 * Revision 0.46  91/05/22  11:52:15  chua
 * *** empty log message ***
 * 
 * Revision 0.45  91/05/17  16:55:29  chua
 * *** empty log message ***
 * 
 * Revision 0.44  91/05/17  16:55:25  chua
 * *** empty log message ***
 * 
 * Revision 0.43  91/05/15  14:08:38  chua
 * A new global variable  Instrument *selectedInstrument is added.  This is a pointer to the current 
 * instrument node which has a note selected (either from the notes info panel or by clicking on it.  Note
 * selection is now exclusive, meaning only one selected note per timeline document, instead of one note
 * per instrument as previously.
 * 
 * 
 * Revision 0.42  1991/05/15  02:56:57  chua
 * Two constants are defined, OK and Error, as return values from function calls.  This is
 * for readability of code only.
 *
 * Revision 0.41  1991/04/24  00:44:48  chua
 * Added some new variables to deal with selection procedures.  They are:
 * int areaSelected
 * int startX, endX, startY, endY
 * int clipDuration
 * Instrument *clipInstHead
 *
 * Revision 0.40  1991/03/29  00:15:43  chua
 * This file contains some widely used global constant definitions and global variables.  It also includes
 * most of the include files necessary for the TimeLine application and this file is included by most of the
 * C files.
 * */

static char mainHrcsid[] = "$Header: /Source/Media/collab/TimeLine/RCS/main.h,v 1.12 92/10/07 15:15:42 drapeau Exp $";

#ifndef _main_
#define _main_

#include <stdio.h>
#include <sys/param.h>
#include <xview/cms.h>
#include <xview/xv_xrect.h>
#include <xview/font.h>
#include <xview/svrimage.h>
#include <xview/icon.h>
#include <xview/xview.h>
#include <xview/notice.h>
#include <xview/notify.h>
#include <xview/textsw.h>
#include <xview/scrollbar.h>
#include <xview/panel.h>
#include <MAEstro.h>
#include <Receiver.h>
#include <Sender.h>
#include "TimeLine_ui.h"
#include "EditInfo_ui.h"
#include "ConnectPortManager_ui.h"
#include "BlankTime_ui.h"
#include "Info_ui.h"
#include "Pause_ui.h"
#include "Region_ui.h"
#include "instrument.h"

#define MaxTimeLineWindows 10					    /* Maximum # of documents that can be opened simultaneously */
#define Grey84     	0					    /* Color definitions used in the canvas colormaps */
#define Grey92     	1
#define Grey65     	2
#define White      	3
#define Red	    	4
#define Unused2    	5
#define Unused3    	6
#define Black      	7
#define NumColors  	8

#define Raised 		0					    /* Used to determine if a box border should be raised... */
#define Sunken 		1					    /* ...or sunken or in wait state (background red) */
#define Waiting		2

#define FileLoad 	0					    /* Used for error checking when opening or saving files */
#define FileSave 	1

#define LoadFile	0					    /* Optypes used for checking if changes have been made. */ 
#define ClearAll 	1
#define ConnectPM 	2
#define QuitTimeLine	3
#define CloseFile	4

/* Define the state of the TimeLine editor */
#define PlayMode		0
#define PlaySelectedMode	1
#define StopMode		2
#define PauseMode		3
#define PauseSelectedMode	4
#define ResumeMode		5
#define ResumeSelectedMode	6

/* Constants for synchronization routines */
#define GeneratingSyncHints	0
#define NoSyncHintsAvailable	1
#define SyncHintsAvailable	2

/* Define if a check is ok */
#define OK	0
#define Error	1

#define PingTimes		4				    /* Number of times to ping an application before giving up */
#define TimeThreshold   	500				    /* Time interval for detection of double click (1/2 second) */
#define DistanceThreshold 	3				    /* Distance interval for either a double click or positioning of playback head */
#define MaxWindows 	10					    /* Maximum number of timeline documents that can be opened */
#define TimeLineName "TimeLine"					    /* Name that this app registers with the PortManager */
#define UnknownIconName "Unknown"				    /* Name of icon file for applications not known to TimeLine */

extern Attr_attribute	INSTANCE;				    /* Used to easily recover xview objects */

struct TimeLineFrame
{
  TimeLine_window_objects*			TimeLine_window;    /* Pointer to the base window object */
  BlankTime_InsertBlankTimePopup_objects*	InsertBlankTimePopup;
  Info_InfoPopup_objects			*InfoPopup;
  Pause_PausePopup_objects			*PausePopup;
  Region_RegionPopup_objects			*RegionPopup;
  ConnectPortManager_PortManagerPopup_objects	*PortManagerPopup;
  
  char filename[MAXPATHLEN];					    /* Name of the current document being edited */
  
  /* The following are parameters required to performing drawing on the three different canvases: Application, Draw and TimeLine */
  Display *dpyDraw, *dpyApp, *dpyTime;
  GC gc;							    /* GC for canvas drawing */
  GC gcLine;							    /* GC for the playback head, drawing mode is set to XOR */
  Xv_cmsdata cms_data;
  Window xidDraw, xidApp, xidTime;
  Xv_Window paintWinDraw, paintWinApp, paintWinTime;
  int pixelTable[NumColors];
  
  /* Handlers to the canvas scrollbars */
  Scrollbar DrawScrollbarVer, DrawScrollbarHor, AppScrollbar, TimeScrollbar;
  Scrollbar TimeScrollbarV;					    /* not used */
  int areaSelected;						    /* Indicates if an area on the canvas has been selected */
  int noteSelected;						    /* Indicates if a note has been selected */
  int startX, endX;						    /* Start and end X positions of a selected area */
  int startY, endY;						    /* Start and end Y positions of a selected area */
  int startnoteX, endnoteX;					    /* Start and end X positions of a selected note */
  int startnoteY, endnoteY;					    /* Start and end Y positions of a selected note */
  int zoomLevel;						    /* Zoom level of the display, w/respect to edit mode level */
  int status;							    /* Current state of TimeLine, whether in play or stop mode */
  int numberOfApps;						    /* Number of applications currently opened */
  int chosenApp;						    /* Currently chosen application */
  Sender *TimeLineSender;					    /* Sender to the port manager */
  Receiver *TimeLineReceiver;					    /* Receiver for the TimeLine app */
  Port TimeLinePort;
  int TimeLineLength;						    /* Length of the TimeLine in pixels */
  int canvasStart;						    /* Starting pixel of the current TimeLine canvas */
  int change;							    /* Flag to indicate if change has been made to the TimeLine document */
  int gridSpacing;						    /* Indicates the spacing of the grid to be drawn (if zero, then no grid) */
  long lastX;							    /* Current position of the playback head */
  Instrument *instHead;						    /* Head pointer to instrument list */
  Instrument *selectedInstrument;				    /* Pointer to the instrument which is currently selected (icon depressed) */
  Instrument *noteInstrument;					    /* Pointer to the instrument which has a note selected */
  Pause *pauseHead;						    /* Head pointer to the pause marker list */
  Pause *selectedPause;						    /* Pointer to the selected pause marker */
  int numPause;							    /* Number of pause markers */
  int pauseEdit;						    /* The current entry in the pause marker panel list that is chosen */
  Pause *donePause;						    /* Indicates that this pause has already been performed */
  tlRegion *regionHead;						    /* Head pointer to the region info list */
  tlRegion *selectedRegion;					    /* Pointer to the selected region node */
  int numRegion;						    /* Number of regions */
  int regionEdit;						    /* The current entry in the region panel list that is chosen */
  int syncHints;						    /* Indicates whether sync hint information is available */
};

typedef struct TimeLineFrame *TimeLineFramePtr;
extern TimeLineFramePtr TimeLineWindow[MaxWindows + 1];
extern int WindowFree[MaxWindows + 1];
extern int paletteName;						    /* Counter to differentiate between the different palette names */
extern int scrollHorStart, scrollHorEnd;			    /* Horizontal start and end point of the canvas window */
extern int scrollVerStart, scrollVerEnd;			    /* Vertical start and end point of the canvas window */
extern int numberOfWindows;					    /* Indicates how many windows are currently open */

extern char TimeLineHostname[MAXHOSTNAMELEN];			    /* Hostname of PortManager that the TimeLine editor is checked with */ 
extern char TimeLineHost[MAXHOSTNAMELEN];			    /* Host from where the TimeLine Editor is launched */

extern int ReceiverPortNumber;					    /* Port number for the TimeLine to listen on */
extern Instrument *clipInstHead;				    /* Head pointer to the selected instrument list */
extern int clipDuration;					    /* Duration of the selected area in the clipboard */
extern Xv_font *font;						    /* Font used in the note info panel list */
extern int quitAll;						    /* Flag to indicate if quitting all TL windows is desired */
extern int			autoPlay;			    /* Flags to indicate command-line options telling TL... */
extern int			autoQuit;			    /* ...to begin playback immediately & quit after done. */

extern int startApp;						    /* The starting application to be played during playback */
extern int numApps;						    /* The number of applications to be played during playback */
extern Server_image unknownIcon;				    /* Server image of the unknown app icon */

								    /* External declarations of functions */
extern void CheckOptions();					    /* TimeLine.c */
extern void TimeLineInit();
extern void UpdateHeader();
extern void AlertMessage();
extern void GetUnknownIcon();

extern void CanvasInit();					    /* Canvas.c */
extern void SetCanvasHeight();
extern void DrawCanvasRepaintHandler();
extern void TimeCanvasRepaintHandler();

extern void OpenAppsInitialize();				    /* openApps.c */
extern Server_image OpenAppsFindIcon();
extern Menu_item ShowApplicationHandler();
extern Menu_item UpdateAppsHandler();
extern Menu_item HideApplicationHandler();

extern Instrument* InstrumentNew();				    /* instrument.c */
extern void AddInstrument();
extern void FreeInstrumentList();
extern Instrument* FindInstrument();
extern void DrawTimeLine();
extern void InstrumentDrawIcon();
extern void InstrumentDraw();

extern int OpenHandler();					    /* file.c */
extern int SaveHandler();	
extern Menu_item QuitHandler();

extern void ClearAllNotes();					    /* note.c */
extern void DeleteNote();
extern void CalculateNoteTime();
extern void AddandDisplayNewNote();
extern int InsertNewNote();
extern void DrawMoveNote();

extern void PlayStop();						    /* play.c */
extern Menu_item	PlaySelectedHandler();
extern Menu_item	PlayFromHandler();
extern void		BlinkPlayButton(void);
extern void		UpdatePlaybackHead(void);
extern void 		PrepareNoteForPerformance(Instrument*, int);
extern void		ResumeOrPerformSelection(void);
extern Note*		FindNextNoteToPerform(Instrument*);
extern void		UpdateEndTime(Instrument*);
extern void		StopPlayingSelection(void);
extern void		UpdateSyncHints(int);
extern int		CalculateStartTime(Instrument*);

extern void InitEditInfoWindow();				    /* notesInfo.c */
extern void ShowInfoWindow();
extern void InitNotesInfo();
extern void SelectNoteInfo();
extern void DeselectNote();

extern void DrawSelectArea();					    /* select.c */
extern void CopyToClipboard();
extern void DeleteNotesFromList();
extern void PasteFromClipboard();

extern void DimButtons();					    /* dim.c */

extern void InstrumentMute();					    /* mute.c */
extern int CheckAppOpen();

extern void ShowNewCanvas();					    /* moveCanvas.c */
extern void CheckHorizontalScrolling();
extern void CheckVerticalScrolling();
extern Notify_value HorizontalScrollHandler();
extern Notify_value VerticalScrollHandler();
extern void ScrollToFirstQuarter();

extern void DrawGrid();						    /* grid.c */

extern void FreePause();					    /* pause.c */
extern void UpdatePauseList();
extern void ClearAllPause();

extern void FreeRegion();					    /* region.c */
extern void UpdateRegionList();
extern void ClearAllRegion();
extern void SetStartEndRegion();

extern void AppCanvasRepaintHandler();				    /* appCanvas.c */
extern int CheckDoubleClick();

extern void DrawPlaybackHead();					    /* drawCanvas.c */

extern void PauseResume();					    /* stop.c */

extern Menu_item ClearAllHandler();				    /* edit.c */
extern Menu_item CopyHandler();
extern Menu_item CutHandler();
extern Menu_item PasteHandler();

extern void CreateCursor();					    /* cursor.c */
extern void NormalCursor();
extern void BusyCursor();
extern void ConnectPortManager();				    /* connect.c */

#endif
