/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/TimeLine/RCS/connect.c,v 1.1 91/10/03 17:40:01 chua Exp Locker: drapeau $ */
/* $Log:	connect.c,v $
 * Revision 1.1  91/10/03  17:40:01  chua
 * *** empty log message ***
 * 
 * Revision 1.0  91/09/30  16:50:12  chua
 * Initial revision
 *  */

static char connectrcsid[] = "$Header: /Source/Media/collab/TimeLine/RCS/connect.c,v 1.1 91/10/03 17:40:01 chua Exp Locker: drapeau $";

#include "main.h"

/*
 * Notify callback function for `NewPortManagerText'.
 * Calls the notify function for the ConnectPortManagerButton when a return is pressed.
 */
Panel_setting NewPortManager(item, event)
     Panel_item	item;
     Event		*event;
{
  ConnectPortManager(item, NULL);
  return panel_text_notify(item, event);
}

/*
 * Notify callback function for `ConnectPortManagerButton'.
 * This function will take the name specifed on the NewPortManagerText textfield and attempt to make a connection 
 * with the port manager on this host.  If it succeeds, it will disconnect from the previous port manager it was connected to (if any).
 */
void ConnectPortManager(item, event)
     Panel_item	item;
     Event		*event;
{
  Sender *tempSender;
  char buf[100];
  ConnectPortManager_PortManagerPopup_objects	*ip = (ConnectPortManager_PortManagerPopup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
  TimeLineFramePtr tlFrame;
  Window	owner = xv_get(ip->PortManagerPopup, XV_OWNER);
  TimeLine_window_objects * tlip = (TimeLine_window_objects *) xv_get(owner, XV_KEY_DATA, INSTANCE);

  tlFrame = TimeLineWindow[xv_get(tlip->controls, PANEL_CLIENT_DATA)];


  if (strcmp(tlFrame->TimeLinePort.hostName,			    /* Do not reconnect if it is the same host, just do an update apps */
	     (char *) xv_get(ip->NewPortManagerText, PANEL_VALUE)) == 0) 
  {
    UpdateAppsHandler(tlFrame->TimeLine_window->appButton, MENU_NOTIFY);
    return;
  }
  if (CheckChanges(ConnectPM, tlFrame) == NOTICE_YES)		    /* check if unsaved changes exist */
    return;
  strcpy(tlFrame->TimeLinePort.hostName, (char *) xv_get(ip->NewPortManagerText, PANEL_VALUE));
  tempSender = NewSender(&(tlFrame->TimeLinePort));
  if (tempSender)
  {
    if (tlFrame->TimeLineSender && tlFrame->TimeLineReceiver)	    /* Disconnect from previous Port Manager (if any) */
      DestroyReceiver(tlFrame->TimeLineSender, tlFrame->TimeLineReceiver);
    tlFrame->TimeLineSender = tempSender;
    tlFrame->TimeLineReceiver = NewReceiver(tlFrame->TimeLineSender, "TimeLine", ReceiverPortNumber);
    sprintf(buf, "Current Port Manager : %s\n", tlFrame->TimeLinePort.hostName);
    xv_set(ip->CurrentPortManagerMsg, PANEL_LABEL_STRING, buf, NULL);
    FreePause(tlFrame);
    UpdatePauseList(tlFrame, 0);
    ClearAllRegion(tlFrame->RegionPopup->ClearAllRegionButton, NULL); /* Clear all the region */
    FreeInstrumentList(tlFrame);
    strcpy(tlFrame->filename, "untitled");
    tlFrame->change = 0;
    UpdateHeader(tlFrame, 0);
    OpenAppsInitialize(tlFrame, 1);				    /* Get the new list of open applications from the new Port Manager */
    SetCanvasHeight(tlFrame);
    AppCanvasRepaintHandler(tlFrame->TimeLine_window->AppCanvas, tlFrame->paintWinApp, 
			    tlFrame->dpyApp, tlFrame->xidApp, NULL);
    ScrollToFirstQuarter(tlFrame, 0, 1);
  }
  else 
    AlertMessage(tlFrame, "Failed to connect with the PortManager.",
		 "Check that the hostname is valid, and that the PortManager is running on it.", NULL);
}

/*
 * Notify callback function for `ClosePortManagerPopupButton'.
 * Close the Connect Port Manager popup window
 */
void ClosePortManagerPopup(item, event)
     Panel_item	item;
     Event		*event;
{
  ConnectPortManager_PortManagerPopup_objects	*ip = (ConnectPortManager_PortManagerPopup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

  xv_set(ip->PortManagerPopup, FRAME_CMD_PUSHPIN_IN, FALSE, NULL);
  xv_set(ip->PortManagerPopup, XV_SHOW, FALSE, NULL);
}

/*
 * Menu handler for `OptionsMenu (Connect with new Port Manager ...)'.
 * Open the popup window to choose a new port manager to connect to.
 */
Menu_item ConnectPortManagerHandler(item, op)
     Menu_item	item;
     Menu_generate	op;
{
  TimeLineFramePtr tlFrame;
  TimeLine_window_objects * ip = (TimeLine_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

  tlFrame = TimeLineWindow[xv_get(ip->controls, PANEL_CLIENT_DATA)];
  switch (op) 
  {
   case MENU_DISPLAY:
    break;
   case MENU_DISPLAY_DONE:
    break;
   case MENU_NOTIFY:
    xv_set(tlFrame->PortManagerPopup->PortManagerPopup, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
    xv_set(tlFrame->PortManagerPopup->PortManagerPopup, XV_SHOW, TRUE, NULL);
    break;
   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}
