/*
 * Copyright (c) 1990, 1991, 1992 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/QuoteMaker/RCS/selectionUtils.c,v 2.11 92/05/14 15:42:36 drapeau Exp $ */
/* $Log:	selectionUtils.c,v $
 * Revision 2.11  92/05/14  15:42:36  drapeau
 * * Updated copyright information.
 * * Removed SemiHighlightSelection() as it is no longer used.
 * * Removed inclusion of "gdd.h" file as it is not used by
 *   this file.
 * 
 * Revision 2.10  91/12/31  18:45:24  drapeau
 * Removed the inclusion of string.h, since XView will include the
 * appropriate definitions.
 * 
 * Revision 2.0  91/09/30  15:02:45  derek
 * Version number changed to 2.0.
 * 
 * Revision 1.37  91/09/15  20:06:34  derek
 * The following things are done:
 * 1.      The foreground of mainTextPane and Quote Window are set to be black.
 *         Also, the color of all the text fields are set to black.
 * 2.      Now the quoted text will be shown directly on the Quote Window
 *         when a panel-item selection is made.  The text will also be shown
 *         while the author is highlighting a selection in the text window.
 * 3.      The inconsistency problem regarding text selection is being taken
 *         care of.  When the mouse cursor re-enters the text window,
 *         the selection will be highlighted again.
 * 4.      When the play button is pressed, the text currently selected
 *         in the text window (rather than the text initially associated
 *         with the edit) will be displayed.
 * 5.      The name of the menu_option "Show Quote Window Specifications panel"
 *         is shortened to be "Quote Window Options ..."
 * 6.      A notify_interpose_destroy_func() is being added to fix the bug
 *         that QuoteMaker might exit without killing the Quote Window (which
 *         is also a base window).
 * 7.      When a different font family or font style is selected, the change
 *         will be automatically be reflected on the Quote Window (without the
 *         need to "play" the edit in order to verify the font).  For font
 *         size, the change will be reflected when either a return character is
 *         entered at the text field or when one of those numeric "arrows"
 *         are pressed.
 * 8.      The play button will now flash when an edit is being played.
 *         Pause button will also glow when playing is paused.
 * 9.      In the course of playing, when another edit is selected,
 *         the playing will be stopped.
 * 10.     I have used Saber to clean up the code.
 * 11.     The left-over "NewEditListPopUp" window is removed.
 * 12.     The bug that when quote window is iconified, it wont be un-iconified
 *         when the edit is played in timeline, is fixed.
 * 13.     The DurationEstimate function is changed so that it no longer
 *         needs an edit to be selected first.  It will take textWindowStart
 *         and textWindowEnd directly as input parameters.
 * 
 * 
 * 
 * Revision 1.36  91/09/05  15:48:05  derek
 * The following changes are made:
 * 1.      The name "Quoted Text Window" has been changed to "Quote Window"
 *         in the app.
 * 2.      ShowApplication() and HideApplication() is changed because of the
 *         the change of quote window from a popup to a basewindow.
 * 3.      The QuitProc of QuoteMaker is fixed so that the quote window,
 *         as a base window, will be destroyed separately.
 * 4.      Now hitting return in the label field will not result in adding
 *         a new edit.
 * 5.      Copyright messages are included in front of every .h and .c file.
 * 6.      The scrollbar and the footer of the Quote Window are hidden.
 * 7.      I have changed the include openpanel.h statement in QuoteMaker.c
 *         to include Browse.h.
 * 8.      The delete bug corresponding to the change that the panel-list
 *         must have a choice -- is fixed.  Also, the corresponding bug
 *         for deleteAll is also fixed.
 * 9.      Now, deleteAll and deletion of the last item in Panel_list
 *         will cause the panel-list to be destroyed and a new one will
 *         be created.
 * 10.     GetOpt files have been removed from the directory.  Corresponding
 *         changes are made.
 * 11.     The start and end byte fields are removed from the main panel.
 * 12.     I have put iconify, hide and show quote window to be buttons
 *         instead of menu options.
 * 13.     I have removed the PreviewPanelPopup and incorporated its features into
 *         the main panel.  The three buttons:  pause, play and stop and
 *         the DurationGauge are moved to the main panel.  But the
 *         StatusMessage is removed.
 * 14.     The EnableLocationChange and EnableSizeChange choice setting
 *         are removed.  There are no longer such choices.
 * 15.     Right now if a panel-item is selected and if another panel-item
 *         is picked, the DeselectList() operation in the middle is
 *         eliminated.  This operation involves updating of text fields and
 *         messages and its removal speeds up the program.  The panel-list
 *         must now take at least one choice.  (A choice must be selected
 *         whenever there is at least one item on the list).  And now
 *         there is no way to deselect a list by the user.
 * 16.     The "modified bit" associated with the CurrentSelectionNumberLabel
 *         is implemented.  Now, if a selection is picked, and if either
 *         the quote window is moved or any text fields are changed, the
 *         modified bit will be on.
 * 17.     The Show-text-window button and the Show-quote-window-specifications-popup
 *         button are removed.  They are now menu options under the Options Menu.
 * 18.     The Modify button has its name changed to "Update Edit".
 * 
 * Revision 1.35  91/08/26  12:10:24  derek
 * The following things are done:
 * 1.	I have added a few notice_prompts to the linkProtocol (network)
 * 	functions to give warnings about invalid document names.
 * 2.	The quoted text window will by default be hidden during "blank"
 * 	times. ie. when it is not displaying any text.  The interface has
 * 	been changed so that it now has a HideQuotedTExtWindowAfterPreview
 * 	check box.  The QuotedTextWindow will either stay on the screen
 * 	or be hidden as the author desires.
 * 3.	Make the changes corresponding to the changing of name from OpenPanel
 * 	to Browse.
 * 4.	The return value bug for OpenHandler, SaveHandler is fixed.
 * 5.	I have changed the code so that Save and SaveAs will behave correctly.
 * 	The SaveAs PopUp/Open PopUp are removed.  Browse check is 
 * 	incorporated in the applications.
 * 6.	The QuoteMaker file format has been changed.  An EditNumber field	
 * 	has been added.
 * 7.	Changes corresponding to the return value by OpenDoc and SetSelection
 * 	are made.
 * 8.	GetAppIcon() has been implemented.
 * 9.	Fonts specified in the Edit-list will be preloaded in OpenDoc().
 * 	This will hopefully eliminate the startup delay needed to load
 * 	the font when we put text onto the Quoted TExt Window for the 
 * 	first time.
 * 10.	The "play" button will now play things specified in the 
 * 	QuotedTExtWindowSpecificationsPopUp (instead of those specified
 * 	in the editList).
 * 11.	The show selection button is replaced by the set selection button.
 * 	The Set Selection button willl now not only set the current
 * 	edit parameters but will also highlight the corresponding section
 * 	in the text.  Also, when one item on the panel-list is clicked on,
 * 	the corresponding segment in the text will also be highlighted.
 * 12.	Notify events which tells the app to show the size and location 
 * 	of the Quoted Text Window are set up.  ie. those text-fields
 * 	on the interface will be updated instantaneously.
 * 16.	editList.label is being sent across the network.
 * 17.	The title bar and the footer of the QuotedTExtWindow are hidden.
 * 
 * Revision 1.34  91/07/15  12:20:09  derek
 * 1.      I have added font selection panel to the application.
 *         Now a user can specify a font by choosing a font family, a font
 *         style and font size.
 * 2.      Location and size fields are added to the application.  User
 *         can specify the size and location of the QuotedTextWindow.
 * 3.      A duration estimate button is added to estimate how long the
 *         the quoted text should last.
 * 4.      Interface has been redesigned to accomodate the addition of
 *         font, size and location functionalities.
 * 6.      EditList file format has been changed to accomodate the new
 *         fields.  They are:  location (x,y), width, height, font family,
 *         font style, font width for QuotedTextWindow.
 * 5.      Two timers have been added in an attempt to ensure accuracy
 *         of gauge-updating in the preview panel.
 * 6.      Command line args are now supported.
 * 7.      I have cleaned up the code by using saber.
 * 8.      Several bugs from previous revision are fixed.
 * 
 * 
 * Revision 1.33  91/07/02  15:07:56  derek
 * QuoteMaker now fully speaks the new MAEstro protocol.
 * 
 * Revision 1.32  91/06/27  18:21:25  derek
 * I have cleaned up some of the comments.  No change in code.
 * 
 * Revision 1.31  91/06/19  17:44:23  drapeau
 * No changes; changing RCS revision numbers.
 * 
 * Revision 1.3  91/05/06  01:54:50  drapeau
 * Using new version of RCS for this module; no other changes have been made.
 * 
 * Revision 1.2  91/01/06  20:19:31  drapeau
 * Cosmetic, programming style changes made.  Nothing that changes the semantics
 * of the code.
 * 
 * Revision 1.1  90/12/04  17:22:00  drapeau
 * Initial revision
 *  */

static char rcsid[] = "$Header: /Source/Media/collab/QuoteMaker/RCS/selectionUtils.c,v 2.11 92/05/14 15:42:36 drapeau Exp $";

/* ----------------------------------------------------------------------------
   selectionUtils.c
   
   part of
   
   QuoteMaker
   
   A Text annotation application
   for use with the Link Editor Multimedia Authoring Enviornment
   
   
   developed by George Drapeau and Al Sargent
   
   Copyright (c) 1990 Academic Information Resources, Stanford University,
   and Sun Microsystems, Inc.
   
   for more info, contact drapeau@jessica.stanford.edu
   
   
   
   
   Last Modified:
   October 31, 1990
   */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/font.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include <xview/server.h>          
#include <xview/seln.h>            
#include "QuoteMaker_ui.h"

#include <sys/stat.h>
#include <xview/notice.h>
#include <xview/notify.h>

#define _selection_c_
#include "quoteMakerDefs.h"


/* ----------------------------------------------------------------------------
   Utilities: Textwindow stuff
   */

void UnHighlightSelection()
{ 
  textsw_set_selection(QuoteMaker_textWindowPopup->mainTextPane, 0, 0, PRIMARY_SELECTION);
  textWindowStart = 0;
  textWindowEnd   = 0;
}


void HighlightSelection (start, end)
     int start;
     int end;
{
  if (start < end + 1)
  {
    textsw_normalize_view (QuoteMaker_textWindowPopup->mainTextPane,
			   (Textsw_index) start);
    textsw_set_selection (QuoteMaker_textWindowPopup->mainTextPane, start, end + 1, PRIMARY_SELECTION);
  }
}


void GetSelectionEndpoints(start, end)
     int* start;
     int* end;
{
  Textsw_index first, last;
  Seln_holder holder;
  Seln_request *response;
  register char *ptr;
  
  holder = selection_inquire (server, SELN_PRIMARY);
  if (seln_holder_same_client (&holder, QuoteMaker_textWindowPopup->mainTextPane))
  {
    response = selection_ask (server, &holder,
			      SELN_REQ_FIRST, NULL,
			      SELN_REQ_LAST,  NULL,
			      SELN_REQ_CONTENTS_ASCII, NULL,
			      SELN_REQ_FAKE_LEVEL, SELN_LEVEL_LINE,
			      SELN_REQ_FIRST_UNIT, NULL,
			      SELN_REQ_LAST_UNIT, NULL,
			      NULL);
    ptr = response->data;
    first = *(Textsw_index *) (ptr += sizeof (SELN_REQ_FIRST));
    ptr += sizeof (Textsw_index);
    last = *(Textsw_index *) (ptr += sizeof (SELN_REQ_LAST));
    if (first > last)
    {
      *start = 0;
      *end = 0;
    }
    else
    {
      *start = (int) first;
      *end = (int) last;
    }
  }
  else
  {
    *start = 0;
    *end = 0;
  }
}								    /* end function GetSelectionEndpoints */
