/*
 * Copyright (c) 1990, 1991, 1992 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/QuoteMaker/RCS/quoteMakerDefs.h,v 2.2 92/05/29 12:41:29 drapeau Exp $ */
/* $Log:	quoteMakerDefs.h,v $
 * Revision 2.2  92/05/29  12:41:29  drapeau
 * Modified code to track new name of the MAEstro "Selection" structure;
 * it is now named "MAESelection".
 * 
 * Revision 2.1  92/05/14  15:41:58  drapeau
 * * Updated copyright information.
 * * Removed declaration of SemiHighlightSelection() as it is no longer used.
 * 
 * Revision 2.0  91/09/30  15:02:54  derek
 * Version number changed to 2.0.
 * 
 * Revision 1.33  91/09/15  20:06:39  derek
 * The following things are done:
 * 1.      The foreground of mainTextPane and Quote Window are set to be black.
 *         Also, the color of all the text fields are set to black.
 * 2.      Now the quoted text will be shown directly on the Quote Window
 *         when a panel-item selection is made.  The text will also be shown
 *         while the author is highlighting a selection in the text window.
 * 3.      The inconsistency problem regarding text selection is being taken
 *         care of.  When the mouse cursor re-enters the text window,
 *         the selection will be highlighted again.
 * 4.      When the play button is pressed, the text currently selected
 *         in the text window (rather than the text initially associated
 *         with the edit) will be displayed.
 * 5.      The name of the menu_option "Show Quote Window Specifications panel"
 *         is shortened to be "Quote Window Options ..."
 * 6.      A notify_interpose_destroy_func() is being added to fix the bug
 *         that QuoteMaker might exit without killing the Quote Window (which
 *         is also a base window).
 * 7.      When a different font family or font style is selected, the change
 *         will be automatically be reflected on the Quote Window (without the
 *         need to "play" the edit in order to verify the font).  For font
 *         size, the change will be reflected when either a return character is
 *         entered at the text field or when one of those numeric "arrows"
 *         are pressed.
 * 8.      The play button will now flash when an edit is being played.
 *         Pause button will also glow when playing is paused.
 * 9.      In the course of playing, when another edit is selected,
 *         the playing will be stopped.
 * 10.     I have used Saber to clean up the code.
 * 11.     The left-over "NewEditListPopUp" window is removed.
 * 12.     The bug that when quote window is iconified, it wont be un-iconified
 *         when the edit is played in timeline, is fixed.
 * 13.     The DurationEstimate function is changed so that it no longer
 *         needs an edit to be selected first.  It will take textWindowStart
 *         and textWindowEnd directly as input parameters.
 * 
 * 
 * 
 * Revision 1.32  91/09/05  15:48:08  derek
 * The following changes are made:
 * 1.      The name "Quoted Text Window" has been changed to "Quote Window"
 *         in the app.
 * 2.      ShowApplication() and HideApplication() is changed because of the
 *         the change of quote window from a popup to a basewindow.
 * 3.      The QuitProc of QuoteMaker is fixed so that the quote window,
 *         as a base window, will be destroyed separately.
 * 4.      Now hitting return in the label field will not result in adding
 *         a new edit.
 * 5.      Copyright messages are included in front of every .h and .c file.
 * 6.      The scrollbar and the footer of the Quote Window are hidden.
 * 7.      I have changed the include openpanel.h statement in QuoteMaker.c
 *         to include Browse.h.
 * 8.      The delete bug corresponding to the change that the panel-list
 *         must have a choice -- is fixed.  Also, the corresponding bug
 *         for deleteAll is also fixed.
 * 9.      Now, deleteAll and deletion of the last item in Panel_list
 *         will cause the panel-list to be destroyed and a new one will
 *         be created.
 * 10.     GetOpt files have been removed from the directory.  Corresponding
 *         changes are made.
 * 11.     The start and end byte fields are removed from the main panel.
 * 12.     I have put iconify, hide and show quote window to be buttons
 *         instead of menu options.
 * 13.     I have removed the PreviewPanelPopup and incorporated its features into
 *         the main panel.  The three buttons:  pause, play and stop and
 *         the DurationGauge are moved to the main panel.  But the
 *         StatusMessage is removed.
 * 14.     The EnableLocationChange and EnableSizeChange choice setting
 *         are removed.  There are no longer such choices.
 * 15.     Right now if a panel-item is selected and if another panel-item
 *         is picked, the DeselectList() operation in the middle is
 *         eliminated.  This operation involves updating of text fields and
 *         messages and its removal speeds up the program.  The panel-list
 *         must now take at least one choice.  (A choice must be selected
 *         whenever there is at least one item on the list).  And now
 *         there is no way to deselect a list by the user.
 * 16.     The "modified bit" associated with the CurrentSelectionNumberLabel
 *         is implemented.  Now, if a selection is picked, and if either
 *         the quote window is moved or any text fields are changed, the
 *         modified bit will be on.
 * 17.     The Show-text-window button and the Show-quote-window-specifications-popup
 *         button are removed.  They are now menu options under the Options Menu.
 * 18.     The Modify button has its name changed to "Update Edit".
 * 
 * Revision 1.31  91/08/27  14:37:45  derek
 * The following things are done:
 * 1.	The QuotedTextWindow is changed from a base window to a popup window
 * 	(now it's called QuotedMaker_quotedTextBaseWindow).  I have also
 * 	added a few options: show, hide and iconify QTW and also created
 * 	an icon for QTW.
 * 2.	The quoted text will be set in PerformSelection() instead of 
 * 	in SetSelection().
 * 3.	I have changed the Document field and the EditList field of 
 * 	QuoteMaker so that they will display fill paths.
 * 
 * Revision 1.30  91/08/26  12:10:30  derek
 * The following things are done:
 * 1.	I have added a few notice_prompts to the linkProtocol (network)
 * 	functions to give warnings about invalid document names.
 * 2.	The quoted text window will by default be hidden during "blank"
 * 	times. ie. when it is not displaying any text.  The interface has
 * 	been changed so that it now has a HideQuotedTExtWindowAfterPreview
 * 	check box.  The QuotedTextWindow will either stay on the screen
 * 	or be hidden as the author desires.
 * 3.	Make the changes corresponding to the changing of name from OpenPanel
 * 	to Browse.
 * 4.	The return value bug for OpenHandler, SaveHandler is fixed.
 * 5.	I have changed the code so that Save and SaveAs will behave correctly.
 * 	The SaveAs PopUp/Open PopUp are removed.  Browse check is 
 * 	incorporated in the applications.
 * 6.	The QuoteMaker file format has been changed.  An EditNumber field	
 * 	has been added.
 * 7.	Changes corresponding to the return value by OpenDoc and SetSelection
 * 	are made.
 * 8.	GetAppIcon() has been implemented.
 * 9.	Fonts specified in the Edit-list will be preloaded in OpenDoc().
 * 	This will hopefully eliminate the startup delay needed to load
 * 	the font when we put text onto the Quoted TExt Window for the 
 * 	first time.
 * 10.	The "play" button will now play things specified in the 
 * 	QuotedTExtWindowSpecificationsPopUp (instead of those specified
 * 	in the editList).
 * 11.	The show selection button is replaced by the set selection button.
 * 	The Set Selection button willl now not only set the current
 * 	edit parameters but will also highlight the corresponding section
 * 	in the text.  Also, when one item on the panel-list is clicked on,
 * 	the corresponding segment in the text will also be highlighted.
 * 12.	Notify events which tells the app to show the size and location 
 * 	of the Quoted Text Window are set up.  ie. those text-fields
 * 	on the interface will be updated instantaneously.
 * 16.	editList.label is being sent across the network.
 * 17.	The title bar and the footer of the QuotedTExtWindow are hidden.
 * 
 * Revision 1.29  91/08/13  22:53:01  derek
 * I have incorporated the openpanel/savepanel stuff.
 * 
 * Revision 1.28  91/08/09  18:18:55  derek
 * I removed all the free() statements from the code to
 * fix the bug and improve run-time efficiency.
 * 
 * Revision 1.27  91/07/22  16:47:10  derek
 * I have added 4 buttons to get and set the current
 * location and size of the quoted text window.
 * 
 * Revision 1.26  91/07/15  12:20:34  derek
 * 1.      I have added font selection panel to the application.
 *         Now a user can specify a font by choosing a font family, a font
 *         style and font size.
 * 2.      Location and size fields are added to the application.  User
 *         can specify the size and location of the QuotedTextWindow.
 * 3.      A duration estimate button is added to estimate how long the
 *         the quoted text should last.
 * 4.      Interface has been redesigned to accomodate the addition of
 *         font, size and location functionalities.
 * 6.      EditList file format has been changed to accomodate the new
 *         fields.  They are:  location (x,y), width, height, font family,
 *         font style, font width for QuotedTextWindow.
 * 5.      Two timers have been added in an attempt to ensure accuracy
 *         of gauge-updating in the preview panel.
 * 6.      Command line args are now supported.
 * 7.      I have cleaned up the code by using saber.
 * 8.      Several bugs from previous revision are fixed.
 * 
 * 
 * Revision 1.25  91/07/02  15:08:02  derek
 * QuoteMaker now fully speaks the new MAEstro protocol.
 * 
 * Revision 1.24  91/07/01  18:51:58  derek
 * The following things are done:
 * 1.	The interface is redesigned.  Duration fields are added to each 
 * 	edit list.
 * 2.	The function panel (functions Window) is implemented.  The 
 * 	application is now capable of being "played", "stopped" and
 * 	"paused".  The sense of "time" is now complete.
 * 3.	Makefile fixed.  
 * 4.	Declaration errors left by previous author are cleaned up.
 * 5.	Redundant malloc statements removed.   Certain other
 * 	functions are changed to improve code efficiency.
 * 6.	Code cleaned up by saber.  Removed redundant
 * 	variables.
 * 
 * Revision 1.23  91/06/28  13:16:07  derek
 * Blank functions added to the code to make the application "compatible"
 * with the new protocol.
 * 
 * Revision 1.22  91/06/27  18:21:27  derek
 * I have cleaned up some of the comments.  No change in code.
 * 
 * Revision 1.21  91/06/19  17:44:44  drapeau
 * No changes; changing RCS revision numbers.
 * 
 * Revision 1.2  91/05/06  01:54:21  drapeau
 * Using new version of RCS for this module; no other changes have been made.
 * 
 * Revision 1.1  90/12/04  17:21:58  drapeau
 * Initial revision
 *  */

static char quoteMakerDefsRcsid[] = "$Header: /Source/Media/collab/QuoteMaker/RCS/quoteMakerDefs.h,v 2.2 92/05/29 12:41:29 drapeau Exp $";

#include "QuoteMaker_ui.h"

#ifndef _selection_c_						    /* Is this being included by the selection.c file? */
#include "Sender.h"						    /* No, it's okay to include defs for the Link... */
								    /* ...Protocol.  */
#include "Receiver.h"
#endif

#define MAXLISTSIZE	1000

typedef char BOOL;

typedef struct EditList						    /* Structure to hold the data in an edit list */
{
  int		numItems;
  int		start[MAXLISTSIZE];
  int		end[MAXLISTSIZE];
  double	duration[MAXLISTSIZE];
  int		locX[MAXLISTSIZE];
  int		locY[MAXLISTSIZE];
  int		sizeWidth[MAXLISTSIZE];
  int		sizeHeight[MAXLISTSIZE];
  int		fontFamily[MAXLISTSIZE];
  int		fontStyle[MAXLISTSIZE];
  int		fontSize[MAXLISTSIZE];
  int		hideQTWAfterPlayingEdit[MAXLISTSIZE];
  char		*label[MAXLISTSIZE];
} EditList;


#define	NO_CURRENT_EDIT 	-10
#define PRIMARY_SELECTION 	1   
#define MAX_ENTRY_LEN 		44 
#define LABEL_START 		4
#define LABEL_END 		23
#define MAX_LABEL_LEN 		20

#define MAX_MESSAGE_LEN 	50				    /* Because label goes from char 4 to 23, labels... */
								    /* ... should be allocated to MAX_LABEL_LEN + 1.   */
#define MAX_EDITLIST_LENGTH	200
#define MAX_FILETYPE_LEN	50
#define MAX_TEXTSW_LEN 		500000
#define LINK_EDITOR 		-1
#define USER 			-2
#define YES 			1
#define NO 			0
	

/* ----------------------------------------------------------------------------
   Globals
*/

extern Attr_attribute	INSTANCE;				    /* XView makes this global necessary. */
extern Xv_Server	server;

extern void		OpenDoc();				    /* Functions that the link editor needs.*/
extern void		SetSelection();
extern void		PerformSelection();
extern char**		GetDoc();
extern void		HaltSelection();
extern void		PauseSelection();
extern void		ResumeSelection();
extern void 		HideApplication();
extern void		ShowApplication();
extern int		mostRecentEditNum;

#ifndef _selection_c_						    /* Is this being included by the selection.c file? */
extern MAESelection*	GetSelection();				    /* No, it's okay to include variables for the Link Protocol. */
extern IconData		*GetAppIcon();
extern Sender*		sender;
extern Receiver*	receiver;
extern Port		senderPort;
#endif


/* Variables describing documents and edit lists. */
extern char	absoluteDocumentName[];
extern char	absoluteEditListName[];
extern int	unsavedChangesExist;
extern int	untitledEditListNum;					    /* So we can say untitled0  */
extern EditList	editList;

extern Xv_font *listFont;
extern Xv_font *displayFont;
extern Xv_font *annotateFont;

/* Variables for interface components. */
extern QuoteMaker_baseWindow_objects		*QuoteMaker_baseWindow;
QuoteMaker_quotedTextBaseWindow_objects	        *QuoteMaker_quotedTextBaseWindow;
extern QuoteMaker_infoPopup_objects		*QuoteMaker_infoPopup;
extern QuoteMaker_textWindowPopup_objects	*QuoteMaker_textWindowPopup;
extern QuoteMaker_QuoteWindowSpecificationsPopup_objects	*QuoteMaker_QuoteWindowSpecificationsPopup;


/* ----------------------------------------------------------------------------
   Utilities: Textwindow stuff
*/

void UnHighlightSelection();
void HighlightSelection ();
void GetSelectionEndpoints ();

/********
#define DEBUG
********/

/*
 * Some debugging routines.
 */
#ifdef DEBUG
#define EVENT(P)     printf("Event: %s\n", (P))
#else
#define EVENT(P)
#endif


/*
 *  timer.c
 */
extern	void		SetTimer();
extern	void		CancelTimer();
extern	Notify_value	TimerHandler();
extern	void		InitTimer();
extern  Notify_value	UpdateGaugeHandler();
extern	void		SetButtonGlowTimer();
extern	void		CancelButtonGlowTimer();
extern	Notify_value	ButtonGlowTimerHandler();



/*
 *  QuoteMaker.c
 */
char                    Entry[MAX_EDITLIST_LENGTH];
BOOL                    QTWLocationChangeEnabled;
BOOL                    QTWSizeChangeEnabled;
BOOL			HideQTWAfterPlayingEdit;
int			OldSizeWidth;
int			OldSizeHeight;
int			OldLocX;
int			OldLocY;
int			textWindowStart;
int			textWindowEnd;

extern	void		AddSelection();
extern	void		Show();
extern	void		GiveOneLastChanceToSave();
extern	void		SetCurrentSelection();
extern	char		*FormatEntry();
extern	void		ResetCurrentSelection();
extern	void		UpdateNumEditsMessage();
extern	void		ReadEntry();
extern	void		Alert();
extern	char		*ShortName();
extern	void		SetDocument();
extern  void		InitMainPanel();
extern	void		CheckOptions();
extern	void		LocationChangeEnableSettingHandler();
extern	void		SizeChangeEnableSettingHandler();
extern	void		ShowTextWindowSelection();
extern	void		AlertByNoticePrompt();
extern	void		SetCurrentSizeHandler();
extern	void		SetCurrentLocationHandler();
extern	void		GetCurrentSizeHandler();
extern	void		GetCurrentLocationHandler();
extern	void		InitTextFields();


/*
 *  editList.c
 */
extern	void		SetEditList();
extern	void		DeselectList();
extern	void		DeleteItemFromEditList();
extern	void		EmptyList();
extern	void		OpenEditList();
extern	int		ReadEditListFromFile();
extern	void		SaveEditList();
extern	int		WriteEditListToFile();
extern	void		NewEditList();
extern	void		Hide();
extern	void		RedrawEditList();
extern  void		ClearQuoteWindowSpecificationsPopup();
extern	int		Selected();
extern	void		CheckIfEditModified();
extern	void		ClearEditModified();


#define	SAVE		0
#define	SAVE_AS		1


/*
 *  functions.c
 */
BOOL			PlayPaused;
BOOL			Playing;
char			msg[512];
int			BlackColorIndex;
int			GreenColorIndex;

extern	void		AlertStatus();
extern	void		ClearStatusMessage();
extern	void		ClearQuotedTextWindow();
extern	void		PauseButtonHandler();
extern	void		StopButtonHandler();
extern	void		PutInDefaultDuration();
extern	void		InitQuotedTextWindow();
extern	void		EnableQTWLocationChange();
extern	void		DisableQTWLocationChange();
extern	void		EnableQTWSizeChange();
extern	void		DisableQTWSizeChange();
extern	void		EnableHideQTWAfterPlayingEdit();
extern	void		DisableHideQTWAfterPlayingEdit();
extern	void		SetCurrentLocation();
extern	void		GetCurrentLocation();
extern	void		SetCurrentSize();
extern	void		GetCurrentSize();
extern  void		DisplayTextOnQuoteWindow();
extern  Notify_value	DestroyQuoteWindow();
extern	Notify_value	DestroyBaseWindow();
extern	void		UpdateButtonGlow();
extern	void		CancelButtonGlow();

#define	GLOW_INTERVAL	0.5


/*
 *  font.c
 */
#define MAX_NUM_OF_FONT_FAMILIES  7
#define MAX_NUM_OF_FONT_STYLES    5
#define NONE_SELECTED          -1

extern	int		currentFontFamily;
extern	int		currentFontStyle;
extern	int		currentFontSize;
extern	char		*GetFontFamilyFromList();
extern	char		*GetFontStyleFromList();
extern	void		InitFontPanel();
extern  void            SetFontPanel();
extern  char		*UpperCase();
extern  char		*GetFontFamilyFromItemNum();
extern	char		*GetFontStyleFromItemNum();
extern	void		SetQuotedTextWindowLocation();
extern	void		SetQuotedTextWindowSize();
extern	void		SetQuotedTextWindowFont();
extern	Notify_value	QuotedTextWindowInterposer();
extern	void		PreloadFontsOntoQTW();

Rect			QuoteTextWindowRect;
int                     EditTextFieldOrChoiceModified;

#define	FRAME_X_OFFSET	5
#define FRAME_Y_OFFSET	26


/*
 *  openpanel.c
 */
extern	void		InitBrowse();
extern	int		OpenHandler();
extern	int		SaveHandler();

char	 *documentFirstLine;
char	 *documentFileType;

#define	IS_TEXTFILE	1
#define	IS_EDITLIST	2
#define FILE_OK		0
#define FILE_NOT_OK	-1
