/*
 * Copyright (c) 1990, 1991, 1992 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/*$Header: /Source/Media/collab/QuoteMaker/RCS/functions.c,v 2.15 92/09/25 14:31:50 drapeau Exp $*/
/* $Log:	functions.c,v $
 * Revision 2.15  92/09/25  14:31:50  drapeau
 * Fixed errors in the way the quoted text window was being located.  The
 * earlier version used the XView attributes "XV_WIDTH", "XV_HEIGHT", "XV_X",
 * and "XV_Y".  This version now uses the more proper "frame_get_rect()" and
 * "frame_set_rect()" functions for window placement and sizing.
 * Also, some cosmetic changes were made to enhance readability and ANSI
 * compliance.
 * 
 * Revision 2.14  92/06/15  14:33:51  drapeau
 * Minor change, casted an xv_get() call to (char*) to avoid compiler
 * warning message.
 * 
 * Revision 2.13  92/05/14  15:41:03  drapeau
 * * Updated copyright information.
 * * Other formatting changes to conform to coding standards.
 * 
 * Revision 2.12  92/01/11  01:43:09  drapeau
 * Removed redeclarations of string functions since OpenWindows 2.0
 * headers don't seem to like them (OpenWindows 3.0 seemed to need
 * them).
 * 
 * Revision 2.11  92/01/09  18:25:19  drapeau
 * Slight modifications to make code ANSI-compliant.
 * 
 * Revision 2.10  91/12/31  18:42:40  drapeau
 * Removed the inclusion of string.h, since XView will include the
 * appropriate definitions.
 * 
 * Revision 2.0  91/09/30  15:02:31  derek
 * Version number changed to 2.0.
 * 
 * Revision 1.12  91/09/15  20:32:31  derek
 * The function ShowPreviewFunctionsPanel() is removed.  Also, in 
 * PreloadFontOntoQTW(), a statement is added to clear the quote window
 * before loading fonts.
 * 
 * Revision 1.11  91/09/15  20:06:25  derek
 * The following things are done:
 * 1.      The foreground of mainTextPane and Quote Window are set to be black.
 *         Also, the color of all the text fields are set to black.
 * 2.      Now the quoted text will be shown directly on the Quote Window
 *         when a panel-item selection is made.  The text will also be shown
 *         while the author is highlighting a selection in the text window.
 * 3.      The inconsistency problem regarding text selection is being taken
 *         care of.  When the mouse cursor re-enters the text window,
 *         the selection will be highlighted again.
 * 4.      When the play button is pressed, the text currently selected
 *         in the text window (rather than the text initially associated
 *         with the edit) will be displayed.
 * 5.      The name of the menu_option "Show Quote Window Specifications panel"
 *         is shortened to be "Quote Window Options ..."
 * 6.      A notify_interpose_destroy_func() is being added to fix the bug
 *         that QuoteMaker might exit without killing the Quote Window (which
 *         is also a base window).
 * 7.      When a different font family or font style is selected, the change
 *         will be automatically be reflected on the Quote Window (without the
 *         need to "play" the edit in order to verify the font).  For font
 *         size, the change will be reflected when either a return character is
 *         entered at the text field or when one of those numeric "arrows"
 *         are pressed.
 * 8.      The play button will now flash when an edit is being played.
 *         Pause button will also glow when playing is paused.
 * 9.      In the course of playing, when another edit is selected,
 *         the playing will be stopped.
 * 10.     I have used Saber to clean up the code.
 * 11.     The left-over "NewEditListPopUp" window is removed.
 * 12.     The bug that when quote window is iconified, it wont be un-iconified
 *         when the edit is played in timeline, is fixed.
 * 13.     The DurationEstimate function is changed so that it no longer
 *         needs an edit to be selected first.  It will take textWindowStart
 *         and textWindowEnd directly as input parameters.
 * 
 * 
 * 
 * Revision 1.10  91/09/05  15:48:01  derek
 * The following changes are made:
 * 1.      The name "Quoted Text Window" has been changed to "Quote Window"
 *         in the app.
 * 2.      ShowApplication() and HideApplication() is changed because of the
 *         the change of quote window from a popup to a basewindow.
 * 3.      The QuitProc of QuoteMaker is fixed so that the quote window,
 *         as a base window, will be destroyed separately.
 * 4.      Now hitting return in the label field will not result in adding
 *         a new edit.
 * 5.      Copyright messages are included in front of every .h and .c file.
 * 6.      The scrollbar and the footer of the Quote Window are hidden.
 * 7.      I have changed the include openpanel.h statement in QuoteMaker.c
 *         to include Browse.h.
 * 8.      The delete bug corresponding to the change that the panel-list
 *         must have a choice -- is fixed.  Also, the corresponding bug
 *         for deleteAll is also fixed.
 * 9.      Now, deleteAll and deletion of the last item in Panel_list
 *         will cause the panel-list to be destroyed and a new one will
 *         be created.
 * 10.     GetOpt files have been removed from the directory.  Corresponding
 *         changes are made.
 * 11.     The start and end byte fields are removed from the main panel.
 * 12.     I have put iconify, hide and show quote window to be buttons
 *         instead of menu options.
 * 13.     I have removed the PreviewPanelPopup and incorporated its features into
 *         the main panel.  The three buttons:  pause, play and stop and
 *         the DurationGauge are moved to the main panel.  But the
 *         StatusMessage is removed.
 * 14.     The EnableLocationChange and EnableSizeChange choice setting
 *         are removed.  There are no longer such choices.
 * 15.     Right now if a panel-item is selected and if another panel-item
 *         is picked, the DeselectList() operation in the middle is
 *         eliminated.  This operation involves updating of text fields and
 *         messages and its removal speeds up the program.  The panel-list
 *         must now take at least one choice.  (A choice must be selected
 *         whenever there is at least one item on the list).  And now
 *         there is no way to deselect a list by the user.
 * 16.     The "modified bit" associated with the CurrentSelectionNumberLabel
 *         is implemented.  Now, if a selection is picked, and if either
 *         the quote window is moved or any text fields are changed, the
 *         modified bit will be on.
 * 17.     The Show-text-window button and the Show-quote-window-specifications-popup
 *         button are removed.  They are now menu options under the Options Menu.
 * 18.     The Modify button has its name changed to "Update Edit".
 * 
 * Revision 1.9  91/08/28  14:06:06  derek
 * The following things are done:
 * 1.	I have changed the NewEditList option to call the file browser
 * 	instead of giving a popup window.
 * 2.	I ahve renamed all the options in the file menu so that they
 * 	are clearer and more informative.
 * 3.	The documentFileType has been changed from "DTR" (which was
 * 	a copying fault :)) to "QuoteMaker".
 * 4.	I ahve changed the stop button so that if it sees that 
 * 	HideQTWAfterPlayingEdit is true, stopplay will hide the window too.
 * 5.	I have changed QuoteMaker.G (the interface) so that there is no
 * 	way to deselect a fontfamily and fontstyle item from the panel list
 * 	(ie. a choice is required.)
 * 
 * Revision 1.8  91/08/27  14:37:33  derek
 * The following things are done:
 * 1.	The QuotedTextWindow is changed from a base window to a popup window
 * 	(now it's called QuotedMaker_quotedTextBaseWindow).  I have also
 * 	added a few options: show, hide and iconify QTW and also created
 * 	an icon for QTW.
 * 2.	The quoted text will be set in PerformSelection() instead of 
 * 	in SetSelection().
 * 3.	I have changed the Document field and the EditList field of 
 * 	QuoteMaker so that they will display fill paths.
 * 
 * Revision 1.7  91/08/26  12:10:15  derek
 * The following things are done:
 * 1.	I have added a few notice_prompts to the linkProtocol (network)
 * 	functions to give warnings about invalid document names.
 * 2.	The quoted text window will by default be hidden during "blank"
 * 	times. ie. when it is not displaying any text.  The interface has
 * 	been changed so that it now has a HideQuotedTExtWindowAfterPreview
 * 	check box.  The QuotedTextWindow will either stay on the screen
 * 	or be hidden as the author desires.
 * 3.	Make the changes corresponding to the changing of name from OpenPanel
 * 	to Browse.
 * 4.	The return value bug for OpenHandler, SaveHandler is fixed.
 * 5.	I have changed the code so that Save and SaveAs will behave correctly.
 * 	The SaveAs PopUp/Open PopUp are removed.  Browse check is 
 * 	incorporated in the applications.
 * 6.	The QuoteMaker file format has been changed.  An EditNumber field	
 * 	has been added.
 * 7.	Changes corresponding to the return value by OpenDoc and SetSelection
 * 	are made.
 * 8.	GetAppIcon() has been implemented.
 * 9.	Fonts specified in the Edit-list will be preloaded in OpenDoc().
 * 	This will hopefully eliminate the startup delay needed to load
 * 	the font when we put text onto the Quoted TExt Window for the 
 * 	first time.
 * 10.	The "play" button will now play things specified in the 
 * 	QuotedTExtWindowSpecificationsPopUp (instead of those specified
 * 	in the editList).
 * 11.	The show selection button is replaced by the set selection button.
 * 	The Set Selection button willl now not only set the current
 * 	edit parameters but will also highlight the corresponding section
 * 	in the text.  Also, when one item on the panel-list is clicked on,
 * 	the corresponding segment in the text will also be highlighted.
 * 12.	Notify events which tells the app to show the size and location 
 * 	of the Quoted Text Window are set up.  ie. those text-fields
 * 	on the interface will be updated instantaneously.
 * 16.	editList.label is being sent across the network.
 * 17.	The title bar and the footer of the QuotedTExtWindow are hidden.
 * 
 * Revision 1.6  91/07/22  16:46:56  derek
 * I have added 4 buttons to get and set the current
 * location and size of the quoted text window.
 * 
 * Revision 1.5  91/07/15  12:19:28  derek
 * 1.      I have added font selection panel to the application.
 *         Now a user can specify a font by choosing a font family, a font
 *         style and font size.
 * 2.      Location and size fields are added to the application.  User
 *         can specify the size and location of the QuotedTextWindow.
 * 3.      A duration estimate button is added to estimate how long the
 *         the quoted text should last.
 * 4.      Interface has been redesigned to accomodate the addition of
 *         font, size and location functionalities.
 * 6.      EditList file format has been changed to accomodate the new
 *         fields.  They are:  location (x,y), width, height, font family,
 *         font style, font width for QuotedTextWindow.
 * 5.      Two timers have been added in an attempt to ensure accuracy
 *         of gauge-updating in the preview panel.
 * 6.      Command line args are now supported.
 * 7.      I have cleaned up the code by using saber.
 * 8.      Several bugs from previous revision are fixed.
 * 
 * 
 * Revision 1.4  91/07/02  15:07:51  derek
 * QuoteMaker now fully speaks the new MAEstro protocol.
 * 
 * Revision 1.3  91/07/01  19:09:22  derek
 * The following things are done:
 * 1.	The interface is redesigned.  Duration fields are added to each
 * 	edit list.
 * 2.	The function panel (functions Window) is implemented.  The
 * 	application is now capable of being "played", "stopped"
 * 	and "Paused".  The sense of "time" is now complete.
 * 3.	Makefile fixed.
 * 4.	Declaration errors left by previous author are cleaned up.
 * 5.	Redundant malloc statements removed.  Certain other
 * 	functions are changed to improve code efficiency.
 * 6.	Code cleaned up by saber.  Removed redundant variables.
 *  */

static char rcsid[] = "$Header: /Source/Media/collab/QuoteMaker/RCS/functions.c,v 2.15 92/09/25 14:31:50 drapeau Exp $";

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include <gdd.h>
#include "QuoteMaker_ui.h"
#include <sys/stat.h>
#include <xview/font.h>
#include <xview/notice.h>
#include <xview/notify.h>
#include <xview/server.h>          
#include <xview/seln.h>            
#include <xview/scrollbar.h>
#include "quoteMakerDefs.h"
#include <math.h>


void
  InitTextFields()
{
  xv_set(QuoteMaker_baseWindow->DurationMinsTextField,
	 PANEL_NOTIFY_LEVEL, PANEL_ALL, NULL);
  xv_set(QuoteMaker_baseWindow->DurationSecsTextField,
	 PANEL_NOTIFY_LEVEL, PANEL_ALL, NULL);
  xv_set(QuoteMaker_baseWindow->selectionLabelField,
	 PANEL_NOTIFY_LEVEL, PANEL_ALL, NULL);
  xv_set(QuoteMaker_QuoteWindowSpecificationsPopup->FontSizeTextField,
	 PANEL_NOTIFY_LEVEL, PANEL_ALL, NULL);
}  


/*
 * Notify callback function for `PauseButton'.
 */
void
PauseButtonHandler(item, event)
	Panel_item	item;
	Event		*event;
{
  extern  double  endTime;
  
  if (Playing)
  {
    if (PlayPaused) 
    {
      PlayPaused = FALSE;
      SetTimer(endTime);
      xv_set(QuoteMaker_baseWindow->PauseButton, PANEL_ITEM_COLOR, BlackColorIndex, NULL);
      AlertStatus("Playing ...");
    }
    else
    {
      PlayPaused = TRUE;
      CancelTimer();
      xv_set(QuoteMaker_baseWindow->PauseButton, PANEL_ITEM_COLOR, GreenColorIndex, NULL);
      xv_set(QuoteMaker_baseWindow->PlayButton, PANEL_ITEM_COLOR, GreenColorIndex, NULL);
    }
  }
  textsw_set_selection(QuoteMaker_textWindowPopup->mainTextPane,    /*  Highlight the selection (because the text_sw... */
		       textWindowStart, textWindowEnd + 1,	    /*  ...will keep forgetting about it.               */
		       PRIMARY_SELECTION);
}


/*
 * Notify callback function for `StopButton'.
 */
void
StopButtonHandler(item, event)
	Panel_item	item;
	Event		*event;
{
  CancelTimer();
  ClearStatusMessage();
  ClearQuotedTextWindow();
  if (HideQTWAfterPlayingEdit)
  {
    xv_set(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow,
	   XV_SHOW, FALSE,
	   NULL);
  }    

  if (Playing)
  {
    CancelButtonGlowTimer();
    CancelButtonGlow();
  }

  PlayPaused = FALSE;
  Playing = FALSE;

  textsw_set_selection(QuoteMaker_textWindowPopup->mainTextPane,    /*  Highlight the selection (because the text_sw... */
		       textWindowStart, textWindowEnd + 1,	    /*  ...will keep forgetting about it.               */
		       PRIMARY_SELECTION);
}


/*
 * Notify callback function for `PlayButton'.
 */
void
PlayButtonHandler(item, event)
	Panel_item	item;
	Event		*event;
{
  int		entryNum;
  int		length;
  int		count;
  int   	mins;
  double	secs;
  double	duration;
  char*		selectedText;
  char*		tempPointer;
  char*		index();
  
  if (Playing)							    /* If and edit is being played right now, do....    */
    return;							    /* ...nothing.                                      */

  entryNum = Selected();

  if (entryNum == NO_CURRENT_EDIT)
    return;
  
  if (entryNum >= editList.numItems)				    /* Check for selection requested not on edit list...*/
    return;							    /* ...ie. edit list has 5 items and request is... */
  /* ...for item # 9 */

  xv_set(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow,
	 FRAME_CLOSED, FALSE,
	 XV_SHOW, TRUE,
	 NULL);

  length=xv_get(QuoteMaker_quotedTextBaseWindow->quotedTextPane,    /* Get the number of characters currently in the... */
		TEXTSW_LENGTH);					    /* ...popup win. */
  if (length > 0)
  {
    textsw_delete(QuoteMaker_quotedTextBaseWindow->quotedTextPane,  /* Erase any previously shown text in the Text... */
		  0, length);					    /* popup window. */
    textsw_reset(QuoteMaker_quotedTextBaseWindow->quotedTextPane,0,0); /* Pretend that the QTW was never modified */
  }
  
  length = textWindowEnd - textWindowStart + 1;			    /* Calculate size of text to be selected */
  selectedText = (char *) malloc(length + 1);			    /* Allocate space for the text to be selected */
  xv_get(QuoteMaker_textWindowPopup->mainTextPane,		    /* Get the text to be selected */
	 TEXTSW_CONTENTS, textWindowStart, selectedText, length);
  selectedText[length] = '\0';					    /* Make sure selected text is NULL-terminated */
  for (tempPointer = selectedText, count=0;			    /* Go through selected text, looking for newlines... */
       tempPointer;						    /* ...and replace each newline with a space. */
       tempPointer = index(tempPointer, '\n'), count++)
  {
    if (tempPointer != selectedText)				    /* Is "tempPointer" pointing to start of the buffer? */
      tempPointer[0] = ' ';					    /* No, must be pointing to a newline; replace it... */
    /* ...with space. */
    if (count > 100)						    /* If this loop has replaced a large number of ... */
      break;							    /* ...lines, exit loop; chances are the end... */
    /* ...won't be saved anyway. */
  }
  
  currentFontSize = xv_get(QuoteMaker_QuoteWindowSpecificationsPopup->FontSizeTextField,
			   PANEL_VALUE);

  SetQuotedTextWindowFont(currentFontFamily,
			  currentFontStyle,
			  currentFontSize);

  xv_set(QuoteMaker_quotedTextBaseWindow->quotedTextPane,	    /* Allow the Quoted Text popup window to be edited */
	 TEXTSW_BROWSING, FALSE, NULL);

  xv_set(QuoteMaker_quotedTextBaseWindow->quotedTextPane,	    /* Put the selected text into the quoted Text... */
	 TEXTSW_CONTENTS, selectedText, NULL);			    /* ...popup window */

  xv_set(QuoteMaker_quotedTextBaseWindow->quotedTextPane,	    /* Allow the Quoted Text popup window to be edited */
	 TEXTSW_BROWSING, TRUE, NULL);
  
  textsw_normalize_view(QuoteMaker_quotedTextBaseWindow->quotedTextPane,
			0);					    /* Make sure quoted text shows up at top of... */
  /* ...popup window. */

  InitTimer();

  Playing = TRUE;
  AlertStatus("Playing ...");
  mins = (int) atoi(xv_get (QuoteMaker_baseWindow->DurationMinsTextField, PANEL_VALUE));
  secs = (double) atof((char*)xv_get(QuoteMaker_baseWindow->DurationSecsTextField, PANEL_VALUE));
  duration = mins * 60.0 + secs;

  textsw_set_selection(QuoteMaker_textWindowPopup->mainTextPane,    /*  Highlight the selection (because the text_sw... */
		       textWindowStart, textWindowEnd + 1,	    /*  ...will keep forgetting about it.               */
		       PRIMARY_SELECTION);

  SetButtonGlowTimer(GLOW_INTERVAL);
  SetTimer(duration);
}


void
  AlertStatus(message)
char  *message;
{
  char m[40];
  
  sprintf(m, "Status :   %s", message);
  
/********
  xv_set(QuoteMaker_PreviewPanelPopup->PreviewPanelStatusMessage,
	 PANEL_LABEL_STRING, m, NULL);
  XFlush((Display *) xv_get(QuoteMaker_PreviewPanelPopup->PreviewPanelPopup, 
			    XV_DISPLAY));
********/
}


void
  ClearStatusMessage()
{
  AlertStatus("");
}


void
  ClearQuotedTextWindow()
{
  int    length;
  
  xv_set(QuoteMaker_quotedTextBaseWindow->quotedTextPane,	    /* Allow the Quoted Text popup window to be edited */
	 TEXTSW_BROWSING, FALSE, NULL);

  length = (int)xv_get(QuoteMaker_quotedTextBaseWindow->quotedTextPane,	
		       TEXTSW_LENGTH);				    /* Get the number of characters currently in the... */
								    /* ...popup win. */
  if (length > 0)
    textsw_delete(QuoteMaker_quotedTextBaseWindow->quotedTextPane,  /* Erase any previously shown text in the Text... */
		  0, length);					    /* popup window. */
  
  textsw_reset(QuoteMaker_quotedTextBaseWindow->quotedTextPane,0,0); /* Pretend that the QTW was never modified */
  
  xv_set(QuoteMaker_quotedTextBaseWindow->quotedTextPane,	    /* Allow the Quoted Text popup window to be edited */
	 TEXTSW_BROWSING, TRUE, NULL);
}


void
  EnableQTWLocationChange()
{
  QTWLocationChangeEnabled = TRUE;
}


void
  DisableQTWLocationChange()
{
  QTWLocationChangeEnabled = FALSE;
}


void
  EnableQTWSizeChange()
{
  QTWSizeChangeEnabled = TRUE;
}



void
  DisableQTWSizeChange()
{
  QTWSizeChangeEnabled = FALSE;
}


void
  EnableHideQTWAfterPlayingEdit()
{
  HideQTWAfterPlayingEdit = TRUE;
  xv_set(QuoteMaker_baseWindow->HideQuoteWindowAfterPlayingEditSetting,
	 PANEL_VALUE, 1, NULL);
}


void
  DisableHideQTWAfterPlayingEdit()
{
  HideQTWAfterPlayingEdit = FALSE;
  xv_set(QuoteMaker_baseWindow->HideQuoteWindowAfterPlayingEditSetting,
	 PANEL_VALUE, 0, NULL);
}


void
  PutInDefaultDuration()
{
  xv_set(QuoteMaker_baseWindow->DurationMinsTextField, PANEL_VALUE,
	 "0", NULL);
  xv_set(QuoteMaker_baseWindow->DurationSecsTextField, PANEL_VALUE,
	 "2.0", NULL);
}  


void
  InitQuotedTextWindow()
{
  (void) notify_interpose_event_func(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow,
				     QuotedTextWindowInterposer, NOTIFY_SAFE);

  xv_set(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow,
	 FRAME_SHOW_HEADER, FALSE,				    /*  Hide the header and the footer of the quoted... */
	 FRAME_SHOW_FOOTER, FALSE,				    /*  ...text window.                                 */
	 NULL);

/**********
  xv_set(xv_get(QuoteMaker_quotedTextBaseWindow->quotedTextPane,
		WIN_VERTICAL_SCROLLBAR), XV_SHOW, FALSE, NULL);

  xv_destroy(xv_get(QuoteMaker_quotedTextBaseWindow->quotedTextPane,
		    WIN_VERTICAL_SCROLLBAR));
********/
  
  notify_interpose_destroy_func(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow,
				DestroyQuoteWindow);

  EditTextFieldOrChoiceModified = FALSE;
  EnableQTWLocationChange();					    /*  A notifier is set up to detect window resize... */
  EnableQTWSizeChange();					    /*  ...and location change events.                  */
  EnableHideQTWAfterPlayingEdit();
}


Notify_value
  DestroyQuoteWindow(client, status)
Notify_client client;
Destroy_status status;
{
  if (status == DESTROY_CHECKING)
  {
    xv_set(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow,
	   XV_SHOW, FALSE,
	   NULL);
    notify_veto_destroy(client);
  }

  return NOTIFY_DONE;
}


Notify_value
  DestroyBaseWindow(client, status)
Notify_client client;
Destroy_status status;
{
  if (status == DESTROY_CHECKING)
  {
    if (unsavedChangesExist == YES)
      GiveOneLastChanceToSave();
  }
  else if (status == DESTROY_CLEANUP)
  {
    xv_destroy_safe(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow);
    SenderDisconnectFromPortMgr(sender,&(receiver->receivePort));	    /* Tell the Port Manager "I'm outtahere" */
    exit(0);
/**
  xv_destroy_safe(QuoteMaker_baseWindow->baseWindow);    
**/  
   
    return notify_next_destroy_func(client, status);
  }
  return NOTIFY_DONE;
}



/*
 *  Right now the reason this function is so big is because
 *  of the irregularity of the x interpose function.  For example,
 *  If a window is resized, this function will receive 2 WIN_RESIZE
 *  events and if the window is relocated, 1 WIN_RESIZE event
 *  will be supplied.  Such inconsistency causes this function to 
 *  be a product of "trial-and-error" --- and hidden bugs are 
 *  expected.
 */
Notify_value
  QuotedTextWindowInterposer(Frame		frame,
			     Event*		event,
			     Notify_arg		arg,
			     Notify_event_type	type)
{
  int		currentSizeWidth;
  int		currentSizeHeight;
  static  Rect  tempRect;

  if (event_action(event) == WIN_RESIZE && event_id(event) != 31744)
  {
    if (xv_get(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow, XV_SHOW) == TRUE)
    {
      frame_get_rect(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow,
		     &tempRect);
      currentSizeWidth = tempRect.r_width;
      currentSizeHeight = tempRect.r_height;
      sprintf(msg, "%d x %d", currentSizeWidth, currentSizeHeight);
      xv_set(QuoteMaker_QuoteWindowSpecificationsPopup->SizeMessage,
	     PANEL_LABEL_STRING, msg, NULL);
      
      if (currentSizeWidth != OldSizeWidth || currentSizeHeight != OldSizeHeight)
      {
	CheckIfEditModified(FALSE);
      }
      OldSizeWidth = currentSizeWidth;
      OldSizeHeight = currentSizeHeight;
      sprintf(msg, "%d x %d", tempRect.r_left, tempRect.r_top);
      xv_set(QuoteMaker_QuoteWindowSpecificationsPopup->LocationMessage,
	     PANEL_LABEL_STRING, msg, NULL);
      if (tempRect.r_left != OldLocX || tempRect.r_top != OldLocY)
      {
	CheckIfEditModified(FALSE);
      }
      OldLocX = tempRect.r_left;
      OldLocY = tempRect.r_top;
    }
  }
  else if (!(event_action(event) == 31815 && event_id(event) == 31744))
  {
    if (xv_get(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow, XV_SHOW) == TRUE)
    {
      frame_get_rect(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow,
		     &tempRect);
      sprintf(msg, "%d x %d", tempRect.r_left, tempRect.r_top);
      xv_set(QuoteMaker_QuoteWindowSpecificationsPopup->LocationMessage,
	     PANEL_LABEL_STRING, msg, NULL);
      if (tempRect.r_left != OldLocX || tempRect.r_top != OldLocY)
      {
	CheckIfEditModified(FALSE);
      }
      else
      {
	if (!EditTextFieldOrChoiceModified)
	{
	  ClearEditModified();
	}
      }
      OldLocX = tempRect.r_left;
      OldLocY = tempRect.r_top;
    }								    /*  ...resets the flag.                            */
  }
  
  if (event_action(event) == 32536 && event_id(event) == 32536)
  {
    if (!EditTextFieldOrChoiceModified)
    {
      ClearEditModified();
    }
  }
  return notify_next_event_func((Notify_client)frame,
				(Notify_event)event, arg, type);
}



void
  GetCurrentLocation(int* locX, int* locY)
{
  Rect  tempRect;
  
  frame_get_rect(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow,
		 &tempRect);
  
  *locX = tempRect.r_left;
  *locY = tempRect.r_top;
}


void
  SetCurrentLocation(int locX, int locY)
{
  static  Rect  tempRect;
  
  tempRect.r_left  = locX + FRAME_X_OFFSET;			    /*  Some mysterious offsets to work-around the...   */
  tempRect.r_top = locY + FRAME_Y_OFFSET;			    /*  ..."shifting" when the window location is set.  */
  
  frame_set_rect(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow,
		 &tempRect);
}


void
  GetCurrentSize(width, height)
int   *width;
int   *height;
{
  static  Rect  tempRect;

  frame_get_rect(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow,
		 &tempRect);
  *width = tempRect.r_width;
  *height = tempRect.r_height;
}								    /* end function GetCurrentSize */


void
  SetCurrentSize(int   width,
		 int   height)
{
  static  Rect  tempRect;

  tempRect.r_width = width;
  tempRect.r_height = height;
  frame_set_rect(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow,
		 &tempRect);
}

  
void
  DisplayTextOnQuoteWindow()
{
  int    	start;
  int    	end;
  int    	length;
  int		count;
  static  int	currentSelectedTextBufferLength = 1000;
  static char*	selectedText = NULL;
  char*		tempPointer;
  char*		index();
  
  start = textWindowStart;					    /* Get start and end points for the selection.  */
  end = textWindowEnd;
  length = end - start + 1;					    /* Calculate size of text to be selected */
  
  if (!selectedText)
  {
    selectedText = malloc(1000);
    currentSelectedTextBufferLength = 1000;
  }
  
  if (currentSelectedTextBufferLength < length + 1)
  {
    currentSelectedTextBufferLength = length + 1;
    selectedText = (char *) malloc(length + 1);			    /* Allocate space for the text to be selected */
  }
    
  if (!selectedText)
  {
    printf("malloc failure in Text pane event handler.\n");
  }
  
  xv_get(QuoteMaker_textWindowPopup->mainTextPane,		    /* Get the text to be selected */
	 TEXTSW_CONTENTS, start, selectedText, length);
  selectedText[length] = '\0';					    /* Make sure selected text is NULL-terminated */
  for (tempPointer = selectedText, count=0;			    /* Go through selected text, looking for newlines... */
       tempPointer;						    /* ...and replace each newline with a space. */
       tempPointer = index(tempPointer, '\n'), count++)
  {
    if (tempPointer != selectedText)				    /* Is "tempPointer" pointing to start of the buffer? */
      tempPointer[0] = ' ';					    /* No, must be pointing to a newline; replace it... */
    /* ...with space. */
    if (count > 100)						    /* If this loop has replaced a large number of ... */
      break;							    /* ...lines, exit loop; chances are the end... */
    /* ...won't be saved anyway. */
  }
  
  currentFontSize = xv_get(QuoteMaker_QuoteWindowSpecificationsPopup->FontSizeTextField,
			   PANEL_VALUE);
  
  SetQuotedTextWindowFont(currentFontFamily,
			  currentFontStyle,
			  currentFontSize);
  
  xv_set(QuoteMaker_quotedTextBaseWindow->quotedTextPane,	    /* Allow the Quoted Text popup window to be edited */
	 TEXTSW_BROWSING, FALSE, NULL);
  
  xv_set(QuoteMaker_quotedTextBaseWindow->quotedTextPane,	    /* Put the selected text into the quoted Text... */
	 TEXTSW_CONTENTS, selectedText, NULL);			    /* ...popup window */
  
  xv_set(QuoteMaker_quotedTextBaseWindow->quotedTextPane,	    /* Allow the Quoted Text popup window to be edited */
	 TEXTSW_BROWSING, TRUE, NULL);
  
  textsw_normalize_view(QuoteMaker_quotedTextBaseWindow->quotedTextPane,
			0);					    /* Make sure quoted text shows up at top of... */
  /* ...popup window. */
  
}  



void
  UpdateButtonGlow()
{
  static short count = 0;
  
  if (count == 0)
  {
    count = 1;
    if (Playing)
    {
      xv_set(QuoteMaker_baseWindow->PlayButton, PANEL_ITEM_COLOR, GreenColorIndex, NULL);
    }
  }
  else
  {
    count = 0;
    if (Playing)
    {
      xv_set(QuoteMaker_baseWindow->PlayButton, PANEL_ITEM_COLOR, BlackColorIndex, NULL);
    }
  }
}


void
  CancelButtonGlow()
{
  xv_set(QuoteMaker_baseWindow->PlayButton, PANEL_ITEM_COLOR, BlackColorIndex, NULL);
  xv_set(QuoteMaker_baseWindow->PauseButton, PANEL_ITEM_COLOR, BlackColorIndex, NULL);
}
