/******************************************************************************\
*                                                                              *
*        File : MaMA_structs.h                                                 *
*                                                                              *
* Description : Contains the structures and definitions used in the            *
*               code for the Media editor MaMA in ANSI-C                       *
*                                                                              *
\******************************************************************************/
#define NIL(cast)    (cast)0
#define False 0
#define True  1

#define PATHLEN  256			/* max length of complete path        */
#define FILELEN  64			/* max length of file name            */
#define HYPERLEN  64			/* max length of a hyperlink name     */
#define LABELLEN  256			/* max length of a label name         */
#define DBG_MSG_LEN  256		/* max length of a debug message      */

typedef enum _FIT { 
    NONE, 
    WTP, 
    PTW
} FIT;

typedef enum _L_TYPE {
    EL,
    AL,
    FL
} L_TYPE;

typedef enum _ACTIONTYPE {
    Jump,
    GotoFP,
    GotoNP,
    GotoPP,
    GotoLP,
    ZoomIn,
    ZoomOut,
    Zoom100,
    OpenDoc,
    CloseDoc,
    QuitDoc,
    InitDoc,
} ACTIONTYPE;

typedef struct _LINKLIST{
    struct _LINKLIST *next;
    char Linkname[HYPERLEN];
} LINKLIST;

typedef struct _DOCINFO{
    char Path[PATHLEN];
    char Name[FILELEN];
    LINKLIST *LinkList;
} DOCINFO;

typedef struct _FILEINFO{
    char Dir[PATHLEN];
    char File[FILELEN];
} FILEINFO;

typedef struct _POSITION {
    int Xpos;
    int Ypos;
} POSITION;

typedef union _PARAM {
    char     Hyperlink[HYPERLEN];
    int      Times;
    FIT      Fit;
    POSITION *WindowPos;
} PARAM;

typedef struct _ACTION {
    ACTIONTYPE ActionType;
    PARAM      *Param;
} ACTION;

typedef struct _ACTIONLIST {
    struct _ACTIONLIST *next;
    FILEINFO *Path;
    ACTION   *Action;
    int      Duration;
    int      Selected;
} ACTIONLIST;

typedef struct _FILELIST {
    struct _FILELIST *next;
    DOCINFO  *File;
    int      Selected;
} FILELIST;

typedef struct _EDITLIST {
    struct _EDITLIST *next;
    char       Label[LABELLEN];
    ACTIONLIST *ActionList;
    int        TotalDur;
    int        Selected;
} EDITLIST;

typedef struct _EDITLISTINFO {
    EDITLIST *EditList;
    char     FullFileName[PATHLEN + FILELEN];
    int      Changed;
} EDITLISTINFO;

typedef struct _AUTOMNTLIST {
    struct _AUTOMNTLIST *next;
    char Dir[FILELEN];
    int Selected;
} AUTOMNTLIST;
