/*
 * Copyright (c) 1990, 1991, 1992 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */
/* $Header: /Source/Media/bryant/DisplayTool/RCS/gallery.c,v 1.1 92/10/29 13:55:03 drapeau Exp $ */
/* $Log:	gallery.c,v $
 * Revision 1.1  92/10/29  13:55:03  drapeau
 * Initial revision
 *  */
static char dtGallery[] = "$Header: /Source/Media/bryant/DisplayTool/RCS/gallery.c,v 1.1 92/10/29 13:55:03 drapeau Exp $";

#include "DisplayTool.h"
#include "externs.h"



/*
 * Event callback function for `gallery'.
 */
Notify_value
  DisplayTool_baseWindow_gallery_event_callback(Xv_window win, Event *event, Notify_arg arg, Notify_event_type type)
{
  if (event_id(event) == LOC_DRAG) 
  {
    GalleryEventProc(win, event, arg, type);
  }
  /* gxv_start_connections DO NOT EDIT THIS SECTION */
  
  if (event_action(event) == ACTION_SELECT)
  {
    GalleryEventProc(win, event, arg, type);
  }
  
  if (event_action(event) == ACTION_ADJUST)
  {
    GalleryEventProc(win, event, arg, type);
  }
  
  if (event_action(event) == ACTION_MENU)
  {
    GalleryEventProc(win, event, arg, type);
  }
  
  /* gxv_end_connections */
  
  return notify_next_event_func(win, (Notify_event) event, arg, type);
}



/*
 * Called when an event is received in the gallery canvas.
 */
Notify_value
  GalleryEventProc(Xv_window		win,
		   Event*		event,
		   Notify_arg		arg,
		   Notify_event_type	type)
{
  static int	oldx, oldy;
  static int	first;
  static int	dragging = FALSE;
  int		i;
  int		scrollbarOffset;
  int		oldSelectedGalleryImage;
  XPoint	loc;
  XEvent	compressedEvent;
  IMAGE		tempImage;
  
  if (event_action(event) != event_id(event))			    /* If the event does have an XView action associated... */
    {								    /* ...with it then the id number and the action value... */
      switch (event_action(event))				    /* ...will be distinct -- Volume 7, pg. 126 */
	{
	case ACTION_SELECT :  /* the action */
	case MS_LEFT :	      /* the actual (literal) event */
	case ACTION_ADJUST :
	case MS_MIDDLE :
	case ACTION_MENU :
	case MS_RIGHT :
	  if (event_is_down(event))
	    {
	      loc.x = event_x(event);
	      loc.y = event_y(event);
	      oldSelectedGalleryImage = selectedGalleryImage;
	      selectedGalleryImage = loc.x/102+(loc.y/102)*imagesPerRow;
	      PrintDTDiagnostics(diagString);
	      if (selectedGalleryImage < numGalleryImages)
	        HighlightGalleryImage(selectedGalleryImage, oldSelectedGalleryImage);
	      else
		{
		  if (oldSelectedGalleryImage != None)
		    HighlightGalleryImage(oldSelectedGalleryImage, oldSelectedGalleryImage);
		  selectedGalleryImage = None;
		}
	    }
	  else
            if (event_is_up(event) && dragging)
	      {
		tempImage = gallery[selectedGalleryImage];
		if (tempImage->galleryImage == (XImage*)NULL)	    /* If the galleryImage doesn't exist, create it first. */
		  tempImage->galleryImage = Resize(tempImage->imageData,
						  tempImage->origWidth,
						  tempImage->origHeight,
						  100, 100);
		XPutImage(display, galleryWin, theGC,
			  tempImage->galleryImage, 0, 0,
	                  oldx, oldy, 100, 100);
		if (first)
		  CreateCopyOfImage(oldx, oldy);
		HighlightGalleryImage(selectedGalleryImage, selectedGalleryImage);
		oldx     = 0;
		oldy     = 0;
		first    = FALSE;
		dragging = FALSE;
	      }
	  break;
	  default : ;
	}
    }
  else								    /* If the doesn't have a specific action associated... */
    switch (event_id(event))					    /* ...with it, only an id number */
      {
      case LOC_DRAG:
	if (selectedGalleryImage != None)			    /* Is an image currently selected?  I.e., is there.... */
	  {							    /* ...something to drag around? */
	    tempImage = gallery[selectedGalleryImage];		    /* Yes, point to the currently-selected Gallery image */
	    if (tempImage->galleryImage == (XImage*)NULL)	    /* If the galleryImage doesn't exist, create it first. */
	      tempImage->galleryImage = Resize(tempImage->imageData,
					      tempImage->origWidth,
					      tempImage->origHeight,
					      100, 100);
	    dragging = TRUE;
	    PrintDTDiagnostics(diagString);
	    if (oldx!=0 || oldy!=0)
	      XPutImage(display, galleryWin, theGC,		    /* Draw the image in XOR mode in its previous position,... */
			tempImage->galleryImage,		    /* ...to erase it */
			0, 0,  oldx, oldy, 100, 100);
	    XPutImage(display, galleryWin, theGC,		    /* Draw the image again in XOR mode in its new position,... */
		      tempImage->galleryImage,			    /* ...to show it */
		      0, 0,  event_x(event), event_y(event), 100, 100);
	    if (event_y(event) > 100*(int)xv_get(galleryScrollbar,  /* Has the image been dragged close enough to the slides... */
						 SCROLLBAR_VIEW_START))	/* ...window that the image should be drawn in the... */
	      {							    /* ...slides window? */
		scrollbarOffset =				    /* Yes, determine where to position the image */
		  (int)(SmallHeight) * (int)xv_get(slidesScrollbar,
						   SCROLLBAR_VIEW_START) -
		    104 * (int)xv_get(galleryScrollbar, SCROLLBAR_VIEW_START);
		if (first)
		  XPutImage(display, slidesWin, theGC,
			    tempImage->galleryImage,
			    0, 0,  oldx, 
			    oldy-borderOffset+scrollbarOffset, 100, 100);
		else
		  first = TRUE;
		
		XPutImage(display, slidesWin, theGC,
			  tempImage->galleryImage,
			  0, 0,  event_x(event), 
			  event_y(event)-borderOffset+scrollbarOffset,
			  100, 100);
	      }
	    oldx = event_x(event);
	    oldy = event_y(event);
	  }
	break;
      default:
	;
      }
  if (display)
    for (i=XEventsQueued(display, QueuedAlready); i > 1; i--)
      XNextEvent(display, &compressedEvent); 
  
  /* gxv_start_connections DO NOT EDIT THIS SECTION */
  
  /* gxv_end_connections */
  
  return notify_next_event_func(win, (Notify_event) event, arg, type);
}								    /* end function GalleryEventProc */




/*
 *   GalleryEventProc sub-function when the mouse is released -- copy the image
 */
void
  CreateCopyOfImage(int oldx, int oldy)
{
  int	i;
  IMAGE	tempImage;
  char	errorMessage[MaxLength];
  int	scrollbarOffset = SmallHeight * (int)xv_get(slidesScrollbar,  SCROLLBAR_VIEW_START) - 
    104 * (int)xv_get(galleryScrollbar, SCROLLBAR_VIEW_START);
  
  PrintDTDiagnostics("Entering CreateCopyOfImage.\n");
  if (oldy - borderOffset+scrollbarOffset < 0)
    return;
  if (dtImage[numSlidesImages] != (IMAGE)NULL)			    /* Free up space taken by this image, if necessary */
    FreeImage(dtImage[numSlidesImages]);
  dtImage[numSlidesImages] =					    /* Create a new image with the same file data as the... */
    CreateImage(gallery[selectedGalleryImage]->filename);	    /* ...one being copied */
  if (dtImage[numSlidesImages] == (IMAGE)NULL)
  {
    sprintf(diagString, "In CreateCopyOfImage, could not create new image for file %s.\n",
	    gallery[selectedGalleryImage]->filename);
    PrintDTDiagnostics(diagString);
    return;
  }
  tempImage = dtImage[numSlidesImages];				    /* Point temp variable to newly-created image */
  sprintf(diagString, "Before 3 Resizes, tempImage stuff: origWidth=%d, origHeight=%d, largeWidth=%d, largeHeight=%d.\n",
	  tempImage->origWidth, tempImage->origHeight,
	  tempImage->largeWidth, tempImage->largeHeight);
  PrintDTDiagnostics(diagString);
  if (tempImage->galleryImage == (XImage*)NULL)			    /* If the galleryImage doesn't exist, create it first. */
    tempImage->galleryImage = Resize(tempImage->imageData,
				     tempImage->origWidth,
				     tempImage->origHeight,
				     100, 100);
  if (tempImage->slideImage == (XImage*)NULL)			    /* If the slideImage doesn't exist, create it first. */
    tempImage->slideImage = Resize(tempImage->imageData,
				   tempImage->origWidth,
				   tempImage->origHeight,
				   tempImage->largeWidth / largeFactor,
				   tempImage->largeHeight / largeFactor);
  if (tempImage->largeImage == (XImage*)NULL)			    /* If the largeImage doesn't exist, create it first. */
    tempImage->largeImage = Resize(tempImage->imageData,
				   tempImage->origWidth,
				   tempImage->origHeight,
				   tempImage->largeWidth,
				   tempImage->largeHeight);
  tempImage->slide = WhichSlide(oldx, oldy-borderOffset+scrollbarOffset,
				slideSize, &tempImage->corner);
  if (tempImage->slide > MaxNumSlides-1)
  {
    sprintf(errorMessage, "Can't exceed %d slides.", MaxNumSlides);
    notice_prompt(baseWindow->baseWindow, NULL,
		  NOTICE_MESSAGE_STRINGS,
		  errorMessage,
		  " ",
		  "Images beyond this limit shall",
		  "be placed in the last slide.",
		  NULL,
		  NOTICE_BUTTON_YES, "OK",
		  NULL);
    tempImage->slide = MaxNumSlides - 1;
    SlidesRepaint(NULL, NULL, NULL, NULL);
  }
  for (i=0; i < tempImage->nfcols && i<=NumColors; i++)
    cmap[(int)tempImage->freecols[i]]++;
/*  
  GetOffsets(numSlidesImages, &xoffset, &yoffset);
  PaintSlide(tempImage->slide);
  
  XClearArea(display, slidesWin, 0, 0,
	     SmallWidth, SmallHeight, True); 
  XPutImage(display, slidesWin, theGC, tempImage->slideImage,
	    0, 0, xoffset + tempImage->corner.x,
	    yoffset + tempImage->corner.y,
	    tempImage->largeWidth / largeFactor,
	    tempImage->largeHeight / largeFactor);
*/  
  selectedSlide = tempImage->slide;
  numSlidesImages++;
  SetCurrentSlide(selectedSlide+1);
  changes = True;
  SetTotalNumberOfSlides();
  PaintSlide(selectedSlide);
  RedrawRectangles();
  return;
}								    /* end function CreateCopyOfImage */




void
  HighlightGalleryImage(int imageNum, int oldImageNum)
{
  char	theMsg[256];
  
  PrintDTDiagnostics("Entering HighlightGalleryImage.\n");
  XSetLineAttributes(display, theGC, 2, LineSolid, CapProjecting, JoinMiter);
  XSetFunction(display, theGC, GXcopy); 
  if (oldImageNum==None)
    {
      sprintf(theMsg, "Current Image: %s", gallery[imageNum]->filename);
      xv_set(baseWindow->currentImageMsg, PANEL_LABEL_STRING, theMsg, NULL);
      XSetForeground(display, theGC, pixelValues[Red]);
      XDrawRectangle(display, galleryWin, theGC, (imageNum%imagesPerRow)*100+4*(imageNum%imagesPerRow)+1, 
		     (imageNum/imagesPerRow)*100+4*(imageNum/imagesPerRow)+1, 102, 102);
    }
  else if (imageNum == oldImageNum)
    {
      sprintf(theMsg, "Current Image: None");
      xv_set(baseWindow->currentImageMsg, PANEL_LABEL_STRING, theMsg, NULL);
      XSetForeground(display, theGC, BlackPixel(display, DefaultScreen(display)));
      XDrawRectangle(display, galleryWin, theGC, (imageNum%imagesPerRow)*100+4*(imageNum%imagesPerRow)+1, 
		     (imageNum/imagesPerRow)*100+4*(imageNum/imagesPerRow)+1, 102, 102);
      selectedGalleryImage = None;
    }
  else								    /* (imageNum!=oldImageNum && oldImageNum!=None)  */
    {
      sprintf(theMsg, "Current Image: %s", gallery[imageNum]->filename);
      xv_set(baseWindow->currentImageMsg, PANEL_LABEL_STRING, theMsg, NULL);
      XSetForeground(display, theGC, BlackPixel(display, DefaultScreen(display)));
      XDrawRectangle(display, galleryWin, theGC, (oldImageNum%imagesPerRow)*100+4*(oldImageNum%imagesPerRow)+1, 
		     (oldImageNum/imagesPerRow)*100+4*(oldImageNum/imagesPerRow)+1, 102, 102);
      XSetForeground(display, theGC, pixelValues[Red]);
      XDrawRectangle(display, galleryWin, theGC, (imageNum%imagesPerRow)*100+4*(imageNum%imagesPerRow)+1, 
		     (imageNum/imagesPerRow)*100+4*(imageNum/imagesPerRow)+1, 102, 102);
    }
  XSetFunction(display, theGC, GXxor); 
}								    /* end function HighlightGalleryImage */



/*
 * Repaint callback function for `gallery'.
 */
void
  GalleryRepaint(Canvas		canvas,
		 Xv_window	paint_window, 
		 Window		xid,
		 Xv_xrectlist*	rects)
{
  int	i;
  
  PrintDTDiagnostics("Called GalleryRepaint.\n");
  XSetFunction(display, theGC, GXcopy); 
  XClearArea(display, galleryWin, 0, 0, 645, 4*MaxNumImages, True);
  XSetForeground(display, theGC, WhitePixel(display, DefaultScreen(display)));
  XFillRectangle(display, galleryWin, theGC, 0, 0, 645, 4*MaxNumImages);
  for (i = 0; i < numGalleryImages; i++)
  {
    if (selectedGalleryImage == i)
      XSetForeground(display, theGC, pixelValues[Red]);
    else
      XSetForeground(display, theGC, BlackPixel(display, DefaultScreen(display)));
    XDrawRectangle(display, galleryWin, theGC, (i%imagesPerRow)*100+4*(i%imagesPerRow)+1, 
		   (i/imagesPerRow)*100+4*(i/imagesPerRow)+1, 102, 102);
    if (!performing)
    {
      PaintGalleryImage(i);
    }
  }
  XSetFunction(display, theGC, GXxor); 
}								    /* end function GalleryRepaint */



void PaintGalleryImage(int imageNum)
{
  IMAGE	theImage;

  theImage = gallery[imageNum];
  if (theImage->galleryImage == (XImage*)NULL)			    /* If the galleryImage doesn't exist, create it first. */
    theImage->galleryImage = Resize(theImage->imageData,
				    theImage->origWidth,
				    theImage->origHeight,
				    100, 100);
  XPutImage(display, galleryWin, theGC,
	    theImage->galleryImage,
	    0, 0,
	    (imageNum % imagesPerRow) * 100 +
	    4 * ((imageNum % imagesPerRow) + 1) - 2, 
	    (imageNum / imagesPerRow) * 100 +
	    4 * ((imageNum / imagesPerRow) + 1) - 2, 
	    100, 100);
}								    /* end function PaintGalleryImage */
