/*
 * Copyright (c) 1990, 1991, 1992 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */
/* $Header: /Source/Media/bryant/DisplayTool/RCS/cursor.c,v 1.1 92/10/29 13:53:56 drapeau Exp $ */
/* $Log:	cursor.c,v $
 * Revision 1.1  92/10/29  13:53:56  drapeau
 * Initial revision
 *  */
static char dtCursor[] = "$Header: /Source/Media/bryant/DisplayTool/RCS/cursor.c,v 1.1 92/10/29 13:53:56 drapeau Exp $";

#include "DisplayTool.h"
#include "externs.h"

#include <xview/cursor.h>

static Xv_Cursor busyCursor;
static Xv_Cursor normalCursor;

void CreateCursor() 
{
  busyCursor = (Xv_Cursor) xv_create(XV_NULL, CURSOR,
				CURSOR_SRC_CHAR, OLC_BUSY_PTR,				 
				NULL);
  normalCursor = (Xv_Cursor) xv_create(XV_NULL, CURSOR,
				CURSOR_SRC_CHAR, OLC_BASIC_PTR,				 
				NULL);
}								    /* end function CreateCursor */



void NormalCursor()
{
  xv_set(xv_get(baseWindow->gallery, CANVAS_NTH_PAINT_WINDOW, 0),
	 WIN_CURSOR, normalCursor, NULL);		
  xv_set(xv_get(baseWindow->slides, CANVAS_NTH_PAINT_WINDOW, 0),
	 WIN_CURSOR, normalCursor, NULL);		
}								    /* end function NormalCursor */



void BusyCursor() 
{
  xv_set(xv_get(baseWindow->gallery, CANVAS_NTH_PAINT_WINDOW, 0),
	 WIN_CURSOR, busyCursor, NULL);		
  xv_set(xv_get(baseWindow->slides, CANVAS_NTH_PAINT_WINDOW, 0),
	 WIN_CURSOR, busyCursor, NULL);		
}								    /* end function BusyCursor */



void BusyApp()
{
  xv_set(baseWindow->baseWindow, FRAME_BUSY, TRUE, NULL);
  BusyCursor();
}								    /* end function BusyApp */


void NormalApp()
{
  xv_set(baseWindow->baseWindow, FRAME_BUSY, FALSE, NULL);
  NormalCursor();
}								    /* end function NormalApp */
