/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/DTR/RCS/save.c,v 1.0 92/01/06 17:52:36 drapeau Exp Locker: derek $ */
/* $Log:	save.c,v $
 * Revision 1.0  92/01/06  17:52:36  drapeau
 * * Deleted InitPaths() since no longer necessary.
 * * Modified SaveSoundFile() so that removing a file now uses the system
 *   call unlink() instead of using the more awkward "system()" function.
 * Also, Made a number of cosmetic changes to make code easier to read and
 * to conform to programming specifications.
 * 
 * Revision 0.23  91/09/18  22:47:37  derek
 * The following things are done:
 * 1.	The Makefile is changed corresponding to the changes in collab/.
 * 2.	Copyright messages included.
 * 3.	Some minor bugs fixed.
 * 
 * Revision 0.22  91/08/21  11:34:31  derek
 * The following changes are made:
 * 1.	Now the duration and size of the recorded sound will be displayed
 * 	during recording.
 * 2.	I have changed GetSelection() corresponding to the request of Tek joo
 * 3.	Info Panel is added to the application.
 * 4.	Fixed SizeToFitHandler() so that when no file or buffer is currently
 * 	loaded, it would not do anything (except giving a warning
 * 	notice_prompt).
 * 5.	Inplemented the `Close' Menu option in the document menu.
 * 6.	Fixed the bug in which after ClearAll and I press PreviewEdit,
 * 	the edit wont be played.
 * 7.	I have made the changes corresponding to the change in OpenPanel's
 * 	name.  (from OpenPanel to Browse).
 * 8.	Incorporated BrowseCheck to check command line arg.
 * 9.	Changed most EditingStatusMessages to NoticePrompts.
 * 10.	SoundFileSaveAsPopUp and EditListSaveAsPopUp are removed 
 * 	from the application.
 * 
 * Revision 0.21  91/08/16  18:10:52  derek
 * 
 * The following things are done:
 * 1.	I have fixed an openpanel bug in my code in which I 
 * 	made the app return the wrong values to OpenHandler and
 * 	the SaveHandler.
 * 2.	The flashing color of the play button has been changed from
 * 	Red to Green.
 * 3.	Fixed a quantization bug: Buffer.play.end, when converted
 * 	from endingTimeInSec, should not exceed Buffer_hdr_data_size - 1.
 * 
 * Revision 0.20  91/08/14  16:14:13  derek
 * Fixed a few saving/appending bugs.
 * 
 * Revision 0.19  91/08/08  11:02:24  derek
 * This is a cleaner version.  I have removed lots of printf/fprintf 
 * statements from it, and have also cleaned up the code using xsaber.
 * This version should run substantially faster.
 * 
 * Revision 0.18  91/08/07  16:24:46  derek
 * The Edit list part of DTR is done.  OpenPanel is also incorporated.
 * 
 * Revision 0.17  91/07/30  11:45:48  derek
 * I have fixed the tmp file conflict bug.
 * 
 * Revision 0.16  91/07/26  13:18:32  derek
 * Some saving bugs fixed.
 * 
 * Revision 0.15  91/07/23  21:25:30  derek
 * This version is not ready for release.  Disk space editing is half-done:
 * the application can play an infinite sound and the canvases can handle
 * infinite sound files.  The app is pretty bug free too, I think.  The
 * weakness is that it cannot record sond infinitely.
 * 
 * Revision 0.14  91/06/26  15:55:54  derek
 * I have reformatted the code to conform coding specs.
 * 
 * Revision 0.13  91/06/25  11:40:06  derek
 * I have added the new protocol items.
 * 
 * Revision 0.12  91/06/05  15:00:09  derek
 * checking in after porting the code to collab
 * 
 * Revision 0.11  91/06/02  10:28:17  derek
 * changes made in the save-as function
 * 
 * Revision 0.10  1991/04/25  01:52:26  derek
 * This version is checked in on 4/24/91
 * */
static char rcsid[] = "$Header: /Source/Media/collab/DTR/RCS/save.c,v 1.0 92/01/06 17:52:36 drapeau Exp Locker: derek $";

#include "dtr.h"
#include "dtr_ui.h"

/*
 *  Verify the selected region of the waveform buffer and 
 *  return its size.
 */
int
  GetRecordedDataSize()
{
  int	cnt;
  char	msg[256];
  extern      dtr_mainWindow_objects  *dtr_mainWindow;
  
  EVENT("Get_Recorded_Data_Size");
  
  if (Buffer.hdr.data_size == 0)
  {
    AlertByNoticePrompt(dtr_mainWindow->menuControlPanel,
			"No data in buffer.");
    return (0);
  }
  cnt = Buffer.play.end - Buffer.play.start;
  
  if (cnt == 0)
  {
    AlertByNoticePrompt(dtr_mainWindow->menuControlPanel,
			"No data in selected region.");
    return (0);
  }

  if (Buffer.play.start >= Buffer.hdr.data_size)		    
  {
    sprintf(msg, "Start position (%d) beyond EOF (%d).",
	    Buffer.play.start, Buffer.hdr.data_size);
    AlertByNoticePrompt(dtr_mainWindow->menuControlPanel, msg);
    return (-1);
  }
  
  if (cnt < 0)
  {
    sprintf(msg, "Start position (%d) beyond End position (%d).",
	    Buffer.play.start, Buffer.play.end);
    AlertByNoticePrompt(dtr_mainWindow->menuControlPanel, msg);
    return (-1);
  }
  
  return (cnt);
}


int
  SaveSoundFile(append, sourceFileName, destFileName)
BOOL  append;
char  *sourceFileName;
char  *destFileName;
{
  char		*info = NULL;						    /*  Right now the pointer to info string is NULL... */
  unsigned	Ilen = 0;						    /*  ...and set length of info string = 0.           */
  int   	err;
  Audio_hdr  	sourcetmphdr;
  Audio_hdr  	desttmphdr;
  Audio_hdr  	tmphdr;
  struct stat  	st;
  int   	bytes;
  int   	sourcefd;
  int   	destfd;
  int   	rtn;
  int   	cnt;
  int   	outcnt;
  unsigned 	char  data[1024];
  int   	status;
  extern  dtr_mainWindow_objects  *dtr_mainWindow;
  
  EVENT("Save_Sound_File");
  
  status = FILE_NOT_OK;
  err = 0;
  stat(sourceFileName, &st);
  if (WaveEditMode == TRUE)
  {
    bytes = Buffer.hdr.data_size;
    
    if (append)
    {								    /*  Append data to existing file.                   */
      SameSoundFile = FALSE;
      if ((destfd = open(Buffer.filename, O_RDWR)) < 0)
      {
	sprintf(msg, "Can't open '%s' (%s).",
		Buffer.filename, sys_errlist[errno]);
	AlertByNoticePrompt(dtr_mainWindow->menuControlPanel, msg);
	return FILE_NOT_OK;
      }
      
      if (!S_ISREG(st.st_mode) ||				    /*  Make sure this is already an audio file.        */
	  (audio_read_filehdr(destfd, &tmphdr, (char *)NULL, 0) !=
	   AUDIO_SUCCESS))
      {
	sprintf(msg, "'%s' is not a valid audio file.",
		Buffer.filename, sys_errlist[errno]);
	AlertByNoticePrompt(dtr_mainWindow->menuControlPanel, msg);
	goto closerr;
      }
    
      if ((int)lseek(destfd, st.st_size, L_SET) < 0)
	goto writerr;
    }
    else							    /*  Create a dest file.                              */
    {
      destfd = open(destFileName, O_WRONLY | O_CREAT | O_TRUNC,	    
		   0666);
    
      tmphdr = Buffer.hdr;					    /*  Write an audio file header first.               */
      tmphdr.data_size = bytes;
      if ((destfd < 0) || 
	  (audio_write_filehdr(destfd, &tmphdr,
			       info, Ilen)
	   != AUDIO_SUCCESS))
	goto writerr;
     }
  
    rtn = write(destfd, (char *)&Buffer.data[Buffer.play.start], bytes);
    err = (rtn != bytes);
    if (append && !err)
    {
      if ((tmphdr.data_size != AUDIO_UNKNOWN_SIZE) &&
	  (audio_rewrite_filesize(destfd, 
				  (tmphdr.data_size + bytes)) !=
	   AUDIO_SUCCESS))
	err++;
    }
  
    if (err)
    {
     writerr:
      sprintf(msg, "Can't %s to '%s' (%s).",
	      (append ? "append" : "write"), destFileName,
	      sys_errlist[errno]);
      AlertByNoticePrompt(dtr_mainWindow->menuControlPanel, msg);
      goto closerr;
    }
    sprintf(currentSoundFile,"%s", destFileName);
    if (append)							    /*  If append and in WaveEditMode...                */
    {								    /*  ...This statement is added so that if we are... */
      strcpy(Buffer.filename, "");
      SoundBufferReady = ReadSoundFile(TRUE);			    /*  ...appending data to an existing file, the ...  */
      FileReady = FALSE;					    /*  ...canvas will be displaying an updated...      */
      SameSoundFile = TRUE;					    /*  ...(appended) version of the file.              */
      RepaintWaveCanvas();
      RepaintGlobalWaveCanvas();
    }
    BufferSaved = TRUE;
    status = FILE_OK;
   closerr:
    (void) close(destfd);
  }
  else								    /*  If NOT in WaveEditMode.                         */
  {
    if (!append)						    /*  Create a new file.                              */
    {
      unlink(destFileName);
      sprintf(msg, "cp %s %s", SoundFileInTmp, destFileName);
      system(msg);
      sprintf(currentSoundFile, "%s", destFileName);
      status = FILE_OK;
    }
    else							    /*  If appending to an existing file.               */
    {
      if ((sourcefd = open(sourceFileName, O_RDONLY)) < 0)	    /*  Handle source file first.                       */
      {
	sprintf(msg, "Can't open '%s' (%s).",
		sourceFileName, sys_errlist[errno]);
	AlertByNoticePrompt(dtr_mainWindow->menuControlPanel, msg);
	return FILE_NOT_OK;
      }
      stat(sourceFileName, &st);
      if (!S_ISREG(st.st_mode) ||				    /*  Make sure the source file is already an...      */
	  (audio_read_filehdr(sourcefd, &sourcetmphdr,		    /*  ...audio file.                                  */
			      (char *)NULL, 0)
	   != AUDIO_SUCCESS))
      {
	sprintf(msg, "'%s' is not a valid audio file.",
		destFileName, sys_errlist[errno]);
	AlertByNoticePrompt(dtr_mainWindow->menuControlPanel, msg);
	goto closerr2;
      }
      if ((destfd = open(destFileName, O_RDWR)) < 0)		    /*  Now, handle dest file.                          */
      {
	sprintf(msg, "Can't open '%s' (%s).",
		destFileName, sys_errlist[errno]);
	AlertByNoticePrompt(dtr_mainWindow->menuControlPanel, msg);
	return FILE_NOT_OK;
      }
    
      stat(destFileName, &st);
      if (!S_ISREG(st.st_mode) ||				    /*  Make sure this is already an audio file.        */
	  (audio_read_filehdr(destfd, &desttmphdr,
			      (char *)NULL, 0)
	   != AUDIO_SUCCESS))
      {
	sprintf(msg, "'%s' is not a valid audio file.",
		destFileName, sys_errlist[errno]);
	AlertByNoticePrompt(dtr_mainWindow->menuControlPanel, msg);
	goto closerr2;
      }
    
      if ((int)lseek(destfd, st.st_size, L_SET) < 0)		    /*  Seek to the end of the dest file (destFileName). */
      {								    /*  And then we will starting appending things...    */
	AlertByNoticePrompt(dtr_mainWindow->menuControlPanel,	    /*  ...to the end of this file.                      */
			    "Error in lseek\n");
      }
      
      outcnt = sourcetmphdr.data_size;
      while(outcnt > 1024)
      {
	cnt = read(sourcefd, (char *)data, 1024);
	rtn = write(destfd, (char *)data, cnt);
	
	if (rtn > 0)
	{
	  outcnt -=rtn;
	}
	else
	  break;
      }
      if (outcnt > 0)
      {
	cnt = read(sourcefd, (char *)data, outcnt);
	rtn = write(destfd, (char *)data, cnt);
      }
      if (!err)
	if ((desttmphdr.data_size != AUDIO_UNKNOWN_SIZE) &&
	    (audio_rewrite_filesize(destfd,
				    (sourcetmphdr.data_size +
				     desttmphdr.data_size)))
	    != AUDIO_SUCCESS)
	{
	  err++;
	}
    
      if (err)
      {
       writerr2:
	sprintf(msg, "Can't append to '%s' (%s).",
		destFileName, sys_errlist[errno]);
	AlertByNoticePrompt(dtr_mainWindow->menuControlPanel, msg);
	goto closerr2;
      }
      sprintf(currentSoundFile, "%s", destFileName);		    /*  I am hoping that in case of any error above, .. */
								    /*  ...this step will be bypassed.                  */
      if (append)						    /*  This statement is added so that if we are...    */
      {								    /*  ...appending to a file, we want the canvas...   */
	strcpy(Buffer.filename, "");
	SoundBufferReady = ReadSoundFile(TRUE);			    /*  ...to show the most updated appended version.   */
	FileReady = FALSE;
	SameSoundFile = TRUE;
	RepaintWaveCanvas();
	RepaintGlobalWaveCanvas();
      }
      status = FILE_OK;
     closerr2:
      (void) close(sourcefd);
      (void) close(destfd);
    }
  }
  return (status);
}								    /* end function SaveSoundFile */
