;GIL-3
(
(
	:type                   :menu
	:name                   documentMenu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             "Document"
	:menu-item-labels       ("Open Sound File" "Save Sound File" "Save Sound File As..." "About DTR ... " "Close" "Quit" )
	:menu-item-label-types  (:string :string :string :string :string :string )
	:menu-item-states       (:active :active :active :active :active :active )
	:menu-item-defaults     (nil nil nil nil nil nil )
	:initial-selections     (nil nil nil nil nil nil )
	:menu-item-handlers     (OpenFileHandler SaveSoundFileMenuOption SaveSoundFileAsMenuOption InfoHandler CloseHandler QuitDtr )
	:menu-item-menus        (nil nil nil nil nil nil )
	:menu-item-colors       ("" "" "" "" "" "" )
	:pinnable               t
	:user-data              ()
	:actions                (
		(
		:from                   (documentMenu "Open Sound File")
		:when                   (Notify )
		:to                     (documentMenu "Open Sound File")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (OpenFileHandler)
		)
		(
		:from                   (documentMenu "Save Sound File")
		:when                   (Notify )
		:to                     (documentMenu "Save Sound File")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (SaveSoundFileMenuOption)
		)
		(
		:from                   (documentMenu "Save Sound File As...")
		:when                   (Notify )
		:to                     (documentMenu "Save Sound File As...")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (SaveSoundFileAsMenuOption)
		)
		(
		:from                   (documentMenu "About DTR ... ")
		:when                   (Notify )
		:to                     (documentMenu "About DTR ... ")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (InfoHandler)
		)
		(
		:from                   (documentMenu "Close")
		:when                   (Notify )
		:to                     (documentMenu "Close")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (CloseHandler)
		)
		(
		:from                   (documentMenu "Quit")
		:when                   (Notify )
		:to                     (documentMenu "Quit")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (QuitDtr)
		)
	)
)
(
	:type                   :menu
	:name                   editMenu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             ""
	:menu-item-labels       ("Cut" "Copy" "Undo" "Paste" "Clear All" )
	:menu-item-label-types  (:string :string :string :string :string )
	:menu-item-states       (:active :active :active :active :active )
	:menu-item-defaults     (nil nil nil nil nil )
	:initial-selections     (nil nil nil nil nil )
	:menu-item-handlers     (CutHandler CopyHandler UndoHandler PasteHandler ClearAllHandler )
	:menu-item-menus        (nil nil nil nil nil )
	:menu-item-colors       ("" "" "" "" "" )
	:pinnable               t
	:user-data              ()
	:actions                (
		(
		:from                   (editMenu "Cut")
		:when                   (Notify )
		:to                     (editMenu "Cut")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (CutHandler)
		)
		(
		:from                   (editMenu "Copy")
		:when                   (Notify )
		:to                     (editMenu "Copy")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (CopyHandler)
		)
		(
		:from                   (editMenu "Undo")
		:when                   (Notify )
		:to                     (editMenu "Undo")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (UndoHandler)
		)
		(
		:from                   (editMenu "Paste")
		:when                   (Notify )
		:to                     (editMenu "Paste")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (PasteHandler)
		)
		(
		:from                   (editMenu "Clear All")
		:when                   (Notify )
		:to                     (editMenu "Clear All")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ClearAllHandler)
		)
	)
)
(
	:type                   :menu
	:name                   audioOutputOptionsMenu
	:help                   ""
	:columns                1
	:menu-type              :exclusive
	:menu-handler           nil
	:menu-title             ""
	:menu-item-labels       ("icons/speaker.icon" "icons/headphone.icon" )
	:menu-item-label-types  (:glyph :glyph )
	:menu-item-states       (:active :active )
	:menu-item-defaults     (nil nil )
	:initial-selections     (nil nil )
	:menu-item-handlers     (SetSpeakerOutput SetHeadphoneOutput )
	:menu-item-menus        (nil nil )
	:menu-item-colors       ("" "" )
	:pinnable               t
	:user-data              ()
	:actions                (
		(
		:from                   (audioOutputOptionsMenu "icons/speaker.icon")
		:when                   (Notify )
		:to                     (audioOutputOptionsMenu "icons/speaker.icon")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (SetSpeakerOutput)
		)
		(
		:from                   (audioOutputOptionsMenu "icons/headphone.icon")
		:when                   (Notify )
		:to                     (audioOutputOptionsMenu "icons/headphone.icon")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (SetHeadphoneOutput)
		)
	)
)
(
	:type                   :menu
	:name                   optionsMenu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             "Options"
	:menu-item-labels       ("Clear Selection" "Size To Fit" "Global Wave Canvas" "Enable Sound Editing" "Audio Output Options" )
	:menu-item-label-types  (:string :string :string :string :string )
	:menu-item-states       (:active :active :active :active :active )
	:menu-item-defaults     (nil nil nil nil nil )
	:initial-selections     (nil nil nil nil nil )
	:menu-item-handlers     (ResetMarkersHandler SizeToFitHandler GlobalWaveCanvasHandler ToggleSoundEditing nil )
	:menu-item-menus        (nil nil nil nil audioOutputOptionsMenu )
	:menu-item-colors       ("" "" "" "" "" )
	:pinnable               t
	:user-data              ()
	:actions                (
		(
		:from                   (optionsMenu "Clear Selection")
		:when                   (Notify )
		:to                     (optionsMenu "Clear Selection")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ResetMarkersHandler)
		)
		(
		:from                   (optionsMenu "Size To Fit")
		:when                   (Notify )
		:to                     (optionsMenu "Size To Fit")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (SizeToFitHandler)
		)
		(
		:from                   (optionsMenu "Global Wave Canvas")
		:when                   (Notify )
		:to                     (optionsMenu "Global Wave Canvas")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (GlobalWaveCanvasHandler)
		)
		(
		:from                   (optionsMenu "Enable Sound Editing")
		:when                   (Notify )
		:to                     (optionsMenu "Enable Sound Editing")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ToggleSoundEditing)
		)
	)
)
(
	:type                   :menu
	:name                   editListDocumentMenu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             ""
	:menu-item-labels       ("Open Edit List" "Save Edit List" "Save Edit List As..." "New" )
	:menu-item-label-types  (:string :string :string :string )
	:menu-item-states       (:active :active :active :active )
	:menu-item-defaults     (nil nil nil nil )
	:initial-selections     (nil nil nil nil )
	:menu-item-handlers     (OpenEditListHandler SaveEditListHandler EditListSaveAsHandler NewEditListHandler )
	:menu-item-menus        (nil nil nil nil )
	:menu-item-colors       ("" "" "" "" )
	:pinnable               t
	:user-data              ()
	:actions                (
		(
		:from                   (editListDocumentMenu "Open Edit List")
		:when                   (Notify )
		:to                     (editListDocumentMenu "Open Edit List")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (OpenEditListHandler)
		)
		(
		:from                   (editListDocumentMenu "Save Edit List")
		:when                   (Notify )
		:to                     (editListDocumentMenu "Save Edit List")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (SaveEditListHandler)
		)
		(
		:from                   (editListDocumentMenu "Save Edit List As...")
		:when                   (Notify )
		:to                     (editListDocumentMenu "Save Edit List As...")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (EditListSaveAsHandler)
		)
		(
		:from                   (editListDocumentMenu "New")
		:when                   (Notify )
		:to                     (editListDocumentMenu "New")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (NewEditListHandler)
		)
	)
)
(
	:type                   :base-window
	:name                   mainWindow
	:owner                  nil
	:width                  600
	:height                 460
	:background-color       "light gray"
	:foreground-color       ""
	:label                  "Digital Tape Recorder"
	:label-type             :string
	:initial-state          :open
	:show-footer            nil
	:resizable              nil
	:icon-file              "icons/dtr.icon"
	:icon-label             ""
	:icon-mask-file         ""
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   menuControlPanel
	:owner                  mainWindow
	:help                   ""
	:x                      0
	:y                      0
	:width                  600
	:height                 115
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   documentButton
	:owner                  menuControlPanel
	:help                   ""
	:x                      12
	:y                      8
	:width                  94
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "black"
	:label                  "Document"
	:label-type             :string
	:initial-state          :active
	:menu                   documentMenu
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   editButton
	:owner                  menuControlPanel
	:help                   ""
	:x                      120
	:y                      8
	:width                  24
	:height                 19
	:constant-width         t
	:button-type            :normal
	:foreground-color       "black"
	:label                  "Edit"
	:label-type             :string
	:initial-state          :active
	:menu                   editMenu
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   optionsButton
	:owner                  menuControlPanel
	:help                   ""
	:x                      192
	:y                      8
	:width                  80
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "black"
	:label                  "Options"
	:label-type             :string
	:initial-state          :active
	:menu                   optionsMenu
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   openEditListButton
	:owner                  menuControlPanel
	:help                   ""
	:x                      280
	:y                      8
	:width                  76
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "black"
	:label                  "Edit List..."
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         ShowEditListPanelHandler
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (mainWindow openEditListButton)
		:when                   (Notify )
		:to                     (mainWindow openEditListButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ShowEditListPanelHandler)
		)
	)
)
(
	:type                   :message
	:name                   durationLabelMessage
	:owner                  menuControlPanel
	:help                   ""
	:x                      365
	:y                      12
	:width                  63
	:height                 13
	:foreground-color       "black"
	:label                  "Duration:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   durationMessage
	:owner                  menuControlPanel
	:help                   ""
	:x                      438
	:y                      12
	:width                  0
	:height                 0
	:foreground-color       "black"
	:label                  ""
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   sizeLabelMessage
	:owner                  menuControlPanel
	:help                   ""
	:x                      397
	:y                      32
	:width                  31
	:height                 13
	:foreground-color       "black"
	:label                  "Size:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   sizeMessage
	:owner                  menuControlPanel
	:help                   ""
	:x                      438
	:y                      32
	:width                  0
	:height                 0
	:foreground-color       "black"
	:label                  ""
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   spaceLeftOnTmpLabelMessage
	:owner                  menuControlPanel
	:help                   ""
	:x                      8
	:y                      44
	:width                  130
	:height                 13
	:foreground-color       "black"
	:label                  "Space left on /tmp:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   spaceLeftOnTmpMessage
	:owner                  menuControlPanel
	:help                   ""
	:x                      148
	:y                      44
	:width                  0
	:height                 0
	:foreground-color       "black"
	:label                  ""
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   recordButton
	:owner                  menuControlPanel
	:help                   ""
	:x                      4
	:y                      68
	:width                  60
	:height                 42
	:constant-width         t
	:button-type            :normal
	:foreground-color       "black"
	:label                  "icons/record.icon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         RecordButtonHandler
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (mainWindow recordButton)
		:when                   (Notify )
		:to                     (mainWindow recordButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (RecordButtonHandler)
		)
	)
)
(
	:type                   :button
	:name                   pauseButton
	:owner                  menuControlPanel
	:help                   ""
	:x                      84
	:y                      68
	:width                  60
	:height                 42
	:constant-width         t
	:button-type            :normal
	:foreground-color       "black"
	:label                  "icons/pause.icon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         PauseButtonHandler
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (mainWindow pauseButton)
		:when                   (Notify )
		:to                     (mainWindow pauseButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (PauseButtonHandler)
		)
	)
)
(
	:type                   :button
	:name                   stopButton
	:owner                  menuControlPanel
	:help                   ""
	:x                      164
	:y                      68
	:width                  60
	:height                 42
	:constant-width         t
	:button-type            :normal
	:foreground-color       "black"
	:label                  "icons/stop.icon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         StopButtonHandler
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (mainWindow stopButton)
		:when                   (Notify )
		:to                     (mainWindow stopButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (StopButtonHandler)
		)
	)
)
(
	:type                   :button
	:name                   playButton
	:owner                  menuControlPanel
	:help                   ""
	:x                      244
	:y                      68
	:width                  60
	:height                 42
	:constant-width         t
	:button-type            :normal
	:foreground-color       "black"
	:label                  "icons/play.icon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         PlayButtonHandler
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (mainWindow playButton)
		:when                   (Notify )
		:to                     (mainWindow playButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (PlayButtonHandler)
		)
	)
)
(
	:type                   :slider
	:name                   playGain
	:owner                  menuControlPanel
	:help                   ""
	:x                      336
	:y                      68
	:width                  254
	:height                 26
	:value-x                369
	:value-y                68
	:slider-width           200
	:ticks                  10
	:foreground-color       "black"
	:label                  "Play "
	:label-type             :string
	:layout-type            :horizontal
	:orientation            :horizontal
	:show-endboxes          nil
	:show-range             nil
	:show-value             nil
	:min-value              0
	:max-value              100
	:min-value-string       ""
	:max-value-string       ""
	:min-tick-string        ""
	:max-tick-string        ""
	:initial-value          0
	:initial-state          :active
	:notify-handler         PlayGainSlider
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (mainWindow playGain)
		:when                   (Notify )
		:to                     (mainWindow playGain)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (PlayGainSlider)
		)
	)
)
(
	:type                   :slider
	:name                   recordGain
	:owner                  menuControlPanel
	:help                   ""
	:x                      324
	:y                      92
	:width                  267
	:height                 26
	:value-x                370
	:value-y                92
	:slider-width           200
	:ticks                  10
	:foreground-color       ""
	:label                  "Record"
	:label-type             :string
	:layout-type            :horizontal
	:orientation            :horizontal
	:show-endboxes          nil
	:show-range             nil
	:show-value             nil
	:min-value              0
	:max-value              100
	:min-value-string       ""
	:max-value-string       ""
	:min-tick-string        ""
	:max-tick-string        ""
	:initial-value          0
	:initial-state          :active
	:notify-handler         RecordGainSlider
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (mainWindow recordGain)
		:when                   (Notify )
		:to                     (mainWindow recordGain)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (RecordGainSlider)
		)
	)
)
(
	:type                   :canvas-pane
	:name                   vuMeterCanvas
	:owner                  mainWindow
	:help                   ""
	:x                      0
	:y                      115
	:width                  147
	:height                 32
	:background-color       "BG1"
	:foreground-color       ""
	:initial-state          :visible
	:draggable              nil
	:droppable              nil
	:default-drop-site      nil
	:menu                   nil
	:horizontal-scrollbar   nil
	:scrollable-width       147
	:vertical-scrollbar     nil
	:scrollable-height      32
	:repaint-proc           VUMeterCanvasRepaintHandler
	:event-handler          nil
	:drawing-model          :xview
	:user-data              ()
	:actions                (
		(
		:from                   (mainWindow vuMeterCanvas)
		:when                   (Repaint )
		:to                     (mainWindow vuMeterCanvas)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (VUMeterCanvasRepaintHandler)
		)
	)
)
(
	:type                   :control-area
	:name                   selectionInfoControlPanel
	:owner                  mainWindow
	:help                   ""
	:x                      147
	:y                      115
	:width                  453
	:height                 32
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   selectionDurationLabelMessage
	:owner                  selectionInfoControlPanel
	:help                   ""
	:x                      8
	:y                      8
	:width                  134
	:height                 13
	:foreground-color       "black"
	:label                  "Selection Duration :"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   selectionDurationMessage
	:owner                  selectionInfoControlPanel
	:help                   ""
	:x                      152
	:y                      8
	:width                  0
	:height                 0
	:foreground-color       "black"
	:label                  ""
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   selectionSizeLabelMessage
	:owner                  selectionInfoControlPanel
	:help                   ""
	:x                      312
	:y                      8
	:width                  35
	:height                 13
	:foreground-color       "black"
	:label                  "Size :"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   selectionSizeMessage
	:owner                  selectionInfoControlPanel
	:help                   ""
	:x                      356
	:y                      8
	:width                  0
	:height                 0
	:foreground-color       "black"
	:label                  ""
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :canvas-pane
	:name                   waveCanvas
	:owner                  mainWindow
	:help                   ""
	:x                      0
	:y                      147
	:width                  596
	:height                 200
	:background-color       "BG3"
	:foreground-color       "White"
	:initial-state          :visible
	:draggable              nil
	:droppable              nil
	:default-drop-site      nil
	:menu                   nil
	:horizontal-scrollbar   nil
	:scrollable-width       596
	:vertical-scrollbar     nil
	:scrollable-height      200
	:repaint-proc           WaveCanvasRepaintHandler
	:event-handler          WaveCanvasEventHandler
	:drawing-model          :xwindows
	:user-data              ()
	:actions                (
		(
		:from                   (mainWindow waveCanvas)
		:when                   (Repaint )
		:to                     (mainWindow waveCanvas)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (WaveCanvasRepaintHandler)
		)
		(
		:from                   (mainWindow waveCanvas)
		:when                   (AnyEvent )
		:to                     (mainWindow waveCanvas)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (WaveCanvasEventHandler)
		)
	)
)
(
	:type                   :canvas-pane
	:name                   scaleCanvas
	:owner                  mainWindow
	:help                   ""
	:x                      0
	:y                      347
	:width                  596
	:height                 64
	:background-color       "Highlight"
	:foreground-color       ""
	:initial-state          :visible
	:draggable              nil
	:droppable              nil
	:default-drop-site      nil
	:menu                   nil
	:horizontal-scrollbar   nil
	:scrollable-width       596
	:vertical-scrollbar     nil
	:scrollable-height      64
	:repaint-proc           ScaleCanvasRepaintHandler
	:event-handler          nil
	:drawing-model          :xwindows
	:user-data              ()
	:actions                (
		(
		:from                   (mainWindow scaleCanvas)
		:when                   (Repaint )
		:to                     (mainWindow scaleCanvas)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ScaleCanvasRepaintHandler)
		)
	)
)
(
	:type                   :control-area
	:name                   zoomControlPanel
	:owner                  mainWindow
	:help                   ""
	:x                      0
	:y                      410
	:width                  597
	:height                 50
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   canvasRewind2Button
	:owner                  zoomControlPanel
	:help                   ""
	:x                      8
	:y                      8
	:width                  42
	:height                 26
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "icons/rewind2.icon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         CanvasRewind2Handler
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (mainWindow canvasRewind2Button)
		:when                   (Notify )
		:to                     (mainWindow canvasRewind2Button)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (CanvasRewind2Handler)
		)
	)
)
(
	:type                   :button
	:name                   canvasRewind1Button
	:owner                  zoomControlPanel
	:help                   ""
	:x                      64
	:y                      8
	:width                  42
	:height                 26
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "icons/rewind1.icon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         CanvasRewind1Handler
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (mainWindow canvasRewind1Button)
		:when                   (Notify )
		:to                     (mainWindow canvasRewind1Button)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (CanvasRewind1Handler)
		)
	)
)
(
	:type                   :button
	:name                   canvasFastForward1Button
	:owner                  zoomControlPanel
	:help                   ""
	:x                      136
	:y                      8
	:width                  42
	:height                 26
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "icons/fastfrwd1.icon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         CanvasFastForward1Handler
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (mainWindow canvasFastForward1Button)
		:when                   (Notify )
		:to                     (mainWindow canvasFastForward1Button)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (CanvasFastForward1Handler)
		)
	)
)
(
	:type                   :button
	:name                   canvasFastForward2Button
	:owner                  zoomControlPanel
	:help                   ""
	:x                      192
	:y                      8
	:width                  42
	:height                 26
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "icons/fastfrwd2.icon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         CanvasFastForward2Handler
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (mainWindow canvasFastForward2Button)
		:when                   (Notify )
		:to                     (mainWindow canvasFastForward2Button)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (CanvasFastForward2Handler)
		)
	)
)
(
	:type                   :text-field
	:name                   zoomLevelTextField
	:owner                  zoomControlPanel
	:help                   ""
	:x                      340
	:y                      8
	:width                  100
	:height                 15
	:value-x                392
	:value-y                8
	:value-length           6
	:stored-length          80
	:rows                   3
	:foreground-color       "black"
	:text-type              :alphanumeric
	:label                  "Zoom :"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         ZoomLevelTextFieldHandler
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (mainWindow zoomLevelTextField)
		:when                   (Notify )
		:to                     (mainWindow zoomLevelTextField)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ZoomLevelTextFieldHandler)
		)
	)
)
(
	:type                   :message
	:name                   zoomTimesMessage
	:owner                  zoomControlPanel
	:help                   ""
	:x                      460
	:y                      8
	:width                  49
	:height                 13
	:foreground-color       "black"
	:label                  "time(s)"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :slider
	:name                   zoomSlider
	:owner                  zoomControlPanel
	:help                   ""
	:x                      260
	:y                      28
	:width                  317
	:height                 20
	:value-x                260
	:value-y                28
	:slider-width           280
	:ticks                  0
	:foreground-color       "black"
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:orientation            :horizontal
	:show-endboxes          t
	:show-range             nil
	:show-value             nil
	:min-value              100
	:max-value              500
	:min-value-string       ""
	:max-value-string       ""
	:min-tick-string        ""
	:max-tick-string        ""
	:initial-value          0
	:initial-state          :active
	:notify-handler         ZoomSliderHandler
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (mainWindow zoomSlider)
		:when                   (Notify )
		:to                     (mainWindow zoomSlider)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ZoomSliderHandler)
		)
	)
)
(
	:type                   :popup-window
	:name                   globalWaveCanvasPopUp
	:owner                  mainWindow
	:width                  707
	:height                 236
	:background-color       "light gray"
	:foreground-color       ""
	:label                  "Global Wave Canvas"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            t
	:resizable              t
	:pinned                 nil
	:done-handler           nil
	:event-handler          GlobalWaveCanvasEventHandler
	:user-data              ()
	:actions                (
		(
		:from                   (globalWaveCanvasPopUp)
		:when                   (AnyEvent )
		:to                     (globalWaveCanvasPopUp)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (GlobalWaveCanvasEventHandler)
		)
	)
)
(
	:type                   :canvas-pane
	:name                   globalWaveCanvas
	:owner                  globalWaveCanvasPopUp
	:help                   ""
	:x                      17
	:y                      0
	:width                  669
	:height                 194
	:background-color       "BG3"
	:foreground-color       "White"
	:initial-state          :visible
	:draggable              nil
	:droppable              nil
	:default-drop-site      nil
	:menu                   nil
	:horizontal-scrollbar   nil
	:scrollable-width       669
	:vertical-scrollbar     nil
	:scrollable-height      194
	:repaint-proc           GlobalWaveCanvasRepaintHandler
	:event-handler          GlobalWaveCanvasEventHandler
	:drawing-model          :xwindows
	:user-data              ()
	:actions                (
		(
		:from                   (globalWaveCanvasPopUp globalWaveCanvas)
		:when                   (Repaint )
		:to                     (globalWaveCanvasPopUp globalWaveCanvas)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (GlobalWaveCanvasRepaintHandler)
		)
		(
		:from                   (globalWaveCanvasPopUp globalWaveCanvas)
		:when                   (AnyEvent )
		:to                     (globalWaveCanvasPopUp globalWaveCanvas)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (GlobalWaveCanvasEventHandler)
		)
	)
)
(
	:type                   :control-area
	:name                   globalWaveControlPanel
	:owner                  globalWaveCanvasPopUp
	:help                   ""
	:x                      17
	:y                      194
	:width                  623
	:height                 42
	:background-color       "light gray"
	:foreground-color       ""
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   globalWaveCanvasDoneButton
	:owner                  globalWaveControlPanel
	:help                   ""
	:x                      328
	:y                      8
	:width                  49
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Done"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          GlobalWaveCanvasDoneHandler
	:user-data              ()
	:actions                (
		(
		:from                   (globalWaveCanvasPopUp globalWaveCanvasDoneButton)
		:when                   (AnyEvent )
		:to                     (globalWaveCanvasPopUp globalWaveCanvasDoneButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (GlobalWaveCanvasDoneHandler)
		)
	)
)
(
	:type                   :popup-window
	:name                   editListPanelPopUp
	:owner                  mainWindow
	:width                  466
	:height                 460
	:background-color       "light gray"
	:foreground-color       ""
	:label                  "Edit List Panel"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            nil
	:resizable              nil
	:pinned                 nil
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   editListUpperControlPanel
	:owner                  editListPanelPopUp
	:help                   ""
	:x                      0
	:y                      0
	:width                  466
	:height                 261
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   editListFileButton
	:owner                  editListUpperControlPanel
	:help                   ""
	:x                      16
	:y                      12
	:width                  94
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Document"
	:label-type             :string
	:initial-state          :active
	:menu                   editListDocumentMenu
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   totalNumberOfEditsLabelMessage
	:owner                  editListUpperControlPanel
	:help                   ""
	:x                      248
	:y                      12
	:width                  118
	:height                 13
	:foreground-color       "black"
	:label                  "Number of Edits :"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   totalNumberOfEditsMessage
	:owner                  editListUpperControlPanel
	:help                   ""
	:x                      372
	:y                      12
	:width                  0
	:height                 0
	:foreground-color       "black"
	:label                  ""
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   editListMessage
	:owner                  editListUpperControlPanel
	:help                   ""
	:x                      120
	:y                      52
	:width                  0
	:height                 0
	:foreground-color       "black"
	:label                  ""
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   editListScrollListHeaderMessagePart1
	:owner                  editListUpperControlPanel
	:help                   ""
	:x                      20
	:y                      60
	:width                  188
	:height                 13
	:foreground-color       "black"
	:label                  "Edit #               Label               "
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   editListScrollListHeaderMessagePart2
	:owner                  editListUpperControlPanel
	:help                   ""
	:x                      280
	:y                      60
	:width                  165
	:height                 13
	:foreground-color       "black"
	:label                  "Duration (min : sec . 10ths)"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :scrolling-list
	:name                   editListScrollList
	:owner                  editListUpperControlPanel
	:help                   ""
	:x                      16
	:y                      80
	:width                  420
	:height                 164
	:value-x                16
	:value-y                80
	:rows                   8
	:foreground-color       ""
	:label                  ""
	:title                  ""
	:label-type             :string
	:layout-type            :horizontal
	:read-only              t
	:multiple-selections    nil
	:selection-required     nil
	:initial-state          :active
	:droppable              nil
	:default-drop-site      nil
	:menu                   nil
	:notify-handler         DumpEntry
	:event-handler          nil
	:initial-list-values    ()
	:initial-list-glyphs    ()
	:initial-selections     ()
	:user-data              ()
	:actions                (
		(
		:from                   (editListPanelPopUp editListScrollList)
		:when                   (Notify )
		:to                     (editListPanelPopUp editListScrollList)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (DumpEntry)
		)
	)
)
(
	:type                   :control-area
	:name                   editListLowerControlPanel
	:owner                  editListPanelPopUp
	:help                   ""
	:x                      0
	:y                      260
	:width                  466
	:height                 200
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   currentEditLabelMessage
	:owner                  editListLowerControlPanel
	:help                   ""
	:x                      144
	:y                      8
	:width                  134
	:height                 13
	:foreground-color       "black"
	:label                  "Current Selection :  "
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   currentEditMessage
	:owner                  editListLowerControlPanel
	:help                   ""
	:x                      284
	:y                      8
	:width                  0
	:height                 0
	:foreground-color       "black"
	:label                  ""
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   soundFileTextField
	:owner                  editListLowerControlPanel
	:help                   ""
	:x                      10
	:y                      32
	:width                  446
	:height                 15
	:value-x                96
	:value-y                32
	:value-length           45
	:stored-length          1024
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "Sound File :"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   labelTextField
	:owner                  editListLowerControlPanel
	:help                   ""
	:x                      10
	:y                      59
	:width                  445
	:height                 15
	:value-x                95
	:value-y                59
	:value-length           45
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "Label         :"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         LabelTextFieldHandler
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (editListPanelPopUp labelTextField)
		:when                   (Notify )
		:to                     (editListPanelPopUp labelTextField)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (LabelTextFieldHandler)
		)
	)
)
(
	:type                   :message
	:name                   startingTimeMessage
	:owner                  editListLowerControlPanel
	:help                   ""
	:x                      9
	:y                      87
	:width                  100
	:height                 13
	:foreground-color       "black"
	:label                  "Starting Time :"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   startingTimeMinuteTextField
	:owner                  editListLowerControlPanel
	:help                   ""
	:x                      125
	:y                      87
	:width                  48
	:height                 15
	:value-x                125
	:value-y                87
	:value-length           6
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   startingTimeMinuteMessage
	:owner                  editListLowerControlPanel
	:help                   ""
	:x                      189
	:y                      87
	:width                  15
	:height                 13
	:foreground-color       "black"
	:label                  "m."
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   startingTimeSecondTextField
	:owner                  editListLowerControlPanel
	:help                   ""
	:x                      220
	:y                      87
	:width                  48
	:height                 15
	:value-x                220
	:value-y                87
	:value-length           6
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   startingTimeSecondMessage
	:owner                  editListLowerControlPanel
	:help                   ""
	:x                      285
	:y                      87
	:width                  9
	:height                 13
	:foreground-color       "black"
	:label                  "s."
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   endingTimeMessage
	:owner                  editListLowerControlPanel
	:help                   ""
	:x                      8
	:y                      107
	:width                  101
	:height                 13
	:foreground-color       "black"
	:label                  "Ending   Time :"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   endingTimeMinuteTextField
	:owner                  editListLowerControlPanel
	:help                   ""
	:x                      125
	:y                      107
	:width                  48
	:height                 15
	:value-x                125
	:value-y                107
	:value-length           6
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   endingTimeMinuteMessage
	:owner                  editListLowerControlPanel
	:help                   ""
	:x                      189
	:y                      107
	:width                  15
	:height                 13
	:foreground-color       "black"
	:label                  "m."
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   endingTimeSecondTextField
	:owner                  editListLowerControlPanel
	:help                   ""
	:x                      220
	:y                      107
	:width                  48
	:height                 15
	:value-x                220
	:value-y                107
	:value-length           6
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   endingTimeSecondMessage
	:owner                  editListLowerControlPanel
	:help                   ""
	:x                      285
	:y                      107
	:width                  9
	:height                 13
	:foreground-color       "black"
	:label                  "s."
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :slider
	:name                   editListVolumeSlider
	:owner                  editListLowerControlPanel
	:help                   ""
	:x                      8
	:y                      128
	:width                  273
	:height                 26
	:value-x                60
	:value-y                128
	:slider-width           200
	:ticks                  10
	:foreground-color       "black"
	:label                  "Volume"
	:label-type             :string
	:layout-type            :horizontal
	:orientation            :horizontal
	:show-endboxes          nil
	:show-range             nil
	:show-value             nil
	:min-value              0
	:max-value              100
	:min-value-string       ""
	:max-value-string       ""
	:min-tick-string        ""
	:max-tick-string        ""
	:initial-value          0
	:initial-state          :active
	:notify-handler         PlayGainSlider
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (editListPanelPopUp editListVolumeSlider)
		:when                   (Notify )
		:to                     (editListPanelPopUp editListVolumeSlider)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (PlayGainSlider)
		)
	)
)
(
	:type                   :button
	:name                   previewEditButton
	:owner                  editListLowerControlPanel
	:help                   ""
	:x                      341
	:y                      128
	:width                  57
	:height                 19
	:constant-width         t
	:button-type            :normal
	:foreground-color       ""
	:label                  "Preview"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         PreviewEditButtonHandler
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (editListPanelPopUp previewEditButton)
		:when                   (Notify )
		:to                     (editListPanelPopUp previewEditButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (PreviewEditButtonHandler)
		)
	)
)
(
	:type                   :button
	:name                   addButton
	:owner                  editListLowerControlPanel
	:help                   ""
	:x                      11
	:y                      164
	:width                  57
	:height                 19
	:constant-width         t
	:button-type            :normal
	:foreground-color       ""
	:label                  "    Add"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         AddButtonHandler
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (editListPanelPopUp addButton)
		:when                   (Notify )
		:to                     (editListPanelPopUp addButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (AddButtonHandler)
		)
	)
)
(
	:type                   :button
	:name                   modifyButton
	:owner                  editListLowerControlPanel
	:help                   ""
	:x                      121
	:y                      164
	:width                  57
	:height                 19
	:constant-width         t
	:button-type            :normal
	:foreground-color       ""
	:label                  "  Modify"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         ModifyButtonHandler
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (editListPanelPopUp modifyButton)
		:when                   (Notify )
		:to                     (editListPanelPopUp modifyButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ModifyButtonHandler)
		)
	)
)
(
	:type                   :button
	:name                   deleteButton
	:owner                  editListLowerControlPanel
	:help                   ""
	:x                      231
	:y                      164
	:width                  57
	:height                 19
	:constant-width         t
	:button-type            :normal
	:foreground-color       ""
	:label                  "  Delete"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         DeleteButtonHandler
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (editListPanelPopUp deleteButton)
		:when                   (Notify )
		:to                     (editListPanelPopUp deleteButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (DeleteButtonHandler)
		)
	)
)
(
	:type                   :button
	:name                   deleteAllButton
	:owner                  editListLowerControlPanel
	:help                   ""
	:x                      341
	:y                      164
	:width                  70
	:height                 19
	:constant-width         t
	:button-type            :normal
	:foreground-color       ""
	:label                  "Delete All"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         DeleteAllButtonHandler
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (editListPanelPopUp deleteAllButton)
		:when                   (Notify )
		:to                     (editListPanelPopUp deleteAllButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (DeleteAllButtonHandler)
		)
	)
)
(
	:type                   :popup-window
	:name                   infoPopUp
	:owner                  mainWindow
	:width                  475
	:height                 270
	:background-color       "light gray"
	:foreground-color       ""
	:label                  "DTR Info"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            t
	:resizable              t
	:pinned                 nil
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   infoControlPanel
	:owner                  infoPopUp
	:help                   ""
	:x                      0
	:y                      0
	:width                  475
	:height                 270
	:background-color       "BG1"
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   appNameMessage
	:owner                  infoControlPanel
	:help                   ""
	:x                      164
	:y                      16
	:width                  148
	:height                 13
	:foreground-color       "black"
	:label                  "Digital Tape Recorder"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   appVersionMessage
	:owner                  infoControlPanel
	:help                   ""
	:x                      204
	:y                      36
	:width                  76
	:height                 13
	:foreground-color       "black"
	:label                  "Version 2.01"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   appDescriptionMessage
	:owner                  infoControlPanel
	:help                   ""
	:x                      136
	:y                      65
	:width                  204
	:height                 13
	:foreground-color       "black"
	:label                  "An audio application for use with"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   appDescription2Message
	:owner                  infoControlPanel
	:help                   ""
	:x                      92
	:y                      85
	:width                  293
	:height                 13
	:foreground-color       "black"
	:label                  "the MAEstro Multimedia Authoring Environment"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   developerMessage
	:owner                  infoControlPanel
	:help                   ""
	:x                      152
	:y                      112
	:width                  143
	:height                 13
	:foreground-color       "black"
	:label                  "Developed by Derek Lai"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   developerMessage1
	:owner                  infoControlPanel
	:help                   ""
	:x                      136
	:y                      132
	:width                  202
	:height                 13
	:foreground-color       "black"
	:label                  "Modifications by George Drapeau"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   copyrightMessage
	:owner                  infoControlPanel
	:help                   ""
	:x                      8
	:y                      156
	:width                  457
	:height                 13
	:foreground-color       "black"
	:label                  "Copyright (C) 1990, 1991, 1992 Libraries and Information Resources (L&IR)"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   copyright2Message
	:owner                  infoControlPanel
	:help                   ""
	:x                      176
	:y                      176
	:width                  118
	:height                 13
	:foreground-color       "black"
	:label                  "Stanford University"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   copyright3Message
	:owner                  infoControlPanel
	:help                   ""
	:x                      176
	:y                      196
	:width                  119
	:height                 13
	:foreground-color       "black"
	:label                  "Stanford, California"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   moreinfoMessage
	:owner                  infoControlPanel
	:help                   ""
	:x                      84
	:y                      232
	:width                  307
	:height                 13
	:foreground-color       "black"
	:label                  "for more info, contact maestro@sioux.stanford.edu"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
)
