/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/DTR/RCS/buffer.c,v 1.0 92/01/06 17:39:19 drapeau Exp Locker: derek $ */
/* $Log:	buffer.c,v $
 * Revision 1.0  92/01/06  17:39:19  drapeau
 * Collapsed ReadSoundFile() and ReadSoundFileIntoBuffer() into one
 * function, to eliminate redundant code.
 * Also, made a number of cosmetic changes to make code easier to read
 * and to conform to programming specifications.
 * 
 * Revision 0.26  91/09/30  16:12:09  derek
 * DTR will now disconnect from the Port Manager when it quits.  Also,
 * a number of printf statements are removed.
 * 
 * Revision 0.25  91/09/18  22:47:11  derek
 * The following things are done:
 * 1.	The Makefile is changed corresponding to the changes in collab/.
 * 2.	Copyright messages included.
 * 3.	Some minor bugs fixed.
 * 
 * Revision 0.24  91/08/27  18:05:34  derek
 * The SizeToFit bug is fixed.
 * 
 * Revision 0.23  91/08/21  17:46:30  derek
 * The big canvas "mis-placed" bug is fixed.
 * 
 * Revision 0.22  91/08/21  11:34:05  derek
 * The following changes are made:
 * 1.	Now the duration and size of the recorded sound will be displayed
 * 	during recording.
 * 2.	I have changed GetSelection() corresponding to the request of Tek joo
 * 3.	Info Panel is added to the application.
 * 4.	Fixed SizeToFitHandler() so that when no file or buffer is currently
 * 	loaded, it would not do anything (except giving a warning
 * 	notice_prompt).
 * 5.	Inplemented the `Close' Menu option in the document menu.
 * 6.	Fixed the bug in which after ClearAll and I press PreviewEdit,
 * 	the edit wont be played.
 * 7.	I have made the changes corresponding to the change in OpenPanel's
 * 	name.  (from OpenPanel to Browse).
 * 8.	Incorporated BrowseCheck to check command line arg.
 * 9.	Changed most EditingStatusMessages to NoticePrompts.
 * 10.	SoundFileSaveAsPopUp and EditListSaveAsPopUp are removed 
 * 	from the application.
 * 
 * Revision 0.21  91/08/08  21:44:10  derek
 * Fixed a number of bugs.
 * 
 * Revision 0.20  91/08/07  16:23:50  derek
 * The Edit list part of DTR is done.  OpenPanel is also incorporated.
 * 
 * Revision 0.19  91/08/06  12:41:03  derek
 * Edit list panel is done.  Still need to link it to the network code.
 * 
 * Revision 0.18  91/07/30  11:45:14  derek
 * I have fixed the tmp file conflict bug.
 * 
 * Revision 0.17  91/07/26  13:17:40  derek
 * Some saving bugs fixed.
 * 
 * Revision 0.16  91/07/24  12:51:45  derek
 * Disk editing is done.  Now the application can record sound infinitely,
 * as long as there is disk space available.  Command line args are also
 * supported.
 * 
 * Revision 0.15  91/07/23  21:21:23  derek
 * This version is not ready for release.  Disk space editing is half-done:
 * the application can play an infinite sound and the canvases can handle
 * infinite sound files.  The app is pretty bug free too, I think.  The
 * weakness is that it cannot record sound infinitely.  
 * 
 * Revision 0.14  91/06/26  15:54:54  derek
 * I have reformatted the code to conform coding specs.
 * 
 * Revision 0.13  91/06/25  11:37:41  derek
 * I have added the new protocol items.
 * 
 * Revision 0.12  91/06/20  19:55:12  derek
 * The network part should be working.  Also fixed numerous minor parts
 * involving the canvas and the display.
 * 
 * Revision 0.10  1991/04/25  01:44:21  derek
 * This version is checked in on 4/24/91
 * */
static char rcsid[] = "$Header: /Source/Media/collab/DTR/RCS/buffer.c,v 1.0 92/01/06 17:39:19 drapeau Exp Locker: derek $";

#include "dtr.h"
#include "dtr_ui.h"


/* 
 *  Initialize the buffer.
 */
void
  InitBuffer()
{
  EVENT("Init_Buffer");
  
  if (Buffer.data != NULL)
    (void) free((char *)Buffer.data);
  Buffer.data = NULL;
  Buffer.alloc_size = 0;
  Buffer.hdr = Device_phdr;
  Buffer.hdr.data_size = 0;
  SoundBufferReady = FALSE;
  FileReady = FALSE;
}


/*
 *  Allocate a buffer to hold data.
 */
AllocBuffer(size)
     unsigned	size;
{
  EVENT("Alloc_Buffer");
  
  if (Buffer.data != NULL)
    (void) free((char *)Buffer.data);
  
  do 
  {								    /*  Allocate a buffer, shrink if request is too...  */
    Buffer.data = (unsigned char *)malloc(size);		    /*  ...big.                                         */
  } 
  while ((Buffer.data == NULL) && (size = size - (size / 8)));
  
  Buffer.alloc_size = size;
}


/*
 *  Set up a new sound buffer and display it.
 */
void
  FileUpdate()
{
  EVENT("File_Update");
  
  Buffer.play.io_position = Buffer.play.start;
  PlayUpdateCursor();
}


BOOL ReadSoundFile(BOOL intoBuffer)
{
  unsigned				size;
  int					valid;
  struct stat				st;
  extern BOOL				CanUndo;
  extern dtr_mainWindow_objects*	dtr_mainWindow;
  extern Scrollbar			WaveCanvasScrollbar;
  
  if (intoBuffer == TRUE)
    EVENT("Read_Sound_File_Into_Buffer");
  else
    EVENT("Read_Sound_File");
  if (NullFileName(Buffer.filename) && (SoundBufferReady == TRUE)   /*  Tackle the case when the some sound is...       */
      && NullFileName(currentSoundFile))			    /*  ...recorded and it has no name yet, but we...   */
  {								    /*  ...still want to play it.                       */
    FileReady = FALSE;
    return(TRUE);
  }
  if (strcmp(currentSoundFile, Buffer.filename) == 0)
  {
    if (intoBuffer == FALSE)
    {
      if ((WaveEditMode == FALSE) && (strcmp(currentSoundFile, "Untitled") == 0))
	return(FALSE);
    }
    if (SameSoundFile)
      return(TRUE);
    if (SoundBufferReady == FALSE) 
    {
      if (!NullFileName(Buffer.filename))
      {
	AlertByNoticePrompt(dtr_mainWindow->menuControlPanel,
			    "Error:   File is not valid.");
	return(FALSE);
      }
    }
  }
  else  
  {
    strcpy(Buffer.filename, currentSoundFile);
    SameSoundFile = FALSE;
  }
  if (intoBuffer == FALSE)
  {
    ResetWaveCanvas();
    ResetGlobalWaveCanvas();
  }
  xv_set(WaveCanvasScrollbar, SCROLLBAR_VIEW_START, 0, NULL);	    /*  Reset the canvas scrollbar.                     */
  if (xv_get(dtr_mainWindow->zoomSlider, PANEL_VALUE) != 10)	    /*  Reset the zoom slider.                          */
    xv_set(dtr_mainWindow->zoomSlider, PANEL_VALUE, 10, NULL);
  Zoom = 1.0;
  
  oldLeftFloatMarker = oldRightFloatMarker = -1.0;		    /*  Reset Various Selection parameters.             */
  WaveCanvasRightMarkerSet = FALSE;
  leftButtonHoldPoint = NOTREADY;
  
  oldLeftFloatGbWaveMarker = oldRightFloatGbWaveMarker = -1.0;	    /*  Reset Various Selection Parameters for global.. */
  GlobalWaveCanvasRightMarkerSet = FALSE;			    /*  ...wave canvas.                                 */
  GbWaveLeftButtonHoldPoint = NOTREADY;
  ClearMessageDisplay();
  if (NullFileName(Buffer.filename))				    /* If there is no file to load, return without doing anything */
    return(FALSE);
  CanUndo = FALSE;						    /*  At this point, there is no way of undo-ing any  */
								    /*  ...edited wave.                                 */
  if (((soundfd = open(Buffer.filename, O_RDONLY)) < 0) ||	    /* Try to open the requested file */
      (fstat(soundfd, &st) < 0))
  {
    sprintf(msg, "Error:   File \"%s\" not found.", 
	    Buffer.filename);
    AlertByNoticePrompt(dtr_mainWindow->menuControlPanel, msg);
    strcpy(Buffer.filename, "");
    FileReady = FALSE;
    return (FALSE);
  }
  valid = (AUDIO_SUCCESS==audio_read_filehdr(soundfd,		    /*  A soundfile consists of 2 parts: the header...  */
					     &Buffer.hdr,	    /*  ...and the data.  We first check whether the... */
					     Buffer.info,	    /*  ...soundfile has a header.  If so, read it...   */
					     sizeof(Buffer.info))); /*  ...in and decode it.                            */
  if (valid) 
  {
    if (Buffer.hdr.data_size == AUDIO_UNKNOWN_SIZE)
    {
      Buffer.hdr.data_size =					    /* Calculate the data size, if not already known.   */
	st.st_size - lseek(soundfd, 0L, L_INCR);
    }
  } 
  else								    /*  If no header, read the file raw and assume...   */
  {								    /*  ...compatibility.                               */
    Buffer.hdr  = Device_phdr;					    /*  Use device configuration.                       */
    (void) lseek(soundfd, 0L, L_SET);				    /*  Rewind file.                                    */
    Buffer.hdr.data_size = st.st_size - lseek(soundfd, 0L, L_INCR);
    Buffer.info[0] = '\0';
  }
  Buffer.hdr_size = lseek(soundfd, 0L, L_INCR);			    /*  Find out the size of the audio header.          */
  if (ActiveFlag & PLAY)					    /*  If active output, set draining flag so that...  */
    Buffer.draining = TRUE;					    /*  ...PlayService() won't try to access the...     */
								    /*  ...obsolete buffer.  FileUpdate() will turn...  */
								    /*  ...off the draining flag if output is still...  */
								    /*  ...active.                                      */
  size = Buffer.hdr.data_size;
  AllocBuffer(size);						    /*  Release the old buffer and allocate a new...    */
								    /*  ...one to hold the data.                        */
  if (intoBuffer == TRUE)
  {
    Buffer.hdr.data_size = read(soundfd, (char *)Buffer.data,
				(int)Buffer.alloc_size);		
  }
  (void) close(soundfd);
  Buffer.display.start = Buffer.play.start = 0;
  Buffer.display.end = Buffer.play.end = Buffer.hdr.data_size - 1;
  FileUpdate();
  if (size != Buffer.hdr.data_size) 
  {								    /*  size = size of soundfile data we expect.        */
    sprintf(msg,						    /*  Buffer.hdr.data_size = the actual amount we...  */
	    " %.2f seconds of data truncated from '%s'.",	    /*  ...can load.  If we could not allocate or...    */
	    audio_bytes_to_secs(&Buffer.hdr,			    /*  ...load the file, show msg.                     */
				(size - Buffer.hdr.data_size)), 
	    Buffer.filename);
    AlertByNoticePrompt(dtr_mainWindow->menuControlPanel, msg);
  }
  if (!valid) 
  {
    sprintf(msg, "Error:   '%s' is not a valid audio file",	    /*  If file is not an audio file, display a...      */
	    Buffer.filename);					    /*  ...warning.                                     */
    AlertByNoticePrompt(dtr_mainWindow->menuControlPanel, msg);
    FileReady = FALSE;
    return(FALSE);
  } else if ((Buffer.hdr.encoding != AUDIO_ENCODING_ULAW) ||
	     (Buffer.hdr.bytes_per_unit != 1) ||
	     (Buffer.hdr.samples_per_unit != 1) ||
	     (Buffer.hdr.channels != 1))
  {
    sprintf(msg, 
	    "'%s' audio encoding cannot be played or displayed properly",
	    Buffer.filename);
    AlertByNoticePrompt(dtr_mainWindow->menuControlPanel, msg);
  }
  UpdateMessageDisplay();
  Zoom = 1.0;
  UpdateZoomLevelDisplay();
  oldLeftFloatMarker = 0.0;					    /*  Reset markers.                                  */
  oldRightFloatMarker = (double) Buffer.hdr.data_size - 1.0;
  WaveCanvasRightMarkerSet = FALSE;
  oldLeftFloatGbWaveMarker = 0.0;
  oldRightFloatGbWaveMarker = (double) Buffer.hdr.data_size - 1.0;
  GlobalWaveCanvasRightMarkerSet = FALSE;
  if (intoBuffer == TRUE)
  {
    FileReady = FALSE;
    SoundBufferReady = TRUE;
  }
  else
  {
    FileReady = TRUE;
    currentSelectionReadyToPlay = FALSE;
    BufferSaved = TRUE;
  }
  FrameStartingSecond = 0.0;
  return(TRUE);
}								    /* end function ReadSoundFile */



unsigned char
  GetFileData(pos)
int pos;
{
  static  unsigned char  posData;
  extern      dtr_mainWindow_objects  *dtr_mainWindow;

  soundfd = open(Buffer.filename, O_RDONLY);

  lseek(soundfd, Buffer.hdr_size + pos, L_SET);
  read(soundfd, &posData, 1);
  close(soundfd);
  
  return(posData);
}


BOOL
  IsTmpSoundFile(filename)
char  *filename;
{
  return(!strcmp(filename, SoundFileInTmp));
}
