/*****************************************************************************
*   "Irit" - the 3d polygonal solid modeller.				     *
*									     *
* Written by:  Gershon Elber				Ver 1.0, Jan. 1992   *
******************************************************************************
* Global definitions of	Graphics interface.			             *
*****************************************************************************/

#ifndef	IRIT_GRAP_H	/* Define only once */
#define	IRIT_GRAP_H

#include "irit_sm.h"
#include "genmat.h"
#include "iritprsr.h"
#include "animate.h"

#define IG_IRIT_BLACK		0
#define IG_IRIT_BLUE		1
#define IG_IRIT_GREEN		2
#define IG_IRIT_CYAN		3
#define IG_IRIT_RED		4
#define IG_IRIT_MAGENTA		5
#define IG_IRIT_BROWN		6
#define IG_IRIT_LIGHTGREY	7
#define IG_IRIT_DARKGRAY	8
#define IG_IRIT_LIGHTBLUE	9
#define IG_IRIT_LIGHTGREEN	10
#define IG_IRIT_LIGHTCYAN	11
#define IG_IRIT_LIGHTRED	12
#define IG_IRIT_LIGHTMAGENTA	13
#define IG_IRIT_YELLOW		14
#define IG_IRIT_WHITE		15

#define IG_MAX_COLOR		15

#define IG_SOLID_LINE		1
#define IG_DOTTED_LINE		2

#define IG_POINT_WIDTH		0.02

/* The current NormalLength is divided by scalar to form real normal length: */
#define IG_NORMAL_DEFAULT_LENGTH	100
#define IG_NORMAL_SCALER_LENGTH		1000

/* The current point cross length is divided by scalar to form real length:  */
#define IG_POINT_DEFAULT_LENGTH	20
#define IG_POINT_SCALER_LENGTH	1000

#define IG_DEFAULT_COLOR	    1  /* For objects with no color defined. */

#define IG_VIEW_PERSPECTIVE		1		      /* View modes. */
#define IG_VIEW_ORTHOGRAPHIC		2
#define IG_DEFAULT_PERSPECTIVE_Z	-5.0	   /* Default Z focal point. */

#define IG_TRANS_SCREEN	1     /* Screen, Object coords. transformation mode. */
#define IG_TRANS_OBJECT	2

#define IG_DEFAULT_NUM_OF_ISOLINES	10
#define IG_DEFAULT_SAMPLES_PER_CURVE	64
#define IG_DEFAULT_POLYGON_FINENESS	20

#define IG_DEFAULT_IRIT_MAT		"irit.mat"

#define IG_IS_DRAG_EVENT(Event)	(Event == IG_EVENT_PERS_ORTHO_Z || \
				 Event == IG_EVENT_ROTATE_X || \
				 Event == IG_EVENT_ROTATE_Y || \
				 Event == IG_EVENT_ROTATE_Z || \
				 Event == IG_EVENT_TRANSLATE_X || \
				 Event == IG_EVENT_TRANSLATE_Y || \
				 Event == IG_EVENT_TRANSLATE_Z || \
				 Event == IG_EVENT_SCALE || \
				 Event == IG_EVENT_NEAR_CLIP || \
				 Event == IG_EVENT_FAR_CLIP)

typedef enum {
    IG_EVENT_NONE = 2000,
    IG_EVENT_QUIT,
    IG_EVENT_SCR_OBJ_TGL,
    IG_EVENT_PERS_ORTHO_TGL,
    IG_EVENT_PERS_ORTHO_Z,
    IG_EVENT_ROTATE_X,
    IG_EVENT_ROTATE_Y,
    IG_EVENT_ROTATE_Z,
    IG_EVENT_TRANSLATE_X,
    IG_EVENT_TRANSLATE_Y,
    IG_EVENT_TRANSLATE_Z,
    IG_EVENT_SCALE,
    IG_EVENT_NEAR_CLIP,
    IG_EVENT_FAR_CLIP,
    IG_EVENT_DEPTH_CUE,
    IG_EVENT_DBL_BUFFER,
    IG_EVENT_SAVE_MATRIX,
    IG_EVENT_PUSH_MATRIX,
    IG_EVENT_POP_MATRIX,
    IG_EVENT_ANIMATION,
    IG_EVENT_STATE
} IGGraphicEventType;

typedef enum {   /* Note that some device drivers depends on this order. */
    IG_STATE_OOPS = 1,
    IG_STATE_MORE_SENSITIVE,
    IG_STATE_LESS_SENSITIVE,
    IG_STATE_SCR_OBJ_TGL,
    IG_STATE_PERS_ORTHO_TGL,
    IG_STATE_DEPTH_CUE,
    IG_STATE_CACHE_GEOM,
    IG_STATE_DRAW_SOLID,
    IG_STATE_BACK_FACE_CULL,
    IG_STATE_DOUBLE_BUFFER,
    IG_STATE_ANTI_ALIASING,
    IG_STATE_DRAW_INTERNAL,
    IG_STATE_DRAW_VNORMAL,
    IG_STATE_DRAW_PNORMAL,
    IG_STATE_DRAW_SRF_MESH,
    IG_STATE_DRAW_SRF_POLY,
    IG_STATE_FOUR_PER_FLAT,
    IG_STATE_MORE_ISOLINES,
    IG_STATE_LESS_ISOLINES,
    IG_STATE_FINER_APPROX,
    IG_STATE_COARSER_APPROX,
    IG_STATE_LONGER_VECTORS,
    IG_STATE_SHORTER_VECTORS,
    IG_STATE_WIDER_LINES,
    IG_STATE_NARROW_LINES,
    IG_STATE_VIEW_FRONT,
    IG_STATE_VIEW_SIDE,
    IG_STATE_VIEW_TOP,
    IG_STATE_VIEW_ISOMETRY,
    IG_STATE_CLEAR_VIEW,
    IG_STATE_ANIMATION,

    IG_STATE_FINER_ADAP_ISO,
    IG_STATE_COARSER_ADAP_ISO,
    IG_STATE_FINER_RULED_SRF,
    IG_STATE_COARSER_RULED_SRF,
    IG_STATE_RULED_SRF_APPROX,
    IG_STATE_ADAP_ISO_DIR
} IGGlblStateType;

extern int
    IGGlblBackGroundColor[3],
    IGGlblDrawInternal,
    IGGlblDrawVNormal,
    IGGlblDrawPNormal,
    IGGlblMore,
    IGGlblForceUnitMat,
    IGGlblDrawSolid,
    IGGlblBackFaceCull,
    IGGlblDoDoubleBuffer,
    IGGlblNumOfIsolines,
    IGGlblSamplesPerCurve,
    IGGlblLineWidth,
    IGGlblAdapIsoDir,
    IGGlblPolylineOptiApprox,
    IGGlblPolygonOptiApprox,
    IGGlblDepthCue,
    IGGlblCacheGeom,
    IGGlblFourPerFlat,
    IGGlblAntiAliasing,
    IGGlblDrawSurfaceMesh,
    IGGlblDrawSurfacePoly,
    IGGlblStandAlone,
    IGGlblTransformMode,
    IGGlblViewMode,
    IGGlblDebugObjectsFlag,
    IGGlblDebugEchoInputFlag,
    IGGlblDelayedClear,
    IGGlblDisplayListIsUsed,
    IGGlblIntensityHighState,
    IGGlblAbortKeyPressed,
    IGGlblAnimation,
    IGGlblNumFiles,
    IGGlblPrgmInput,
    IGGlblPrgmOutput;

extern char
    *IGGlblTransPrefPos,
    *IGGlblViewPrefPos,
    **IGGlblFileNames;

extern RealType
    IGGlblLightSrcPos[4],
    IGGlblFineNess,
    IGGlblChangeFactor,
    IGGlblZMinClip,
    IGGlblZMaxClip,
    IGGlblNormalLen;

extern IPObjectStruct
    *IGGlblDisplayList;

extern MatrixType
    IGGlblCrntViewMat,
    IGGlblIsometryViewMat;

extern AnimationStruct IGAnimation;

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

/* Gen_grap.c routines - generic graphic's driver routines. */
void IGConfigureGlobals(char *PrgmName, int argc, char **argv);
void IGProcessCommandMessages(int ProcessCommandMessages);
int IGReadObjectsFromSocket(int ViewMode, IPObjectStruct **DisplayList);
void IGSaveCurrentMat(int ViewMode, char *Name);
int IGProcessEvent(IGGraphicEventType Event, RealType ChangeFactor);
void IGActiveListFreeNamedAttribute(char *Name);
int IGDefaultStateHandler(int State, int Refresh);

/* Functions that should be defined in most graphics driver. */
int IGHandleState(int State, int Refresh);
void IGHandleInternalEvents(void);
void IGCreateStateMenu(void);
void IGSetColorIntensity(int High);
void IGSetColorObj(IPObjectStruct *PObj);
void IGSetWidthObj(int Width);
void IGIritBeep(void);
void IGMoveTo2D(RealType X, RealType Y);
void IGLineTo2D(RealType X, RealType Y);

/* The primitive drawing routines. */
void IGMoveTo3D(RealType *Pt);
void IGLineTo3D(RealType *Pt);
void IGDrawObject(IPObjectStruct *PObj);
void IGDrawPtVec(IPObjectStruct *PObj);
void IGDrawPoly(IPObjectStruct *PObj);
void IGDrawCurve(IPObjectStruct *PObj);
void IGDrawSurface(IPObjectStruct *PObj);
void IGDrawTrimSrf(IPObjectStruct *PObj);
void IGDrawTrivar(IPObjectStruct *PObj);
void IGRedrawViewWindow(void);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif /* IRIT_GRAP_H */

