#include	<stdio.h>
#include	"cmap.h"

/* Device-independent routines related to function editing
 */

/*
 * Some control points have changed.
 * Figure out how much needs to be redisplayed and call the graphics routines.
 * Also recompute spline parameters &c if needed.
 */
void
redo (box, from, to, reflags)
    int box;
    int from, to;	/* Range of control points (cbox[].cval's) which changed */
{
    int		i, k, lo, hi;
    XPoint	p[MAXVALS+1];	/* A batch of points */
    register struct cval *c;

    if(spline) {
	lo = from-2;
	hi = to+2;
    } else {
	lo = from-1;
	hi = to+1;
    }
    if(lo<0) lo = 0;
    if(hi>=cbox[box].count) hi = cbox[box].count-1;
    if(lo>=hi)
	return;

    if(reflags&RECALC) {
	if(spline) {
	    recalc_spline(box, lo, hi);
	}
    }

    /* Anyway redisplay */

    c = &cbox[box].cval[lo];
    k = 0;
    if(spline) {
    } else {
	for(i = lo; i <= hi; i++, c++, k++) {
	    if(c->pump && i > 0) {
		int ly = (c-1)->y;
		int ry = c->y + c->pump*YSCALE;
		int lx = ItoGX((c-1)->x), rx = ItoGX(c->x);
		int dy = (c->pump > 0) ? -YSCALE : YSCALE;
		int ny = (c->pump > 0) ? c->pump : -c->pump;

		p[k].x = rx;
		p[k].y = ItoGY(ry);
		k++;
		do {
			putlines(box, p, k, reflags&UNDRAW ? 0 : 1);
			ly += dy;
			ry += dy;
			p[0].x = lx;
			p[0].y = ItoGY(ly);
			p[1].x = rx;
			p[1].y = ItoGY(ry);
			k = 2;
		} while(--ny > 0);	
	    }
	    p[k].x = ItoGX(c->x);
	    p[k].y = ItoGY(c->y);
	}
    }
    /* Display last (generally only) batch of lines */
    if(k > 0)
	putlines(box, p, k, reflags&UNDRAW ? 0 : 1);

    k = 0;
    c = &cbox[box].cval[lo];
    for(i = lo; i <= hi; i++, k++, c++) {
	p[k].x = ItoGX(c->x);
	p[k].y = ItoGY(c->y);
    }
    putpoints(box, p, k, reflags&UNDRAW ? 0 : 1);

    if(reflags&REDOLUT) {
	int lox, hix;

	lox = cbox[box].cval[lo].x;
	hix = cbox[box].cval[hi].x;
	relut(lox, hix);
	if(box <= 2)
		updateCmap(lox, hix);
    }
}

relut(lox, hix)
	int lox, hix;
{
	struct tuple rgb;
	register int i, x;

	i = lox * 256 / XSCALE;
	do {
		x = i * XSCALE / 256;
		map_to_tuple(x, &rgb);
		lut[i].red   = rgb.v[0] * (65536 / YSCALE);
		lut[i].green = rgb.v[1] * (65536 / YSCALE);
		lut[i].blue  = rgb.v[2] * (65536 / YSCALE);
		i++;
	} while(x < hix);
}


recalc_spline(box, lo, hi)
	int box;
	int lo, hi;
{
	/* Real Soon Now */
}

int
eval_box(x, box)	/* Evaluate a box function, return internal coords */
	int x;		/* colormap X (internal coordinate) */
	int box;
{
	register struct cval *c;
	register int i, dx, dy;
	int n;
	static int oi[NBOX];	/* Cache */

	i = cbox[box].count;
	c = &cbox[box].cval[0];
	if(i <= 1)
		return c->y;

	n = cbox[box].count;
	/* Check the cache -- avoid repeating search if this x is in same
	 * interval as last one.
	 */
	if(! ((i = oi[box]) < n
	      && x < (c = &cbox[box].cval[i])->x
	      && (i == 0 || x >= (c-1)->x))) {
	    /* Miss, do the full search */
	    for(c = &cbox[box].cval[0], i = 0; i < n; i++, c++) {
		/* Find interval containing x. Could use binary search... */
		if(x < c->x)
			break;
	    }
	}
	/* Be linear for now */
	/* Check for end conditions */
	/* Always return result mod YSCALE so pumps don't drive us crazy.
	 * Casting to unsigned int first lets % YSCALE become bitwise AND.
	 */
	if(i == 0) {
		/* linear extrapolation off left end */
		return ((unsigned int) (c->y + (x - c->x)
				* ((c+1)->y + YSCALE * (c+1)->pump - c->y)
				/ ((c+1)->x - c->x)) % YSCALE);
	} else {
		if(i >= n)	/* extrapolating off right end? */
			c--;
		return ((unsigned int) (c->y + (x - c->x)
				* (c->y + YSCALE * c->pump - (c-1)->y)
				/ (c->x - (c-1)->x))
			% YSCALE);
	}
}


/* Map a point in the color map to {r,g,b,a} */

void
map_to_tuple(x, t)
	int x;				/* colormap X (internal coordinate) */
	register struct tuple *t;	/* tuple to be filled in */
{
	struct tuple v;
	register int i;

	for(i = 0; i < NBOX; i++)
		t->v[i] = eval_box(x, i);
	switch(colorscheme) {
	case HSV: hsv2rgb(t, t); break;
	case YIQ: yiq2rgb(t, t); break;
	}
}

void
add_point(box, ix, iy, flags)
	int box;
	int ix, iy;
	int flags;
{
	int n, i;
	register struct cval *c;

	lastpt = -1;		/* Fail by default */

	/* Room to add point? */
	n = cbox[box].count;
	if(n == MAXVALS) {
		boxMessage(box, "Already have %d points", MAXVALS);
		return;
	}
	for(i = 0, c = &cbox[box].cval[0], n = cbox[box].count;
	    i < n; i++, c++)
		if(ix <= c->x)
			break;
	/* Can't add to left of left edge nor right of right edge */
	if(i <= 0 || i >= n) {
		boxMessage(box, "Out of bounds");
		return;
	}
	/* If adding on top of existing point, shove new guy to ix-1.
	 * Works unless we already have a point at ix-1.
	 */
	if(ix == c->x) {
		ix--;
		if(ix == (c-1)->x) {
			boxMessage(box, "No room @ %d", ix);
			return;
		}
	}
	redo(box, i, i, UNDRAW);
	lastpt = i;	/* Success is inevitable */
	lastbox = box;
	cbox[box].count++;
	for(c = &cbox[box].cval[n]; n > i; n--, c--)
		*c = *(c-1);

	c->x = ix;
	c->y = iy;
	c->flags = flags;
	c->pump = 0;
	redo(box, i, i+1, RECALC|REDOLUT);
}

void
move_point(box, point, ix, iy, flags)
	int box;
	int point;	/* control point index in cval[] */
	int ix, iy;	/* move there */
	int flags;	/* maybe main point vs. left or right spline wings? */
{
	int x, y;
	register struct cval *c;

	c = &cbox[box].cval[point];
	/* clamp X */
	x = ix;
	if(c->flags & LOCK_X)
		x = c->x;
	else if(point > 0 && x <= (c-1)->x)
		x = (c-1)->x + 1;
	else if(point < cbox[box].count-1 && x >= (c+1)->x)
		x = (c+1)->x - 1;
	else if(x < 0)
		x = 0;
	else if(x >= XSCALE)
		x = XSCALE-1;

	/* clamp Y */
	y = iy;
	if(c->flags & LOCK_Y)
		y = c->y;
	else if(y < 0)
		y = 0;
	else if(y >= YSCALE)
		y = YSCALE-1;

	if(c->x != x || c->y != y) {
		redo(box, point, point, UNDRAW);
		c->x = x;
		c->y = y;
		redo(box, point, point, RECALC|REDOLUT);
	}
	lastpt = point;
	lastbox = box;
}

void
del_point(box, point, flags)
	int box;
	int point;
	int flags;
{
	register struct cval *c;
	register int i, n1;

	n1 = cbox[box].count-1;
	if(point <= 0 || point >= n1) {
		boxMessage(box, "Can't delete end points");
		return;
	}

	redo(box, point, point, UNDRAW);
	c = &cbox[box].cval[point];
	for(i = point; i < n1; i++, c++) {
		*c = *(c+1);
	}
	cbox[box].count = n1;
	redo(box, point, point, RECALC|REDOLUT);
}
