#include	<stdio.h>
#include	"cmap.h"

/* l = (max+min) / 2
 * s = (max(r,g,b) - min(r,g,b)) / 2*Min(l, (1-l))
 * h = angle 0..YSCALE-1
 *	red is max component where 0<=h<=YSCALE/6 or YSCALE*5/6<=h<YSCALE,
 *	green is max where YSCALE*1/6<=h<=YSCALE*3/6,
 *	blue is max where YSCALE*3/6<=h<=YSCALE*5/6.
 */

hls2rgb(hls, rgb)
	register struct tuple *hls, *rgb;
{
	int i, imin, imax;
	int dh, vdiff;
	int h = (unsigned)hls->v[0] % YSCALE;
	int l = (unsigned)hls->v[1] % YSCALE;
	int s = (unsigned)hls->v[2] % YSCALE;

	i = 6*h / YSCALE;	/* map hue to sextant 0..5 */
	imax = ((i+1)/2) % 3;
	imin = ((i+4)/2) % 3;
	dh = 6*h - imax*(2*YSCALE);
	if(dh < 0)
		dh = -dh;
	else if(dh > YSCALE)
		dh = 6*YSCALE - dh;
	/* dh is abs(delta hue from the center point of the imax'th color), */
	/* rescaled so 0 <= dh < YSCALE  */

	vdiff = ((l > YSCALE/2) ? YSCALE - l : l) * s / YSCALE;
	/* l = (max+min)/2, vdiff = (max-min)/2 */

	rgb->v[imax] = l + vdiff;
	rgb->v[imin] = l - vdiff;
	rgb->v[3-imax-imin] = l - vdiff + vdiff*dh / (YSCALE/2);
}


/* v = max(r,g,b)
 * s = 1 - (min(r,g,b) / max(r,g,b))
 * h = angle 0..YSCALE-1
 *	red is max component where 0<=h<=YSCALE/6 or YSCALE*5/6<=h<YSCALE,
 *	green is max where YSCALE*1/6<=h<=YSCALE*3/6,
 *	blue is max where YSCALE*3/6<=h<=YSCALE*5/6.
 */

hsv2rgb(hsv, rgb)
	register struct tuple *hsv, *rgb;
{
	int i, imin, imax;
	int dh, vmin, vmax;
	int h = (unsigned)hsv->v[0] % YSCALE;
	int s = (unsigned)hsv->v[1] % YSCALE;
	int v = (unsigned)hsv->v[2] % YSCALE;

	i = 6*h / YSCALE;	/* map hue to sextant 0..5 */
	imax = ((i+1)/2) % 3;
	imin = ((i+4)/2) % 3;
	dh = 6*h - imax*(2*YSCALE);
	if(dh < 0)
		dh = -dh;
	else if(dh > YSCALE)
		dh = 6*YSCALE - dh;	/* abs(dh) mod 360 degrees */

	vmin = v * (YSCALE-s) / YSCALE;	/* min = s*v. */
	rgb->v[imax] = v;
	rgb->v[imin] = vmin;
	rgb->v[3-imax-imin] = vmin + (v-vmin)*dh / YSCALE;
}

/* YIQ -- NTSC color encoding.
 * R = Y  + 0.9557 I  + 0.6199 Q
 * G = Y  - 0.2716 I  - 0.6469 Q
 * B = Y  - 1.1082 I  + 1.7051 Q
 * In real NTSC the Y, I, Q values are horizontally band-limited:
 *  Y 4.2 Mhz (221 cycles/scan line),  I 1.3 MHz (68.3), Q 0.5 MHz (26.3).
 * Thus for best color resolution it's advantageous to choose colors with
 * approximately equal Q values, since it has the narrowest bandpass.
 *
 * In the code the coefficients above appear scaled by 32768, and I and Q
 * are offset by half full scale so 0 is midrange.
 */
yiq2rgb(yiq, rgb)
	register struct tuple *yiq, *rgb;
{
	int y, i, q;
	register int k;

	y = yiq->v[0];
	i = yiq->v[1] - YSCALE/2;
	q = yiq->v[2] - YSCALE/2;
#define	S(frac, v)	((frac*YSCALE/10000) * (v) / YSCALE)
	rgb->v[0] = y + S(9557, i) + S(6199, q);
	rgb->v[1] = y - S(2716, i) - S(6469, q);
	rgb->v[2] = y - S(11082, i) + S(17051, q);
	for(k = 0; k <= 2; k++) {
		if(rgb->v[k] < 0) rgb->v[k] = 0;
		else if(rgb->v[k] >= YSCALE) rgb->v[k] = YSCALE-1;
		/* alternatively... rgb->v[k] &= (YSCALE-1); */
	}
}
