#line 2 "sieve.l"
/* GNU Mailutils -- a suite of utilities for electronic mail
   Copyright (C) 1999-2002, 2004-2005, 2007-2012, 2014-2016 Free
   Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General
   Public License along with this library.  If not, see
   <http://www.gnu.org/licenses/>. */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif  



#line 27 "sieve-lex.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 37
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define mu_sieve_yyconst const
#else
#define mu_sieve_yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (mu_sieve_yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((mu_sieve_yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE mu_sieve_yyrestart(mu_sieve_yyin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(mu_sieve_yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct mu_sieve_yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t mu_sieve_yy_size_t;
#endif

extern mu_sieve_yy_size_t mu_sieve_yyleng;

extern FILE *mu_sieve_yyin, *mu_sieve_yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define mu_sieve_yyless(n) \
	do \
		{ \
		/* Undo effects of setting up mu_sieve_yytext. */ \
        int mu_sieve_yyless_macro_arg = (n); \
        YY_LESS_LINENO(mu_sieve_yyless_macro_arg);\
		*mu_sieve_yy_cp = (mu_sieve_yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(mu_sieve_yy_c_buf_p) = mu_sieve_yy_cp = mu_sieve_yy_bp + mu_sieve_yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up mu_sieve_yytext again */ \
		} \
	while ( 0 )

#define unput(c) mu_sieve_yyunput( c, (mu_sieve_yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct mu_sieve_yy_buffer_state
	{
	FILE *mu_sieve_yy_input_file;

	char *mu_sieve_yy_ch_buf;		/* input buffer */
	char *mu_sieve_yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	mu_sieve_yy_size_t mu_sieve_yy_buf_size;

	/* Number of characters read into mu_sieve_yy_ch_buf, not including EOB
	 * characters.
	 */
	mu_sieve_yy_size_t mu_sieve_yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int mu_sieve_yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int mu_sieve_yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int mu_sieve_yy_at_bol;

    int mu_sieve_yy_bs_lineno; /**< The line count. */
    int mu_sieve_yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int mu_sieve_yy_fill_buffer;

	int mu_sieve_yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via mu_sieve_yyrestart()), so that the user can continue scanning by
	 * just pointing mu_sieve_yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t mu_sieve_yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t mu_sieve_yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * mu_sieve_yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (mu_sieve_yy_buffer_stack) \
                          ? (mu_sieve_yy_buffer_stack)[(mu_sieve_yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (mu_sieve_yy_buffer_stack)[(mu_sieve_yy_buffer_stack_top)]

/* mu_sieve_yy_hold_char holds the character lost when mu_sieve_yytext is formed. */
static char mu_sieve_yy_hold_char;
static mu_sieve_yy_size_t mu_sieve_yy_n_chars;		/* number of characters read into mu_sieve_yy_ch_buf */
mu_sieve_yy_size_t mu_sieve_yyleng;

/* Points to current character in buffer. */
static char *mu_sieve_yy_c_buf_p = (char *) 0;
static int mu_sieve_yy_init = 0;		/* whether we need to initialize */
static int mu_sieve_yy_start = 0;	/* start state number */

/* Flag which is used to allow mu_sieve_yywrap()'s to do buffer switches
 * instead of setting up a fresh mu_sieve_yyin.  A bit of a hack ...
 */
static int mu_sieve_yy_did_buffer_switch_on_eof;

void mu_sieve_yyrestart (FILE *input_file  );
void mu_sieve_yy_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE mu_sieve_yy_create_buffer (FILE *file,int size  );
void mu_sieve_yy_delete_buffer (YY_BUFFER_STATE b  );
void mu_sieve_yy_flush_buffer (YY_BUFFER_STATE b  );
void mu_sieve_yypush_buffer_state (YY_BUFFER_STATE new_buffer  );
void mu_sieve_yypop_buffer_state (void );

static void mu_sieve_yyensure_buffer_stack (void );
static void mu_sieve_yy_load_buffer_state (void );
static void mu_sieve_yy_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER mu_sieve_yy_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE mu_sieve_yy_scan_buffer (char *base,mu_sieve_yy_size_t size  );
YY_BUFFER_STATE mu_sieve_yy_scan_string (mu_sieve_yyconst char *mu_sieve_yy_str  );
YY_BUFFER_STATE mu_sieve_yy_scan_bytes (mu_sieve_yyconst char *bytes,mu_sieve_yy_size_t len  );

void *mu_sieve_yyalloc (mu_sieve_yy_size_t  );
void *mu_sieve_yyrealloc (void *,mu_sieve_yy_size_t  );
void mu_sieve_yyfree (void *  );

#define mu_sieve_yy_new_buffer mu_sieve_yy_create_buffer

#define mu_sieve_yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        mu_sieve_yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            mu_sieve_yy_create_buffer(mu_sieve_yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->mu_sieve_yy_is_interactive = is_interactive; \
	}

#define mu_sieve_yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        mu_sieve_yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            mu_sieve_yy_create_buffer(mu_sieve_yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->mu_sieve_yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->mu_sieve_yy_at_bol)

/* Begin user sect3 */

typedef unsigned char YY_CHAR;

FILE *mu_sieve_yyin = (FILE *) 0, *mu_sieve_yyout = (FILE *) 0;

typedef int mu_sieve_yy_state_type;

extern int mu_sieve_yylineno;

int mu_sieve_yylineno = 1;

extern char *mu_sieve_yytext;
#define mu_sieve_yytext_ptr mu_sieve_yytext

static mu_sieve_yy_state_type mu_sieve_yy_get_previous_state (void );
static mu_sieve_yy_state_type mu_sieve_yy_try_NUL_trans (mu_sieve_yy_state_type current_state  );
static int mu_sieve_yy_get_next_buffer (void );
static void mu_sieve_yy_fatal_error (mu_sieve_yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up mu_sieve_yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(mu_sieve_yytext_ptr) = mu_sieve_yy_bp; \
	mu_sieve_yyleng = (size_t) (mu_sieve_yy_cp - mu_sieve_yy_bp); \
	(mu_sieve_yy_hold_char) = *mu_sieve_yy_cp; \
	*mu_sieve_yy_cp = '\0'; \
	(mu_sieve_yy_c_buf_p) = mu_sieve_yy_cp;

#define YY_NUM_RULES 37
#define YY_END_OF_BUFFER 38
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct mu_sieve_yy_trans_info
	{
	flex_int32_t mu_sieve_yy_verify;
	flex_int32_t mu_sieve_yy_nxt;
	};
static mu_sieve_yyconst flex_int16_t mu_sieve_yy_accept[146] =
    {   0,
        0,    0,    2,    2,    0,    0,    0,    0,   38,   36,
       34,   35,   36,    9,   36,   21,   23,   36,   36,   36,
       36,   36,   36,   36,   36,   36,    2,    4,    3,   37,
       33,   37,   37,   37,   27,   37,   34,    0,   24,    0,
        9,    9,    8,    9,    9,    1,   21,   21,    0,   23,
       23,    0,   19,   19,   19,   19,   19,   11,   19,   19,
       19,   19,    2,    3,    3,    5,    0,   33,    0,    0,
        0,   27,    0,   26,   25,    9,    9,    0,   20,   19,
       19,   19,   19,   16,   19,   19,   19,    0,    9,    9,
       22,   19,   19,   13,   19,   19,   19,   19,   18,    0,

        9,    9,   22,   15,   14,   12,   17,   19,    0,    0,
        9,    9,   19,    0,   29,    0,    0,    0,    0,    0,
        9,    9,   10,    0,   28,    0,    0,    9,    9,    0,
       31,    0,    0,    9,    6,    9,    0,   30,    0,   32,
        9,    9,    9,    7,    0
    } ;

static mu_sieve_yyconst flex_int32_t mu_sieve_yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    4,    5,    1,    1,    1,    1,    1,
        1,    6,    1,    1,    7,    1,    8,    9,   10,   10,
       10,   10,   10,   10,   10,   11,   11,   12,    1,    1,
        1,    1,    1,    1,   13,   13,   13,   13,   13,   13,
       14,   15,   15,   15,   14,   15,   14,   15,   15,   15,
       15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
        1,   16,    1,    1,   15,    1,   17,   13,   18,   19,

       20,   21,   14,   22,   23,   15,   14,   24,   14,   25,
       26,   27,   28,   29,   30,   31,   32,   15,   15,   33,
       34,   15,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static mu_sieve_yyconst flex_int32_t mu_sieve_yy_meta[35] =
    {   0,
        1,    2,    3,    1,    2,    4,    2,    1,    5,    5,
        5,    1,    6,    7,    7,    2,    6,    6,    6,    6,
        6,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7
    } ;

static mu_sieve_yyconst flex_int16_t mu_sieve_yy_base[169] =
    {   0,
        0,    0,   32,   33,   37,   38,   41,   43,  334,  335,
      331,  335,   33,   48,  326,   44,   51,    0,    0,   31,
      307,  313,  308,  302,  307,   43,    0,  335,   58,  323,
      335,   65,   65,  335,  335,    0,  323,   66,  335,    0,
      321,   71,  335,   72,   73,  335,   70,  309,    0,   76,
      308,    0,    0,  297,  286,  289,  294,    0,  286,  288,
      282,  242,    0,   83,   90,  335,  270,  335,   97,   80,
       88,  335,    0,  335,  335,   92,   99,    0,    0,  233,
      226,   83,  215,    0,  199,  194,  204,  104,  105,  106,
      191,  159,  158,    0,  157,  157,  153,  163,    0,  108,

      109,  110,  160,    0,    0,    0,    0,  144,  131,  111,
      112,  115,  152,  121,  335,  168,  137,    0,  143,  146,
      147,  124,    0,  165,  335,  152,  149,  163,  153,  158,
      335,  161,  122,  118,  335,  127,  116,  335,  114,  335,
      159,   49,   45,  335,  335,  181,  188,  195,  202,  209,
      211,  214,  221,  228,  235,  242,  249,  256,  259,  261,
      264,  269,  276,  279,  286,  293,  300,  307
    } ;

static mu_sieve_yyconst flex_int16_t mu_sieve_yy_def[169] =
    {   0,
      145,    1,  146,  146,  147,  147,  148,  148,  145,  145,
      145,  145,  149,  150,  145,  145,  145,  151,  152,  152,
      152,  152,  152,  152,  152,  152,  153,  145,  154,  155,
      145,  155,  156,  145,  145,  157,  145,  149,  145,  158,
      150,  150,  145,  150,  150,  145,  145,  145,  159,  145,
      145,  160,  152,  152,  152,  152,  152,  152,  152,  152,
      152,  152,  153,  154,  154,  145,  155,  145,  155,  155,
      156,  145,  157,  145,  145,  150,  150,  161,  160,  152,
      152,  152,  152,  152,  152,  152,  152,  155,  150,  150,
      161,  152,  152,  152,  152,  152,  152,  152,  152,  155,

      150,  150,  145,  152,  152,  152,  152,  152,  162,  155,
      150,  150,  152,  145,  145,  163,  162,  164,  117,  155,
      150,  150,  152,  163,  145,  164,  155,  165,  150,  145,
      145,  166,  167,  165,  145,  150,  166,  145,  167,  145,
      150,  168,  168,  145,    0,  145,  145,  145,  145,  145,
      145,  145,  145,  145,  145,  145,  145,  145,  145,  145,
      145,  145,  145,  145,  145,  145,  145,  145
    } ;

static mu_sieve_yyconst flex_int16_t mu_sieve_yy_nxt[370] =
    {   0,
       10,   11,   12,   13,   14,   10,   10,   15,   16,   17,
       17,   18,   19,   19,   19,   10,   20,   19,   19,   21,
       22,   19,   23,   19,   24,   19,   19,   19,   25,   19,
       26,   19,   19,   19,   28,   28,   39,   29,   29,   31,
       31,   32,   32,   34,   35,   34,   35,  144,   40,   42,
       43,  144,   47,   47,   54,   55,   36,   48,   36,   50,
       50,   50,   61,   65,   51,   66,   69,   68,   72,   39,
       44,   62,   42,   43,   43,   43,   49,   45,   47,   47,
       73,   40,   68,   48,   50,   50,   50,   70,  145,   51,
      145,   72,   77,   44,   43,   65,   76,   66,   69,   68,

       45,   43,   94,   73,   88,   95,   68,   43,   43,   89,
       68,   43,   43,   68,   43,   90,  140,   43,  138,   70,
      135,  100,  114,  115,  140,  116,   43,  112,  101,   43,
      121,  110,  114,  115,  102,  116,  122,  117,  114,  115,
      111,  116,  120,  145,  145,  145,  119,  145,   68,   43,
      129,   68,  119,  130,  131,   43,  132,  141,  145,  130,
      131,   43,  132,  138,  127,  135,  128,  125,  133,  136,
      125,  123,  113,  103,  109,  108,  107,  106,  105,  104,
      142,   27,   27,   27,   27,   27,   27,   27,   30,   30,
       30,   30,   30,   30,   30,   33,   33,   33,   33,   33,

       33,   33,   38,   38,  103,   38,   38,   38,   38,   41,
       41,   41,   41,   41,   41,   41,   52,   52,   53,   53,
       53,   63,   63,   99,   98,   63,   63,   63,   64,   64,
       97,   64,   64,   64,   64,   67,   67,   67,   67,   67,
       67,   67,   71,   71,   96,   71,   71,   71,   71,   74,
       74,   93,   74,   74,   74,   74,   75,   75,   92,   75,
       75,   75,   75,   78,   78,   79,   79,   79,   91,   91,
      118,  118,   68,   87,  118,  118,  124,  124,  124,  124,
      124,  124,  124,  126,  126,  126,  134,  134,  134,  134,
      134,  134,  134,  137,  137,  137,  137,  137,  137,  137,

      139,  139,  139,  139,  139,  139,  139,  143,  143,  143,
      143,  143,  143,  143,   86,   85,   84,   83,   82,   81,
       80,   51,   48,   43,   37,   68,   60,   59,   58,   57,
       56,   46,   37,  145,    9,  145,  145,  145,  145,  145,
      145,  145,  145,  145,  145,  145,  145,  145,  145,  145,
      145,  145,  145,  145,  145,  145,  145,  145,  145,  145,
      145,  145,  145,  145,  145,  145,  145,  145,  145
    } ;

static mu_sieve_yyconst flex_int16_t mu_sieve_yy_chk[370] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    3,    4,   13,    3,    4,    5,
        6,    5,    6,    7,    7,    8,    8,  143,   13,   14,
       14,  142,   16,   16,   20,   20,    7,   16,    8,   17,
       17,   17,   26,   29,   17,   29,   32,   32,   33,   38,
       14,   26,   42,   42,   44,   45,   16,   14,   47,   47,
       33,   38,   70,   47,   50,   50,   50,   32,   64,   50,
       64,   71,   45,   42,   76,   65,   44,   65,   69,   69,

       42,   77,   82,   71,   70,   82,   88,   89,   90,   76,
      100,  101,  102,  110,  111,   77,  139,  112,  137,   69,
      134,   88,  114,  114,  133,  114,  122,  102,   89,  136,
      111,  100,  109,  109,   90,  109,  112,  109,  117,  117,
      101,  117,  110,  117,  119,  119,  109,  119,  120,  121,
      122,  127,  117,  126,  126,  129,  126,  136,  119,  130,
      130,  141,  130,  132,  120,  128,  121,  124,  127,  129,
      116,  113,  108,  103,   98,   97,   96,   95,   93,   92,
      141,  146,  146,  146,  146,  146,  146,  146,  147,  147,
      147,  147,  147,  147,  147,  148,  148,  148,  148,  148,

      148,  148,  149,  149,   91,  149,  149,  149,  149,  150,
      150,  150,  150,  150,  150,  150,  151,  151,  152,  152,
      152,  153,  153,   87,   86,  153,  153,  153,  154,  154,
       85,  154,  154,  154,  154,  155,  155,  155,  155,  155,
      155,  155,  156,  156,   83,  156,  156,  156,  156,  157,
      157,   81,  157,  157,  157,  157,  158,  158,   80,  158,
      158,  158,  158,  159,  159,  160,  160,  160,  161,  161,
      162,  162,   67,   62,  162,  162,  163,  163,  163,  163,
      163,  163,  163,  164,  164,  164,  165,  165,  165,  165,
      165,  165,  165,  166,  166,  166,  166,  166,  166,  166,

      167,  167,  167,  167,  167,  167,  167,  168,  168,  168,
      168,  168,  168,  168,   61,   60,   59,   57,   56,   55,
       54,   51,   48,   41,   37,   30,   25,   24,   23,   22,
       21,   15,   11,    9,  145,  145,  145,  145,  145,  145,
      145,  145,  145,  145,  145,  145,  145,  145,  145,  145,
      145,  145,  145,  145,  145,  145,  145,  145,  145,  145,
      145,  145,  145,  145,  145,  145,  145,  145,  145
    } ;

static mu_sieve_yy_state_type mu_sieve_yy_last_accepting_state;
static char *mu_sieve_yy_last_accepting_cpos;

extern int mu_sieve_yy_flex_debug;
int mu_sieve_yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define mu_sieve_yymore() mu_sieve_yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *mu_sieve_yytext;
#line 1 "sieve.l"

#line 26 "sieve.l"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>  
#include <sys/file.h>
#include <sys/stat.h>
#include <errno.h>
#include <string.h>
#include <mailutils/cctype.h>
#include <mailutils/wordsplit.h>
#include <sieve-priv.h>
#include <sieve-gram.h>
  
static char *multiline_delimiter;
static int strip_tabs; 

static int number (void);
static int string (void);
static void line_begin (void);
static void line_add (char const *text, size_t len);
static void line_addz (char const *text); 
static void line_finish (void);
static void multiline_begin (void);
static void multiline_add (void);
static void multiline_finish (void);
static char *multiline_strip_tabs (char *text);
static void ident (const char *text);
static void sieve_include (void);
static void sieve_searchpath (void);
static char *str_unescape (char *text, size_t len);
static int isemptystr (char *text);

static ino_t sieve_source_inode;
struct mu_locus mu_sieve_locus;
static int newline;

static mu_stream_t input_stream;
 
static int
fillbuf (char *buf, size_t max_size)
{
  int rc;

  if (!input_stream)
    return 0;
  
  rc = mu_stream_read (input_stream, buf, max_size, &max_size);
  if (rc)
    {
      mu_diag_funcall (MU_DIAG_ERROR, "mu_stream_read",
		       mu_sieve_locus.mu_file, rc);
      return 0;
    }
  return max_size;
}
 
#undef YY_INPUT
#define YY_INPUT(buf,result,max_size) result = fillbuf (buf, max_size)
#define LEX_BUFFER_STATE YY_BUFFER_STATE
#define SET_BUFFER_STATE(s) do { \
        (s) = YY_CURRENT_BUFFER; \
        mu_sieve_yy_switch_to_buffer(mu_sieve_yy_create_buffer (mu_sieve_yyin, YY_BUF_SIZE)); \
} while (0)
#define RESTORE_BUFFER_STATE(s) do { \
        mu_sieve_yy_delete_buffer (YY_CURRENT_BUFFER); \
        mu_sieve_yy_switch_to_buffer (s); \
} while (0)

static void
init_locus (char const *name, ino_t ino)
{
  mu_sieve_locus.mu_file = mu_i_sv_id_canon (mu_sieve_machine, name);
  mu_sieve_locus.mu_line = 1;
  mu_sieve_locus.mu_col = 0;
  newline = 0;
  sieve_source_inode = ino;
}
 
static void
advance_locus (void)
{
  if (newline)
    {
      mu_sieve_locus.mu_line++;
      mu_sieve_locus.mu_col = 0;
      mu_sieve_yylloc.beg = mu_sieve_yylloc.end = mu_sieve_locus;                        
    }
  else
    {
      mu_sieve_locus.mu_col += mu_sieve_yyleng;
      mu_sieve_yylloc.beg = mu_sieve_yylloc.end = mu_sieve_locus;                        
      mu_sieve_yylloc.beg.mu_col -= mu_sieve_yyleng;                             
    }
  newline = mu_sieve_yytext[mu_sieve_yyleng-1] == '\n';
}
 
#define YY_USER_ACTION advance_locus ();
   
struct buffer_ctx
{
  struct buffer_ctx *prev;
  struct mu_locus locus;
  ino_t i_node;
  mu_stream_t input;
  LEX_BUFFER_STATE state;
};

static struct buffer_ctx *context_stack;

static struct buffer_ctx *ctx_lookup (ino_t ino);
static int push_source (const char *name);
static int pop_source (void);

struct buffer_ctx *
ctx_lookup (ino_t ino)
{
  struct buffer_ctx *ctx;

  for (ctx = context_stack; ctx; ctx = ctx->prev)
    if (ctx->i_node == ino)
      break;
  return ctx;
}
        
int
push_source (const char *name)
{
  int rc;
  mu_stream_t stream;
  struct buffer_ctx *ctx;
  struct stat st;
        
  if (stat (name, &st))
    {
      mu_diag_at_locus (MU_LOG_ERROR, &mu_sieve_locus,
			_("cannot stat `%s': %s"), name, strerror (errno));
      mu_i_sv_error (mu_sieve_machine);
      return 1;
    }

  if (mu_sieve_locus.mu_file && st.st_ino == sieve_source_inode)
    {
      mu_sieve_yyerror (_("recursive inclusion"));
      return 1;
    }
  if ((ctx = ctx_lookup (st.st_ino)))
    {
      mu_sieve_yyerror (_("recursive inclusion"));
      if (ctx->prev)
	{
	  mu_diag_at_locus (MU_LOG_ERROR, &ctx->prev->locus,
			    _("`%s' already included here"),
			    name);
	  mu_i_sv_error (mu_sieve_machine);
	}
      else
	{
	  mu_diag_at_locus (MU_LOG_ERROR, &mu_sieve_locus,
			    _("`%s' already included at top level"),
			    name);
	  mu_i_sv_error (mu_sieve_machine);
	}	  
      return 1;
    }

  rc = mu_file_stream_create (&stream, name, MU_STREAM_READ);
  if (rc)
    {
      mu_diag_at_locus (MU_LOG_ERROR, &mu_sieve_locus,
			_("cannot open file `%s': %s"),
			name, mu_strerror (rc));
      mu_i_sv_error (mu_sieve_machine);
      return 1;
    }

  /* Push current context */
  if (mu_sieve_locus.mu_file)
    {
      advance_locus ();
      ctx = mu_sieve_malloc (mu_sieve_machine, sizeof (*ctx));
      ctx->locus = mu_sieve_locus;
      ctx->i_node = sieve_source_inode;
      ctx->input = input_stream;
      ctx->prev = context_stack;
      context_stack = ctx;

      /* Switch to the new context */
      SET_BUFFER_STATE (ctx->state);
    }
  input_stream = stream;

  init_locus (name, st.st_ino);

  return 0;
}

int
pop_source ()
{
  struct buffer_ctx *ctx;

  mu_stream_destroy (&input_stream);

  if (!context_stack)
    {
      input_stream = NULL;
      init_locus (NULL, 0);
      return 1;
    }
  /* Restore previous context */
  input_stream = context_stack->input;
  mu_sieve_locus = context_stack->locus;
  sieve_source_inode = context_stack->i_node;
  RESTORE_BUFFER_STATE (context_stack->state);
  ctx = context_stack->prev;
  mu_sieve_free (mu_sieve_machine, context_stack);
  context_stack = ctx;

  return 0;
}
#define YY_NO_INPUT 1

#line 827 "sieve-lex.c"

#define INITIAL 0
#define COMMENT 1
#define ML 2
#define STR 3

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int mu_sieve_yy_init_globals (void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int mu_sieve_yylex_destroy (void );

int mu_sieve_yyget_debug (void );

void mu_sieve_yyset_debug (int debug_flag  );

YY_EXTRA_TYPE mu_sieve_yyget_extra (void );

void mu_sieve_yyset_extra (YY_EXTRA_TYPE user_defined  );

FILE *mu_sieve_yyget_in (void );

void mu_sieve_yyset_in  (FILE * in_str  );

FILE *mu_sieve_yyget_out (void );

void mu_sieve_yyset_out  (FILE * out_str  );

mu_sieve_yy_size_t mu_sieve_yyget_leng (void );

char *mu_sieve_yyget_text (void );

int mu_sieve_yyget_lineno (void );

void mu_sieve_yyset_lineno (int line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int mu_sieve_yywrap (void );
#else
extern int mu_sieve_yywrap (void );
#endif
#endif

#ifndef mu_sieve_yytext_ptr
static void mu_sieve_yy_flex_strncpy (char *,mu_sieve_yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int mu_sieve_yy_flex_strlen (mu_sieve_yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int mu_sieve_yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( mu_sieve_yytext, mu_sieve_yyleng, 1, mu_sieve_yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->mu_sieve_yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( mu_sieve_yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( mu_sieve_yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, mu_sieve_yyin))==0 && ferror(mu_sieve_yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(mu_sieve_yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "mu_sieve_yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef mu_sieve_yyterminate
#define mu_sieve_yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) mu_sieve_yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int mu_sieve_yylex (void);

#define YY_DECL int mu_sieve_yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after mu_sieve_yytext and mu_sieve_yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register mu_sieve_yy_state_type mu_sieve_yy_current_state;
	register char *mu_sieve_yy_cp, *mu_sieve_yy_bp;
	register int mu_sieve_yy_act;
    
#line 256 "sieve.l"

         /* C-style comments */
#line 1013 "sieve-lex.c"

	if ( !(mu_sieve_yy_init) )
		{
		(mu_sieve_yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (mu_sieve_yy_start) )
			(mu_sieve_yy_start) = 1;	/* first start state */

		if ( ! mu_sieve_yyin )
			mu_sieve_yyin = stdin;

		if ( ! mu_sieve_yyout )
			mu_sieve_yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			mu_sieve_yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				mu_sieve_yy_create_buffer(mu_sieve_yyin,YY_BUF_SIZE );
		}

		mu_sieve_yy_load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		mu_sieve_yy_cp = (mu_sieve_yy_c_buf_p);

		/* Support of mu_sieve_yytext. */
		*mu_sieve_yy_cp = (mu_sieve_yy_hold_char);

		/* mu_sieve_yy_bp points to the position in mu_sieve_yy_ch_buf of the start of
		 * the current run.
		 */
		mu_sieve_yy_bp = mu_sieve_yy_cp;

		mu_sieve_yy_current_state = (mu_sieve_yy_start);
mu_sieve_yy_match:
		do
			{
			register YY_CHAR mu_sieve_yy_c = mu_sieve_yy_ec[YY_SC_TO_UI(*mu_sieve_yy_cp)];
			if ( mu_sieve_yy_accept[mu_sieve_yy_current_state] )
				{
				(mu_sieve_yy_last_accepting_state) = mu_sieve_yy_current_state;
				(mu_sieve_yy_last_accepting_cpos) = mu_sieve_yy_cp;
				}
			while ( mu_sieve_yy_chk[mu_sieve_yy_base[mu_sieve_yy_current_state] + mu_sieve_yy_c] != mu_sieve_yy_current_state )
				{
				mu_sieve_yy_current_state = (int) mu_sieve_yy_def[mu_sieve_yy_current_state];
				if ( mu_sieve_yy_current_state >= 146 )
					mu_sieve_yy_c = mu_sieve_yy_meta[(unsigned int) mu_sieve_yy_c];
				}
			mu_sieve_yy_current_state = mu_sieve_yy_nxt[mu_sieve_yy_base[mu_sieve_yy_current_state] + (unsigned int) mu_sieve_yy_c];
			++mu_sieve_yy_cp;
			}
		while ( mu_sieve_yy_base[mu_sieve_yy_current_state] != 335 );

mu_sieve_yy_find_action:
		mu_sieve_yy_act = mu_sieve_yy_accept[mu_sieve_yy_current_state];
		if ( mu_sieve_yy_act == 0 )
			{ /* have to back up */
			mu_sieve_yy_cp = (mu_sieve_yy_last_accepting_cpos);
			mu_sieve_yy_current_state = (mu_sieve_yy_last_accepting_state);
			mu_sieve_yy_act = mu_sieve_yy_accept[mu_sieve_yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( mu_sieve_yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*mu_sieve_yy_cp = (mu_sieve_yy_hold_char);
			mu_sieve_yy_cp = (mu_sieve_yy_last_accepting_cpos);
			mu_sieve_yy_current_state = (mu_sieve_yy_last_accepting_state);
			goto mu_sieve_yy_find_action;

case 1:
YY_RULE_SETUP
#line 258 "sieve.l"
{ BEGIN(COMMENT); }
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 259 "sieve.l"
/* eat anything that's not a '*' */
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 260 "sieve.l"
/* eat up '*'s not followed by '/'s */
	YY_BREAK
case 4:
/* rule 4 can match eol */
YY_RULE_SETUP
#line 261 "sieve.l"
;
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 262 "sieve.l"
{ BEGIN (INITIAL); }
	YY_BREAK
/* Preprocessor directives (an extension) */
case 6:
/* rule 6 can match eol */
YY_RULE_SETUP
#line 264 "sieve.l"
{ sieve_include (); }
	YY_BREAK
case 7:
/* rule 7 can match eol */
YY_RULE_SETUP
#line 265 "sieve.l"
{ sieve_searchpath (); } 
	YY_BREAK
/* End-of-line comments */
case 8:
/* rule 8 can match eol */
YY_RULE_SETUP
#line 267 "sieve.l"
;
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 268 "sieve.l"
/* end-of-file comment */;
	YY_BREAK
/* Reserved words */
case 10:
YY_RULE_SETUP
#line 270 "sieve.l"
return REQUIRE; 
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 271 "sieve.l"
return IF;      
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 272 "sieve.l"
return ELSIF;  
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 273 "sieve.l"
return ELSE;    
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 274 "sieve.l"
return ANYOF;   
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 275 "sieve.l"
return ALLOF;   
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 276 "sieve.l"
return NOT;
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 277 "sieve.l"
return FALSE;
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 278 "sieve.l"
return TRUE;
	YY_BREAK
/* Identifiers */
case 19:
YY_RULE_SETUP
#line 280 "sieve.l"
{ ident (mu_sieve_yytext); return IDENT; } 
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 281 "sieve.l"
{ ident (mu_sieve_yytext + 1); return TAG; }
	YY_BREAK
/* Numbers */
case 21:
YY_RULE_SETUP
#line 283 "sieve.l"
{ return number (); }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 284 "sieve.l"
{ return number (); }
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 285 "sieve.l"
{ return number (); }
	YY_BREAK
/* Quoted strings */
case 24:
YY_RULE_SETUP
#line 287 "sieve.l"
{ return string (); }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 288 "sieve.l"
{ BEGIN(STR);
                    line_begin ();
  		    line_addz (str_unescape (mu_sieve_yytext + 1, mu_sieve_yyleng - 1)); }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 291 "sieve.l"
{ line_addz (str_unescape (mu_sieve_yytext, mu_sieve_yyleng)); }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 292 "sieve.l"
{ BEGIN(INITIAL);
                  if (mu_sieve_yyleng > 1) 
                     line_add (mu_sieve_yytext, mu_sieve_yyleng - 1); 
                   line_finish ();
		   return STRING; }
	YY_BREAK
/* Multiline strings */
case 28:
/* rule 28 can match eol */
YY_RULE_SETUP
#line 298 "sieve.l"
{ BEGIN(ML);
                           multiline_begin (); }
	YY_BREAK
case 29:
/* rule 29 can match eol */
YY_RULE_SETUP
#line 300 "sieve.l"
{ BEGIN(ML);
                           multiline_begin (); }
	YY_BREAK
case 30:
/* rule 30 can match eol */
YY_RULE_SETUP
#line 302 "sieve.l"
{ BEGIN(ML);
                               multiline_begin (); }
	YY_BREAK
case 31:
/* rule 31 can match eol */
YY_RULE_SETUP
#line 304 "sieve.l"
{ BEGIN(ML);
                               multiline_begin (); }
	YY_BREAK
case 32:
/* rule 32 can match eol */
YY_RULE_SETUP
#line 306 "sieve.l"
{ if (multiline_delimiter[0] == '\\')
                              multiline_add ();
                            else
                              sieve_include (); }
	YY_BREAK
case 33:
/* rule 33 can match eol */
YY_RULE_SETUP
#line 310 "sieve.l"
{ char *p = multiline_strip_tabs (mu_sieve_yytext);
	   
           if (strncmp (p, multiline_delimiter, strlen (multiline_delimiter))
	        == 0
	       && isemptystr (p + strlen (multiline_delimiter)))
	     {
	       free (multiline_delimiter);
	       multiline_delimiter = NULL;
	       BEGIN(INITIAL);
	       multiline_finish ();
	       return MULTILINE;
	     }
	    multiline_add (); } 
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 323 "sieve.l"
;
	YY_BREAK
/* Other tokens */
case 35:
/* rule 35 can match eol */
YY_RULE_SETUP
#line 325 "sieve.l"
;
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 326 "sieve.l"
return mu_sieve_yytext[0];
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 328 "sieve.l"
ECHO;
	YY_BREAK
#line 1325 "sieve-lex.c"
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(COMMENT):
case YY_STATE_EOF(ML):
case YY_STATE_EOF(STR):
	mu_sieve_yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int mu_sieve_yy_amount_of_matched_text = (int) (mu_sieve_yy_cp - (mu_sieve_yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*mu_sieve_yy_cp = (mu_sieve_yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->mu_sieve_yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed mu_sieve_yyin at a new source and called
			 * mu_sieve_yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(mu_sieve_yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->mu_sieve_yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->mu_sieve_yy_input_file = mu_sieve_yyin;
			YY_CURRENT_BUFFER_LVALUE->mu_sieve_yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for mu_sieve_yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since mu_sieve_yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (mu_sieve_yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->mu_sieve_yy_ch_buf[(mu_sieve_yy_n_chars)] )
			{ /* This was really a NUL. */
			mu_sieve_yy_state_type mu_sieve_yy_next_state;

			(mu_sieve_yy_c_buf_p) = (mu_sieve_yytext_ptr) + mu_sieve_yy_amount_of_matched_text;

			mu_sieve_yy_current_state = mu_sieve_yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * mu_sieve_yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			mu_sieve_yy_next_state = mu_sieve_yy_try_NUL_trans( mu_sieve_yy_current_state );

			mu_sieve_yy_bp = (mu_sieve_yytext_ptr) + YY_MORE_ADJ;

			if ( mu_sieve_yy_next_state )
				{
				/* Consume the NUL. */
				mu_sieve_yy_cp = ++(mu_sieve_yy_c_buf_p);
				mu_sieve_yy_current_state = mu_sieve_yy_next_state;
				goto mu_sieve_yy_match;
				}

			else
				{
				mu_sieve_yy_cp = (mu_sieve_yy_c_buf_p);
				goto mu_sieve_yy_find_action;
				}
			}

		else switch ( mu_sieve_yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(mu_sieve_yy_did_buffer_switch_on_eof) = 0;

				if ( mu_sieve_yywrap( ) )
					{
					/* Note: because we've taken care in
					 * mu_sieve_yy_get_next_buffer() to have set up
					 * mu_sieve_yytext, we can now set up
					 * mu_sieve_yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(mu_sieve_yy_c_buf_p) = (mu_sieve_yytext_ptr) + YY_MORE_ADJ;

					mu_sieve_yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (mu_sieve_yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(mu_sieve_yy_c_buf_p) =
					(mu_sieve_yytext_ptr) + mu_sieve_yy_amount_of_matched_text;

				mu_sieve_yy_current_state = mu_sieve_yy_get_previous_state(  );

				mu_sieve_yy_cp = (mu_sieve_yy_c_buf_p);
				mu_sieve_yy_bp = (mu_sieve_yytext_ptr) + YY_MORE_ADJ;
				goto mu_sieve_yy_match;

			case EOB_ACT_LAST_MATCH:
				(mu_sieve_yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->mu_sieve_yy_ch_buf[(mu_sieve_yy_n_chars)];

				mu_sieve_yy_current_state = mu_sieve_yy_get_previous_state(  );

				mu_sieve_yy_cp = (mu_sieve_yy_c_buf_p);
				mu_sieve_yy_bp = (mu_sieve_yytext_ptr) + YY_MORE_ADJ;
				goto mu_sieve_yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of mu_sieve_yylex */

/* mu_sieve_yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int mu_sieve_yy_get_next_buffer (void)
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->mu_sieve_yy_ch_buf;
	register char *source = (mu_sieve_yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (mu_sieve_yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->mu_sieve_yy_ch_buf[(mu_sieve_yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->mu_sieve_yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (mu_sieve_yy_c_buf_p) - (mu_sieve_yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((mu_sieve_yy_c_buf_p) - (mu_sieve_yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->mu_sieve_yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->mu_sieve_yy_n_chars = (mu_sieve_yy_n_chars) = 0;

	else
		{
			mu_sieve_yy_size_t num_to_read =
			YY_CURRENT_BUFFER_LVALUE->mu_sieve_yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int mu_sieve_yy_c_buf_p_offset =
				(int) ((mu_sieve_yy_c_buf_p) - b->mu_sieve_yy_ch_buf);

			if ( b->mu_sieve_yy_is_our_buffer )
				{
				mu_sieve_yy_size_t new_size = b->mu_sieve_yy_buf_size * 2;

				if ( new_size <= 0 )
					b->mu_sieve_yy_buf_size += b->mu_sieve_yy_buf_size / 8;
				else
					b->mu_sieve_yy_buf_size *= 2;

				b->mu_sieve_yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					mu_sieve_yyrealloc((void *) b->mu_sieve_yy_ch_buf,b->mu_sieve_yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->mu_sieve_yy_ch_buf = 0;

			if ( ! b->mu_sieve_yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(mu_sieve_yy_c_buf_p) = &b->mu_sieve_yy_ch_buf[mu_sieve_yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->mu_sieve_yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->mu_sieve_yy_ch_buf[number_to_move]),
			(mu_sieve_yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->mu_sieve_yy_n_chars = (mu_sieve_yy_n_chars);
		}

	if ( (mu_sieve_yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			mu_sieve_yyrestart(mu_sieve_yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->mu_sieve_yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((mu_sieve_yy_size_t) ((mu_sieve_yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->mu_sieve_yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		mu_sieve_yy_size_t new_size = (mu_sieve_yy_n_chars) + number_to_move + ((mu_sieve_yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->mu_sieve_yy_ch_buf = (char *) mu_sieve_yyrealloc((void *) YY_CURRENT_BUFFER_LVALUE->mu_sieve_yy_ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->mu_sieve_yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in mu_sieve_yy_get_next_buffer()" );
	}

	(mu_sieve_yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->mu_sieve_yy_ch_buf[(mu_sieve_yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->mu_sieve_yy_ch_buf[(mu_sieve_yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(mu_sieve_yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->mu_sieve_yy_ch_buf[0];

	return ret_val;
}

/* mu_sieve_yy_get_previous_state - get the state just before the EOB char was reached */

    static mu_sieve_yy_state_type mu_sieve_yy_get_previous_state (void)
{
	register mu_sieve_yy_state_type mu_sieve_yy_current_state;
	register char *mu_sieve_yy_cp;
    
	mu_sieve_yy_current_state = (mu_sieve_yy_start);

	for ( mu_sieve_yy_cp = (mu_sieve_yytext_ptr) + YY_MORE_ADJ; mu_sieve_yy_cp < (mu_sieve_yy_c_buf_p); ++mu_sieve_yy_cp )
		{
		register YY_CHAR mu_sieve_yy_c = (*mu_sieve_yy_cp ? mu_sieve_yy_ec[YY_SC_TO_UI(*mu_sieve_yy_cp)] : 1);
		if ( mu_sieve_yy_accept[mu_sieve_yy_current_state] )
			{
			(mu_sieve_yy_last_accepting_state) = mu_sieve_yy_current_state;
			(mu_sieve_yy_last_accepting_cpos) = mu_sieve_yy_cp;
			}
		while ( mu_sieve_yy_chk[mu_sieve_yy_base[mu_sieve_yy_current_state] + mu_sieve_yy_c] != mu_sieve_yy_current_state )
			{
			mu_sieve_yy_current_state = (int) mu_sieve_yy_def[mu_sieve_yy_current_state];
			if ( mu_sieve_yy_current_state >= 146 )
				mu_sieve_yy_c = mu_sieve_yy_meta[(unsigned int) mu_sieve_yy_c];
			}
		mu_sieve_yy_current_state = mu_sieve_yy_nxt[mu_sieve_yy_base[mu_sieve_yy_current_state] + (unsigned int) mu_sieve_yy_c];
		}

	return mu_sieve_yy_current_state;
}

/* mu_sieve_yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = mu_sieve_yy_try_NUL_trans( current_state );
 */
    static mu_sieve_yy_state_type mu_sieve_yy_try_NUL_trans  (mu_sieve_yy_state_type mu_sieve_yy_current_state )
{
	register int mu_sieve_yy_is_jam;
    	register char *mu_sieve_yy_cp = (mu_sieve_yy_c_buf_p);

	register YY_CHAR mu_sieve_yy_c = 1;
	if ( mu_sieve_yy_accept[mu_sieve_yy_current_state] )
		{
		(mu_sieve_yy_last_accepting_state) = mu_sieve_yy_current_state;
		(mu_sieve_yy_last_accepting_cpos) = mu_sieve_yy_cp;
		}
	while ( mu_sieve_yy_chk[mu_sieve_yy_base[mu_sieve_yy_current_state] + mu_sieve_yy_c] != mu_sieve_yy_current_state )
		{
		mu_sieve_yy_current_state = (int) mu_sieve_yy_def[mu_sieve_yy_current_state];
		if ( mu_sieve_yy_current_state >= 146 )
			mu_sieve_yy_c = mu_sieve_yy_meta[(unsigned int) mu_sieve_yy_c];
		}
	mu_sieve_yy_current_state = mu_sieve_yy_nxt[mu_sieve_yy_base[mu_sieve_yy_current_state] + (unsigned int) mu_sieve_yy_c];
	mu_sieve_yy_is_jam = (mu_sieve_yy_current_state == 145);

		return mu_sieve_yy_is_jam ? 0 : mu_sieve_yy_current_state;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int mu_sieve_yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(mu_sieve_yy_c_buf_p) = (mu_sieve_yy_hold_char);

	if ( *(mu_sieve_yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* mu_sieve_yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (mu_sieve_yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->mu_sieve_yy_ch_buf[(mu_sieve_yy_n_chars)] )
			/* This was really a NUL. */
			*(mu_sieve_yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			mu_sieve_yy_size_t offset = (mu_sieve_yy_c_buf_p) - (mu_sieve_yytext_ptr);
			++(mu_sieve_yy_c_buf_p);

			switch ( mu_sieve_yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because mu_sieve_yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					mu_sieve_yyrestart(mu_sieve_yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( mu_sieve_yywrap( ) )
						return EOF;

					if ( ! (mu_sieve_yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return mu_sieve_yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(mu_sieve_yy_c_buf_p) = (mu_sieve_yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (mu_sieve_yy_c_buf_p);	/* cast for 8-bit char's */
	*(mu_sieve_yy_c_buf_p) = '\0';	/* preserve mu_sieve_yytext */
	(mu_sieve_yy_hold_char) = *++(mu_sieve_yy_c_buf_p);

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void mu_sieve_yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        mu_sieve_yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            mu_sieve_yy_create_buffer(mu_sieve_yyin,YY_BUF_SIZE );
	}

	mu_sieve_yy_init_buffer(YY_CURRENT_BUFFER,input_file );
	mu_sieve_yy_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void mu_sieve_yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		mu_sieve_yypop_buffer_state();
	 *		mu_sieve_yypush_buffer_state(new_buffer);
     */
	mu_sieve_yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(mu_sieve_yy_c_buf_p) = (mu_sieve_yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->mu_sieve_yy_buf_pos = (mu_sieve_yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->mu_sieve_yy_n_chars = (mu_sieve_yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	mu_sieve_yy_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (mu_sieve_yywrap()) processing, but the only time this flag
	 * is looked at is after mu_sieve_yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(mu_sieve_yy_did_buffer_switch_on_eof) = 1;
}

static void mu_sieve_yy_load_buffer_state  (void)
{
    	(mu_sieve_yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->mu_sieve_yy_n_chars;
	(mu_sieve_yytext_ptr) = (mu_sieve_yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->mu_sieve_yy_buf_pos;
	mu_sieve_yyin = YY_CURRENT_BUFFER_LVALUE->mu_sieve_yy_input_file;
	(mu_sieve_yy_hold_char) = *(mu_sieve_yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE mu_sieve_yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) mu_sieve_yyalloc(sizeof( struct mu_sieve_yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in mu_sieve_yy_create_buffer()" );

	b->mu_sieve_yy_buf_size = size;

	/* mu_sieve_yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->mu_sieve_yy_ch_buf = (char *) mu_sieve_yyalloc(b->mu_sieve_yy_buf_size + 2  );
	if ( ! b->mu_sieve_yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in mu_sieve_yy_create_buffer()" );

	b->mu_sieve_yy_is_our_buffer = 1;

	mu_sieve_yy_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with mu_sieve_yy_create_buffer()
 * 
 */
    void mu_sieve_yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->mu_sieve_yy_is_our_buffer )
		mu_sieve_yyfree((void *) b->mu_sieve_yy_ch_buf  );

	mu_sieve_yyfree((void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a mu_sieve_yyrestart() or at EOF.
 */
    static void mu_sieve_yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	mu_sieve_yy_flush_buffer(b );

	b->mu_sieve_yy_input_file = file;
	b->mu_sieve_yy_fill_buffer = 1;

    /* If b is the current buffer, then mu_sieve_yy_init_buffer was _probably_
     * called from mu_sieve_yyrestart() or through mu_sieve_yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->mu_sieve_yy_bs_lineno = 1;
        b->mu_sieve_yy_bs_column = 0;
    }

        b->mu_sieve_yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void mu_sieve_yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->mu_sieve_yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->mu_sieve_yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->mu_sieve_yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->mu_sieve_yy_buf_pos = &b->mu_sieve_yy_ch_buf[0];

	b->mu_sieve_yy_at_bol = 1;
	b->mu_sieve_yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		mu_sieve_yy_load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void mu_sieve_yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	mu_sieve_yyensure_buffer_stack();

	/* This block is copied from mu_sieve_yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(mu_sieve_yy_c_buf_p) = (mu_sieve_yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->mu_sieve_yy_buf_pos = (mu_sieve_yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->mu_sieve_yy_n_chars = (mu_sieve_yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(mu_sieve_yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from mu_sieve_yy_switch_to_buffer. */
	mu_sieve_yy_load_buffer_state( );
	(mu_sieve_yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void mu_sieve_yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	mu_sieve_yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((mu_sieve_yy_buffer_stack_top) > 0)
		--(mu_sieve_yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		mu_sieve_yy_load_buffer_state( );
		(mu_sieve_yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void mu_sieve_yyensure_buffer_stack (void)
{
	mu_sieve_yy_size_t num_to_alloc;
    
	if (!(mu_sieve_yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(mu_sieve_yy_buffer_stack) = (struct mu_sieve_yy_buffer_state**)mu_sieve_yyalloc
								(num_to_alloc * sizeof(struct mu_sieve_yy_buffer_state*)
								);
		if ( ! (mu_sieve_yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in mu_sieve_yyensure_buffer_stack()" );
								  
		memset((mu_sieve_yy_buffer_stack), 0, num_to_alloc * sizeof(struct mu_sieve_yy_buffer_state*));
				
		(mu_sieve_yy_buffer_stack_max) = num_to_alloc;
		(mu_sieve_yy_buffer_stack_top) = 0;
		return;
	}

	if ((mu_sieve_yy_buffer_stack_top) >= ((mu_sieve_yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (mu_sieve_yy_buffer_stack_max) + grow_size;
		(mu_sieve_yy_buffer_stack) = (struct mu_sieve_yy_buffer_state**)mu_sieve_yyrealloc
								((mu_sieve_yy_buffer_stack),
								num_to_alloc * sizeof(struct mu_sieve_yy_buffer_state*)
								);
		if ( ! (mu_sieve_yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in mu_sieve_yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((mu_sieve_yy_buffer_stack) + (mu_sieve_yy_buffer_stack_max), 0, grow_size * sizeof(struct mu_sieve_yy_buffer_state*));
		(mu_sieve_yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE mu_sieve_yy_scan_buffer  (char * base, mu_sieve_yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) mu_sieve_yyalloc(sizeof( struct mu_sieve_yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in mu_sieve_yy_scan_buffer()" );

	b->mu_sieve_yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->mu_sieve_yy_buf_pos = b->mu_sieve_yy_ch_buf = base;
	b->mu_sieve_yy_is_our_buffer = 0;
	b->mu_sieve_yy_input_file = 0;
	b->mu_sieve_yy_n_chars = b->mu_sieve_yy_buf_size;
	b->mu_sieve_yy_is_interactive = 0;
	b->mu_sieve_yy_at_bol = 1;
	b->mu_sieve_yy_fill_buffer = 0;
	b->mu_sieve_yy_buffer_status = YY_BUFFER_NEW;

	mu_sieve_yy_switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to mu_sieve_yylex() will
 * scan from a @e copy of @a str.
 * @param mu_sieve_yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       mu_sieve_yy_scan_bytes() instead.
 */
YY_BUFFER_STATE mu_sieve_yy_scan_string (mu_sieve_yyconst char * mu_sieve_yystr )
{
    
	return mu_sieve_yy_scan_bytes(mu_sieve_yystr,strlen(mu_sieve_yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to mu_sieve_yylex() will
 * scan from a @e copy of @a bytes.
 * @param mu_sieve_yybytes the byte buffer to scan
 * @param _mu_sieve_yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE mu_sieve_yy_scan_bytes  (mu_sieve_yyconst char * mu_sieve_yybytes, mu_sieve_yy_size_t  _mu_sieve_yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	mu_sieve_yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _mu_sieve_yybytes_len + 2;
	buf = (char *) mu_sieve_yyalloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in mu_sieve_yy_scan_bytes()" );

	for ( i = 0; i < _mu_sieve_yybytes_len; ++i )
		buf[i] = mu_sieve_yybytes[i];

	buf[_mu_sieve_yybytes_len] = buf[_mu_sieve_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = mu_sieve_yy_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in mu_sieve_yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->mu_sieve_yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void mu_sieve_yy_fatal_error (mu_sieve_yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine mu_sieve_yyless() so it works in section 3 code. */

#undef mu_sieve_yyless
#define mu_sieve_yyless(n) \
	do \
		{ \
		/* Undo effects of setting up mu_sieve_yytext. */ \
        int mu_sieve_yyless_macro_arg = (n); \
        YY_LESS_LINENO(mu_sieve_yyless_macro_arg);\
		mu_sieve_yytext[mu_sieve_yyleng] = (mu_sieve_yy_hold_char); \
		(mu_sieve_yy_c_buf_p) = mu_sieve_yytext + mu_sieve_yyless_macro_arg; \
		(mu_sieve_yy_hold_char) = *(mu_sieve_yy_c_buf_p); \
		*(mu_sieve_yy_c_buf_p) = '\0'; \
		mu_sieve_yyleng = mu_sieve_yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int mu_sieve_yyget_lineno  (void)
{
        
    return mu_sieve_yylineno;
}

/** Get the input stream.
 * 
 */
FILE *mu_sieve_yyget_in  (void)
{
        return mu_sieve_yyin;
}

/** Get the output stream.
 * 
 */
FILE *mu_sieve_yyget_out  (void)
{
        return mu_sieve_yyout;
}

/** Get the length of the current token.
 * 
 */
mu_sieve_yy_size_t mu_sieve_yyget_leng  (void)
{
        return mu_sieve_yyleng;
}

/** Get the current token.
 * 
 */

char *mu_sieve_yyget_text  (void)
{
        return mu_sieve_yytext;
}

/** Set the current line number.
 * @param line_number
 * 
 */
void mu_sieve_yyset_lineno (int  line_number )
{
    
    mu_sieve_yylineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see mu_sieve_yy_switch_to_buffer
 */
void mu_sieve_yyset_in (FILE *  in_str )
{
        mu_sieve_yyin = in_str ;
}

void mu_sieve_yyset_out (FILE *  out_str )
{
        mu_sieve_yyout = out_str ;
}

int mu_sieve_yyget_debug  (void)
{
        return mu_sieve_yy_flex_debug;
}

void mu_sieve_yyset_debug (int  bdebug )
{
        mu_sieve_yy_flex_debug = bdebug ;
}

static int mu_sieve_yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from mu_sieve_yylex_destroy(), so don't allocate here.
     */

    (mu_sieve_yy_buffer_stack) = 0;
    (mu_sieve_yy_buffer_stack_top) = 0;
    (mu_sieve_yy_buffer_stack_max) = 0;
    (mu_sieve_yy_c_buf_p) = (char *) 0;
    (mu_sieve_yy_init) = 0;
    (mu_sieve_yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    mu_sieve_yyin = stdin;
    mu_sieve_yyout = stdout;
#else
    mu_sieve_yyin = (FILE *) 0;
    mu_sieve_yyout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * mu_sieve_yylex_init()
     */
    return 0;
}

/* mu_sieve_yylex_destroy is for both reentrant and non-reentrant scanners. */
int mu_sieve_yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		mu_sieve_yy_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		mu_sieve_yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	mu_sieve_yyfree((mu_sieve_yy_buffer_stack) );
	(mu_sieve_yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * mu_sieve_yylex() is called, initialization will occur. */
    mu_sieve_yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef mu_sieve_yytext_ptr
static void mu_sieve_yy_flex_strncpy (char* s1, mu_sieve_yyconst char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int mu_sieve_yy_flex_strlen (mu_sieve_yyconst char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *mu_sieve_yyalloc (mu_sieve_yy_size_t  size )
{
	return (void *) malloc( size );
}

void *mu_sieve_yyrealloc  (void * ptr, mu_sieve_yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void mu_sieve_yyfree (void * ptr )
{
	free( (char *) ptr );	/* see mu_sieve_yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "mu_sieve_yytables"

#line 328 "sieve.l"



int
mu_sieve_yywrap ()
{
  return pop_source();
}

static char *
get_file_name (char *p, char *endp, int *usepath)
{
  char exp, *name, *startp;
  int n;
  
  if (usepath)
    *usepath = 0;
  switch (*p)
    {
    case '"':
      exp = '"';
      break;

    case '<':
      exp = '>';
      if (usepath)
	*usepath = 1;
      break;

    default:
      mu_sieve_yyerror (_("preprocessor syntax"));
      return NULL;
    }

  for (startp = ++p; p < endp && *p != exp; p++)
    ;

  if (*p != exp)
    {
      mu_sieve_yyerror (_("missing closing quote in preprocessor statement"));
      return NULL;
    }
  
  n = p - startp;
  name = mu_sieve_malloc (mu_sieve_machine, n + 1);
  memcpy (name, startp, n);
  name[n] = 0;
  return name;
}

static int
_try_include (void *item, void *data)
{
  char **dir = data;
  char *name = mu_make_file_name ((char*) item, *dir);

  if (!name)
    {
      mu_diag_funcall (MU_DIAG_ERROR, "mu_make_file_name", NULL, ENOMEM);
      return 0;
    }
  if (access (name, R_OK) == 0)
    {
      *(char**) data = name;
      return 1;
    }
  free (name);
  return 0;
}

static void
sieve_include (void)
{
  char *p, *endp = mu_sieve_yytext + mu_sieve_yyleng, *name;
  int usepath;
  
  p = strstr (mu_sieve_yytext, "include");
  for (p += 7; p < endp && mu_isspace (*p); p++)
    ;

  name = get_file_name (p, endp, &usepath);
  if (!name)
    return;
  
  if (usepath && name[0] != '/' && memcmp (name, "..", 2))
    {
      char *p = name;
      if (mu_sieve_include_path
	  && mu_list_foreach (mu_sieve_include_path, _try_include, &p))
	{
	  push_source (p);
	  mu_sieve_free (mu_sieve_machine, name);
	  free (p);
	  return;
	}
    }

  push_source (name);
  mu_sieve_free (mu_sieve_machine, name);
}

static void
sieve_searchpath (void)
{
  char *p, *endp = mu_sieve_yytext + mu_sieve_yyleng, *name;
  
  p = strstr (mu_sieve_yytext, "searchpath");
  for (p += 10; p < endp && mu_isspace (*p); p++)
    ;
  name = get_file_name (p, endp, NULL);
  if (name)
    {
      mu_i_sv_load_add_dir (mu_sieve_machine, name);
      mu_sieve_free (mu_sieve_machine, name);
    }
}

int
mu_i_sv_lex_begin (const char *name)
{
  return push_source (name);
}

int
mu_i_sv_lex_begin_string (const char *buf, int bufsize,
			  const char *fname, int line)
{
  int rc;
  
  if (!fname)
    return 1;
  mu_sieve_yyrestart (NULL);

  rc = mu_static_memory_stream_create (&input_stream, buf, bufsize);
  if (rc)
    {
      mu_diag_funcall (MU_DIAG_ERROR, "mu_static_memory_stream_create",
		       NULL, rc);
      return 1;
    }

  init_locus (fname, 0);

  return 0;
}

void
mu_i_sv_lex_finish (void)
{
  while (pop_source () == 0)
    ;
}
  
static int
number ()
{
  char *p;
  mu_sieve_yylval.number = strtoul (mu_sieve_yytext, &p, 0);
  switch (*p)
    {
    case 'k':
    case 'K':
      mu_sieve_yylval.number *= 1024L;
      break;
      
    case 'm':
    case 'M':
      mu_sieve_yylval.number *= 1024*1024L;
      break;
      
    case 'g':
    case 'G':
      mu_sieve_yylval.number *= 1024*1024*1024L;
    }
  return NUMBER;
}

static int
string (void)
{
  line_begin ();
  line_add (mu_sieve_yytext + 1, mu_sieve_yyleng - 2);
  line_finish ();
  return STRING; 
}

static int
isemptystr (char *text)
{
  for (; *text && mu_isspace (*text); text++)
    ;
  return *text == 0;
}

static char *
multiline_strip_tabs (char *text)
{
  if (strip_tabs)
    for (; *text == '\t'; text++)
      ;
  return text;
}

static void
line_add (char const *text, size_t len)
{
  mu_opool_append (mu_sieve_machine->string_pool, text, len);
}

static void
line_addz (char const *text)
{
  mu_opool_appendz (mu_sieve_machine->string_pool, text);
}

static void
multiline_add (void)
{
  mu_opool_appendz (mu_sieve_machine->string_pool,
		    multiline_strip_tabs (mu_sieve_yytext));
}

static void
line_begin (void)
{
  /* nothing */
}

static void
multiline_begin (void)
{
  char *p = mu_sieve_yytext + 5; /* past the text: keyword */

  if (*p == '-')
    {
      strip_tabs = 1;
      p++;
    }
  else
    strip_tabs = 0;

  if (!mu_isspace (*p))
    {
      char *endp;
      int len;
      
      for (endp = p; *endp; endp++)
	if (mu_isspace (*endp))
	  break;

      len = endp - p;
      multiline_delimiter = mu_sieve_malloc (mu_sieve_machine, len + 1);
      memcpy (multiline_delimiter, p, len);
      multiline_delimiter[len] = 0;
    }
  else
    {
      multiline_delimiter = strdup (".");
      if (!multiline_delimiter)
	{
	  mu_sieve_yyerror (_("not enough memory"));
	  exit (1);
	}
    }

  line_begin ();
}

static void
multiline_finish (void)
{
  line_finish ();
}

static void
ident (const char *text)
{
  mu_sieve_yylval.string = strdup (text);
  if (!mu_sieve_yylval.string)
    {
      mu_sieve_yyerror (_("not enough memory"));
      exit (1);
    }
}

/* Escapes the last character from mu_sieve_yytext */
static char *
str_unescape (char *text, size_t len)
{
  char *str = mu_sieve_malloc (mu_sieve_machine, len);
  memcpy (str, text, len - 2);
  str[len - 2] = mu_wordsplit_c_unquote_char (text[len - 1]);
  str[len - 1] = 0;
  return str;
}

static mu_i_sv_interp_t string_interpreter;

static void
line_finish (void)
{
  char *str;
  
  mu_opool_append_char (mu_sieve_machine->string_pool, 0);
  str = mu_opool_finish (mu_sieve_machine->string_pool, NULL);
  if (string_interpreter)
    {
      char *exp;
      int rc = mu_i_sv_string_expand (str, string_interpreter, NULL, &exp);
      if (rc == 0)
	{
	  mu_opool_free (mu_sieve_machine->string_pool, str);
	  mu_opool_appendz (mu_sieve_machine->string_pool, exp);
	  mu_opool_append_char (mu_sieve_machine->string_pool, 0);
	  free (exp);
	  str = mu_opool_finish (mu_sieve_machine->string_pool, NULL);
	}
      else if (rc != MU_ERR_CANCELED)
	{
	  mu_diag_at_locus (MU_LOG_ERROR, &mu_sieve_locus,
			    _("error expandind string: %s"),
			    mu_strerror (rc));
	}
    }
  mu_sieve_yylval.string = str;
}

int
mu_sieve_require_encoded_character (mu_sieve_machine_t mach,
				    const char *name)
{
  string_interpreter = mu_i_sv_expand_encoded_char;
  return 0;
}

