/*
 * This file is part of the coreboot project.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

/*
 * This is the original bootblock used by coreboot on x86 systems. It contains
 * a monolithic code flow, assembled from the following stages:
 *     - reset16.inc: the reset vector
 *     - entry16.inc: protected mode setup
 *     - entry32.inc: segment descriptor setup
 *     - timestamp.inc: store TSC in MMX registers
 *     - generated/bootblock.inc: ROMCC part of the bootblock
 *
 * This is used on platforms which do not select C_ENVIRONMENT_BOOTBLOCK, and it
 * tries to do the absolute minimum before walking CBFS and jumping to romstage.
 *
 * This file assembles the bootblock program by the order of the includes. Thus,
 * it's extremely important that one pays very careful attention to the order
 * of the includes.
 */

#include <arch/x86/prologue.inc>
#include <cpu/x86/16bit/entry16.inc>
#include <cpu/x86/16bit/reset16.inc>
#include <cpu/x86/32bit/entry32.inc>

#include <arch/x86/timestamp.inc>

#if CONFIG(SSE)
#include <cpu/x86/sse_enable.inc>
#endif

/*
 * This bootblock.inc file is generated by ROMCC. The above program flow
 * falls through to this point. ROMCC assumes the last function it parsed
 * is the main function and it places its instructions at the beginning of
 * the generated file. Moreover, any library/common code needed in bootblock
 * needs to come after bootblock.inc.
 */
#include <generated/bootblock.inc>
