/*  

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

Portions of the src code for X-Windows in this application
fall under an MIT copyright.

Copyright 1985, Massachusetts Institute of Technology
*/
/***************************************************************************
**
**    This file contains the various utilities required by sgmpxperfmon.c
** Most of the routines are from xperfmon.c
**
***************************************************************************/
#include  "sgmpxperfmon.h"

/*
 *                     usage();
 * Prints the the method of invoking sgmpxperfmon.
 */

 usage()
 {
	printf(
  "Usage :\n sgmpxperfmon <-s session> gateway <input><output><bytes><packets> options ... \n");
	printf("\toptions ::\n");
	printf("\t\t  host:display\n");
	printf("\t\t =geometry\n");
	printf("\t\t -rv (-reverse)\n");
	printf("\t\t -bw (-border) width\n");
	printf("\t\t -fn (-font) font\n");
	printf("\t\t -bd (-color) color\n");
	printf("\t\t -fg (-foreground) foreground\n");
	printf("\t\t -bg (-background) background\n");
	printf("\t\t -hl (-highlight) highlight\n");
	printf("\t\t -u  (-update) update\n");
	printf("\t\t -s  (-session) sesssion\n");
	printf("\t\t -in#(-interface#) internet address\n");
 
	exit(1);



}


/*
 *			getopt(to_matched, table)
 * This routine identifies the options and prefixes. The options being :
 *   'bytes', 'input','output', 'packets' and their prefixes.
 *
 */

 getopt(to_match,table) 
 register char *to_match;
 register char **table;

 {

	register char *p, *q;
	int found, index, nmatches, longest;

	longest = nmatches = 0;
	found = index = -1;
	for (p = *table; p; p = *(++table))
		{ index++;
		  for (q = to_match; *q == *p++; q++)
			if (*q == 0)       /* is it an exact match? */
				return(index);
			if(!*q)           /* it could be a prefix */
				{ if (q - to_match > longest)
					{ longest = q - to_match;
					  nmatches = 1;
					  found = index;
					}
				   else if (q - to_match == longest)
					   nmatches++;
				}
		}
 	if (nmatches > 1)
		return(-1);
	return(found);
 }

				

/*
 *			init_stat(interface,index,maxval,label_2)
 * This routine initializes the various statistics to be
 * displayed.
 *
 */

 init_stat(interface,index, maxval, label_2)
 int interface,index, maxval;
 char *label_2;
 {
  int i,j,ptr;

	if (interface == ALL_INTERFACE) /* then life is a bit easy !*/
		{ for ( i = 0; i < default_interface_num; i++)
		    
		     /* the function get_interface_info would have
		      * filled in the relevant data : type,status
 		      *	and the number of the interface. No checking
		      * needs to be done against the numbers specified
 		      * by the user.
		      */
			/* fill in the rest of the data */
		    initialize(index,i,maxval);
		 }
	   
		else /* cater to the user specified interface's only */
		  {for( j = 0; j < interface; j++)	
			{ptr = possible_interface[j].index;
			 initialize(index,ptr,maxval);
		   	}
		   }
                   
 }		  			

/* This funtion initializes the various data in the structure
 *
 */

  initialize(index,number,maxval)
  int index,number,maxval;
  {
		switch(index) {
	
			case input:
				stats[number].packets_in.label_1 = "Input";
				stats[number].bytes_in.label_1 = "Input";
			      break;
	
			case output:
				stats[number].packets_out.label_1 = "Output";
				stats[number].bytes_out.label_1 = "Output";
			      break;	

			case bytes:
				stats[number].bytes_in.max_val = maxval;
				stats[number].bytes_out.max_val = maxval;
				stats[number].bytes_in.label_2 = "Bytes";
				stats[number].bytes_out.label_2 = "Bytes";
			     break;	
			       
			case packets :
				stats[number].packets_in.max_val = maxval;
				stats[number].packets_out.max_val = maxval;
				stats[number].packets_in.label_2 = "Packets";
				stats[number].packets_out.label_2 = "Packets";
			    break;


			    }

				  
   }	
				   



