/*  

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

Portions of the src code for X-Windows in this application
fall under an MIT copyright.

Copyright 1985, Massachusetts Institute of Technology
*/
/* sgmp include */
#include "sgmp.h"
#include "varcvt.h"
/* For the X Windows */
#include <X/Xlib.h>
#include <netdb.h>

/* some definitions */

#define		DEFAULT_BORDER_WIDTH	3 
#define 	DEFAULT_POSITION	"=%dx%d-0+0"
#define		MAX_GW_INTERFACE	10	/* Can be any value */	
#define		NUM_POSSIBLE_STATS	4
#define		MAX_STATS		4
#define		TIMEOUT1		30 /* for _GW_cfg_nnets */
#define		TIMEOUT2		30 /*status and type of interface*/
#define         TIMEOUT3                60 /* for collection of data*/
#define		USEC_INC		0/* micro sec increment */
#define		SEC_INC			1    /* sec increment */
#define		NO_RESPONSE		-2


/* for the statistics to be displayed */

#define		ALL_INTERFACE		0	
#define		NO_STAT			0
#define		NUM_VALS_PER		1000
#define		CHECK_STATUS		20
#define		NUMBFLAG		10
#define		TYPEFLAG		11
#define		DATAFLAG		12	
#define 	IFNUMBFLAG		13
#define         SECS_PER_TIME_TICK      30
#define		bytes			0
#define		input			1
#define		output			2
#define		packets			3

/* Defines the maximum limits of the quantities displayed */

#define		MAX_BYTES		30000
#define		MAX_PACKETS		500

/*char *options[NUM_POSSIBLE_STATS +1] = {
		"input","output","bytes","packets",0};*/

char *gateway_numb;		/* gateway to be monitored */
extern int possible_stats[NUM_POSSIBLE_STATS];
typedef struct _possible_interface {
				    char *number;
				    int index;
				   }possible_interface_type;
extern possible_interface_type possible_interface[MAX_GW_INTERFACE];
extern int interface_num;          /* number of interfaces to be monitored 
				    * as specified by user.If none are 
				    * specified data of all the interfaces
				    * upto a maximum of 10 are displayed .
				    */
extern int default_interface_num;
extern int actual_number;
struct statistics {
		int	 min_val;
		int 	 max_val;
		int	 old;
		int	 value[NUM_VALS_PER];
		char	 *label_1,*label_2;
		  };
 
typedef struct _interface_stat {
					char			*number;
					char			*name;
					char			*type;
					char			*status;
					char			*title;
					struct statistics	packets_in;
					struct statistics	packets_out;
					struct statistics	bytes_in;
					struct statistics	bytes_out;	
		      }interface_stat;
extern interface_stat stats[MAX_GW_INTERFACE];

extern int num_of_val;		/* value being plotted */
extern int want_IP,want_OP,want_IB,want_OB;
extern int update_value;
extern int next_display();
