/*  

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

Portions of the src code for X-Windows in this application
fall under an MIT copyright.

Copyright 1985, Massachusetts Institute of Technology
*/
/*****************************************************************************
**                      	sgmpxperfmon.c
**
**	This is the 'main' program for the sgmpxperfmon. Part of the code has
** taken from 'xperfmon' application.
**  
** NOTE:: Currently the application requests data for all the interfaces
**        on the GW,even if only ONE interface is specified. This is due
**	  to the inability of requesting for a specific interface number.
**	  (as per the protocol weget the next variable on the list)
******************************************************************************/

#include "sgmpxperfmon.h"
/* Statistics of interfaces on a gateway are stored in
 * stats[k].statistics
 */
#define FORALLPOSSIBLESTATS(stat)\
	for (stat = 0; stat < NUM_POSSIBLE_STATS; stat ++)
#define FORALLPOSSIBLEINTER(interf)\
	for (interf = 0; interf < MAX_GW_INTERFACE; interf++)
#define max(a,b)	((a)>(b)? (a):(b))
#define min(a,b)        ((a)>(b)? (b):(a))
char *font_name = "6x10";		   	/* default font */
int interface_num = ALL_INTERFACE;		/*number of interfaces */
int default_interface_num ;		   /* numb. interface on GW */
int IB,IP,OB,OP,BP,IO;
int IBP,IOP,IOB,OBP;
int want_IP,want_OP,want_IB,want_OB;
int background;				    /* color of background*/
int foreground;				    /* color of graph */
int highlight;				    /* color of text,scale */
int border_width = DEFAULT_BORDER_WIDTH;    /* The border width */
int minheight;				    /* min. height of window */
int minwidth;				    /* min. widht of window */
int possible_stats[NUM_POSSIBLE_STATS];      /* user requested statistics */
int reverse = 0;			    /* video option */
int update_value = SEC_INC;		    /*for adjusting values */
int num_of_val;				    /* the number of the value*/
static char do_time[NUM_VALS_PER];                  /*for tick marks */ 
int debug;                                  /* for debuging purposes */
int actual_number;                          /* actual number of interfaces*/
char *display = NULL;			    /* The display server */
char def[32];				    /* position of the graph*/
char *option;				    /* for default options */
char *session;                              /* the session name */
possible_interface_type possible_interface[MAX_GW_INTERFACE];
					   /*user requested interface numb*/
interface_stat stats[MAX_GW_INTERFACE];	    /* interface statistics*/
static int num_stats;			   /* for user specific stats. */
static int graph_x_offset;		    /* offset,x axis */
static struct timeval saved_time,current_time; 	    /* time recording*/
static struct timezone dummy_zone;         /* time recording */
static struct timeval timeout = {	    /* for the timer */
				SEC_INC,
				USEC_INC
		                };
FontInfo *finfo;			   /* font info. needed */
Window Win;				   /* the window to be created */
int next_display();
OpaqueFrame	win;

short gray_bits[16] = {
	0xaaaa, 0x55555, 0xaaaa, 0x55555,
	0xaaaa, 0x55555, 0xaaaa, 0x55555,
	0xaaaa, 0x55555, 0xaaaa, 0x55555,
	0xaaaa, 0x55555, 0xaaaa, 0x55555};

/* These are the additional options available.
 * NOTE : DO NOT change the order of this. ELSE it will effect the 
 * data collection in 'sgmpxgetinfo.c'
 * If you have to change the the values, do it in the sgmpxperfmon.h file.
 *
 */
char *options[NUM_POSSIBLE_STATS + 1] = {
		"bytes","input","output","packets",0};

main(argc,argv)
int argc;
char **argv;
{
double update = -1.;			    /* frequency of updating */
double atof();
int opt;				    /* option index */
int i,k;					    /* counter */
int Select_mask,select_mask = 0;	    /* for masking */
int maxplus1;				    /* for select syscall */
int val = 2;
char *back_color;			    /* background color */
char *fore_color;			    /* foreground color */
char *border_color;			    /* border color */
char *high_color; 			    /* hightlighting color */
char *geometry = NULL;				    /* location of window */
struct timeval timeleft;		    /* for timing purposes */
Color cdef;				    /* For use of color monitors */
Pixmap border_pixmap;

	if (( session = (char *)malloc(sizeof (char) * 20)) == NULL)
		{ fprintf(stderr,"SGMPX :: Could not allocate memory,						...exiting\n");
		 exit(1);
		}
	strcpy(session,"public");
	if(argc < 3) usage();
	if(argv[1][0] == '-' && argv[1][1] != 's') usage();
	else if(argv[1][0] == '-')
	 {strcpy(session,"");
	  strcpy(session,argv[2]);
	  val = 4;
	 }
	

	/* Get the user specified options */

	if ((option = XGetDefault(argv[0],"ReverseVideo")) != NULL)
		if(strcmp(option, "on") == 0)
		reverse = 1;
	if ((option = XGetDefault(argv[0],"BorderWidth")) != NULL)
		border_width = atoi(option);
	if ((option = XGetDefault(argv[0],"BodyFont")) != NULL)
		font_name = option;
	if ((border_color = XGetDefault(argv[0],"Border")) == NULL)
		border_color = XGetDefault(argv[0],"Bordercolor");
	back_color = XGetDefault(argv[0],"Background");
	fore_color = XGetDefault(argv[0],"Foreground");
	high_color = XGetDefault(argv[0],"Highlight");
	if ((option = XGetDefault(argv[0], "Update")) != NULL)
		update_value = update = atof(option);

	/* parse command line and read options */

	/* The gateway to be monitored */
	if (( gateway_numb = (char *)malloc(sizeof (char) * 20)) == NULL)
		{ fprintf(stderr,"SGMPX :: Could not allocate memory,						...exiting\n");
		 exit(1);
		}
	if(argv[1][0] == '-')
	gateway_numb = argv[3];
	else
	gateway_numb = argv[1];
	/* initialize the various statistics to default*/
	FORALLPOSSIBLESTATS(i)	
		possible_stats[i] = NO_STAT;

	/* initialize the interface numbers */
	FORALLPOSSIBLEINTER(i)
		possible_interface[i].number = NULL;
	
	/* the options */	
	for (i = val; i < argc; i++)
	{
		if (argv[i][0] == '=')		   /* the geometry */
			{ geometry = argv[i];
			  continue;
			}

		if (index(argv[i], ':') != NULL)   /* host:display */
			{ display = argv[i];
			  continue;
			}

		if (strcmp(argv[i], "-rv") == 0 || /* black on white */
		strcmp(argv[i], "-reverse") == 0)
			{ reverse = 1;
			  continue;
			}

		if (strcmp(argv[i], "-bw") == 0 || /* border width */
		strcmp(argv[i], "-border") == 0)
		 	{if ( ++i >= argc) usage(); 
			 border_width = atoi(argv[i]);
			  continue;
		        }	
		if (strcmp(argv[i], "-fn") == 0 || /* name font */
		strcmp(argv[i], "-font") == 0)
			{ if (++i >= argc) usage();
			  font_name = argv[i];
			  continue;
			}	
	
		if (strcmp(argv[i], "-bd") == 0 ||  /* border color */
 		strcmp(argv[i], "-color") == 0)
			{ if (++i >= argc) usage();
			  border_color = argv[i];
			  continue;
			}

		if (strcmp(argv[i], "-fg") == 0 ||  /* foreground color*/
		strcmp(argv[i], "-foreground") == 0)
			{ if(++i >= argc) usage();
		 	  fore_color = argv[i];
			  continue;
			}
		
	 	if (strcmp(argv[i], "-bg") == 0 ||   /* background color */
		strcmp(argv[i], "-background") == 0)
			{ if(++i >= argc) usage();
			  back_color = argv[i];
			  continue;
			}

		if (strcmp(argv[i], "-hl") == 0 ||   /* highlight color */
		strcmp(argv[i], "-highlight") == 0)
			{ if (++i >= argc) usage();
			  high_color = argv[i];
			  continue;
			}

		if (strcmp(argv[i], "-u") == 0 ||     /* update interval */
		strcmp(argv[i], "-update") == 0)
			{ if (++i >= argc) usage();
			  update_value = update = atof(argv[i]);
			  continue;
			}
                if(strcmp(argv[i], "-s") == 0 ||     /* session name */
                strcmp(argv[i],"-session") == 0)
                        {if(++i >= argc) usage();
                         strcpy(session,argv[i]);
                         continue;    
                        }       

		if (strcmp(argv[i], "-in#") == 0 ||  /* interface number */
		strcmp(argv[i], "-interface#") == 0)
			{ if(++i >= argc) usage();
			if((possible_interface[interface_num].number =
			   (char *)malloc(sizeof(char) * 20) ) == NULL)
				{  fprintf(stderr,
				 "SGMPX:Cannot allocate memory space...\n");
					exit(1);
				}
			strcpy(possible_interface[interface_num++].number,
								argv[i]);
			if(interface_num > MAX_GW_INTERFACE)
			 {
			fprintf(stderr,
    		       "SGMPX: Sorry! Cannot display data for %d interfaces\n",
				interface_num);
			exit(1);
			 }
			continue;
			}

		opt = getopt(argv[i],options);
		if(opt < 0)
	        fprintf(stderr,"SGMPX :: Unknown option, %s\n",argv[i]);
	       
 		if (opt >= 0 &&opt < NUM_POSSIBLE_STATS) 
			{ if (num_stats == MAX_STATS)
			   fprintf( stderr,
			"SGMPX :: MAX_STATS exceeded,please recompile!\n");
			
			else
			    possible_stats[opt] = ++num_stats;
				continue;
			}
	   usage();
	}

	
	if (num_stats == 0) 		/*no user specific stat. requested*/
	  { want_IP = want_IB = want_OB = want_OP = 1;
		FORALLPOSSIBLESTATS(k)   /* initialize all statistics */
		      {	possible_stats[k] = ++num_stats;
			if (num_stats == MAX_STATS)
			 break;
		      }
	  }	
	/* else figure out the actual number of stats */
		else
		{
		if(IB = possible_stats[bytes] && possible_stats[input])
		   want_IB = 1;
		if(IP = possible_stats[packets] && possible_stats[input])
		   want_IP = 1;
		if(OP = possible_stats[output] && possible_stats[packets])
		   want_OP = 1;
		if(OB = possible_stats[output] && possible_stats[bytes])
		   want_OB = 1;
		if(BP = possible_stats[bytes] && possible_stats[packets])
		   want_IB = want_OB = want_IP = want_OP = 1; 
		if(IO = possible_stats[input] && possible_stats[output])
		   want_IB = want_OB = want_IP = want_OP = 1; 
		if(IBP = IB && possible_stats[packets])
		   want_IB = want_IP = 1; 
		if(IOP = IO && possible_stats[packets])
		   want_IP = want_OP = 1;
		if(IOB = IO && possible_stats[bytes])
		   {want_IB = want_OB = 1;want_OP = want_IP = 0;}
		if(OBP = OB && possible_stats[packets])
		{   want_OB = want_OP = 1;want_IP = want_IB = 0;}
		if(IBP || IOP || IOB || OBP)
   		  num_stats = 2;
		else 
			if(BP || IO || (IO && BP))
		   	  num_stats = 4;
			else		
				if(IB || IP || OP || OB)
		   		  num_stats = 1 ;
				else
			           {	num_stats = 2;	
		  			if(possible_stats[bytes])
					want_IB = want_OB = 1;
		  			if(possible_stats[packets])
					want_IP = want_OP = 1;
		  			if(possible_stats[input])
					want_IB = want_IP = 1;
		  			if(possible_stats[output])
					want_OP = want_OB = 1;
				    }	
		 }


 	/* time to fetch the number of interface's on the GW */

       actual_number = default_interface_num=
			get_interface_info(gateway_numb,session,NUMBFLAG,TIMEOUT1,Win);
	if(default_interface_num <= 0)
	 {fprintf(stderr,"SGMPX: Error in interface number\n");
	  exit(1);
	 }
	if (interface_num == ALL_INTERFACE && 
		default_interface_num > MAX_GW_INTERFACE)
		{ fprintf(stderr,
                 " SGMPX :: Gateway supports more than MAX_INTERFACE\n");
		 default_interface_num = MAX_GW_INTERFACE;
		  fprintf(stderr,
              " SGMPX :: Default interface number set to %d\n",MAX_GW_INTERFACE);
		}

	else 
	    { if(interface_num > MAX_GW_INTERFACE)
	      {fprintf(stderr,
	      "SGMPX : Cannot display more than %d interfaces\n",MAX_GW_INTERFACE);
		exit(1);
	      }
	    	if(interface_num != ALL_INTERFACE &&
			interface_num < MAX_GW_INTERFACE)
		default_interface_num = interface_num;
	   }	
	/* walk the interface table and get relevant data */
	initialize_stats();
/*
 * The  function,get_interface_info, writes into the structure 
 * interface_stat the relevant information, which is : type of interface,
 * status of interface.
 *
 */
	get_interface_info(gateway_numb,session,TYPEFLAG,TIMEOUT2,Win);

			    /* get the interface number and write into
			       number field */ 
	get_interface_info(gateway_numb,session,IFNUMBFLAG,TIMEOUT1,Win);
	if(interface_num != ALL_INTERFACE)
	  if(check_interfaces(default_interface_num) < 0)
		exit(10);

	init_stat(interface_num,input,0,"Input");
	init_stat(interface_num,output,0,"Output");
	init_stat(interface_num,bytes,MAX_BYTES,"Bytes");
	init_stat(interface_num,packets,MAX_PACKETS,"Packets");
	if (border_width < 0) border_width = DEFAULT_BORDER_WIDTH;

	if(update > 1.0) { 
	timeout.tv_sec = update;
	timeout.tv_usec = (update - (double)((int)update)) * 1000000.0;
	}
	if (!XOpenDisplay(display))
		{ fprintf(stderr,
		  "%s:Can't open display'%s'\n",
		   argv[0],XDisplayName(display));
			exit(1);
		}

	if ((finfo = XOpenFont (font_name)) == NULL)
		{ fprintf(stderr,"Can't load font %s! \n", font_name);
		  exit(1);
		}
	/* fetch the labels to be displayed */
       	   get_title(gateway_numb);
	/* Get the size of the longest font */
	for(k = 0; k < default_interface_num; k++)
	  {
	   int s_width,kindex;
	   kindex = k;
	   if(interface_num != ALL_INTERFACE)
		kindex = possible_interface[k].index;

       	  s_width = XStringWidth(stats[kindex].packets_in.label_1,finfo,0,0);
	  graph_x_offset = max(graph_x_offset,s_width);
	  s_width = XStringWidth(stats[kindex].packets_in.label_2,finfo,0,0);
	  graph_x_offset = max(graph_x_offset,s_width);
       	  s_width = XStringWidth(stats[kindex].packets_out.label_1,finfo,0,0);
	  graph_x_offset = max(graph_x_offset,s_width);
	  s_width = XStringWidth(stats[kindex].packets_out.label_2,finfo,0,0);
	  graph_x_offset = max(graph_x_offset,s_width);
       	  s_width = XStringWidth(stats[kindex].bytes_in.label_1,finfo,0,0);
	  graph_x_offset = max(graph_x_offset,s_width);
	  s_width = XStringWidth(stats[kindex].bytes_in.label_2,finfo,0,0);
	  graph_x_offset = max(graph_x_offset,s_width);
       	  s_width = XStringWidth(stats[kindex].bytes_out.label_1,finfo,0,0);
	  graph_x_offset = max(graph_x_offset,s_width);
	  s_width = XStringWidth(stats[kindex].bytes_out.label_2,finfo,0,0);
	  graph_x_offset = max(graph_x_offset,s_width);
	  }
	graph_x_offset += 30;
	gettimeofday(&saved_time,&dummy_zone);
	
	if (border_color && DisplayCells() > 2 &&
      	    XParseColor (border_color, &cdef) && XGetHardwareColor(&cdef))
		border_pixmap = XMakeTile(cdef.pixel);
	else if (border_color && strcmp(border_color,"black") == 0)
		border_pixmap = BlackPixmap;
	else if (border_color && strcmp(border_color,"white") == 0)
		border_pixmap = WhitePixmap;
	else
		border_pixmap = XMakePixmap (
			(Bitmap) XStoreBitmap (16,16,gray_bits),
						BlackPixel,WhitePixel);
	
	    
	if (back_color && DisplayCells() > 2 &&
	    XParseColor (border_color, &cdef) && XGetHardwareColor(&cdef)) 
	     { background = cdef.pixel;
	     }
	else if (back_color && (strcmp(back_color, "white") == 0))
		{
		  background = WhitePixel;
		  reverse = 0;
		}
	else if (back_color && (strcmp(back_color, "black") == 0)) 
		{
		  background = BlackPixel;
		  reverse = 0;
		}
	else
		background = BlackPixel;

	if (fore_color && DisplayCells() > 2 &&
	   XParseColor(fore_color, &cdef) && XGetHardwareColor(&cdef))
	    { foreground = cdef.pixel;
	    }
	else if (fore_color && (strcmp(fore_color, "black") == 0))
	    { foreground = BlackPixel;
	      reverse = 0;
	    }
	else if (fore_color && (strcmp(fore_color, "white") == 0))
	    { foreground = WhitePixel;
	      reverse = 0;
	    }
	else
		foreground = WhitePixel;

	if (high_color && DisplayCells() > 2 &&
	    XParseColor (high_color, &cdef) && XGetHardwareColor(&cdef))
		 highlight = cdef.pixel;
	else
		highlight = foreground;

	if(reverse) 
		{ highlight = background;
		  background = foreground;
		  foreground = highlight;
		}
	win.bdrwidth = border_width;
	win.border = border_pixmap;
	win.background = XMakeTile(background);

	minheight = (finfo->height *3 +2) * num_stats 
					    * default_interface_num + 45;
	minwidth = graph_x_offset + 150;
	sprintf(def, DEFAULT_POSITION,minwidth+100,
		 (finfo->height * 3 + 3) * num_stats *default_interface_num);

	Win = XCreate ("SGMP Performance Monitor", argv[0], geometry,
			def, &win, minwidth, minheight);

	XMapWindow (Win);

	redisplay(Win);
	timeleft = timeout;
	Select_mask = 1<<dpyno();  /* get the file descriptor for reading */ 
	maxplus1 = 1 + dpyno();
	XSelectInput(Win,KeyPressed | ExposeWindow |ExposeCopy);
	while(1)	/* the main loop */
		{int n;
			select_mask = Select_mask;
			XFlush();
			if ((n = 
		        select(maxplus1, &select_mask,NULL, NULL, &timeleft))
							< 0)
			exit(46);
		 if(debug)
		fprintf(stderr,"selected n=%d mask=0x%x, time=[%s%d]\n",
		n, select_mask, timeleft.tv_sec, timeleft.tv_usec);
			if (sgmp_perfmon_selected
				(Win,n,select_mask,&timeleft) < 0)
				break;
		}
 }
	

/***************************************************************************
 * 			initialze_stats();
 *  		 This initializes the staticstics structure .
 *
 *************************************************************************/

initialize_stats()

{
  int i;
	for (i = 0; i < MAX_GW_INTERFACE; i++)
	{
	  stats[i].number = NULL;
	  stats[i].name = NULL;
	  stats[i].type = NULL;
	  stats[i].status = NULL;
	 
	}
}

/************************************************************************
**			check_interfaces()
**	This function checks the user requested interface against the 
** available interface number on the gateway.
** NOTE:: To prevent ambiguity it is important that the user specify the
** 	  whole interface number and not a part of it.
**
************************************************************************/ 

check_interfaces(req_number)
int req_number;     /* number of interfaces requested by user */
{
 int test,k,i;
	for(i = 0;i < req_number; i++)
	{
	 for(k = 0; k < actual_number; k++)
	  	{test = strncmp(stats[k].number,possible_interface[i].number,
			  strlen(stats[k].number));	
		  if(!test) /* the numbers match */
		     	 { possible_interface[i].index = k;
			   goto next; 
			}
		}
	next:	if(!test)
			continue;
		else
		 { fprintf(stderr,"Interface %s is not available on GW\n",
				possible_interface[i].number);
		   return(-1);
		 }
	}
	return(0);
 }

/**************************************************************************
 *			display_dividers()
 * This funtion is responsible for drawing 'dividers' on the display and
 * also the 'tick' marks along the divider.
 *
 *************************************************************************/

#define First_Point(v,xv,yv) {v->x = xv; v->y = yv;\
			v++->flags = VertexDontDraw;}

#define Next_Point(v,xv,yv) {v->x = xv; v->y = yv;\
		v++->flags = VertexRelative | VertexDrawLastPoint; }
#define	interface_gap	4	
#define foo_width 16
#define foo_height 16
#define   Y_INTERFACE  ((win.height - 45)/default_interface_num)	
#define Y_UNIT  ((Y_INTERFACE - (2+finfo->height+interface_gap))/num_stats)
display_dividers(w,clear_first)
int clear_first;
Window w;
 {	int interface;
	register int i,stat;
	register int lwidth = win.width - graph_x_offset;
	Vertex v[NUM_VALS_PER];
	register Vertex *vp;
	register int y_org ;
	char *label1,*label2;

	XTextMask(w,0,2,"SGMP PERFORMANCE MONITOR",strlen("SGMP PERFORMANCE MONITOR"),finfo->id,highlight);
	if((label1 = (char *)malloc(sizeof(char)*20)) == NULL)
	 { fprintf(stderr,"SGMPX :: Cannot allocate memory\n");
	    exit(1);
	 }
	if((label2 = (char *)malloc(sizeof(char)*20)) == NULL)
	 { fprintf(stderr,"SGMPX :: Cannot allocate memory\n");
	    exit(1);
	 }
	sprintf(label1,"GATEWAY :: %s",gateway_numb);
	sprintf(label2,"UPDATE (APPROX) :: %d SECS",update_value);
	XTextMask(w,0,15,label1,strlen(label1),finfo->id, highlight);
	XTextMask(w,0,30,label2,strlen(label2),finfo->id,highlight);
	XLine(w,0,45,win.width,45,20,20,foreground,GXcopy,~0);
	for(interface = 0; interface < default_interface_num ; interface++)
 	{
 	     if(interface)
		y_org = finfo->height + 3 + Y_INTERFACE * interface + 45;
		else
		  y_org = finfo->height +47;/* the very first interface*/	

	 for(stat = 0; stat < num_stats; stat++)
	   {	
				y_org += Y_UNIT;						 
		vp = v;
		if(clear_first)
			XPixSet(w, graph_x_offset,y_org - 2,
				lwidth, 5, background);
		/* draw the horizontal line */
		XLine(w,graph_x_offset,y_org,win.width,y_org,1,1,
			foreground,GXcopy,~0);

		for(i = 0; i < num_of_val; i++)
		   {	if(do_time[i])
			{ First_Point(vp, graph_x_offset+i,y_org-2);
			  Next_Point(vp,0,4);
			}
		   }
		if(vp != v)
			XDraw(w,v, vp-v, 1,1,foreground, GXcopy, ~0);
	    }
	/* Draw the demarkation for the interfaces */
		 y_org += interface_gap;
   	      XLine(w,0,y_org,win.width,y_org,
			20,20,foreground,GXcopy,~0);
	
	}
	free(label1);free(label2);
 }

/******************************************************************************
 *				redisplay(w)
 * This function is resonsible for redisplaying a window when and if necessary.
 *
 ****************************************************************************/
 
 redisplay(w)
 Window w;
 {
  int interface,i;
  int stat,index;
  int done_IP,done_OP,done_IB,done_OB;
  register int y_org;	
	XClear(w);
	display_dividers(w,0); /* display dividers without clearing*/
	for(i = 0;i < default_interface_num; i++)
 	{ int text_size;
	  char temp[20];
	
	  done_IP = done_OP = done_IB = done_OB = 0;
	
		if(i)
		   y_org = finfo->height + 48 + Y_INTERFACE * i;
		    else
			y_org = finfo->height+ 45; /* the first interface*/
       		 if(interface_num != ALL_INTERFACE)
		   interface = possible_interface[i].index;
		  else
		   interface = i; 
		XTextMask(w,0,Y_INTERFACE * i +47,
				stats[interface].title,
				strlen(stats[interface].title),
				finfo->id,highlight);
		for(stat = 0;stat < num_stats; stat++)
			{ 
		    if(want_IP && !done_IP)           /* Input packets */
			{XTextMask(w, 0, y_org,
			  stats[interface].packets_in.label_1,
			 strlen(stats[interface].packets_in.label_1),
			 finfo->id,highlight);
			XTextMask(w, 0, y_org + 10,
			  stats[interface].packets_in.label_2,
			 strlen(stats[interface].packets_in.label_2),
			 finfo->id,highlight);
			sprintf(temp,"%d",
				stats[interface].packets_in.max_val);
			text_size = XStringWidth (temp,finfo,0,0);
			XTextMask (w,graph_x_offset-2-text_size,
			     y_org+5,temp,strlen(temp),
				finfo->id,highlight);
			sprintf(temp,"%d",
				stats[interface].packets_in.min_val);
			text_size = XStringWidth (temp,finfo,0,0);
			XTextMask (w,graph_x_offset-2-text_size,
			     y_org+Y_UNIT -5,temp,strlen(temp),
				 finfo->id,highlight);
			done_IP = 1;
			  y_org += Y_UNIT;
			continue;	
			}
		    if(want_IB && !done_IB)	/*input bytes */
			{XTextMask(w, 0, y_org,
			  stats[interface].bytes_in.label_1,
			 strlen(stats[interface].bytes_in.label_1),
			 finfo->id,highlight);
			XTextMask(w, 0, y_org + 10,
			  stats[interface].bytes_in.label_2,
			 strlen(stats[interface].bytes_in.label_2),
			 finfo->id,highlight);
			sprintf(temp,"%d",
				stats[interface].bytes_in.max_val);
			text_size = XStringWidth (temp,finfo,0,0);
			XTextMask (w,graph_x_offset-2-text_size,
			     y_org+5,temp,strlen(temp),
				finfo->id,highlight);
			sprintf(temp,"%d",
				stats[interface].bytes_in.min_val);
			text_size = XStringWidth (temp,finfo,0,0);
			XTextMask (w,graph_x_offset-2-text_size,
			     y_org+Y_UNIT-5,temp,strlen(temp),
				 finfo->id,highlight);	
			done_IB = 1;
			  y_org += Y_UNIT;
			continue;
			}
		    if(want_OP && !done_OP)	/* output packets */
			{XTextMask(w, 0, y_org,
			  stats[interface].packets_out.label_1,
			 strlen(stats[interface].packets_out.label_1),
			 finfo->id,highlight);
			XTextMask(w, 0, y_org + 10,
			  stats[interface].packets_out.label_2,
			 strlen(stats[interface].packets_out.label_2),
			 finfo->id,highlight);
			sprintf(temp,"%d",
				stats[interface].packets_out.max_val);
			text_size = XStringWidth (temp,finfo,0,0);
			XTextMask (w,graph_x_offset-2-text_size,
			     y_org+5,temp,strlen(temp),
				finfo->id,highlight);
			sprintf(temp,"%d",
				stats[interface].packets_out.min_val);
			text_size = XStringWidth (temp,finfo,0,0);
			XTextMask (w,graph_x_offset-2-text_size,
			     y_org+Y_UNIT -5,temp,strlen(temp),
				 finfo->id,highlight);	
			done_OP = 1;
			  y_org += Y_UNIT;
			continue;
			}
			

		    if(want_OB && !done_OB)	/* output bytes */
			{XTextMask(w, 0, y_org,
			  stats[interface].bytes_out.label_1,
			 strlen(stats[interface].bytes_out.label_1),
			 finfo->id,highlight);
			XTextMask(w, 0, y_org + 10,
			  stats[interface].bytes_out.label_2,
			 strlen(stats[interface].bytes_out.label_2),
			 finfo->id,highlight);
			sprintf(temp,"%d",
				stats[interface].bytes_out.max_val);
			text_size = XStringWidth (temp,finfo,0,0);
			XTextMask (w,graph_x_offset-2-text_size,
			     y_org+5,temp,strlen(temp),
				finfo->id,highlight);
			sprintf(temp,"%d",
				stats[interface].bytes_out.min_val);
			text_size = XStringWidth (temp,finfo,0,0);
			XTextMask (w,graph_x_offset-2-text_size,
			     y_org+Y_UNIT-5,temp,strlen(temp),
				 finfo->id,highlight);	
			done_OB = 1;
			  y_org += Y_UNIT;
			continue;
			}
		}
	}
	if(num_of_val > 0) 
	for(interface = 0; interface < default_interface_num;
					interface++)
	  { register int y_org,y_base; 

	    if(interface)
		 y_org = finfo->height + 48 + Y_INTERFACE *interface;
		
	     else
		 y_org = finfo->height + 45;
		  y_base = y_org + Y_UNIT;
	    if(interface_num == ALL_INTERFACE)
		index = interface;
	    else
		index = possible_interface[interface].index;
	redisplay_stat_values(w, y_base,index);
	}
	
	
   }

/************************************************************************
**
**			  redisplay_stat_values()
**
**	This functions redisplays the plotted values on the graph
**
************************************************************************/

redisplay_stat_values(w, y_base,index)
Window w;
int y_base,index;
 {
	register int j, newY;
	Vertex v[NUM_VALS_PER];
	register Vertex *vp = v;
	int done_IP, done_OP, done_IB, done_OB;
	int ndone_IP,ndone_OP,ndone_IB,ndone_OB;
	int trace,stat,npts;
	done_IP = done_OP = done_IB = done_OB = 0;
	ndone_IP = ndone_OP = ndone_IB = ndone_OB = 0;
	
	for(stat = 0;stat < num_stats; stat++)
		{
		if(want_IP && !done_IP)
		  { newY = y_base - min(Y_UNIT, (Y_UNIT * (
			stats[index].packets_in.value[1] -
		    	stats[index].packets_in.min_val)/
			(stats[index].packets_in.max_val -
			stats[index].packets_in.min_val)));
			done_IP = 1;
			trace = 1;
	 		goto next;
		  }
		if(want_IB && !done_IB)	
		  { newY = y_base - min(Y_UNIT, (Y_UNIT * (
			stats[index].bytes_in.value[1] -
		    	stats[index].bytes_in.min_val)/
			(stats[index].bytes_in.max_val -
			stats[index].bytes_in.min_val)));
			done_IB = 1;
			trace = 2;
		        goto next;
		  }
		if(want_OP && !done_OP)	
		  { newY = y_base - min(Y_UNIT, (Y_UNIT * (
			stats[index].packets_out.value[1] -
		    	stats[index].packets_out.min_val)/
			(stats[index].packets_out.max_val -
			stats[index].packets_out.min_val)));
			done_OP = 1;
			trace = 3;
			goto next;
		  }
		if(want_OB && !done_OB)	
		  { newY = y_base - min(Y_UNIT, (Y_UNIT * (
			stats[index].bytes_out.value[1] -
		    	stats[index].bytes_out.min_val)/
			(stats[index].bytes_out.max_val -
			stats[index].bytes_out.min_val)));
			done_OB = 1;
			trace = 4;
		  }
	next:	First_Point(vp, graph_x_offset, newY);
		for(j = 2; j < num_of_val; )
			{
			 register int npts = 0, oldY = newY;
			 do
			     {  if(want_IP && !ndone_IP && done_IP)
		  		 {newY = y_base - min(Y_UNIT, (Y_UNIT * (
				  stats[index].packets_in.value[j] -
		    	 	  stats[index].packets_in.min_val)/
				  (stats[index].packets_in.max_val -
				  stats[index].packets_in.min_val)));
		   	         }	
			       if(want_IB && !ndone_IB && done_IB)
		  		 {newY = y_base - min(Y_UNIT, (Y_UNIT * (
				  stats[index].bytes_in.value[j] -
		    	 	  stats[index].bytes_in.min_val)/
				  (stats[index].bytes_in.max_val -
				  stats[index].bytes_in.min_val)));
		   	         }	
			       if(want_OP && !ndone_OP && done_OP)
		  		 {newY = y_base - min(Y_UNIT, (Y_UNIT * (
				  stats[index].packets_out.value[j] -
		    	 	  stats[index].packets_out.min_val)/
				  (stats[index].packets_out.max_val -
				  stats[index].packets_out.min_val)));
		   	         }	
			       if(want_OB && !ndone_OB && done_OB)
		  		 {newY = y_base - min(Y_UNIT, (Y_UNIT * (
				  stats[index].bytes_out.value[j] -
		    	 	  stats[index].bytes_out.min_val)/
				  (stats[index].bytes_out.max_val -
				  stats[index].bytes_out.min_val)));
		   	         }	
				 j++;
				 npts++;
			     }
			     while ((oldY == newY) && (j < num_of_val));

			if(--npts)
				Next_Point(vp, npts, 0);
			Next_Point(vp, 1,newY - oldY);
		}	
	/* figure out which is just finished */
			switch(trace)
				{
				 case 1: ndone_IP = 1;break;
				 case 2: ndone_IB = 1;break;
				 case 3: ndone_OP = 1;break;
				 case 4: ndone_OB = 1;break;
				}
    
		if( vp != v)
			XDraw(w, v, vp-v, 1, 1, foreground, GXcopy, ~0);
		y_base += Y_UNIT;
   }
 }
				 


/************************************************************************
**
**			get_title()
**	This extract the appropriate title to be displaye from  the
** interface_stat structure and writes it into the title field.
**
** A title consists of :
**	GATEWAY :: #INTERFACE TYPE STATUS
***********************************************************************/

get_title(gateway)
char *gateway;
{
int i,k;
	for( k= 0; k < default_interface_num; k++)
	{
	 int typelen, numberlen,gatelen;
	   if(interface_num == ALL_INTERFACE)
	      i = k;
	   else
		i = possible_interface[k].index;
		numberlen = strlen(stats[i].number) ;
		typelen = strlen(stats[i].type) + numberlen;
	if((stats[i].title = (char *)malloc(sizeof(char) * 50)) == NULL)
	  { fprintf(stderr,"Could not allocate memory,...exiting\n");
	    exit(1);
	  }
	sprintf(stats[i].title,"%s :: ",stats[i].number);
	sprintf(&(stats[i].title[numberlen + 4]),"%s ",stats[i].type);
	sprintf(&(stats[i].title[typelen + 5]),"%s",stats[i].status);
   }
 }

/************************************************************************
**			sgmp_perfmon_selected()
**	This is responsible for reacting towards any changes made to the
** window in question. This function also goes and collects the various 
** statistics and the end of each interval.
**
************************************************************************/

int sgmp_perfmon_selected(w,number, mask, timer)
int mask,number;
Window w;
struct timeval *timer;

{

	if(number == 0) /* if the timer has expired */
	   {
	   /* get the recent update for the interfaces */ 
            get_interface_info(gateway_numb,session,DATAFLAG,TIMEOUT3,w);

	    gettimeofday(&current_time, &dummy_zone);
	    if (current_time.tv_sec < saved_time.tv_sec) 
		{ /* Super user set the clock back */
		  saved_time = current_time;
		  saved_time.tv_sec -= SECS_PER_TIME_TICK;
		}
	    if(saved_time.tv_sec + SECS_PER_TIME_TICK <= current_time.tv_sec)
		{ saved_time = current_time;
		  do_time[num_of_val] = 1;/* display it */
		}
	     else
		do_time[num_of_val] = 0; /* no need to display*/
		next_display(w);
	    }

	if (mask & (1 << dpyno()))
	   {
		XEvent event;
		XEvent pevent;
		XExposeWindowEvent *exp_event;
		int key;
		if (!XPending()) return(-1); /* end of connection */
		while (XPending())
		  {
			XNextEvent(&event);
			switch(event.type){
		
			case KeyPressed:
			  	if((key = mapkey(((XKeyPressedEvent *)
						     &event)->detail)) > 0)
					switch(key) {
					case 'f' : /*faster usec timeout */
						if(timeout.tv_usec >=
								 USEC_INC)
							timeout.tv_usec -= 
								 USEC_INC;
						else
						 { if (timeout.tv_sec >= 
								SEC_INC)
						     {
							timeout.tv_sec -= 
								SEC_INC;
							timeout.tv_usec =
							1000000 - USEC_INC;
						      }
						  }
					    break;
					case 's' : /*slower usec timeout */
						 if (timeout.tv_usec <
							1000000-USEC_INC)
						 timeout.tv_usec +=USEC_INC;
						 else
						    { timeout.tv_usec = 0;
						      timeout.tv_usec +=1;
						    }
					    break;
					case 'F' : /* faster sec timeout */
						if(timeout.tv_sec >=SEC_INC)
							timeout.tv_sec -=
								SEC_INC;
					    break;
					case 'S': /* slower sec timeout */
						timeout.tv_sec += SEC_INC;
						 break;
					case 'R' : /*reset */
						 timeout.tv_sec = SEC_INC;
						 timeout.tv_usec = USEC_INC;
						 num_of_val = 0;

						 redisplay(w);
					     break;
					case 'h' :
					case 'H' :
					case '?' : /* help */
						printf(
						"%s\n%s\n%s\n%s\n%s\n%s\n",
						"'s' slower usec timeout",
						"'f' faster usec timeout",
						"'S' slower sec timeout",
						"'F' faster sec timeout",
						"'R' reset timeout and display",
						"'q' or 'Q' quit");
						return(0);
					case 'q' :
					case 'Q' :
					      return(-1);
				     }
				break;
			case ExposeWindow :
				XSync(0);
				while (XPending() != 0) {
					XPeekEvent (&pevent);
					if(pevent.type != ExposeWindow)
						break;
					XNextEvent(&event);
				}
			
				exp_event = (XExposeWindowEvent *) &event;
				win.x = exp_event->x;
				win.y = exp_event->y;
				win.width = exp_event->width;
				win.height = exp_event->height;
				redisplay(w);
				break;
			default:  /* NEED TO IMPROVE ON THIS LIST */
				break;
			    }
			}
		}
		*timer = timeout;
		return(0);
  }
			




/***********************************************************************
**			 next_display()
**	This function is responsible for plotting tht next point on the 
** display . The index to the value to be plotted is given by 'num_of_val'
**
***********************************************************************/

next_display(w)
Window w;
{ int interface;
  int stat,redisp;
  int tempindex = 0;
  int done_IP,done_OP,done_IB,done_OB;
  register int y_base,y_org;
  static count = 0;
 
    for(interface = 0; interface < default_interface_num; interface++)
       
       {done_IP = done_OP = done_IB = done_OB = 0;
	
	if(interface_num == ALL_INTERFACE) /* no specific interface */
   	  tempindex = interface;
	 else  		      	           /* user secified interfaces only */
 	  tempindex = possible_interface[interface].index;	
	if(interface)
	  y_org = finfo->height + 46 + Y_INTERFACE * interface;
	 
	else
	 y_org = finfo->height + 45;
	 y_base = y_org + Y_UNIT;
 	 

	for(stat = 0; stat < num_stats; stat++)
		{
  		 register int newY,oldY;
		   if(num_of_val <= 1 )
			{
			oldY = newY = y_base;
		        y_base += Y_UNIT;	
			continue;
			}
		if (do_time[num_of_val])   /* draw the tick marks */
		{ y_org += Y_UNIT;
		  XLine(w, graph_x_offset+num_of_val, y_org,
			 graph_x_offset+num_of_val,y_org+4,
			1,1, foreground, GXcopy, ~0);
		}
		if(want_IP && !done_IP)	   /* input packets */
		  { newY = y_base - min(Y_UNIT, (Y_UNIT * (
		           stats[tempindex].packets_in.value[num_of_val] -
			   stats[tempindex].packets_in.min_val)/
			  (stats[tempindex].packets_in.max_val -
			   stats[tempindex].packets_in.min_val)));
		   
		   oldY = y_base - min(Y_UNIT, (Y_UNIT * (
		           stats[tempindex].packets_in.value[num_of_val - 1] -
			   stats[tempindex].packets_in.min_val)/
			  (stats[tempindex].packets_in.max_val -
			   stats[tempindex].packets_in.min_val)));
		  XLine(w,graph_x_offset+num_of_val,oldY,
			graph_x_offset+num_of_val+1,newY,1,1,
			foreground, GXcopy, ~0);
		  XFlush();
		   done_IP = 1;
		  y_base += Y_UNIT;
		 continue;
		}
		   			

		if(want_IB && !done_IB)	   /* input packets */
		  { newY = y_base - min(Y_UNIT, (Y_UNIT * (
		           stats[tempindex].bytes_in.value[num_of_val] -
			   stats[tempindex].bytes_in.min_val)/
			  (stats[tempindex].bytes_in.max_val -
			   stats[tempindex].bytes_in.min_val)));
		   oldY = y_base - min(Y_UNIT, (Y_UNIT * (
		           stats[tempindex].bytes_in.value[num_of_val - 1] -
			   stats[tempindex].bytes_in.min_val)/
			  (stats[tempindex].bytes_in.max_val -
			   stats[tempindex].bytes_in.min_val)));
		  XLine(w,graph_x_offset+num_of_val,oldY,
			graph_x_offset+num_of_val+1,newY,1,1,
			foreground, GXcopy, ~0);
		  XFlush();
		   done_IB = 1;
		   y_base += Y_UNIT;
		  continue;
		}


		if(want_OP && !done_OP)	   /* input packets */
		  { newY = y_base - min(Y_UNIT, (Y_UNIT * (
		           stats[tempindex].packets_out.value[num_of_val] -
			   stats[tempindex].packets_out.min_val)/
			  (stats[tempindex].packets_out.max_val -
			   stats[tempindex].packets_out.min_val)));
		   oldY = y_base - min(Y_UNIT, (Y_UNIT * (
		           stats[tempindex].packets_out.value[num_of_val - 1] -
			   stats[tempindex].packets_out.min_val)/
			  (stats[tempindex].packets_out.max_val -
			   stats[tempindex].packets_out.min_val)));
		  XLine(w,graph_x_offset+num_of_val,oldY,
			graph_x_offset+num_of_val+1,newY,1,1,
			foreground, GXcopy, ~0);
		  XFlush();
		   done_OP = 1;
		   y_base += Y_UNIT;
		  continue;
		}


		if(want_OB && !done_OB)	   /* input packets */
		  { newY = y_base - min(Y_UNIT, (Y_UNIT * (
		           stats[tempindex].bytes_out.value[num_of_val] -
			   stats[tempindex].bytes_out.min_val)/
			  (stats[tempindex].bytes_out.max_val -
			   stats[tempindex].bytes_out.min_val)));
		   oldY = y_base - min(Y_UNIT, (Y_UNIT * (
		           stats[tempindex].bytes_out.value[num_of_val - 1] -
			   stats[tempindex].bytes_out.min_val)/
			  (stats[tempindex].bytes_out.max_val -
			   stats[tempindex].bytes_out.min_val)));
		  XLine(w,graph_x_offset+num_of_val,oldY,
			graph_x_offset+num_of_val+1,newY,1,1,
			foreground, GXcopy, ~0);
			XFlush();
		   done_OB = 1;
		   y_base += Y_UNIT;
		  continue;
		}

	  }
	}
	

	/* check if the maximum number of values have been filled in */

	if (++num_of_val >= NUM_VALS_PER ||
	   num_of_val >= win.width - graph_x_offset)
		{
		 int num_shift_left = (win.width-graph_x_offset)/2;
		 int width = (win.width-graph_x_offset)- num_shift_left;
		 register int j;
		 for(j = num_shift_left; j< num_of_val; j++)
		  do_time[j-num_shift_left] = do_time[j]; /* shift the
							   * tick marks
							   */


    for(interface = 0; interface < default_interface_num; interface++)
       {
	done_IP = done_OP = done_IB = done_OB = 0;
	if(interface)
	 y_org = finfo->height + 46 + Y_INTERFACE * interface;
	else
	 y_org = finfo->height + 45;

	if(interface_num == ALL_INTERFACE) /* no specific interface */
   	  tempindex = interface;
	 else  		      	           /* user secified interfaces only */
 	  tempindex = possible_interface[interface].index;	
	for(stat = 0; stat < num_stats; stat++)
	{
	 register int ys, nmax = 1,t;
	 ys = y_org ;
	 if(want_IP && !done_IP)
	 {
	  for(j = num_shift_left + 2; j< num_of_val;j++)
	  {
	  t = stats[tempindex].packets_in.value[j-num_shift_left] =
		stats[tempindex].packets_in.value[j];
		nmax = nmax > t ? nmax :  t;
	  }

	if (nmax != stats[tempindex].packets_in.max_val)
	  { stats[tempindex].packets_in.max_val = nmax;
	    redisp = 1; /* redisplay with new maximum value */
	  }
	if(!redisp)
	 {
	  	XMoveArea(w,graph_x_offset+num_shift_left,
		ys,graph_x_offset,ys,width,Y_UNIT + 2);
		XPixSet(w, graph_x_offset+num_shift_left,ys,width,
		       Y_UNIT+2,background);
	 }
	 y_org += Y_UNIT;
	 done_IP = 1;
	 continue;
	}


	 if(want_IB && !done_IB)
	 {
	  for(j = num_shift_left + 2; j< num_of_val;j++)
	  {
	  t = stats[tempindex].bytes_in.value[j-num_shift_left] =
		stats[tempindex].bytes_in.value[j];
		nmax = nmax > t ? nmax :  t;
	  }

	if (nmax != stats[tempindex].bytes_in.max_val)
	  { stats[tempindex].bytes_in.max_val = nmax;
	    redisp = 1; /* redisplay with new maximum value */
	  }
	if(!redisp)
	 {
	  	XMoveArea(w,graph_x_offset+num_shift_left,
		ys,graph_x_offset,ys,width,Y_UNIT + 2);
		XPixSet(w, graph_x_offset+num_shift_left,ys,width,
		       Y_UNIT+2,background);
	 }
	 y_org += Y_UNIT;
	 done_IB = 1;
	 continue;
       }

	 if(want_OP && !done_OP)
	 {
	  for(j = num_shift_left + 2; j< num_of_val;j++)
	  {
	  t = stats[tempindex].packets_out.value[j-num_shift_left] =
		stats[tempindex].packets_out.value[j];
		nmax = nmax > t ? nmax :  t;
	  }

	if (nmax != stats[tempindex].packets_out.max_val)
	  { stats[tempindex].packets_out.max_val = nmax;
	    redisp = 1; /* redisplay with new maximum value */
	  }
	if(!redisp)
	 {
	  	XMoveArea(w,graph_x_offset+num_shift_left,
		ys,graph_x_offset,ys,width,Y_UNIT + 2);
		XPixSet(w, graph_x_offset+num_shift_left,ys,width,
		       Y_UNIT+2,background);
	 }

	 y_org += Y_UNIT;
	 done_OP = 1;
	 continue;
       }
	 

	if(want_OB && !done_OB)
	 {
	  for(j = num_shift_left + 2; j< num_of_val;j++)
	  {
	  t = stats[tempindex].bytes_out.value[j-num_shift_left] =
		stats[tempindex].bytes_out.value[j];
		nmax = nmax > t ? nmax :  t;
	  }

	if (nmax != stats[tempindex].bytes_out.max_val)
	  { stats[tempindex].bytes_out.max_val = nmax;
	    redisp = 1; /* redisplay with new maximum value */
	  }
	if(!redisp)
	 {
	  	XMoveArea(w,graph_x_offset+num_shift_left,
		ys,graph_x_offset,ys,width,Y_UNIT + 2);
		XPixSet(w, graph_x_offset+num_shift_left,ys,width,
		       Y_UNIT+2,background);
	 }

	 y_org += Y_UNIT;
	 done_OB = 1;
	 continue;
       }

    }
  }
	if(count++ == CHECK_STATUS)  /* time to check status? */
	 {
        get_interface_info(gateway_numb,session,TYPEFLAG,TIMEOUT2,w);
	get_title(gateway_numb);
	count = 0; /* reinitialize the count */
	}
	num_of_val -= num_shift_left+1;
	if(redisp)
		redisplay(w);
	else
		display_dividers(w,1);
	}
   }
 
 
 
