/*  

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

Portions of the src code for X-Windows in this application
fall under an MIT copyright.

Copyright 1985, Massachusetts Institute of Technology
*/
/******************************************************************************
**
**			 get_interface_info()
**
** File contains the program to fetch the relevant data from the gateway. 
**
**
******************************************************************************/
#include "sgmpxperfmon.h"       /* application specific include */

/* variables we're going to ask for */
#define TYPE		"_GW_net_if_type"
#define STATUS		"_GW_net_if_status"
#define NUMBER		"_GW_cfg_nnets"
#define INFNUMB		"_GW_pr_DODip_addr_value"
#define INPKTS		"_GW_net_if_in_pkts"
#define OUTPKTS		"_GW_net_if_out_pkts"
#define INBYTES		"_GW_net_if_in_bytes"
#define OUTBYTES	"_GW_net_if_out_bytes"


/* other definitions */
#define SERVICE		"sgmp"	/* service we're trying to contact */
#define MAXRETRIES	1	/* max number of times to retry */
#define INITFILE	"/etc/sgmp.variables" /* init file for the variable converter */

/* environment for interrupts */
jmp_buf env;

get_interface_info(gateway,session,FLAG,TIMEOUT,w)
char *gateway;
char *session;
int FLAG;
int TIMEOUT;
Window w;

{ int ac;			/* number of variables to be requested */
  strng *av[4];			/* names of variables to be requested */
  int onintr();			/* interrupt handler for recv timeout*/
  int rc;			/* return code for sending */
  static long address;			/* IP address we are sending to */
  struct itimerval interval;	/* the timeout interval */
  struct itimerval disable;	/* to disable timers */
  int retries;			/* number of times we've retried */
  get_req_msg_type *req_msg;	/* the request message */
  get_rsp_msg_type *reply;	/* the response message */
  int req_id;			/* request id */
  char **s_id;			/* session id */
  short interfacenum = 0;	/* this one is interface number... ? */
  var_op_type *currentvar;	/* the variable we are currently dealing with */
  strng temp1;			/* temporary string structure */
  strng temp2;			/* temporary string structure */
  strng temp3;			/* temporary string structure */
  strng temp4;			/* temporary string structure */
  strng *cvtednum;	        /* to hold numeric representation no. of intf.*/
  strng *cvtedtyp;		/* to hold numeric representation of type */
  strng *cvtedstt;		/* to hold numeric representation of status */
  strng *cvtedinp;		/* to hold numeric representation of INPKTS */
  strng *cvtedoup;		/* to hold numeric representation of OUTPKTS */
  strng *cvtedinb;		/* to hold numeric representation of INBYTES */
  strng *cvtedoub;		/* to hold numeric representation of OUTBYTES */
  strng *cvtedifnumb;		/* to hold numeric representation of INFNUMB */
  strng *struct_string;		/* for temp manipulation of data */
  long *from;			/* dummy - to store an IP address */
  int *msg_type;			/* type of message returned */
  int done = 0;			/* are we done yet? */
  int i,index;			/* just an index */
  static int init_done = 0;
/*
   since we're going to be using this many times, we may as well do
   it here once and for all and save some time
*/
   if((s_id = (char **)malloc(sizeof(char))) == NULL)
     {
	fprintf(stderr,"Cannot allocate memorey space...\n");
	exit(1);
     }
   if((msg_type = (int *)malloc(sizeof(int))) == NULL)
     {
	fprintf(stderr,"Cannot allocate memorey space...\n");
	exit(1);
     }
   if((from = (long *)malloc(sizeof(long))) == NULL)
     {
	fprintf(stderr,"Cannot allocate memorey space...\n");
	exit(1);
     }
 *s_id  = session;		/* the session id */
  interval.it_interval.tv_sec = 0; /* don't want to reload timer */
  interval.it_interval.tv_usec = 0; 
  interval.it_value.tv_sec = TIMEOUT; /* wait this long before timing out */
  interval.it_value.tv_usec = 0;
  disable.it_interval.tv_sec = 0; /* don't want to reload timer */
  disable.it_interval.tv_usec = 0; 
  disable.it_value.tv_sec = 0;	/* wait this long before timing out */
  disable.it_value.tv_usec = 0;

/* convert symbolic to numeric representations */
 if(!init_done) {
 if(sgmp_init_cvt(INITFILE) < 0) /* initialize the variable converter */
	{ fprintf(stderr,"couldn't initialize variable converter\n");
    	   exit(1);
   	}
    if (isalpha(*gateway)) {
     struct hostent *hp;
     if((hp = gethostbyname(gateway)) != NULL)
       bcopy(hp->h_addr,(char *)&address,hp->h_length);/* get 32 bit address*/
     else {
	fprintf(stderr,"couldn't get address for %s\n",gateway);
	exit(1);
     }
    } else if((address = dotto32bit(gateway)) == -1) {
      fprintf(stderr,"couldn't convert %s\n",gateway);
      exit(1);
    }
    init_done = 1;
  }

 switch(FLAG){
	case NUMBFLAG : /* Get the number of interfaces */
        { 
	 temp1.len = strlen(NUMBER); /* The number of interfaces */
	 temp1.str = NUMBER;
	/* Convert number of interfaces */
	if((cvtednum = sgmp_var_cvt(&temp1,SYMTONUM)) == NULL)
	{fprintf(stderr,"SGMPX:Couldn't convert %s\n",temp1.str);
	 exit(1);
	}
	 av[0] = cvtednum;
	 ac = 1;
	req_id = getpid() ^ (int)time(0); /* the request id */
	/* create a request */
	if((req_msg = (get_req_msg_type *)
		      create_sgmp_req(req_id,ac,av)) == NULL)
		{ fprintf(stderr,
			"SGMPX:cannot create request message\n");
		   exit(1);
		}
	retries = 0;
	/* preserve the environment */
	if (setjmp(env))
	 if (retries < MAXRETRIES)
	   {	retries++;
               fprintf(stderr,"SGMPX :: Receive timed out. Retrying...\n");
	   } 
	   else
	    { fprintf(stderr,"SGMPX : Giving up!\n");
		exit(1);
	     }
	 
	/* send the request */
	signal(SIGALRM,SIG_IGN);
		if((  send_sgmp_mesg
 			(GET_REQ_MESG,req_id,address,SERVICE,req_msg,
			*s_id,strlen(*s_id),TIMEOUT)) < 0)
			{ fprintf(stderr,
			  " SGMPX: Timeout while sending\n");
				exit(1);
			}
  	/* sent the request, now wait for response */
	signal(SIGALRM,onintr);           /* catch timeouts */
	setitimer(ITIMER_REAL,&interval); /* start timer */
	reply = (get_rsp_msg_type *)recv_sgmp_mesg
		   (from,NULL,&req_id,msg_type,s_id);
	setitimer(ITIMER_REAL,&disable); /* disable the timer */
	if(reply == NULL)
	  { fprintf(stderr,"SGMPX : Non-coherent reply\n");
	   exit(1);
	  }
	if(*msg_type != GET_RSP_MESG)
	  {fprintf(stderr, "SGMPX : Incorrect response from GW\n");
	   exit(1);
	  }
	if(reply->error_status != 0)  /* there was an error */
	  { fprintf(stderr,"SGMPX : Received an error indication \n");
	    fprintf(stderr,
		"Number of interfaces unknown, exiting ...\n");
		exit(1);
    	  }
	term_sgmp_comm(req_id); /* don't need the socket */
	return(reply->var_op_list->var_value.value.intgr); /* The number of intf */
     }

	case TYPEFLAG :     /* go and collect GW info */
	{
	/* set up string structures for variable conversion */
  	temp1.len = strlen(TYPE);	/* interface type */
        temp1.str = TYPE; 
        temp2.len = strlen(STATUS);	/* interface status */
        temp2.str = STATUS;

	/* convert interface type */
 	 if((cvtedtyp = sgmp_var_cvt(&temp1,SYMTONUM)) == NULL)
   	{ fprintf(stderr,"SGMPX : couldn't convert %s\n",temp1.str);
   	  exit(1);
  	 }
	/* convert interface status */
	  if((cvtedstt = sgmp_var_cvt(&temp2,SYMTONUM)) == NULL)
	   { fprintf(stderr,"SGMPX : couldn't convert %s\n",temp2.str);
	     exit(1);
	   }
	/* fill in first request */
 	 ac = 2;			/* we're asking for two variables */
	  av[0] = cvtedtyp;		/* interface type */
	  av[1] = cvtedstt;		/* interface speed */
	  req_id = getpid() ^ (int)time(0); /* the request id */

	/* now get the information we want */
 	 do {				/* iterate to get information */
	   retries = 0;			/* we haven't timed out yet */
	/* create a request */
	   if((req_msg = (get_req_msg_type *)
		create_sgmp_req(req_id,ac,av)) == NULL)
	    { fprintf(stderr,"SGMPX : Cannot create request message\n");
	      exit(1);
	    }
	/* preserve the environment */
	   if(setjmp(env))
	    {if(retries < MAXRETRIES)	/* if we should retry again */
	{ fprintf(stderr, "SGMPX :: Timed out in receive. Retrying ... \n");
           retries++;		/* retry one more time */
	}
	    else			/* we exceeded the number of retries */
	     { fprintf(stderr,"SGMPX : giving up\n");
	       exit(1);
	     }
	    }
	/* send off request */
	       signal(SIGALRM,SIG_IGN);
	       if((rc = send_sgmp_mesg
			(GET_REQ_MESG,req_id,address,SERVICE,req_msg,
			      *s_id,strlen(*s_id),TIMEOUT)) < 0)
	    switch(rc) {
	     case SEND_TIMEOUT:		/* timed out */
	      fprintf(stderr,"SGMPX : send timeout\n");
	      exit(1);
	     case GEN_ERR:		/* some unknown error */
	      fprintf(stderr,"SGMPX : generic error in send\n");
	      exit(1);
	     default:			/* strange error */
	      fprintf(stderr,"SGMPX : unknown error return in send\n");
	      exit(1);
	    }
	/* sent off request, now wait for a response */
	   signal(SIGALRM,onintr);
	   setitimer(ITIMER_REAL,&interval); /* start timer */
	   reply = (get_rsp_msg_type *)
			recv_sgmp_mesg(from,NULL,&req_id,msg_type,s_id);
	   setitimer(ITIMER_REAL,&disable); /* disable the receive timer */
	   if(reply == NULL)
	    { fprintf(stderr,"SGMPX : could not get a coherent reply\n");
	      exit(1);
	    }
	   if(*msg_type != GET_RSP_MESG)	/* if this wasn't a response message */
	    { fprintf(stderr,"SGMPX : incorrect response from gateway\n");
	      exit(1);
	    }
	   if(reply->error_status != 0)	/* check if we got back an error */
	    { fprintf(stderr,"SGMPX : received error indication\n");
	      fprintf(stderr,"error was in variable %d\n",reply->error_index);
	    }
	   currentvar = reply->var_op_list;
	   if(currentvar == NULL)	/* if we didn't get anything back */
	    { fprintf(stderr,"SGMPX : No variables in response\n");
	      exit(1);
	    }
	/* check if we have finished with interfaces */
	 if(strncmp(cvtedtyp->str,currentvar->var_name->str,
						cvtedtyp->len) != 0)
	  { done =  1;
		continue;
   	  }

      if( *(currentvar->var_name->str) == '_')
	{ if ((struct_string = sgmp_var_cvt
		(currentvar->var_name,CVTIPADD)) == NULL)
	   { fprintf(stderr,"SGMPX : Error while converting var. name\n");
		exit(1);
	   }
	  stats[interfacenum].name = struct_string->str;
	}
      else
	{if((struct_string = sgmp_var_cvt
		(currentvar->var_name,NUMTOSYM)) == NULL)
	   { fprintf(stderr,"SGMPX : Error while converting var. name\n");
		exit(1);
	   }
		stats[interfacenum].name = struct_string->str;
	}
 
	/*  the type of interface */
	/* figure out what type of interface it is */
   	switch((int)(currentvar->var_value.value.intgr))
	 { 
   	 case 0:  stats[interfacenum].type = "Unspecified"; break;
   	 case 1:  stats[interfacenum].type = "IEEE 802.3 MAC"; break;
         case 2:  stats[interfacenum].type = "IEEE 802.4 MAC"; break;
         case 3:  stats[interfacenum].type = "IEEE 802.5 MAC"; break;
   	 case 4:  stats[interfacenum].type = "Ethernet"; break;
   	 case 5:  stats[interfacenum].type = "ProNET-80"; break;
   	 case 6:  stats[interfacenum].type = "ProNET-10"; break;
   	 case 7:  stats[interfacenum].type = "FDDI"; break;
   	 case 8:  stats[interfacenum].type = "X.25"; break;
   	 case 9:  stats[interfacenum].type = "PP Serial"; break;
   	 case 10: stats[interfacenum].type = "Prop. PP Serial"; break;
   	 case 11: stats[interfacenum].type = "ARPA 1822 HDH"; break;
   	 case 12: stats[interfacenum].type = "ARPA 1822"; break;
   	 case 13: stats[interfacenum].type = "AppleTalk"; break;
   	 case 14: stats[interfacenum].type = "StarLAN"; break;
   	 default: stats[interfacenum].type = "Unknown"; break;
   }
/* prepare for next request, since we are at the right spot */
   if((av[0] = (strng *)malloc(currentvar->var_name->len)) == NULL)
    { fprintf(stderr,"can't allocate space for variable to be requested\n");
      exit(1);
    }
   else				/* we could get space, copy name in */
   {if((av[0]->str = (char *)malloc(sizeof(char) * 20)) == NULL)
    { fprintf(stderr,"can't allocate space for variable to be requested\n");
      exit(1);
    }
   }
    for(i = 0; i < currentvar->var_name->len; i++)
     (av[0]->str)[i] = (currentvar->var_name->str)[i];
    av[0]->len = currentvar->var_name->len;
   
/* move on to status */
   currentvar = currentvar->var_next;
   if(currentvar == NULL)	/* no more variables? */
   {stats[interfacenum].status = "Unknown";
    goto label;
   }

   switch(currentvar->var_value.value.intgr) { /* what is the status? */
    case 0: stats[interfacenum].status = "Normal"; break;
    case 1: stats[interfacenum].status = "Missing"; break;
    case 2: stats[interfacenum].status = "Disabled"; break;
    case 3: stats[interfacenum].status = "Down"; break;
    case 4: stats[interfacenum].status = "Linking"; break;
    default: stats[interfacenum].status ="Unknown"; break;
   }
/*  prepare for next request, since we are at the right spot */
   label : if((av[1] = (strng *)malloc(currentvar->var_name->len)) == NULL)
    { fprintf(stderr,"can't allocate space for variable to be requested\n");
      exit(1);
    }
   else				/* we could get space, copy name in */
   {if((av[1]->str = (char *)malloc(sizeof(char) * 20)) == NULL)
    { fprintf(stderr,"can't allocate space for variable to be requested\n");
      exit(1);
    }
   }
    for(i = 0; i < currentvar->var_name->len; i++)
     (av[1]->str)[i] = (currentvar->var_name->str)[i];
    av[1]->len = currentvar->var_name->len;

/*  OK, done. Now prepare for next message */
/*  we've already prepared av above */
   interfacenum++;		/* onto next interface */
   free(req_msg); free(reply);	/* deallocate the messages */
  } while (!done && (interfacenum < MAX_GW_INTERFACE) );/* end of main loop */
	term_sgmp_comm(req_id);	/*  socket not needed any more */ 
	break;
  }
	case IFNUMBFLAG:
	{
	/* set up string structures for variable conversion */
  	temp1.len = strlen(INFNUMB);	/* interface number */
        temp1.str = INFNUMB; 

	/* convert interface type */
 	 if((cvtedifnumb = sgmp_var_cvt(&temp1,SYMTONUM)) == NULL)
   	{ fprintf(stderr,"SGMPX : couldn't convert %s\n",temp1.str);
   	  exit(1);
  	 }
	/* fill in first request */
 	 ac = 1;			/* we're asking for two variables */
	  av[0] = cvtedifnumb;		/* interface type */
	  req_id = getpid() ^ (int)time(0); /* the request id */

	/* now get the information we want */
 	 do {				/* iterate to get information */
	   retries = 0;			/* we haven't timed out yet */
	/* create a request */
	   if((req_msg = (get_req_msg_type *)
		create_sgmp_req(req_id,ac,av)) == NULL)
	    { fprintf(stderr,"SGMPX : Cannot create request message\n");
	      exit(1);
	    }
	/* preserve the environment */
	   if(setjmp(env))
	    {if(retries < MAXRETRIES)	/* if we should retry again */
	{ fprintf(stderr, "SGMPX :: Timed out in receive. Retrying ... \n");
           retries++;		/* retry one more time */
	}
	    else			/* we exceeded the number of retries */
	     { fprintf(stderr,"SGMPX : giving up\n");
	       exit(1);
	     }
	    }
	/* send off request */
	       signal(SIGALRM,SIG_IGN);
	       if((rc = send_sgmp_mesg
			(GET_REQ_MESG,req_id,address,SERVICE,req_msg,
			      *s_id,strlen(*s_id),TIMEOUT)) < 0)
	    switch(rc) {
	     case SEND_TIMEOUT:		/* timed out */
	      fprintf(stderr,"SGMPX : send timeout\n");
	      exit(1);
	     case GEN_ERR:		/* some unknown error */
	      fprintf(stderr,"SGMPX : generic error in send\n");
	      exit(1);
	     default:			/* strange error */
	      fprintf(stderr,"SGMPX : unknown error return in send\n");
	      exit(1);
	    }
	/* sent off request, now wait for a response */
	   signal(SIGALRM,onintr);
	   setitimer(ITIMER_REAL,&interval); /* start timer */
	   reply = (get_rsp_msg_type *)
			recv_sgmp_mesg(from,NULL,&req_id,msg_type,s_id);
	   setitimer(ITIMER_REAL,&disable); /* disable the receive timer */
	   if(reply == NULL)
	    { fprintf(stderr,"SGMPX : could not get a coherent reply\n");
	      exit(1);
	    }
	   if(*msg_type != GET_RSP_MESG)	/* if this wasn't a response message */
	    { fprintf(stderr,"SGMPX : incorrect response from gateway\n");
	      exit(1);
	    }
	   if(reply->error_status != 0)	/* check if we got back an error */
	    { fprintf(stderr,"SGMPX : received error indication\n");
	      fprintf(stderr,"error was in variable %d\n",reply->error_index);
	    }
	   currentvar = reply->var_op_list;
	   if(currentvar == NULL)	/* if we didn't get anything back */
	    { fprintf(stderr,"SGMPX : No variables in response\n");
	      exit(1);
	    }
	/* check if we have finished with interfaces */
	 if(strncmp(cvtedifnumb->str,currentvar->var_name->str,
						cvtedifnumb->len) != 0)
	  { done =  1;
		continue;
   	  }
	
	if(isdigit((currentvar->var_value.value.str->str)[0]))	
          stats[interfacenum].number = currentvar->var_value.value.str->str;
	else
	 { long address;
	   ((char *)(&address))[0] = reply->var_op_list->var_value.value.str->str[0];
	  	
	   ((char *)(&address))[1] = reply->var_op_list->var_value.value.str->str[1];
	   ((char *)(&address))[2] = reply->var_op_list->var_value.value.str->str[2];
	   ((char *)(&address))[3] = reply->var_op_list->var_value.value.str->str[3];
	   if((stats[interfacenum].number =
		(char *)malloc(sizeof(char) * 20)) == NULL)
	   { fprintf(stderr, "SGMPX :: Could not allocate memory\n");
	     exit(1);
	   }
	   strcpy(stats[interfacenum].number,stdtodot(ntohl(address)));
	}
 
/* prepare for next request, since we are at the right spot */
   if((av[0] = (strng *)malloc(currentvar->var_name->len)) == NULL)
    { fprintf(stderr,"can't allocate space for variable to be requested\n");
      exit(1);
    }
   else				/* we could get space, copy name in */
   {if((av[0]->str = (char *)malloc(sizeof(char) * 20)) == NULL)
    { fprintf(stderr,"can't allocate space for variable to be requested\n");
      exit(1);
    }
   }
    for(i = 0; i < currentvar->var_name->len; i++)
     (av[0]->str)[i] = (currentvar->var_name->str)[i];
    av[0]->len = currentvar->var_name->len;
   

/*  OK, done. Now prepare for next message */
/*  we've already prepared av above */
   interfacenum++;		/* onto next interface */
   free(req_msg); free(reply);	/* deallocate the messages */
  } while (!done && (interfacenum < MAX_GW_INTERFACE) );/* end of main loop */
	term_sgmp_comm(req_id);	/*  socket not needed any more */ 
	break;
  }
	case DATAFLAG : /* Time to fetch interface statistics */
	{
	/* set up string structures for variable conversions */
	temp1.len = strlen(INPKTS);	/*input packets */
	temp1.str = INPKTS;
	temp2.len = strlen(OUTPKTS);	/*output packets */
	temp2.str = OUTPKTS;
	temp3.len = strlen(INBYTES);    /* input bytes */
	temp3.str = INBYTES;
	temp4.len = strlen(OUTBYTES);	/* output bytes */
	temp4.str = OUTBYTES;
	
	/* convert input packets */
	if (( cvtedinp = sgmp_var_cvt(&temp1,SYMTONUM)) == NULL)
	{ fprintf(stderr, " SGMPX : Couldn't convert %s\n",temp1.str);
	exit(1);
	}
	/* convert output packets */
	if (( cvtedoup = sgmp_var_cvt(&temp2,SYMTONUM)) == NULL)
	{ fprintf(stderr, " SGMPX : Couldn't convert %s\n",temp2.str);
	exit(1);
	}
	/* convert input bytes */
	if (( cvtedinb = sgmp_var_cvt(&temp3,SYMTONUM)) == NULL)
	{ fprintf(stderr, " SGMPX : Couldn't convert %s\n",temp3.str);
	exit(1);
	}
	/* convert output bytes */
	if (( cvtedoub = sgmp_var_cvt(&temp4,SYMTONUM)) == NULL)
	{ fprintf(stderr, " SGMPX : Couldn't convert %s\n",temp4.str);
	exit(1);
	}
	/* fill in the first request */
	av[0] = cvtedinp;		/* input packets */
	av[1] = cvtedoup;		/* output packets */
	av[2] = cvtedinb;		/* input bytes */
	av[3] = cvtedoub;		/* output bytes */
	ac = 4;				/* requesting 4 variables */
	req_id = getpid() ^ (int)time(0); /* request id */

	/* get the information required */
	do {
	retries =0;
	/* create a request */
	  if(( req_msg = (get_req_msg_type *)
	      create_sgmp_req(req_id,ac,av)) == NULL)
	{fprintf(stderr,
		"SGMPX : Cannot create requested message\n");
		exit(1);
	}

	/* preserve the envioronment */
	if(setjmp(env))
	 {if (retries < MAXRETRIES)
	  { fprintf(stderr, " SGMPX :: Receive timed out. Retrying ...\n");
	    retries++;
	    if(num_of_val> 1)
	    adjust_values(TIMEOUT,w);
	   }
	    else
	     { fprintf(stderr, "SGMPX : No response being received\n");
	       exit(1);
	     }
	 }

	/* send of the request */
	 signal(SIGALRM,SIG_IGN);
	 if(( rc = send_sgmp_mesg
		(GET_REQ_MESG,req_id,address,SERVICE,req_msg,*s_id,
			strlen(*s_id), TIMEOUT)) < 0)
	    switch(rc) {
	     case SEND_TIMEOUT:		/* timed out */
	      fprintf(stderr,"SGMPX : send timeout\n");
	      exit(1);
	     case GEN_ERR:		/* some unknown error */
	      fprintf(stderr,"SGMPX : generic error in send\n");
	      exit(1);
	     default:			/* strange error */
	      fprintf(stderr,"SGMPX : unknown error returned in send\n");
	      exit(1);
	    }
	/* sent off request, now wait for a response */
	   signal(SIGALRM,onintr);
	   setitimer(ITIMER_REAL,&interval); /* start timer */
	   reply = (get_rsp_msg_type *)
			recv_sgmp_mesg(from,NULL,&req_id,msg_type,s_id);
	   setitimer(ITIMER_REAL,&disable); /* disable the receive timer */
	   if(reply == NULL)
	    { fprintf(stderr,"SGMPX : could not get a coherent reply\n");
	      exit(1);
	    }
	   if(*msg_type != GET_RSP_MESG)	/* if this wasn't a response message */
	    { fprintf(stderr,"SGMPX : incorrect response from gateway\n");
	      exit(1);
	    }
	   if(reply->error_status != 0)	/* check if we got back an error */
	    { fprintf(stderr,"SGMPX : received error indication\n");
	      fprintf(stderr,"error was in variable %d\n",reply->error_index);
	    }
	   currentvar = reply->var_op_list;
	   if(currentvar == NULL)
	   { fprintf(stderr,"SGMPX :: No variables in response\n");
	     exit(1);
	   }
	  
	   /* check if we have finished with the interfaces */
	 if(strncmp(cvtedinp->str,currentvar->var_name->str,
						cvtedinp->len) != 0)
	  { done =  1;
		continue;
   	  }
	/* first the input packets */
	if(want_IP)
	 {
	  if((stats[interfacenum].packets_in.value[num_of_val] =
		(currentvar->var_value.value.intgr - 
			stats[interfacenum].packets_in.old)/update_value) < 0)
							/* If the above is
							 * true ,our estimate
						         * during time out
						         * was not good. Plot the
							 * old value */
	      stats[interfacenum].packets_in.value[num_of_val] =
		stats[interfacenum].packets_in.value[num_of_val - 1];	
	  
	 
	  stats[interfacenum].packets_in.old =
		currentvar->var_value.value.intgr;
	 }
	/*prepare the next request */
	if ((av[0] = (strng *)malloc(currentvar->var_name->len)) == NULL)
	{ fprintf(stderr,"Can't allocate memory, exiting ...\n");
	  exit(1);
	}
	else
   	{if((av[0]->str = (char *)malloc(sizeof(char) * 20)) == NULL)
    	 {fprintf(stderr,"can't allocate space for variable to be requested\n");
      		exit(1);
    	 }
   	}
	  for(i = 0;i < currentvar->var_name->len; i++)
		(av[0]->str)[i] = (currentvar->var_name->str)[i];
	  av[0]->len = currentvar->var_name->len;


	/* second, the output packets */
	currentvar = currentvar->var_next;
	if(currentvar == NULL )
	  {fprintf(stderr,"SGMPX : Variable missing\n");
		exit(1);
	  }
	if(want_OP)
	  {
	 	if((stats[interfacenum].packets_out.value[num_of_val] =
		(currentvar->var_value.value.intgr -
			stats[interfacenum].packets_out.old)/update_value) < 0)
		stats[interfacenum].packets_out.value[num_of_val] =
		 stats[interfacenum].packets_out.value[num_of_val - 1];
		stats[interfacenum].packets_out.old =
			currentvar->var_value.value.intgr;
	  }
	/*prepare the next request */
	if ((av[1] = (strng *)malloc(currentvar->var_name->len)) == NULL)
	{ fprintf(stderr,"Can't allocate memory, exiting ...\n");
	  exit(1);
	}
	else
   	{if((av[1]->str = (char *)malloc(sizeof(char) * 20)) == NULL)
    	 {fprintf(stderr,"can't allocate space for variable to be requested\n");
      		exit(1);
    	 }
   	}
	  for(i = 0;i < currentvar->var_name->len; i++)
		(av[1]->str)[i] = (currentvar->var_name->str)[i];
	  av[1]->len = currentvar->var_name->len;

	/* Third, the input bytes */
	currentvar = currentvar->var_next;
	if(currentvar == NULL )
	  {fprintf(stderr,"SGMPX : Variable missing\n");
		exit(1);
	  }

	if(want_IB)
	 {	
		if((stats[interfacenum].bytes_in.value[num_of_val] =
			(currentvar->var_value.value.intgr -
			stats[interfacenum].bytes_in.old)/update_value) < 0)
		stats[interfacenum].bytes_in.value[num_of_val] =
		 stats[interfacenum].bytes_in.value[num_of_val - 1];
		stats[interfacenum].bytes_in.old =
			currentvar->var_value.value.intgr ;
	 }

	/*prepare the next request */
	if ((av[2] = (strng *)malloc(currentvar->var_name->len)) == NULL)
	{ fprintf(stderr,"Can't allocate memory, exiting ...\n");
	  exit(1);
	}
	else
   	{if((av[2]->str = (char *)malloc(sizeof(char) * 20)) == NULL)
    	 {fprintf(stderr,"can't allocate space for variable to be requested\n");
      		exit(1);
         }
   	}
	  for(i = 0;i < currentvar->var_name->len; i++)
		(av[2]->str)[i] = (currentvar->var_name->str)[i];
	  av[2]->len = currentvar->var_name->len;

	/* Fourth, the output bytes */
	currentvar = currentvar->var_next;
	if(currentvar == NULL )
	  {fprintf(stderr,"SGMPX : Variable missing\n");
		exit(1);
	  }
	if(want_OB)
	 {	
		if((stats[interfacenum].bytes_out.value[num_of_val] =
			(currentvar->var_value.value.intgr -
			stats[interfacenum].bytes_out.old)/update_value) < 0)
		stats[interfacenum].bytes_out.value[num_of_val] =
		 stats[interfacenum].bytes_out.value[num_of_val - 1];
		stats[interfacenum].bytes_out.old =
			currentvar->var_value.value.intgr ;
	 }
	/*prepare the next request */
	if ((av[3] = (strng *)malloc(currentvar->var_name->len)) == NULL)
	{ fprintf(stderr,"Can't allocate memory, exiting ...\n");
	  exit(1);
	}
	else
   	{if((av[3]->str = (char *)malloc(sizeof(char) * 20)) == NULL)
    	 {fprintf(stderr,"can't allocate space for variable to be requested\n");
      		exit(1);
         }
   	}
	  for(i = 0;i < currentvar->var_name->len; i++)
		(av[3]->str)[i] = (currentvar->var_name->str)[i];
	  av[3]->len = currentvar->var_name->len;

	/* All done, prepare for next message */
	interfacenum++; /* The next interface */ 
	free(req_msg); free(reply);
	} while (!done && (interfacenum < MAX_GW_INTERFACE) );
        term_sgmp_comm(req_id);
    break;
   }	
 }
}
/************************************************************************
**			adjust_values()
**	In case of a timeout while receiving data an assumption is made
** to the effect that the number of packets/bytes that went by was the
** same as in the previous interval. This is plotted rather than the 
** actual value which is received after the timeout, which is rather
** big (depending on the time interval).
***********************************************************************/

adjust_values(TIMEOUT,w)
int TIMEOUT;
Window w;
{
 int i; 
 for( i = 0; i < actual_number; i++)
   {
	  stats[i].packets_in.old +=
	  stats[i].packets_in.value[num_of_val - 1] * (TIMEOUT)/(update_value*2);
	  stats[i].packets_in.value[num_of_val] =
	    stats[i].packets_in.value[num_of_val-1] ;

	  stats[i].packets_out.old +=
	  stats[i].packets_out.value[num_of_val - 1] * (TIMEOUT)/(update_value*2);
	  stats[i].packets_out.value[num_of_val] = 
	    stats[i].packets_out.value[num_of_val - 1];

	  stats[i].bytes_in.old +=
	  stats[i].bytes_in.value[num_of_val - 1] * (TIMEOUT)/(update_value*2);
	  stats[i].bytes_in.value[num_of_val] =
	    stats[i].bytes_in.value[num_of_val-1];

	  stats[i].bytes_out.old +=
	  stats[i].bytes_out.value[num_of_val - 1] * (TIMEOUT)/(update_value*2);
	  stats[i].bytes_out.value[num_of_val] =
	    stats[i].bytes_out.value[num_of_val-1];
  }
	 
   next_display(w); 
 }

	  	
onintr()
{ longjmp(env);
}

