/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/
/**************************************************************************
**                          util.c
**
**  The following are the support functions for the SGMPWATCH application.
**
*************************************************************************/
#include "sgmp.h"               /* general include file */
#include "sgmpwatch.h"          /* application specific file */
int verbose;                    /* identify the verbose option */
jmp_buf sjbuf;                  /* the buffer for timer use */


/* process the messages */

process_mesg(mesg,req_id,sid,slen,interval,var_count,variable,number)
get_req_msg_type *mesg;
int req_id;
char *sid;
int slen;
int interval;
int var_count;
struct var_value variable[];   /* table of variables */
int *number;

{
long time1,time2,temp_time;              /* for the time */
struct itimerval *value, *ovalue;        /* for the timer */
int *from;                               /* the address of the sender */
int *type;                               /*the type of the message received */
char **session_id;                       /* the session_id */
int interrupt_handler();                 /* to handle timeout */

/* allocate memory space for from */
 if((from = (int *)malloc(sizeof(int))) == NULL)
   {fprintf(stderr,"Cannot allocate memory in process_mesg,exiting...\n");
  exit(1);
  }
 if((type = (int *)malloc(sizeof(int))) == NULL)
   {fprintf(stderr,"Cannot allocate memory in process_mesg,exiting...\n");
  exit(1);
  }

 if(interval == 0)
    interval = default_interval;
   
 time(&time1);
  
 if((send_sgmp_mesg
(GET_REQ_MESG,req_id,*number,"sgmp",mesg,sid,slen,interval)) == SEND_TIMEOUT)
{
 fprintf(stderr,"SGMPWATCH : Time out while trying to  send packet\n");
 return;
}
 time(&time2);

/* set the timer */
/* first the memory spaces */

if((value = (struct itimerval *)malloc(sizeof(struct itimerval))) == NULL)
{fprintf(stderr,"Cannot allocate memory in util.c, exiting ...");
 exit(1);
}

if((ovalue = (struct itimerval *)malloc(sizeof(struct itimerval))) == NULL)
{fprintf(stderr,"Cannot allocate memory in util.c, exiting ...");
 exit(1);
}

temp_time = interval - (time2 - time1);   /* for later use */
value->it_value.tv_sec = temp_time;       /* set the second field */
value->it_value.tv_usec = 0;              /* set the micro sec field */
value->it_interval.tv_sec = 0;            /* set the second field */
value->it_interval.tv_usec = 0;           /* set the micro sec field */

time(&time1);

setitimer(ITIMER_REAL,value,ovalue);     /* start the timer */
 signal(SIGALRM,interrupt_handler);

if(setjmp(sjbuf) < 0)
{
 fprintf(stderr,"SGMPWATCH :: recv_sgmp_msg : Timeout, no response received \n");
  return;
}
/* message sent( hopefully!) - now receive the response */

 mesg =  (get_rsp_msg_type *)recv_sgmp_mesg(from,NULL,&req_id,type,&session_id); 

 process_received_mesg(mesg,from,var_count,variable);

  time(&time2);
/* check if there is any time left before the next request */

 if((temp_time - (time2 - time1)) > 0)         /* if there is time */
   sleep(temp_time - (time2 - time1));         /* take a 'nap' */

 return;
}


process_received_mesg(rsp_mesg,from,var_count,variable)
get_rsp_msg_type *rsp_mesg;
int *from;
int var_count;
struct var_value variable[];

{

int err_val;                          /* the error number */
int index;                            /* index to the faulty variable*/
int var_index = 0;                    /* index to the variables */
int string_size;                      /* size of 'string' */
int i,j = 0;                          /* index into message */
int k;                                /* counter */
static int var_rec_intgr = 0;         /* indicates integer value is recorded*/
static int var_rec_strng = 0;         /* indicates string value is recorded*/
char *string;                         /* the name of the variable */
char message[128];                    /* message to go into the logs */
char netnumb[16];                     /* net number in the dot notation*/
struct smpask_file_var *log;          /* for logs to be opened */
struct var_value *fv;                 /* pointer for var and file name*/
struct var_value *find_entry();       /* function to verify a variable */
FILE *fp;                             /*file pointer to write into the logs*/
long clock;                           /* to get the time */
var_op_list_type p,temp;              /* ptr. to the variables in mesg. */
strng *struct_string;                 /* a character string structure */
strng *sgmp_var_cvt();                /* the variable converter */

switch( rsp_mesg->error_status)       /* check for any errors */
  {
 case GMP_ERR_NOERROR:                /* no error, process reply */
  p = rsp_mesg->var_op_list;          /* pointer to list of variables */
   break;

 case GMP_ERR_TOO_BIG:                /* packet sent too big */
      fprintf(stderr,"SGMPWATCH : GMP_ERR_TOO_BIG : Packet sent resulted in too large a reply\n");
        return;

 case GMP_ERR_BAD_VALUE:                 /* bad variable value */
      fprintf(stderr,"SGMPWATCH : GMP_ERR_BAD_VALUE : Bad variable value\n");
       return;
 
 case GMP_ERR_NIX_NAME :                 /* bad variable name */

       fprintf(stderr,"SGMPWATCH :: GMP_ERR_NIX_NAME : Bad variable name\t");

      index =  rsp_mesg->error_index;
      p = rsp_mesg->var_op_list;
      index--;
      while(index > 0)      /* get to the bad variable */
      { index--;
        p = p->var_next;
    if(p == NULL)
      {fprintf(stderr,"\nSGMPWATCH :: GMP_ERR_NIX_NAME : Index specified is non-existent\n");
       exit(1);
     }
      }



  /* get the string to the printable form if needed */
  /* it is assumed here that any IP address returned will be in standard
   notation (ie: a 32 bit quantity) and not in dot notation */
  if(*(p->var_name->str) == '_')
    {  if(( struct_string = sgmp_var_cvt(p->var_name,CVTIPADD)) == NULL)
	 {fprintf(stderr,"SGMPWATCH:: sgmp_var_cvt : Error while converting the variable name");
            exit(1);
	}
        string = struct_string->str;
	}
  else
    {if(( struct_string = sgmp_var_cvt(p->var_name,NUMTOSYM)) == NULL)
	 {fprintf(stderr,"SGMPWATCH :: sgmp_var_cvt : Error while converting the variable name");
            exit(1);
	}
      string = struct_string->str;
      }

       fprintf(stderr,"\t%s\n",string);
        return;

 default:
       fprintf(stderr,"SGMPWATCH : UNKNOWN ERROR\n");
       return;

      }
 /* start processing the reply */
while(p != NULL)                 /* till the last variable is not reached*/
  {
 time(&clock);                   /* get the time */

 sprintf(message,"%s",ctime(&clock));  /* record the time */
 for(i = 0;message[i] != '\n'; i++)
           ;
 message[i++] = '\t';
  /* put in the net number */
 sprintf((message + i),"%d.%d.%d.%d\t",(((char *)((from)))[0] & CONVMASK),
                                       (((char *)((from)))[1] & CONVMASK),
                                       (((char *)((from)))[2] & CONVMASK),
                                       (((char *)((from)))[3] & CONVMASK));

 for (;message[i] != '\t'; i++)      /* find the delimiter */
            ;
  i++;

 /* put in the variable name and its value, after checking it out */
  
  string = p->var_name->str;        /* the variable name */
  string_size = p->var_name->len;
/* it is assumed here that any IP address returned will be in standard
   notation (ie: a 32 bit quantity) and not in dot notation */
  if(*string == '_')
    {  if(( struct_string = sgmp_var_cvt(p->var_name,CVTIPADD)) == NULL)
	 {fprintf(stderr,"SGMPWATCH :: sgmp_var_cvt : Error while converting the variable name");
            exit(1);
	}
  string = struct_string->str;
	}
  else
    {if(( struct_string = sgmp_var_cvt(p->var_name,NUMTOSYM)) == NULL)
	 {fprintf(stderr,"SGMPWATCH :: sgmp_var_cvt : Error while converting the variable name");
            exit(1);
	}
      string = struct_string->str;
      }
 
 if((fv = find_entry(variable,var_count,string,variable)) == NULL)
   { fprintf(stderr,"SGMPWATCH :: Received response for a variable not requested :: %s\n",string);
 p = p->var_next;                   /* the next variable in the list */
     continue;                         /* fetch the next variable */
   }
 sprintf((message + i),"%s\t",string); /* variable name */
  for( ;message[i] != '\t'; i++)       /* find the delimiter */
             ;
  i++;

  switch(p->var_value.type)
    {
    case  INTEGER:
        /*if it is the response to first query or the option is verbose */
        if(!var_rec_intgr | verbose )
               {sprintf((message +i),"%d\n",(p->var_value.value.intgr));
                 variable[j].value.intgr = p->var_value.value.intgr;
                 var_rec_intgr = 1;
                 break;
	       }
       else
  if(p->var_value.value.intgr != variable[j].value.intgr)
               { sprintf((message +i),"%d\n",(p->var_value.value.intgr));
                  break;
               }
             j++;
               p = p->var_next;           /*the next variable in the list */
              continue;
    
       case PRIM_STR:
        /*if it is the response to first query or the option is verbose */
        if(!var_rec_strng | verbose)              
          { sprintf((message +i),"%s\n",p->var_value.value.str->str);
            variable[j].value.string = p->var_value.value.str->str;
               var_rec_strng = 1;
             break;
          }
       else
             if( strcmp(p->var_value.value.str->str,variable[j].value.string))
               { sprintf((message +i),"%s\n",p->var_value.value.str->str);
                 break;
               }
            j++;
             p = p->var_next;              /* the next variable in the list */
             continue;

    }          

 p = p->var_next;                      /* the next variable in the list */
 /* the message is constructed */

 fprintf(stdout,"%s",message);    /* log in the message */
 fprintf(stdout,"\007 \n");              /* beep */
 j++;                           /* the next variable */
 }      
}
 

interrupt_handler()
{
 signal(SIGALRM,interrupt_handler);
 longjmp(sjbuf,-1);
}
