/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/
/**********************************************************************
**
**                            tbl_util.c
**
**  This contains functions to manupilate the the database(currently flat
** files) of SGMPWATCH.
**
************************************************************************/

#include "sgmp.h"                 /* general include file */
#include "sgmpwatch.h"            /* application specific file */

/* new_table - sorts the data variable wise, size being given in 'size'*/

new_table(size,option_count,var,variable)
int size;                        /* size of the table */
int option_count;                /* numb. of options specified */
char *var[];                     /* data to be put in */
struct var_value variable[];     /* array of pointers */

{ int i,j;                       /* counters */
  char  *temp;                   /* temporary buffer */

for(i = 0; i < size; i++)
  strcpy(variable[i].data,var[option_count + i + 2]);/*copy contents of argv */
  /*allocate memory space */
  if((temp = (char *)malloc(128 * sizeof(char))) == NULL)
  { fprintf(stderr,"new_table: cannot allocate space for var. name\n");
    return(-1);
  }

 /* sort the data and fill in the table - bubble sort */
  for(i = 0; i < size - 1; i++)
   for(j = size - 1; j > i;j--)
    if(strcmp(variable[j].data,variable[j-1].data) < 0) 
 {   strcpy(temp, variable[j-1].data);             
     strcpy(variable[j-1].data,"");             /*clear */
     strcpy(variable[j-1].data,variable[j].data);
     strcpy(variable[j].data,"");               /* clear */
     strcpy(variable[j].data,temp); 
     strcpy(temp,"");                  /* clear */    
  }

 /* free allocated memory space */
 free(temp);

 return(0);
 }

 /* find entry - find an entry in the table given a variable name */
 struct var_value *
 find_entry(variable,size,string)
 struct var_value variable[];
 int size;
 char *string;

{ int index;                  /* index into the table */
  int upper,lower;            /* the current upper and lower bounds */
/* check for special case of first element */
 if(strncmp(variable[0].data,string,strlen(variable[0].data)) == 0)/* if same */
     return(variable);
/* initialize the search */
  lower = 0;                  /* beginning of table */
  upper = size;               /* end of table */
  do{
    index = (lower + upper)/2;
  if(strncmp(variable[index].data,string,strlen(variable[index].data)) == 0)     /* if same */
     return(variable + index);    /* return the pointer to the structure */
  if(strncmp(variable[index].data,string,strlen(variable[index].data)) >  0)     
   upper = index;
 else
    lower = index;
  }while (upper > (lower+1));
  return((struct var_value *)NULL);
}
    
