/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/

  /***************************************************************************
**                         sgmpwatch
**
**   This is the shell program for the sgmpwatch application. This application
** is intended to monitor any change in variable values over a specific
** interval of time.
**
**             Usage:
**                  sgmpwatch [options]  gateway variable(s)
**
***************************************************************************/

#include "sgmp.h"                         /* general include file */
#include "sgmpwatch.h"			  /* application specific include */
int verbose = 0;                          /* flag for verbose output */
int interval = 0;                         /* interval between each query */
int session_len;   	                  /* length of the session id */
char *session_id;        	          /* the session id */

main(argc,argv)
int argc;
char *argv[];

{
int conv();                        /* fuction for conversion */
int var_count = 0;                 /* the number of variables to be monitored*/
int option_count = 0;              /* numb. of options specified */
int pid;                           /* the process id */
int req_id;                        /* the request id */
int i;                             /* counter */
long *number;                       /* pointer to the gateway number */
short var_size = 0;                /* the size of a variable */
long clock;                        /* the time */
struct var_value variable[MAX_VAR];/* array of pointers */
void print_usage();                /* to print usage of sgmpwatch */
strng *struc_strng;                /* for char & it's size */
get_req_msg_type *mesg;            /* message to be sent */
var_op_list_type temp,p;           /* pointers to the varibles in message */
struct hostent *hp;		   /* in case user specified a host name */

/* The default session name */                           
 session_id = "public";
 session_len = 6;

 /* check the  number of command line  arguments */
 if(argc < 3  )
    print_usage();
 if(argv[1] != NULL)
        { if(!strncmp("_GW_",argv[1],4)) 
          print_usage();
        }
     else
         print_usage();

/* Read the options and process them */
if(argv[1][0] == '-')
      {if(process_option(argv[1]) < 0)          /* process the option */
         exit(1);
           option_count++;
      }
if(argv[2][0] == '-')             
      {if(process_option(argv[2]) < 0)          /* process the next option */
       exit(1);
        option_count++;
      }
if((argv[option_count + 1]!= NULL) & (argv[option_count + 2] != NULL))
     {if(!strncmp(argv[option_count + 1],"_GW_",4))
     print_usage();
     }

 else
     print_usage();

/* get the number of variables specified */
   var_count = argc - option_count - 2;
/* allocate memory space for the table of variables */

for(i = 0; i <= MAX_VAR; i++)
  {if((variable[i].data = (char *)malloc(sizeof(char)* 100)) == NULL)
       {fprintf(stderr,"Could not allocate memory in main.c, exiting... \n");
        exit(1);
       }
   if((variable[i].value.string = (char *)malloc(sizeof(char)* 100)) == NULL)
       {fprintf(stderr,"Could not allocate memory in main.c, exiting... \n");
        exit(1);
       }
  }
/* get the gateway in byte form */
  number = (long *)malloc(sizeof(long));   /* memory for the bytes */
  if(argv[option_count + 1] == NULL)
    {fprintf(stderr,"SGMPWATCH :: No gateway address given\n");
     exit(1);
    }

  if(isalpha(argv[option_count + 1][0]))	 /* if user specified a hostname */
   if((hp = gethostbyname(argv[option_count + 1])) == NULL)
    { fprintf(stderr,"SGMPWATCH :: cannot get address for %s\n",argv[option_count + 1]);
      exit(1);
    }
   else					 /* we were able to get address */
    bcopy(hp->h_addr,(char *)(number),hp->h_length);
  else					 /* user specified address */
   nstob(argv[option_count + 1],number);

/* sort and store the variables in a table for later reference */
if((new_table(var_count,option_count,argv,variable)) < 0)
   exit(1);

/* allocate memory fo the 'get_req_mesg_type' */
if((mesg = (get_req_msg_type *)malloc(sizeof(get_req_msg_type))) == NULL)
  {fprintf(stderr,"Could not allocate memory in main.c, exiting ...\n");
    exit(1);
  }
/* construct the packet to be sent */
                                  /* compute the request id */
pid = getpid();                   /* get the process id */
 time(&clock);                    /* get the time */
req_id = mesg->request_id = pid ^ (int)ctime(&clock);
mesg->error_status = 0;           /*initialze */
mesg->error_index = 0;            /*initialize */
                                  /* construct the variable list */
  if((mesg->var_op_list = (var_op_type *)malloc(sizeof(var_op_type))) == NULL)
  {fprintf(stderr,"Cannot allocate memory in main.c, exiting ... \n");
   exit(1);
  }
 p = mesg->var_op_list;

if(sgmp_init_cvt("/etc/sgmp.variables")< 0)
  {fprintf(stderr,"SGMPWATCH :: sgmp_init_cvt : Error while initializing the convertor \n");
   exit(1);
   }

for(i = 0; i < var_count; i++)    /* create the message to be sent */
  {
   p->var_value.type = INTEGER;   /* dummy allocation */
   p->var_value.value.intgr = 0;  /* dummy allocation */
                                  /*memory for string structure */
if((struc_strng = (strng*)malloc(sizeof(strng))) == NULL)
  {fprintf(stderr,"Could not allocate memory in main.c, exiting...\n");
    exit(1);
  }
p->var_name = struc_strng;
var_size = strlen(argv[i + option_count + 2]); /* size of variable */
                                  /* memory for strng->str */
if((struc_strng->str = (char *)malloc(var_size + 1)) == NULL)
   {fprintf(stderr,"Could not allocate memory in main.c, exiting ...\n");
    exit(1);
   }
                                  /* fill in variable and it's size */
struc_strng->str = argv[i + option_count + 2];   /* the variable */
struc_strng->len = var_size;
if((p->var_name = sgmp_var_cvt(struc_strng,SYMTONUM)) == NULL)
   {fprintf(stderr,"SGMPWATCH :: sgmp_var_cvt : Error while converting symbol-number\n");
    fprintf("Check the variable(s) requested to be monitored\n");
    exit(1);
   }
if(i != var_count - 1 )           /* allocate pointer to next variable */
   { if((temp = (var_op_type*)malloc(sizeof(var_op_type))) == NULL)
       {fprintf(stderr,"Cannot allocate memory in main.c,exiting ...\n");
	exit(1);
       }
   p->var_next = temp;
   p = temp;                      /* for the next variable */
   }
else
  p->var_next = (var_op_list_type)NULL;
}

/* All the initializations are over, start sending and receiving messages */

 p = mesg->var_op_list;

 /* Start sending and receiving messages */
for(;;)
  process_mesg(mesg,req_id,session_id,session_len,interval,var_count,variable,number);
 
 }



 
/*************************************************************************
**   Function to process the options in sgmpwatch, only three are specified so
**   far.
*************************************************************************/

process_option(option)
char *option;

  { if ( option[1] == 'i')
      interval = conv(option + 2);        /* convert string into an integer */
     else
       if (option[1] == 'v')
         verbose = 1;                     /* set the verbose flag */
        else
	  if (option[1] == 's')		  /* the session_id */
		{
		/* memory for the session id */
		if((session_id = (char *)malloc(sizeof(char))) == NULL)
  		  {fprintf(stderr,
	   	     "Cannot allocate memory space in main.c, exiting ...\n");
   			exit(1);
		  }
		   strcpy(session_id,option+2);
		   session_len = strlen(session_id);

  		}
		else
          		{fprintf(stderr,"SGMPWATCH : Illegal option\n");
	    		 return(-1);
          		}
     return(0);
   }

/***************************************************************************/

int conv(string)
char *string;
{
 if ((string + 2) == NULL)
   { fprintf(stderr,"SGMPWATCH :Error, no interval specified\n");
     exit(1);
   }

 return(atoi(string));    /* return the interval */

}

/***************************************************************************
**                      print_usage
**
*****************************************************************************/

void print_usage()
 { fprintf(stderr,
	"Usage : sgmpwatch [-iInterval][-v][-sSession] gateway variable(s)\n");
  exit(1);
 }
