/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/
/*****************************************************************************
**
**			util.c
**
** File of support functions for SGMPTRAPD
**
**
****************************************************************************/
#include "sgmp.h"
#include "sgmptrapd.h"

/* readconfig - read (or reread) the config file */
readconfig()
{ 
  yyparse();			/* parse the config file */
/* make new tables */
  if (NETLOG_count)
    new_table(*NETLOG_count,trapd_net_type); /* netlogs table */
  if (SEPLOG_count)
    new_table(*SEPLOG_count,trapd_gate_type); /* seplogs table */
  return(0);
}

#ifndef hpux
/* reaper - reap dead children */
reaper()
{ union wait status;
  while(wait3(&status,WNOHANG,(struct rusage *)NULL) > 0)
		;
  return(0);
}
#endif

/* process_trp - process a trap that came in */
process_trp(mesg,from)
trap_req_msg_type *mesg;
long from;
{ struct file_number *log;	/* for logs to be opened */
  FILE *fp;			/* file pointer to write into logs */
  long clock;			/* to get the time */
  val_list_type *vallist;
  char message[128];		/* message to go into logs */
  char netnum[16];		/* net number in dot notation */
  int i;			/* index into message */
/* get the time */
  time(&clock);
/* construct message */
/* time stamp */
  sprintf(message,"%s",ctime(&clock));
  for (i=0; message[i] != '\n'; i++)
		;
  message[i++] = '\t';
/* put in net number */
  sprintf((message+i),"%d.%d.%d.%d\t ", (((char *)(&from))[0] & CONVMASK),
					(((char *)(&from))[1] & CONVMASK),
					(((char *)(&from))[2] & CONVMASK),
					(((char *)(&from))[3] & CONVMASK));
  for (; message[i] != '\t' ; i++) /* find delimiter */
		;
  i++;
/* put in trap type */
  switch (mesg->trap_type) {	/* figure what sort of trap we have got */
   case COLD_START:		/* Cold Start Trap Type */
    sprintf((message+i),"Cold Start Trap\n");
    break;
   case WARM_START:		/* Warm Start Trap Type */
    sprintf((message+i),"Warm Start Trap\n");
    break;
   case LINK_FAIL:		/* Link Failure Trap Type */
    sprintf((message+i),"Link Failure Trap\n");
    break;
   case AUTH_FAIL:		/* Authentication Failure Trap Type */
    sprintf((message+i),"Authentication Failure Trap\n");
    break;
   case EGP_NHBR_LOST:		/* EGP Neighbor Loss Trap Type */
    sprintf((message+i),"EGP Neighbor Loss Trap\n");
    break;
   case LINK_UP:		/* Link Up Trap Type */
    sprintf((message+i),"Link Up Trap\n");
    break;
   default:			/* Unknown trap type */
     sprintf((message+i),"Unknown Trap Type %d\n", mesg->trap_type);
     fprintf(stderr,"Trap of Unknown Type received %s",message);
     break;
  }
  vallist = mesg->val_list;
  while (vallist) {
    for (; message[i] != '\n' ; i++) /* find delimiter */
      ;
/* check what sort of conversion we have to do */
/* flags for the variable converter are defined in "varcvt.h" */
/* we know that variables represented symbolically start with '_' */
/* process the variable value */
    switch(vallist->var_op.type) { /* decide what the value is */
/* the types a variable value can take on are defined in "sgmp.h" */
/* legal types */
    case INTEGER:			/* value is an integer */
      sprintf((message+i),"\t%d\n",vallist->var_op.value.intgr);
      break;
    case PRIM_STR:			/* a primitive string */
/* kludge because internet addresses can be returned as strings */
      if(isalnum((vallist->var_op.value.str->str)[0]))
	sprintf((message+i),"\t%s\n",vallist->var_op.value.str->str);
      else
	{ long address;
	  ((char *)(&address))[0] = vallist->var_op.value.str->str[0];
	  ((char *)(&address))[1] = vallist->var_op.value.str->str[1];
	  ((char *)(&address))[2] = vallist->var_op.value.str->str[2];
	  ((char *)(&address))[3] = vallist->var_op.value.str->str[3];
	  sprintf((message+i),"\t%s\n",stdtodot(ntohl(address)));
	}
      break;
/* illegal types - this should never happen */
    case CONS_STR:			/* constructed string */
    default:
      printf("unknown type");
      break;
    }
    vallist = vallist->var_next;
  }  /* end loop over reply var list */
/* constructed the message, now log it as appropriate */
  if ((fp = fopen(*all_file,"a")) == NULL)
   fprintf(stderr,"cannot open %s\n",*all_file);
  else
   { fprintf(fp,"%s",message);	/* log in ALLLOG file */
     fclose(fp);
   }
/* log in SEPLOG if necessary */
 if (SEPLOG_count)
  if ((log = find_entry(trapd_gate_type,*SEPLOG_count,from)) != NULL)
   if((fp = fopen(log->file_name,"a")) == NULL)
    fprintf(stderr,"cannot open %s\n",log->file_name);
   else
    { fprintf(fp,"%s",message);
      fclose(fp);
    }
/* try to log in NETLOG, if such logging is necessary */
 if (NETLOG_count)
  for (i=1; i < sizeof(long); i++)
   { u_long netmask;			/* the netmask */
     netmask = (((u_long)(~0x00)) << i*8); /* construct the netmask */
     log = find_entry(trapd_net_type,*NETLOG_count,(from & netmask));
     if(log != NULL)
      if((fp = fopen(log->file_name,"a")) == NULL)
       fprintf(stderr,"cannot open NETLOG %s\n",log->file_name);
      else				/* couldn't open NETLOG */
       { fprintf(fp,"%s",message);
         fclose(fp);
       }
   }
  return(0);
}
