%{
/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/
/****************************************************************************
 * This is the parser for the Simple Gateway Monitoring protocol's, SGMPTRAPD
 *  configuration file. It was writtern by using LEX and YACC
 * In case of SEPLOG and NETLOG this returns an array of structures containing
 * a pointer to the file name and a 32 bit integer containing the network
 * number. The SEPLOG information is contained in
 *                 (*trapd_gate_type)[] {
 *				char *file_name;
 *				int number;
 *			}
 *  and the NETLOG information is contained in
 *		(*trapd_net_type)[] {
 *  				char *file_name;
 *				inet number;
 *     			}
 * The ALLLOG option returns a pointer to the name of the file : 
 *			char **all_file;
 *The following integers keep track of the total number of NETLOG and SEPLOG
 * options given in the configuration files :
 *	   int 	*NETLOG_count;
 *	   int 	*SEPLOG_count;
 *
 ************************************************************************/
#include "sgmp.h"
#include "sgmptrapd.h"

extern int line_count;             /* Line number being parsed */
line_count = 1;                    /* Initialization */
int option_set = 0;    /* flag to check wether option has been speccifed*/
int net_gate_numb_set = 0;/* flag to check the presence of net/gate no. */
%}

%start options
%token SEPLOG NETLOG ALLLOG GATE_NUMB NET_NUMB LOG_NAME SESSION
%token NLINE ERROR SESSION_NAME

%% /* the rules section */
options		:       options option_type NLINE
			{line_count++;}
		|	options NLINE               
			{line_count++;}
                |
		;

option_type	:	option1
		|	option2
		|	option3
                |       session 
		;

option1		:	SEPLOG GATE_NUMB LOG_NAME
			{option_set = 0;        /* reset flag */
			 net_gate_numb_set = 0; /*reset flag  */}
		;

option2		:	NETLOG NET_NUMB LOG_NAME
			{option_set = 0;        /* reset flag */}
		;

option3		:	ALLLOG LOG_NAME
			{option_set = 0;       /* reset flag */}
		;

session         :       SESSION SESSION_NAME


		
%%
  yyerror()
 
    {
   extern int line_count;
   extern char yytext[];
 if((option_set) && (!net_gate_numb_set) ) 
  fprintf(stderr,"***** Option specified without net/gateway number!! *****\n");
 fprintf(stderr,"SGMPTRAPD CONFIGURATION: Error at line %d :: \" %s \" \n",line_count,yytext);
             
       exit(1);
   }
