%{
/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/

#include "sgmp.h"
#include "sgmptrapd.h"
#include "y.tab.h"

extern int option_set;
extern int net_gate_numb_set;

struct file_number **trapd_gate_type;   /*struct. to store SEPLOG info.*/
struct file_number **trapd_net_type;    /*struct. to store NETLOG info. */
char **all_file;                        /*to store ALLLOG file name */
char *s_id;                             /* the session id */
int *NETLOG_count = NULL;               /*Number of NETLOG options */
int *SEPLOG_count = NULL;               /*Number of SEPLOG options */
int   Gateway = 1;                      /*identifies a gateway number */
int   Net = 0;                          /*identifies a network number*/
int   All = 2;	       /* identifies use of both net and gateway number*/
int   type;                             /* a switch */
static int session_flag = 0;            /* to identify a session name */

/* switches to test wether memory allocation has been done */
static int malloc_SEPLOG = 0;           /* for SEPLOG data structure */
static int malloc_NETLOG = 0;           /* for NETLOG data structure */
static int malloc_ALLOG = 0;            /* for ALLOG data structure */
%}

D		[0-9]
DD		{D}{D}
NZ		[1-9]
Z		[0]

%%
^#(.)* 		{ /* Do nothing if it is a comment */ }   

#(.)		{ fprintf(stderr,"***** Wrong usage of comment indicator '#'*****\n"); 
			return(ERROR)	; }

SEPLOG		{       

  if(!malloc_SEPLOG){               /* allocate memory if not allocated */
trapd_gate_type = (struct file_number **)malloc(sizeof(struct file_number *));
if((*trapd_gate_type = (struct file_number*)malloc(MAX_SEPLOG * sizeof(struct file_number))) == NULL) {
     fprintf(stderr,"Error in malloc : at yylex");
       exit(1);}
  SEPLOG_count  = (int *)malloc(sizeof(int));
  *SEPLOG_count = 0;
         malloc_SEPLOG = 1;         /* set the flag */
       }           
			       option_set = 1; /*set flag*/
				type = Gateway; 
				return(SEPLOG);
			}

NETLOG		{	   

  if(!malloc_NETLOG) {              /*allocate memory if not allocated */
trapd_net_type = (struct file_number **)malloc(sizeof(struct file_number *));
if((*trapd_net_type = (struct file_number*)malloc(MAX_NETLOG * sizeof(struct file_number))) == NULL) {
      fprintf(stderr,"Error in malloc : at yylex");
       exit(1);}
  NETLOG_count  = (int *)malloc(sizeof(int));
   *NETLOG_count = 0;
        malloc_NETLOG = 1;          /* set the flag */
    }
		     option_set = 1;  /* set flag */
				type = Net; 
				return(NETLOG);
			}

ALLLOG		{

    if(!malloc_ALLOG)               /*allocate memory if not allocated */
     all_file = (char **)malloc(sizeof(char *));
		        option_set = 1; /*set flag */
				type = All;
				return(ALLLOG);
			}

SESSION        {         /* session name */
       if((s_id = (char *)malloc(sizeof(char *) * MAX_SID_LEN)) == NULL)
             { fprintf(stderr,"Couldnot allocate memory space, exiting ...\n");
                exit(1);
             }
                    session_flag = 1;
                     return(SESSION);
               }


[\n]			{	return(NLINE);
			}


{D}?{DD}"."({D}?{D})?{D}"."({D}?{D})?{D}"."({NZ}?{NZ})?{NZ} {
	if(!option_set){
fprintf(stderr,"***** Attempt to set Gateway number without option *****\n"); 
	return(ERROR);     }
					get_numb(type);         
	net_gate_numb_set = 1;      /*flag to indicate presence of no. */
					return(GATE_NUMB);

			}
{D}?{DD}"."({D}?{D})?{D}"."({D}?{D})?{D}"."{Z}*	{
	if(!option_set){
fprintf(stderr,"***** Attempt to set Net number without option ******\n"); 
		return (ERROR)	; }
					 get_numb(type);
	net_gate_numb_set = 1; /* flag to indicate presence of no. */
					return(NET_NUMB);
			}
[0-9]+"."?[0-9]+?"."?[0-9]+?"."?[0-9]+? {
         if(!option_set){
            fprintf(stderr,"***** No option specified *****\n"); 
		return(ERROR)	; }

                switch(type){
                            case 0:
		fprintf(stderr,"***** Check syntax of Network number[XXX.XXX.XXX.0] *****\n"); 
			return(ERROR);

			     case 1:
		fprintf(stderr,"*****Check syntax of Gateway number[XXX.XXX.XXX.XXX *****]\n");
			return(ERROR); 
           }
         }

[A-Za-z/][A-Za-z0-9_/]*"."?[A-Za-z0-9_/]*	{

               if(session_flag)      /* it is a session name */
            {    strcpy(s_id,yytext);
                session_flag = 0;      /*reset the flag */
                return(SESSION_NAME);
            }
            if(!option_set){
fprintf(stderr,"***** Illegal Option OR Option not specified *****\n"); 
            return(ERROR)	; 
          }


			        allot_file_name(type);
				return(LOG_NAME);
			}

[a-z!@#$%&*+?><,:_-]+	 { 
  fprintf(stderr,"***** Illegal option/ File name *****\n"); 
          return(ERROR)		; 
     
        }

%% /* the program section */

get_numb(numb_type) /* this segment of the program returns the network number
		       concatenated to form a 32 bit integer */

int numb_type;

 {
  int count = 0 ;  /* Keeps track of the total length of of the string */
  int count_temp = 0;
  int numb_char;
  char *temp1,temp2[2]; /* temporary buffer to handle strings */

  temp2[1] = '\0';/* end the string with '\0' */
  temp1 = (char*)malloc(sizeof(char) * 4);  

     while(count < yyleng){

        for(numb_char = 0; (yytext[count] != '.') && (count <= yyleng - 1) ;  count++ ) {
      
      temp2[0] = yytext[count];
      strcat(temp1,temp2);
  }
 
 switch(numb_type){

 case 0:
 (*trapd_net_type)[*NETLOG_count].number = ((*trapd_net_type)[*NETLOG_count].number << 8) | atoi(temp1);
  	break;
 case 1:
 (*trapd_gate_type)[*SEPLOG_count].number= ((*trapd_gate_type)[*SEPLOG_count].number << 8) | atoi(temp1);
	break;

   }
    count++; /*skip the dot*/
    strcpy(temp1,"");  /* clear the buffer to fetch the next byte */
  }
 }
  



allot_file_name() { /* returns the appropriate name of the file */

 char *get_file();

			switch(type) {
				
				case 0: /* a NETLOG file*/
			(*trapd_net_type)[(*NETLOG_count)++].file_name = get_file();
			        break;

				case 1:/* a SEPLOG file*/
			(*trapd_gate_type)[(*SEPLOG_count)++].file_name = get_file();
				break;

				case 2:/* a ALLLOG file*/
				*all_file = get_file();
				break;
			   }
        }

	char *get_file() /* allocates memory space for the file
					  and returns a pointer to it */
	{
         char *p;
   p = (char *)malloc(100);
	   strcpy(p,yytext);
	   return(p);	
	 }





