/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/
/******************************************************************************
**
**			tbl_util.c
**
** This file contains the utilities (functions) to manipulate the
** tables used to access the SGMPTRAPD databases (currently
** flat files.
**
**
******************************************************************************/
#include "sgmp.h"		/* general include file */
#include "sgmptrapd.h"		/* application specific things */

/* new_table - fill in (sort, rather) a new table of 'size' entries */
new_table(size,data)
int size;			/* size of table */
struct file_number **data;	/* data to be put in table */
{ int i,j;			/* counters */
  struct file_number temp;	/* temporary - for sorting */
  if((temp.file_name = (char *)malloc(128*sizeof(char))) == NULL)
   { fprintf(stderr,"new_table: cannot allocate space for file name\n");
     return(-1);
   }
/* sort the data and fill in the table -bubble sort */
  for (i = 0; i < size - 1; i++)
   for (j = size -1 ; j > i ; j--)
    if ((*data)[j].number < (*data)[j-1].number)
     { sprintf(temp.file_name,"%s",(*data)[j].file_name);
       temp.number = (*data)[j].number;
       sprintf((*data)[j].file_name,"%s",(*data)[j-1].file_name);
       (*data)[j].number = (*data)[j-1].number;
       sprintf((*data)[j-1].file_name,"%s",temp.file_name);
       (*data)[j-1].number = temp.number;
     }
/* all done. Now get rid of space allocated for file name and return */
  free(temp.file_name);
  return(0);
}

/* find_entry - find an entry given an IP address and return it */
struct file_number *
find_entry(tab,size,add)
struct file_number **tab;
int size;
int add;
{ int index;			/* index into table to be used in searching */
  int upper,lower;		/* current upper and lower bounds of search */
/* check for special case of first element */
  if((*tab)[0].number == add)	/* if we want first element */
   return(*tab);
/* initialize for search */
  lower = 0;			/* beginning of table - 'C' starts at 0 */
  upper = size;			/* end of table */
  do {
   index = (lower + upper)/2;
   if ((*tab)[index].number == add) /* if we have a match */
    return(*tab+index);		/* return a pointer to the correct entry */
   if ((*tab)[index].number > add) /* if address we want is before this */
    upper = index;
   else				/* address we want is after this */
    lower = index;
  } while (upper > (lower+1));
  return((struct file_number *)NULL);
}
