
/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/

/*****************************************************************************
**
**			main.c
**
** This file contains the main program for the SGMPTRAPD daemon.
** Usage:
**		sgmptrapd [options] config_file &
**
**
*****************************************************************************/
#include "sgmp.h"		/* general include file */
#include "sgmptrapd.h"		/* application specific include file */

main(argc,argv)
int argc;
char *argv[];
{ int i;			/* temporary - counter */
  int fd;			/* temporary - to disassociate from tty */
  int config;			/* config file pointer */
  int errlog;			/* pointer to error log */
  extern int readconfig();	/* function to read the config file */
  extern int reaper();		/* function to 'reap' dead children */
  trap_req_msg_type *mesg;	/* the incoming message */ 
  int mesg_type;		/* the type of the message received */
  long from;			/* the IP address of the message source */
  char *id;			/* the session id */
  int r_id;			/* request id */
  char *svc;			/* service */
/* redirect stderr - commented out in the interests of quick prototyping
  if((errlog = open(ERRLOG,(O_CREAT | O_RDWR),0666)) < 0)
     exit(0);
  if(dup2(errlog,2) < 0)
     exit(0);
  close(errlog);
*/
/* check that we have a config file */
  if (argc < 2)			/* the config file is specified? */
   { fprintf(stderr,"Insufficient number of arguments specified\n");
     fprintf(stderr,"usage: sgmptrapd [options] config_file &\n");
     exit(1);			/* exit if not */
   }
  if((config = open(argv[argc-1],O_RDONLY,0)) < 0) /* open config file */
   { fprintf(stderr,"Cannot open config file %s\n",argv[argc-1]);
     exit(1);
   }
  if(dup2(config,0) < 0)	/* try to switch stdin */
   { fprintf(stderr,"Cannot switch stdin\n");
     exit(1);
   }
  close(config);		/* don't need it anymore */
/* process options - but not config file */
  for (i = 1; i < (argc-2); i++) /* iterate through options */
   { if (argv[i][0] != '-')	/* if this isn't an option */
      { fprintf(stderr,"Unrecognizable option %s\n",argv[i]);
        continue;		/* try next argument */
      }
     switch(argv[i][1])	{	/* determine which option it is */
/* we don't have any options yet :-) */
      default: 			/* Unknown option */
       fprintf(stderr,"Illegal option %s\n",argv[i]);
       fprintf(stderr,"usage: sgmptrapd [options] config_file &\n");
       break;
     }
   }
/* prepare for signals */
  signal(SIGINT,readconfig);	/* parse configuration file */
  signal(SIGHUP,readconfig);	/* parse configuration file */
  signal(SIGUSR1,readconfig);	/* parse configuration file */
  signal(SIGUSR2,readconfig);	/* parse configuration file */
#ifdef hpux
  signal(SIGCLD, SIG_IGN);
#else
  signal(SIGCHLD,reaper);	/* against the day we fork */
#endif
/* disassociate self from tty */
/* if the process can't be disassociated from the tty, tough! go on anyway */
  if((fd = open("/dev/tty",O_RDWR)) < 0)
   fprintf(stderr,"Cannot seize /dev/tty\nContinuing anyway\n");
  else {
#ifdef TIOCNOTTY
   if(ioctl(fd,TIOCNOTTY,0) < 0) /* disassociate self from tty */
    fprintf(stderr,"Cannot disassociate self from tty\nContinuing anyway\n");
#else
   setpgrp();
#endif
   close(fd);
  }
/* read the configuration file */
  readconfig();
/* initialize some preliminary stuff */
  r_id = REQ_ANY;		/* we'll take anything */
  svc = "sgmptrap";		/* the name of the service */
  id = s_id;	        /* the session name */
/* done the startup processing. Now wait for traps */
  while (1)			/* do forever */
   { mesg = (trap_req_msg_type *)recv_sgmp_mesg(&from,svc,&r_id,&mesg_type,&id);
     if (mesg_type != TRP_REQ_MESG) /* if this isn't a trap message */
      continue;			/* throw it away */
     process_trp(mesg,from);
   }
/* NOT REACHED, EVER */
  fprintf(stderr,"broke out of trap processing loop unexpectedly\n");
  exit(1);
}
