/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/
/***************************************************************************
**
**		sgmpquery.c
**
** A simple program to get the value of a single variable from
** a gateway. 
**
** Usage:
**	sgmpquery IP_address variable_name
**
**
**************************************************************************/
#include "sgmp.h"			/* the general include file */
#include "varcvt.h"			/* I'm using the var converter */

#define INITFILE	"/etc/sgmp.variables"/* init file for var converter*/

/* some definitions to improve readability */
#define SERVICE		"sgmp"		/* the service we are requesting */
#define SESSION_ID	"public"	/* the name of the session */
#define TIMEOUT		10		/* we have this long to send */

main(argc,argv)
int argc;
char *argv[];
{ get_req_msg_type *msg;		/* pointer to the message to be sent */
  get_req_msg_type *reply;		/* pointer to the message received */
  strng *name;				/* name after conversion */
  int from;				/* to get address of replying server */
  int i;				/* an index and counter */
/* the type of message received should be GET_RSP_MESG */
  int type;				/* type of message received */
  char *s_id;				/* the session-id of mesg received */
/* check that we have enough parameters */
  if(argc != 3)				/* do we have two parameters? */
   { fprintf(stderr,"wrong number of command line arguments %d\n",argc-1);
     exit(1);
   }
  sgmp_init_cvt(INITFILE);		/* initialize the variable converter */
/* set up message */
/* allocate space for the request message */
  if((msg = (get_req_msg_type *)malloc(sizeof(get_req_msg_type))) == NULL)
   { fprintf(stderr,"cannot allocate structure for request message\n");
     exit(1);
   }
/* allocate space for the one variable we are requesting */
/* the (var_op_type *) could have been a (var_op_list_type) too */
  if((msg->var_op_list = (var_op_type *)malloc(sizeof(var_op_type))) == NULL)
   { fprintf(stderr,"cannot allocate space for variable to be requested\n");
     exit(1);
   }
/* now fill in the various fields of the message */
  msg->request_id = getpid();		/* the request id */
  msg->error_status = 0;		/* no errors yet */
  msg->error_index = 0;			/* no errors yet */
/* this is the hard part: filling in variable names and values */
/* allocate space for the strng structure that is the variable name */
  if((msg->var_op_list->var_name = (strng *)malloc(sizeof(strng))) == NULL)
    { fprintf(stderr,"cannot allocate space for variable name\n");
      exit(1);
    }
/* fill in the variable name */
  msg->var_op_list->var_name->str = argv[2]; /* the name of the variable */
  msg->var_op_list->var_name->len = strlen(argv[2]); /* length of the name */
  if((msg->var_op_list->var_name =
      sgmp_var_cvt(msg->var_op_list->var_name,SYMTONUM)) == NULL)
   { fprintf(stderr,"can't convert name %s\n",argv[2]);
     exit(1);
   }
/* OK, done with the name. Now do the value */
/* the stuff we put in for the value are just placeholders. PUT THEM IN */
  msg->var_op_list->var_value.type = INTEGER; /* placeholder is an integer */
  msg->var_op_list->var_value.value.intgr = 0; /* placeholder has value 0 */
/*
   we're done with the value, now just indicate that this is the only
   variable we have on the list
*/
  msg->var_op_list->var_next = NULL;	/* we have no neighbors */

/*
   we're finally done with the message structure. Now send it off
  and wait for a reply. Notice that both request id and service have
  non-trivial values. This is because we are initiating the 'converstation'
  (so request id has to be non-trivial), and we are querying a server
  at a well-known port (so service has to be non-trivial).
*/
  switch(send_sgmp_mesg(GET_REQ_MESG,msg->request_id,dotto32bit(argv[1]),
         SERVICE,msg,SESSION_ID,strlen(SESSION_ID),TIMEOUT)) {
   case SEND_TIMEOUT:			/* we timed out */
    fprintf(stderr,"timeout in sending off request for variable %s\n",argv[2]);
    exit(1);
   case GEN_ERR:			/* there was a generic error */
    fprintf(stderr,"there was a generic error in sending\n");
    exit(1);
   default:				/* this is a successful return */
    break;
  }
/* wait for a reply */
/* I'm reusing msg->request_id because I know this will only send 1 mesg */
/*
   Notice that service is NULL - this is because we are NOT a server, and
   should not be listening at a well-known port. Also, request-id is
   set to the request-id of the message we want back. Because the request-id
   in non-trivial here, it will be used to find the local port we used
   to send, so we can listen for a reply on the same local port.
*/
  reply = (get_rsp_msg_type *)recv_sgmp_mesg(&from,NULL,&(msg->request_id),
					     &type,&s_id);
  if(reply == NULL)			/* something wrong? */
   { fprintf(stderr,"recv_sgmp_mesg returned NULL\n");
     exit(1);
   }
/* now that we have a reply, process it */
/* check if we have an error */
  if(reply->error_status != 0)		/* error in variable? */
   { fprintf(stderr,"error in variable. error index= %d\n",reply->error_index);
     exit(1);
   }
/* process the variable name.... */
  if(reply->var_op_list->var_name->len <= 0) /* this can't be */
   { fprintf(stderr,"variable name impossibly short\n");
     exit(1);
   }
/* check what sort of conversion we have to do */
/* flags for the variable converter are defined in "varcvt.h" */
/* we know that variables represented symbolically start with '_' */
  if((reply->var_op_list->var_name->str)[0] == '_')  /* symbolic? */
   if((name = sgmp_var_cvt(reply->var_op_list->var_name,CVTIPADD)) == NULL)
    { fprintf(stderr,"couldn't convert symbolic variable name in reply\n");
      exit(1);
    }
   else					/* we could convert name */
    printf("%s\t",name->str);
  else					/* name is in symbolic form */
   if((name = sgmp_var_cvt(reply->var_op_list->var_name,NUMTOSYM)) == NULL)
    { fprintf(stderr,"couldn't convert numeric variable name in reply\n");
      fprintf(stderr,"reply was: ");
      for(i=0; i< reply->var_op_list->var_name->len; i++)
       fprintf(stderr,"%x ",((int)((reply->var_op_list->var_name->str)[i])));
      fprintf(stderr,"\n");
      exit(1);
    }
   else					/* we could convert name */
    printf("%s\t",name->str);
/* process the variable value */
  switch(reply->var_op_list->var_value.type) { /* decide what the value is */
/* the types a variable value can take on are defined in "sgmp.h" */
/* legal types */
   case INTEGER:			/* value is an integer */
    printf("%x",reply->var_op_list->var_value.value.intgr);
    break;
   case PRIM_STR:			/* a primitive string */
    printf("%s",reply->var_op_list->var_value.value.str->str);
    break;
/* illegal types - this should never happen */
   case CONS_STR:			/* constructed string */
   default:
    printf("unknown type");
    break;
  }
/* no particular reason why I didn't do a "printf("..\n") " in the switch */
  putchar('\n');
  exit(0);				/* we're done - bye! */
}
