/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/
/*****************************************************************************
**
**		sgmpserver.c
**
** Stupid little server that accepts messages and returns them to sender
** This listens on the actual sgmp socket.  To use a different socket for
** testing, change "sgmp" in the recv_sgmp_mesg call to another name, which
** must be listed in /etc/services
**
**
*****************************************************************************/
#include "sgmp.h"

main()
{ char *msg;				/* the message we received */
  int address;				/* address from which we recv'd mesg */
  int req_id;				/* request id of the message recv'd */
  int type;				/* type of message received */
  char *session_id;			/* session_id of message received */
  do {
/* initialize things that need initialization */
    req_id = REQ_ANY;			/* we'll take anything */
    session_id = "public";		/* this is fake */
    msg = (char *)recv_sgmp_mesg(&address,"sgmp",&req_id,&type,&session_id);
/* now we've got a message - return to sender */
/*
   note that service is NULL here, because our peer is not listening on 
   a well-known port 
*/
  send_sgmp_mesg(type,req_id,address,NULL,msg,session_id,strlen(session_id),10);
  } while (1);
  exit(0);
}
