/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/
/*
*
*	sgmproute.c
*
*		This application extracts the "routing table" from
*		a gateway, for any network it returns the next hop
*		route, the metric, the type of route and how it
*		learned the route.  The calling conventions determine
*		if it extracts and prints the entire table or one
*		entry in the table.  For instance:
*			sgmproute 128.84.248.254 128.213.0.0
*		prints the information on network 128.213.0.0 ONLY.
*		Where
*			sgmproute 128.84.248.254
*		Prints all the routes known by the gateway.
*		
*
*3SEP87,schoff -initial coding
*4SEP87,schoff -finished with 4 variable output
*
*/

#include <string.h>
#include "sgmp.h"
#include "varcvt.h"


#define GATE	"_GW_pr_DODip_rt_gateway_"
#define METRIC	"_GW_pr_DODip_rt_metric0_"
#define TYPE	"_GW_pr_DODip_rt_type_"
#define HOW	"_GW_pr_DODip_rt_how-learned_"
#define NUMBVARS 4
#define INITFILE "/etc/sgmp.variables"
#define SESSION "public"
#define FIRSTNET	"0.0.0.0"


char *varstuff[NUMBVARS][9] = {
 GATE,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,
 METRIC,NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,
 TYPE,	"Nowhere","Direct","Host","Network","Subnet",NULL,NULL,	NULL,
 HOW,	"None","4.2RIP","EGP","4.3RIP","HELLO","GGP","IGRP",NULL
	};

main(argc,argv)
	int argc;
	char *argv[];
{
	register int i;
	strng *v[NUMBVARS];
	char tnet[50];
	char str[50];
	int rid;
	get_req_msg_type *smesg;
	get_rsp_msg_type *rmesg;
	long gaddr;
	char *session_id;
	int ret;
	int type;
	int done = 0;
	var_op_type *curvar;
	var_op_type *scurvar;
	var_op_type *rcurvar;
	strng *name;
	strng *tname;
	char *c;
	int ivalue;
	struct hostent *hp;
	
	if (argc < 2 )
         { fprintf(stderr,"usage sgmproute [-s session]  address [net_addr]\n");
	   exit(1);
	 }

	if(argv[1][0] == '-')
	 if (argc < 3)
	  { fprintf(stderr,"usage sgmproute [-s session] address [net_addr]\n");
	    exit(1);
	  }
	 else
	  { session_id = argv[2];
	    argv += 2; argc -= 2;
	  }
	else
	 session_id = SESSION;

	if (argc != 2 && argc != 3)
         { fprintf(stderr,"usage sgmproute [-s session]  address [net_addr]\n");
	   exit(1);
	 }

	str[0] = NULL;		/* V6 paranoia */
	if(isalpha(argv[1][0]))	/* if user specified hostname */
		if((hp = gethostbyname(argv[1])) != NULL)
			bcopy(hp->h_addr,(char *)&gaddr,hp->h_length);
		else		/* couldn't get host name */
		{
			fprintf(stderr,"couldn't get address for %s\n",argv[1]);
			exit(1);
		}
	else
		if((gaddr = dotto32bit(argv[1])) == -1)
		{
			fprintf(stderr,"couldn't convert %s\n",argv[1]);
			exit(1);
		}

	if(argc==2)
		strcpy(tnet,FIRSTNET);
	else if(argc==3)
	{
		done = 1;
		strcpy(tnet,argv[2]);
	}
	else
	{
		fprintf(stderr,"%s has wrong number of argument\n",argv[0]);
		exit(1);
	}


	/* initialize the variable converter */
	if(sgmp_init_cvt(INITFILE) < 0)
	{
		fprintf(stderr,"cannot initialize variable converter\n");
		exit(1);
	}

	rid = getpid() ^ (int)time(0); 

	/* variables being stuffed for function call */
	for(i=0; i<NUMBVARS ; i++)
	{
		v[i] = (strng *)malloc(sizeof(strng));
		v[i]->len = strlen(varstuff[i][0]) + strlen(tnet);
		strcpy(str,varstuff[i][0]);
		strcat(str,tnet);
		v[i]->str = str;
		if((v[i] = sgmp_var_cvt(v[i],SYMTONUM)) == NULL)
		{
			fprintf(stderr,"cannot convert variable\n");
			exit(1);
		}
	}


	/* create a request message */
	if((smesg=(get_req_msg_type *)create_sgmp_req(rid,NUMBVARS,v))==NULL)
	{
		fprintf(stderr,"can't create request message\n");
		exit(1);
	}
	
	/* we either do this once or until we print out the entire table */
	do{

		/* launch the request */
		switch(ret=send_sgmp_mesg(GET_REQ_MESG,smesg->request_id,gaddr,
			"sgmp",smesg,session_id,strlen(session_id),30))
		{
		case SEND_TIMEOUT:
		case GEN_ERR:
			fprintf(stderr,"send_sgmp_msg error\n");
			exit(1);
		default:
			break;
		}
		rmesg=(get_rsp_msg_type *)recv_sgmp_mesg(&gaddr,NULL,&rid,&type,&session_id);
	
		curvar = rmesg->var_op_list;

		if((name=sgmp_var_cvt(curvar->var_name,NUMTOSYM)) == NULL)
		{
			fprintf(stderr,"cannot convert response\n");
			exit(1);
		}

		if( (ret=strncmp(name->str,GATE,sizeof(GATE)-2)) == 0)
		{
			printf("%s: ",name->str);
	
			for(i=0; i<NUMBVARS; i++)
			{
				/* 
				* The following code has two problems:
				* 	1) really application specific
				*	2) depends on gateway resonse in
				*		the same order as the query.
				*/
				ivalue = curvar->var_value.value.intgr;
				if(i==0)
				{
					/* I hate this piece of code */
					long address;	
			    		((char *)(&address))[0] = (curvar->var_value.value.str->str)[0];
			    		((char *)(&address))[1] = (curvar->var_value.value.str->str)[1];
			    		((char *)(&address))[2] = (curvar->var_value.value.str->str)[2];
			    		((char *)(&address))[3] = (curvar->var_value.value.str->str)[3];
					printf("  %s",stdtodot(address));
				}
				else if(i==1)
					printf(" %d",ivalue);
				else if(i==2)
					printf(" %s",varstuff[i][ivalue+1]);
				else
					printf(" %s",curvar->var_value.value.str->str);
	
					
				curvar = curvar->var_next;
	
			}
			printf("\n");
				
			/* This is how we walk the table each
				response contains a "pointer"
				to the next "row" of the table
			*/
			rcurvar = rmesg->var_op_list;
			scurvar = smesg->var_op_list;
			for(i=0; i<NUMBVARS ; i++)
			{
				/* since we have a number of
					variables in each
					query we have to take care
					of each
				*/
				scurvar->var_name->str =
					rcurvar->var_name->str;
				scurvar->var_name->len =
					rcurvar->var_name->len;
				scurvar = scurvar->var_next;
				rcurvar = rcurvar->var_next;
			}
		}else
			done=1;
	}while(!done);
}
