/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/
/****************************************************************************
**
**			createreq.c
**
** A function to make the creation of Get Request Messages less painful
**
** Returns a complete request message, or NULL on failure
**
**
***************************************************************************/
#include "sgmp.h"		/* general include file */

get_req_msg_type *
create_sgmp_req(req_id,ac,av)
int req_id;			/* request id on packet to be created */
int ac;				/* number of variables to go into list */
strng *av[];			/* names of variables to go into list */
{ int i;			/* an index */
  int j;			/* an index */
  var_op_type *p;		/* to traverse list */
  get_req_msg_type *mesg;	/* the message to be returned */
/* create the message structure */
  if((mesg = (get_req_msg_type *)malloc(sizeof(get_req_msg_type))) == NULL)
   { fprintf(stderr,"create_sgmp_req: couldn't allocate struct for message\n");
     return((get_req_msg_type *)NULL);
   }
/* fill in request id, error indicators */
  mesg->request_id = req_id;	/* request id */
  mesg->error_status = 0;	/* no errors */
  mesg->error_index = 0;	/* meaningless */
  mesg->var_op_list = NULL;	/* just being paranoid */
/* now fill in the list of variables to be requested */
  for(i = 0; i < ac; i++)
/* allocate space for the variable itself */
    { if(mesg->var_op_list == NULL) /* if this is the first variable */
       if((mesg->var_op_list=(var_op_type *)malloc(sizeof(var_op_type)))==NULL)
        { fprintf(stderr,"create_sgmp_req:couldn't allocate variable %d\n",i+1);
          return((get_req_msg_type *)NULL);
        }
       else			/* could allocate variable */
	  p = mesg->var_op_list;
      else			/* this isn't first variable */
       if((p->var_next = (var_op_type *)malloc(sizeof(var_op_type))) == NULL)
        { fprintf(stderr,"create_sgmp_req:couldn't allocate variable %d\n",i+1);
          return((get_req_msg_type *)NULL);
        }
       else			/* could allocate variable */
	  p = p->var_next;
/* allocate the variable name */
      if((p->var_name = (strng *)malloc(sizeof(strng))) == NULL)
       { fprintf(stderr,"sgmp_get_req: couldn't allocate space for var name\n");
         return((get_req_msg_type *)NULL);
       }
      p->var_name->len = av[i]->len; /* length of the name */
      p->var_name->str = av[i]->str; /* the name itself */
/* allocate the variable value - dummy value */
      p->var_value.type = INTEGER;  /* type of value */
      p->var_value.value.intgr = 0; /* the value */
/* no successor yet */
      p->var_next = NULL;	/* paranoia */
    }
   return(mesg);
}
