/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/
/***************************************************************************
**
**		sgmpquery.c
**
** A simple program to get the value of a single variable from
** a gateway. 
**
** Usage:
**	sgmpquery IP_address variable_name
**
**
**************************************************************************/
#include "sgmp.h"			/* the general include file */
#include "varcvt.h"			/* I'm using the var converter */

#define INITFILE	"/etc/sgmp.variables" /* init file for var converter */

/* some definitions to improve readability */
#define SERVICE		"sgmp"		/* the service we are requesting */
#define SESSION_ID	"public"	/* the name of the session */
#define TIMEOUT		60		/* we have this long before timeout */

main(argc,argv)
int argc;
char *argv[];
{ get_req_msg_type *msg;		/* pointer to the message to be sent */
  get_req_msg_type *reply;		/* pointer to the message received */
  var_op_type *varop,*varop2;
  strng *name;				/* name after conversion */
  int from;				/* to get address of replying server */
  struct itimerval interval;		/* for timing receives */
  struct itimerval disable;		/* to disable timeouts */
  int i;				/* an index and counter */
  int reqid = getpid();			/* the request id */
  int multquery = 0;
  int assign = 0;
  int onintr();				/* interrupt handler for timeouts */
  u_long gwaddr;			/* gateway address */
  struct hostent *hp;			/* host pointer */
/* the type of message received should be GET_RSP_MESG */
  int type;				/* type of message received */
  char *s_id;				/* the session-id of mesg received */
  char *session_id = SESSION_ID;	/* session-id of mesg to be sent */
/* check that we have enough parameters */

/* check if user specified session id */

  while (1) {
    if (argc < 3)
      usage();
    if(argv[1][0] == '-' && argv[1][1] == 's')
      { 
	if (argc < 5) /* make sure arg is there */
	  usage;
	session_id = argv[2];		/* get the session id */
	argv += 2;
	argc -= 2;
      }
    else if (argv[1][0] == '-'  && argv[1][1] == 'm')
      {
	multquery = 1;
	argv++;
	argc--;
      }
    else if (argv[1][0] == '-' && argv[1][1] == 'a')
      {
	assign = 1;
	argv++;
	argc--;
      }
    else break;
  }
  if (argc < (assign ? 5 : 3))
    usage;
  if (multquery && assign) {
    fprintf(stderr, "Cannot assign and tree walk at the same time.\n");
    exit(1);
  }

/* check if user specified hostname or a dot address */
  if(isalpha(argv[1][0]))		/* host name specified? */
   if((hp = gethostbyname(argv[1])) != NULL)
    bcopy(hp->h_addr,(char *)&gwaddr,hp->h_length); /* get 32 bit address */
   else					/* couldn't get hostname */
    { fprintf(stderr,"couldn't get address for %s\n",argv[1]);
      exit(1);
    }
  else					/* user specified dot address */
   if((gwaddr = dotto32bit(argv[1])) == -1)
    { fprintf(stderr,"couldn't convert %s\n",argv[1]);
      exit(1);
    }
/* initialize the variable converter */
  sgmp_init_cvt(INITFILE);		/* initialize the variable converter */
/* set up timing stuff */
  interval.it_interval.tv_sec = 0;	/* don't want to reload timer */
  interval.it_interval.tv_usec = 0;
  interval.it_value.tv_sec = TIMEOUT;	/* timeout after this many seconds */
  interval.it_value.tv_usec = 0;
  disable.it_interval.tv_sec = 0;	/* to disable timer */
  disable.it_interval.tv_usec = 0;
  disable.it_value.tv_sec = 0;
  disable.it_value.tv_usec = 0;
/* set up message */
/* allocate space for the request message */
  if((msg = (get_req_msg_type *)malloc(sizeof(get_req_msg_type))) == NULL)
   { fprintf(stderr,"cannot allocate structure for request message\n");
     exit(1);
   }

/* fill in the constant fields of the message */
  msg->error_status = 0;		/* no errors yet */
  msg->error_index = 0;			/* no errors yet */
  msg->var_op_list = NULL;

/* now allocate the variables */
  while (argc >= 3) {
/* the (var_op_type *) could have been a (var_op_list_type) too */
    if((varop = (var_op_type *)malloc(sizeof(var_op_type))) == NULL)
      { fprintf(stderr,"cannot allocate space for variable to be requested\n");
	exit(1);
      }
    varop->var_next = msg->var_op_list;
    msg->var_op_list = varop;
/* this is the hard part: filling in variable names and values */
/* allocate space for the strng structure that is the variable name */
    if((msg->var_op_list->var_name = (strng *)malloc(sizeof(strng))) == NULL)
      { fprintf(stderr,"cannot allocate space for variable name\n");
	exit(1);
      }
/* fill in the variable name */
    msg->var_op_list->var_name->str = argv[2]; /* the name of the variable */
    msg->var_op_list->var_name->len = strlen(argv[2]);/* length of the name */
    if((msg->var_op_list->var_name = 
      sgmp_var_cvt(msg->var_op_list->var_name,SYMTONUM)) == NULL)
      { fprintf(stderr,"can't convert name %s\n",argv[2]);
      exit(1);
      }
/* OK, done with the name. Now do the value */
/* the stuff we put in for the value are just placeholders. PUT THEM IN */
    if (assign) {
	if (strcmp(argv[3], "integer") == 0) {
	    msg->var_op_list->var_value.type = INTEGER;
	    msg->var_op_list->var_value.value.intgr = atoi(argv[4]);
	} else if (strcmp(argv[3], "octet") == 0) {
	    msg->var_op_list->var_value.type = PRIM_STR;
	    msg->var_op_list->var_value.value.str =
		(strng *)malloc(sizeof(strng));
	    msg->var_op_list->var_value.value.str->str = argv[4];
	    msg->var_op_list->var_value.value.str->len = strlen(argv[4]);
	} else {
	    fprintf(stderr, "SET type must be \"integer\" or \"octet\"\n");
	    exit(1);
	}
	argc -= 2;
	argv += 2;
    } else {
	msg->var_op_list->var_value.type = INTEGER;/* placeholder integer */
	msg->var_op_list->var_value.value.intgr = 0; /* placeholder value 0 */
    }
/*
   we're done with the value, now just indicate that this is the only
   variable we have on the list
*/
    argc--;
    argv++;
  }
  varop = msg->var_op_list;
  msg->var_op_list = NULL;
  while (varop) {
    varop2 = varop->var_next;
    varop->var_next = msg->var_op_list;
    msg->var_op_list = varop;
    varop = varop2;
  }


/*
   we're finally done with the message structure. Now send it off
  and wait for a reply. Notice that both request id and service have
  non-trivial values. This is because we are initiating the 'converstation'
  (so request id has to be non-trivial), and we are querying a server
  at a well-known port (so service has to be non-trivial).
*/
while(1) {  /* loop used to do tree walk if requested */
/*  msg->request_id = reqid++;		/* the request id */
  signal(SIGALRM,SIG_IGN);		/* don't want to hear timeouts here */
  switch(send_sgmp_mesg(assign ? SET_REQ_MESG : GET_REQ_MESG,msg->request_id,
	 gwaddr,SERVICE,msg,session_id,strlen(session_id),TIMEOUT)) {
   case SEND_TIMEOUT:			/* we timed out */
    fprintf(stderr,"timeout in sending off request for variable %s\n",argv[2]);
    exit(1);
   case GEN_ERR:			/* there was a generic error */
    fprintf(stderr,"there was a generic error in sending\n");
    exit(1);
   default:				/* this is a successful return */
    break;
  }
/*
 * Original reused request id, because they knew they were sending only
 * one message.  We still do that, but it's not clear whether it is
 * safe or not.
 */
/*
   Notice that service is NULL - this is because we are NOT a server, and
   should not be listening at a well-known port. Also, request-id is
   set to the request-id of the message we want back. Because the request-id
   in non-trivial here, it will be used to find the local port we used
   to send, so we can listen for a reply on the same local port.
*/
  signal(SIGALRM,onintr);		/* want to hear timeouts now */
  setitimer(ITIMER_REAL,&interval,NULL);/* start timer */
  reply = (get_rsp_msg_type *)recv_sgmp_mesg(&from,NULL,&(msg->request_id),
					     &type,&s_id);
  setitimer(ITIMER_REAL,&disable,NULL);	/* stop timer */
  if(reply == NULL)			/* something wrong? */
   { fprintf(stderr,"recv_sgmp_mesg returned NULL\n");
     exit(1);
   }
/* now that we have a reply, process it */
/* wait for a reply */
  if(reply->error_status != 0)
   { fprintf(stderr,"error in variable. error index= %d\n",reply->error_index);
     exit(1);
   }
/* process the variable name.... */
  varop = reply->var_op_list;
  while (varop) {
    if(varop->var_name->len <= 0) /* this can't be */
      { fprintf(stderr,"variable name impossibly short\n");
	exit(1);
      }
/* check what sort of conversion we have to do */
/* flags for the variable converter are defined in "varcvt.h" */
/* we know that variables represented symbolically start with '_' */
    if((varop->var_name->str)[0] == '_')  /* symbolic? */
      if((name = sgmp_var_cvt(varop->var_name,CVTIPADD)) == NULL)
	{ fprintf(stderr,"couldn't convert symbolic variable name in reply\n");
	  exit(1);
	}
      else					/* we could convert name */
	printf("%s\t",name->str);
    else					/* name is in symbolic form */
      if((name = sgmp_var_cvt(varop->var_name,NUMTOSYM)) == NULL)
	{ fprintf(stderr,"couldn't convert numeric variable name in reply\n");
	  fprintf(stderr,"reply was: ");
	  for(i=0; i< varop->var_name->len; i++)
	    fprintf(stderr,"%x ",(((varop->var_name->str)[i]) & 0x000000ff));
	  fprintf(stderr,"\n");
	  exit(1);
	}
      else					/* we could convert name */
	printf("%s\t",name->str);
/* process the variable value */
    switch(varop->var_value.type) { /* decide what the value is */
/* the types a variable value can take on are defined in "sgmp.h" */
/* legal types */
    case INTEGER:			/* value is an integer */
      printf("0x%x",varop->var_value.value.intgr);
      printf("\t%d",varop->var_value.value.intgr);
      break;
    case PRIM_STR:			/* a primitive string */
    {
      int alnum = isalpha(varop->var_value.value.str->str[0]);
      if (varop->var_value.value.str->len == 4 && !alnum) {
	  long address;
	  ((char *)(&address))[0] = varop->var_value.value.str->str[0];
	  ((char *)(&address))[1] = varop->var_value.value.str->str[1];
	  ((char *)(&address))[2] = varop->var_value.value.str->str[2];
	  ((char *)(&address))[3] = varop->var_value.value.str->str[3];
	  printf("%s",stdtodot(ntohl(address)));
      } else if (varop->var_value.value.str->len == 6 && !alnum) {
	  printf("%02x%02x.%02x%02x.%02x%02x",
	    (unsigned char)varop->var_value.value.str->str[0] & 0xff,
	    (unsigned char)varop->var_value.value.str->str[1] & 0xff,
	    (unsigned char)varop->var_value.value.str->str[2] & 0xff,
	    (unsigned char)varop->var_value.value.str->str[3] & 0xff,
	    (unsigned char)varop->var_value.value.str->str[4] & 0xff,
	    (unsigned char)varop->var_value.value.str->str[5] & 0xff);
      } else
	printf("%s",varop->var_value.value.str->str);
      break;
    }
/* illegal types - this should never happen */
    case CONS_STR:			/* constructed string */
    default:
      printf("unknown type");
      break;
    }
/* no particular reason why I didn't do a "printf("..\n") " in the switch */
    putchar('\n');
    varop = varop->var_next;
  }  /* end loop over reply var list */
  if (! multquery)
    break;
  msg = reply;
}  /* end loop used for tree walk */
  exit(0);				/* we're done - bye! */
}

/* onintr - interrupt hander. Prints error message an exits */
onintr()
{
  fprintf(stderr,"receive timed out after %d seconds\n",TIMEOUT);
  exit(1);
}

usage()
{
  fprintf(stderr,"usage sgmpquery [-s session] [-m] gateway var1 [var2 ...]\n");
  fprintf(stderr,"  where -m does a tree walk\n");
  exit(1);
}
