/*****************************************************************************
**
**			srcroute.c
**
** This is the src route function to find  the src of routing information
** for the network it is passed.
**
**
*****************************************************************************/
#include "sgmp.h"				/* the general include file */
#include "sgmplookup.h"				/*the application include file*/

#define NAMLEN		10			/* length of variable names */
#define MAXVARS		2			/* number of variables */
/* 
   this constant is maximum number of gateways before a net/host is 
   unreachable plus one (the starting gateway). Don't change this unless
   the max hops before a destination is unreachable is changed in 
   Internet space 
*/
#define MAXGW		17			/* max number of gateways */

jmp_buf env;					/* environment for timeouts */

srcroute(gwaddr,s_sid,net,timeout,maxretries)
u_long gwaddr;					/* gateway to query */
char *s_sid;					/* session id of mesg sent */
char *net;					/*route whose src to be found */
int timeout;					/* receive timeout */
int maxretries;					/* max. no. of retries */
{ get_req_msg_type *msg;			/* pointer to request message */
  get_req_msg_type *reply;			/* pointer to reply */
  strng *varnames[MAXVARS];			/* variable names */
  u_long from;					/* address of replying server */
  struct itimerval interval;			/* for timing receives */
  struct itimerval disable;			/* to disable timeouts */
  int i;					/* index and counter */
  int srcintr();				/* timeout interrupt handler */
  struct netent *rp;				/* route pointer */
  u_long rtaddr;				/* route */
  u_long nexthop;				/* to store the next hop */
  int type;					/* should be GET_RSP_MESG */
  char *r_sid;					/* session id of mesg recvd */
  int req_id, rreq_id;				/* req_id of mesg sent,recvd */
  u_long gateways[MAXGW];			/* array of intermediate gws */
  short gwindex;				/* spot in gw array to fill */
  int retries;					/* number of times retried */
  int rc;					/* send return code */

/* check that we have a gateway and session first */
  if(gwaddr == 0)				/* no gateway address */
   { fprintf(stderr,"no gateway to query\n");
     return(-1);
   }
  if(s_sid == NULL)
   { fprintf(stderr,"no session name specified\n");
     return(-1);
   }

/* initializations */
  gwindex = 0;					/* no gateways yet */
  interval.it_interval.tv_sec = 0;		/* don't want to reload timer */
  interval.it_interval.tv_usec = 0;
  interval.it_value.tv_sec = timeout;		/* set timeout */
  interval.it_value.tv_usec = 0;
  disable.it_interval.tv_sec = 0;		/* to disable timer */
  disable.it_interval.tv_usec = 0;
  disable.it_value.tv_sec = 0;
  disable.it_value.tv_usec = 0;
  for(i=0; i < MAXVARS; i++)
   if((varnames[i] = (strng *)malloc(sizeof(strng))) == NULL)
    { fprintf(stderr,"cannot allocate space for variable names\n");
      exit(1);
    }


/* ok, all done with preliminaries. Now get the starting gateway and route */
  if(isalpha(net[0]))				/* if  symbolic route name */
   if((rp = getnetbyname(net)) != NULL)
    bcopy(rp->n_net,(char *)&rtaddr,sizeof(long));
   else						/* couldn't get net name */
    { fprintf(stderr,"couldn't get IP address for %s\n",net);
      exit(1);
    }
  else						/* user specified dot address */
   if((rtaddr = dotto32bit(net)) == -1)
    { fprintf(stderr,"couldn't convert %s\n",net);
      return(-1);
    }

/* now set up the variables to be queried for */
/* first variable: _GW_pr_in_rt_gateway */
  if((varnames[0]->str = (char *)malloc(NAMLEN*sizeof(char))) == NULL)
   { fprintf(stderr,"couldn't allocate space for name of variable 1\n");
     return(-1);
   }
/*
   this is gross, but in the interests of efficiency we do this rather than
   use the variable converter
*/
/* put in the numeric equivalent of _GW_pr_in_rt_gateway */
  (varnames[0]->str)[0] = 0x01;			/* GW */
  (varnames[0]->str)[1] = 0x04;			/* pr */
  (varnames[0]->str)[2] = 0x01;			/* in */
  (varnames[0]->str)[3] = 0x02;			/* rt */
  (varnames[0]->str)[4] = 0x01;			/* gateway */
  bcopy((char *)&rtaddr,((varnames[0]->str)+5),sizeof(u_long));
  varnames[0]->len = 9;				/* put in name length */
/* first variable: _GW_pr_in_rt_metric0 */
  if((varnames[1]->str = (char *)malloc(NAMLEN*sizeof(char))) == NULL)
   { fprintf(stderr,"couldn't allocate space for name of variable 2\n");
     return(-1);
   }
/*
   this is gross, but in the interests of efficiency we do this rather than
   use the variable converter
*/
/* put in the numeric equivalent of _GW_pr_in_rt_metric0 */
  (varnames[1]->str)[0] = 0x01;			/* GW */
  (varnames[1]->str)[1] = 0x04;			/* pr */
  (varnames[1]->str)[2] = 0x01;			/* in */
  (varnames[1]->str)[3] = 0x02;			/* rt */
  (varnames[1]->str)[4] = 0x04;			/* metric0 */
  bcopy((char *)&rtaddr,((varnames[1]->str)+5),sizeof(u_long));
  varnames[1]->len = 9;				/* put in name length */

/* finally.. create the first request message */
  req_id = getpid() ^ (int)time(0);		/* get the request id */
  if((msg = (get_req_msg_type *)create_sgmp_req(req_id,2,varnames)) == NULL)
   { fprintf(stderr,"cannot create a request message\n");
     return(-1);
   }

/* 
   now the heart of the program. Iterate until we reach the source
   of the route 
*/
  nexthop = gwaddr;
  printf("Path:\n");
  do {
   gwaddr = nexthop;

/* set things up for timeouts, preserve environment etc. */
  retries = 0;					/* we haven't retried yet */
  if(setjmp(env))
   if(retries < maxretries)			/* if we should retry again */
      retries++;				/* retry once more */
   else						/* exceeded number of retries */
    { fprintf(stderr,"giving up after %d receive retries\n",retries);
      term_sgmp_comm(req_id);
      return(-1);
    }

/* send off a request message */
   signal(SIGALRM,SIG_IGN);			/* ignore timeouts here */
   if((rc = send_sgmp_mesg(GET_REQ_MESG,req_id,gwaddr,SERVICE,msg,
			   s_sid,strlen(s_sid),TIMEOUT)) < 0)
    switch(rc) {				/* find out what occurred */
     case SEND_TIMEOUT:				/* timed out */
      fprintf(stderr,"timeout occurred in send\n");
      return(-1);
     case GEN_ERR:				/* generic error */
      fprintf(stderr,"generic error occurred in send\n");
      return(-1);
    }

/* prepare to receive */
   rreq_id = req_id;				/* only want to hear this */
   signal(SIGALRM,srcintr);			/* want to hear timeout */
   setitimer(ITIMER_REAL,&interval,NULL);	/* start timer */
   reply = (get_rsp_msg_type *)recv_sgmp_mesg(&from,NULL,&rreq_id,&type,&s_sid);
   setitimer(ITIMER_REAL,&disable,NULL);	/* disable timer */
   term_sgmp_comm(req_id);			/* close this transaction */
   if(reply == NULL)				/* error in reply */
    { fprintf(stderr,"error in reply. Retrying....\n");
      longjmp(env);				/* retry */
    }
   if(type != GET_RSP_MESG)			/* didn't get a response mesg?*/
    { fprintf(stderr,"response was not a response message. Retrying...\n");
      longjmp(env);				/* retry */
    }
   if(reply->error_status != 0)			/* we got an error? */
    { fprintf(stderr,"response error, error index= %d\n",reply->error_index);
      return(-1);
    }
   if(rreq_id != req_id)			/* just being paranoid */
    { fprintf(stderr,"got back unsolicited response. Retrying...\n");
      longjmp(env);				/* retry */
    }
/* check that we got back variables we asked for... */
   if(reply->var_op_list != NULL)
    { if(bcmp(reply->var_op_list->var_name->str,varnames[0]->str,5) != 0)
       { fprintf(stderr,"got back wrong variables. Retrying....\n");
         longjmp(env);
       }
      if(reply->var_op_list->var_next != NULL)
       { if(bcmp(reply->var_op_list->var_next->var_name->str,varnames[1]->str,5) != 0)
          { fprintf(stderr,"got back wrong variables. Retrying....\n");
            longjmp(env);
          }
       }
      else					/* not enough variables */
       { fprintf(stderr,"wrong number of variables. Retrying....\n");
 	 longjmp(env);
       }
    }
   else						/* no variables */
    { fprintf(stderr,"wrong number of variables. Retrying....\n");
      longjmp(env);
    }
     

/* everything is all right. Get the data we need */
/* get the next gateway hop */
   ((char *)(&nexthop))[0] = reply->var_op_list->var_value.value.str->str[0];
   ((char *)(&nexthop))[1] = reply->var_op_list->var_value.value.str->str[1];
   ((char *)(&nexthop))[2] = reply->var_op_list->var_value.value.str->str[2];
   ((char *)(&nexthop))[3] = reply->var_op_list->var_value.value.str->str[3];
/* make sure we don't have a routing loop */
   for(i=0; i < gwindex; i++)
    if(gateways[i] == nexthop)			/* if we've already seen this */
     { fprintf(stderr,"routing loop discovered at %s\n",stdtodot(nexthop));
       return(-1);
     }
   gateways[gwindex++] = nexthop;		/* put in the gateway */
   if(gwindex > MAXGW)				/* if net already unreachable */
    { fprintf(stderr,"net %s unreachable\n",stdtodot(rtaddr));
      return(-1);
    }
    printf("\t\t%s\n",stdtodot((long)gwaddr));
  } while (reply->var_op_list->var_next->var_value.value.intgr > 0);
  
/* done. */
  printf("source of routing information for %s is %s\n",stdtodot(rtaddr),
							stdtodot(gwaddr));
  return(0);
}

/* srcintr - receive timout interrupt handler */
srcintr()
{
  fprintf(stderr,"receive timed out. Retrying....\n");
  longjmp(env);
}
