/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/
/****************************************************************************
**
**			sgmplookup.h
**
** Include file for the sgmplookup application that contains application
** specific definitions
**
**
****************************************************************************/

#include "varcvt.h"

/* definitions */
#define VERSION		"1.1Alpha"	/* current version of software */
#define CMDLEN		32		/* max length of a command */
#define PROMPT		"sgmp> "	/* the command prompt */
#define TIMEOUT		10		/* the default timeout */
#define S_ID		"public"	/* the default session id */
#define SERVICE		"sgmp"		/* the service we want */
#define INITFILE	"/etc/sgmp.variables" /* default init file */
#define MAXRETRIES	1		/* default number of retries */

/* structures */
typedef struct {			/* the command entity */
	short 	cmd_code;		/* the command code */
	char *	cmd_rest;		/* rest of the command line */
} cmdent;

/* command codes */
#define CMD_HLP		1		/* user wants help */
#define CMD_GW		2		/* set the gateway to be queried */
#define CMD_QRY		3		/* ask for a variable */
#define CMD_SESS	4		/* set session name */
#define CMD_TMO		5		/* to specify timeouts */
#define CMD_MQRY	6		/* ask for a variable class */
#define CMD_RTRY	7		/* set max number of recv retries */
#define CMD_SRT		8		/* find source of routing info */
#define CMD_DSP		9		/* display settings */

/* for printing the prompt */
#define printprompt	printf("%s",PROMPT);
