/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/
/*****************************************************************************
**
**			sgmplookup.c
**
** Main routine for the smgplookup program.
**
** Usage: sgmplookup initfile
**
**
****************************************************************************/
#include "sgmp.h"			/* the general include file */
#include "sgmplookup.h"			/* the application specific include */

main(argc,argv)
int argc;
char *argv[];
{ char cmdline[CMDLEN];			/* the command line */
  char *initfile;			/* the variable initialization file */
  cmdent *cmd;				/* the command */
  cmdent *find_cmd();			/* for finding commands */
  long gwaddr;				/* address of the gateway to be asked */
  char *session_id;			/* session id */
  int timeout;				/* timeout */
  int maxretries;			/* maximum number of retries */
  struct hostent *hp;			/* in case user specifies hostname */
/* check if an initialization file has been specified */
  if(argc != 2)				/* if no initialization file */
   initfile = INITFILE;			/* use the system default */
  else					/* user specified an initfile */
   initfile = argv[1];
/* initializations */
  session_id = S_ID;			/* set the default session id */
  timeout = TIMEOUT;			/* set the default timeout */
  maxretries = MAXRETRIES;		/* set max number of receive retries */
  if(sgmp_init_cvt(initfile) < 0)
   { fprintf(stderr,"couldn't initialize variable converter\n");
     exit(1);
   }
/* process user input */
  printf("\t\tsgmplookup Version %s\n\n",VERSION);
  printf("default session name is %s\n",session_id);
  printf("default timeout is %d seconds\n",timeout);
  printf("default number of recv retries is %d \n",maxretries);
  putchar('\n');
  printprompt;				/* print the command prompt */
  while(gets(cmdline) != NULL && strcmp("quit",cmdline) != 0)
   { if(cmdline[0] == '\0' || cmdline[0] == '\r' || cmdline[0] == '\n')
      { printprompt;
	continue;
      }
     if((cmd = find_cmd(cmdline)) == NULL) /* internal error? */
      { printprompt;
        continue;			/* on to next command */
      }
/* we have a command now. Now process it */
     switch(cmd->cmd_code) {		/* what command do we have? */
      case CMD_HLP:			/* user needs help */
	printf("\nLegal commands are:\n\n");
        printf("? or help                     print this message\n");
        printf("gateway gw                    set gateway to be queried\n");
	printf("session session_name          set session name\n");
	printf("retry maxretries	      retry maxtries times\n");
	printf("timeout <integer>	      set timeout to <integer>\n");
        printf("query variable                query for this variable\n");
	printf("mquery variable_class	      query for a variable class\n");
	printf("srcroute IPadd                find src of route for IPadd\n");
	printf("display                       display settings\n");
	printf("^D or quit                    quit\n");
        printf("\n\n");
        break;
      case CMD_GW:			/* set the gateway */
	if(!isalpha((cmd->cmd_rest)[0])) /* if user specified an address */
	 gwaddr = dotto32bit(cmd->cmd_rest);
	else				/* host name specified */
	 if((hp = gethostbyname(cmd->cmd_rest)) == NULL)
	  { fprintf(stderr,"couldn't get address for %s\n",cmd->cmd_rest);
	    break;
	  }
	 else				/* could get address */
	  bcopy(hp->h_addr,(char *)&gwaddr,hp->h_length);
	break;
      case CMD_QRY:			/* want a variable */
	query(gwaddr,session_id,cmd->cmd_rest,timeout,maxretries);
	break;
      case CMD_MQRY:			/* query for a variable class */
        mquery(gwaddr,session_id,cmd->cmd_rest,timeout,maxretries);
	break;
      case CMD_SRT:			/* find the source of routing info */
        srcroute(gwaddr,session_id,cmd->cmd_rest,timeout,maxretries);
        break;
      case CMD_SESS:			/* set session name */
	if((session_id = (char *)malloc(strlen(cmd->cmd_rest)+1)) == NULL)
	 { fprintf(stderr,"couldn't change session name to %s\n",cmd->cmd_rest);
	   break;			/* break out of case */
         }
        strcpy(session_id,cmd->cmd_rest); /* copy in new session name */
        break;
      case CMD_TMO:			/* reset timeout */
	timeout = atoi(cmd->cmd_rest);
	break;
      case CMD_RTRY:			/* reset number of retries */
	maxretries = atoi(cmd->cmd_rest);
	break;
      case CMD_DSP:			/* display settings */
        printf("     gateway            %s\n",stdtodot(gwaddr));
        if(session_id != NULL)
	 printf("     session id         %s\n",session_id);
	printf("     maxretries         %d times\n",maxretries);
	printf("     timeout            %d seconds\n",timeout);
	break; 
      default:				/* unknown command */
	fprintf(stderr,"Unknown command. 'help' for help\n");
        break;
     }					/* end switch statement */
     printprompt;			/* print prompt again */
   }					/* end command processing loop */
  exit(0);
}
