/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/
/*****************************************************************************
**
**			find_cmd.c
**
** A function to convert user input into <cmd code, rest of line> tuples.
** If the command on the command line is unrecognizable, the command
** code field in the tuple is set to -1, and the rest of line field is
** meaningless 
**
**
*****************************************************************************/
#include "sgmp.h"
#include "sgmplookup.h"

struct cmdtab {
	char *	cmd;		/* the command */
	short	code;		/* corresponding code */
} cmdtab[] = {
	"?",		CMD_HLP,
	"help",		CMD_HLP,
	"gateway",	CMD_GW,
	"query",	CMD_QRY,
	"session",	CMD_SESS,
	"timeout",	CMD_TMO,
	"mquery",	CMD_MQRY,
	"retry",	CMD_RTRY,
	"srcroute",	CMD_SRT,
	"display",	CMD_DSP,
};

#define CMD_MAX		10	/* the number of entries in cmdtab */

cmdent *
find_cmd(cmdline)
char *cmdline;			/* the command line received */
{ cmdent *cmd;			/* the command to be returned */
  int i,j;			/* indices/counters */
  if((cmd = (cmdent *)malloc(sizeof(cmdent))) == NULL)
   { fprintf(stderr,"couldn't allocate space for parsed command\n");
     return((cmdent *)NULL);
   }
/* skip leading blanks */
  for(i = 0; cmdline[i] != '\0' && isspace(cmdline[i]); i++)
			;
/* found command, now figure out what it is */
/* found a match? */
  for(j = 0; j < CMD_MAX; j++)
   if(strncmp(cmdtab[j].cmd,(cmdline+i),strlen(cmdtab[j].cmd)) == 0)
    break;
  if(j < CMD_MAX)		/* really found a match? */
   cmd->cmd_code = cmdtab[j].code; /* put in command code */
  else				/* didn't find a match */
   { cmd->cmd_code = -1;	/* unknown command */
     return(cmd);
   }
/* put rest of command line into cmd->cmd_rest */
/* skip command */
  for(; cmdline[i] != '\0' && cmdline[i] != ' '; i++)
		;
/* skip intervening white space */
  for(; cmdline[i] != '\0' && isspace(cmdline[i]); i++)
		;
  if(cmdline[i] == '\0')	/* end of line? */
	cmd->cmd_rest = NULL;	/* no rest of line */
  else				/* put in rest of line */
	cmd->cmd_rest = (cmdline+i);
  return(cmd);
}
