/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/
/**************************************************************************
**                          util.c
**
**  The following are the support functions for the SGMPASK daemon
**
*************************************************************************/
#include "sgmp.h"               /* general include file */
#include "sgmpask.h"            /* application specific file */

jmp_buf sjbuf;                  /* the buffer for timer use */

/* read the configuration file - get the gateway,variables and repective
   file names */

readconfig()
{
  yyparse();                                   /* parse the config. file */
  new_table(*smpask_count,smpask_file_var);    /* put data in memory */
                               
}

#ifndef hpux
/* reaper - reap dead children */

 reaper()
{
 union wait status;
 while(wait3(&status,WNOHANG,(struct rusage *)NULL) > 0)
                         ;
  return(0);
}
#endif

/* process the messages */

process_mesg(mesg,req_id,sid,slen)
get_req_msg_type *mesg;
int req_id;
char *sid;
int slen;

{
long time1,time2,temp_time;              /* for the time */
struct itimerval *value, *ovalue;        /* for the timer */
int *from;                               /* the address of the sender */
int *type;                               /*the type of the message received */
char **session_id;                       /* the session_id */
int interrupt_handler();                    /* to handle timeout */

/* allocate memory space for from */
 if((from = (int *)malloc(sizeof(int))) == NULL)
   {fprintf(stderr,"Cannot allocate memory in process_mesg,exiting...\n");
  exit(1);
  }
 if((type = (int *)malloc(sizeof(int))) == NULL)
   {fprintf(stderr,"Cannot allocate memory in process_mesg,exiting...\n");
  exit(1);
  }

 time(&time1);
  if (interval == NULL)
    {fprintf(stderr,"SGMPASK :: No interval specified\n");
       exit(1);
   }
 if((send_sgmp_mesg
(GET_REQ_MESG,req_id,*smpask_net_number,"sgmp",mesg,sid,slen,*interval)) == SEND_TIMEOUT)
{
 fprintf(stderr,"SGMPASK : Time out while trying to  send packet\n");
 return;
}
 time(&time2);

/* set the timer */
/* first the memory spaces */

if((value = (struct itimerval *)malloc(sizeof(struct itimerval))) == NULL)
{fprintf(stderr,"Cannot allocate memory in util.c, exiting ...");
 exit(1);
}

if((ovalue = (struct itimerval *)malloc(sizeof(struct itimerval))) == NULL)
{fprintf(stderr,"Cannot allocate memory in util.c, exiting ...");
 exit(1);
}

temp_time = *interval - (time2 - time1);  /* for later use */
value->it_value.tv_sec =temp_time;        /* set the second field */
value->it_value.tv_usec = 0;              /* set the micro sec field */
value->it_interval.tv_sec = 0;            /* set the second field */
value->it_interval.tv_usec = 0;           /* set the micro sec field */

time(&time1);

setitimer(ITIMER_REAL,value,ovalue);     /* start the timer */
 signal(SIGALRM,interrupt_handler);

if(setjmp(sjbuf) < 0)
{
 fprintf(stderr,"SGMPASK:: recv_sgmp_msg : Timeout, no response received \n");
  return;
}
/* message sent( hopefully!) - now receive the response */

 mesg =  (get_rsp_msg_type *)recv_sgmp_mesg(from,NULL,&req_id,type,&session_id); 

 process_received_mesg(mesg,from);

  time(&time2);
/* check if there is any time left before the next request */
if(*how_many_times == 1)
  return;

 if((temp_time - (time2 - time1)) > 0)         /* if there is time */
   sleep(temp_time - (time2 - time1));         /* take a 'nap' */

 return;
}


process_received_mesg(rsp_mesg,from)
get_rsp_msg_type *rsp_mesg;
int *from;

{
int err_val;                          /* the error number */
int index;                            /* index to the faulty variable*/
int var_index = 0;                    /* index to the variables */
int string_size;                      /* size of 'string' */
int i;                                /* index into message */
char *string;                         /* the name of the variable */
char message[128];                    /* message to go into the logs */
char netnumb[16];                     /* net number in the dot notation*/
struct smpask_file_var *log;          /* for logs to be opened */
struct file_var *fv;                  /* pointer for var and file name*/
FILE *fp;                             /*file pointer to write into the logs*/
long clock;                           /* to get the time */
var_op_list_type p,temp;              /* ptr. to the variables in mesg. */
strng *struct_string;                  /* a character string structure */
strng *sgmp_var_cvt();                 /* the variable converter */

switch( rsp_mesg->error_status)         /* check for any errors */
  {
 case GMP_ERR_NOERROR:                 /* no error, process reply */
  p = rsp_mesg->var_op_list;           /* pointer to list of variables */
   break;

 case GMP_ERR_TOO_BIG:                  /* packet sent too big */
      fprintf(stderr,"SGMPASK : GMP_ERR_TOO_BIG : Packet sent resulted in too large a reply\n");
        return;

 case GMP_ERR_BAD_VALUE:                 /* bad variable value */
      fprintf(stderr,"SGMPASK : GMP_ERR_BAD_VALUE : Bad variable value\n");
       return;
 
 case GMP_ERR_NIX_NAME :                 /* bad variable name */

       fprintf(stderr,"SGMPASK :: GMP_ERR_NIX_NAME : Bad variable name\t");

      index =  rsp_mesg->error_index;
      p = rsp_mesg->var_op_list;
      index--;
      while(index > 0)      /* get to the bad variable */
      { index--;
        p = p->var_next;
    if(p == NULL)
      {fprintf(stderr,"\nSGMPASK :: GMP_ERR_NIX_NAME : Index specified is non-existent\n");
       exit(1);
     }
      }



  /* get the string to the printable form if needed */
  /* it is assumed here that any IP address returned will be in standard
   notation (ie: a 32 bit quantity) and not in dot notation */
  if(*(p->var_name->str) == '_')
    {  if(( struct_string = sgmp_var_cvt(p->var_name,CVTIPADD)) == NULL)
	 {fprintf(stderr,"SGMPASK :: sgmp_var_cvt : Error while converting the variable name");
            exit(1);
	}
        string = struct_string->str;
	}
  else
    {if(( struct_string = sgmp_var_cvt(p->var_name,NUMTOSYM)) == NULL)
	 {fprintf(stderr,"SGMPASK :: sgmp_var_cvt : Error while converting the variable name");
            exit(1);
	}
      string = struct_string->str;
      }

       fprintf(stderr,"\t%s\n",string);
        return;

 default:
       fprintf(stderr,"SGMPASK : UNKNOWN ERROR\n");
       return;

      }
 /* start processing the reply */
while(p != NULL)                 /* till the last variable is not reached*/
  {
 time(&clock);                   /* get the time */

 sprintf(message,"%s",ctime(&clock));  /* record the time */
 for(i = 0;message[i] != '\n'; i++)
           ;
 message[i++] = '\t';
  /* put in the net number */
 sprintf((message + i),"%d.%d.%d.%d\t",(((char *)((from)))[0] & CONVMASK),
                                       (((char *)((from)))[1] & CONVMASK),
                                       (((char *)((from)))[2] & CONVMASK),
                                       (((char *)((from)))[3] & CONVMASK));

 for (;message[i] != '\t'; i++)      /* find the delimiter */
            ;
  i++;

 /* put in the variable name and its value, after checking it out */
  
  string = p->var_name->str;        /* the variable name */
  string_size = p->var_name->len;
/* it is assumed here that any IP address returned will be in standard
   notation (ie: a 32 bit quantity) and not in dot notation */
  if(*string == '_')
    {  if(( struct_string = sgmp_var_cvt(p->var_name,CVTIPADD)) == NULL)
	 {fprintf(stderr,"SGMPASK :: sgmp_var_cvt : Error while converting the variable name");
            exit(1);
	}
  string = struct_string->str;
	}
  else
    {if(( struct_string = sgmp_var_cvt(p->var_name,NUMTOSYM)) == NULL)
	 {fprintf(stderr,"SGMPASK :: sgmp_var_cvt : Error while converting the variable name");
            exit(1);
	}
      string = struct_string->str;
      }
 
 if((fv = find_entry(smpask_file_var,*smpask_count,string)) == NULL)
   { fprintf(stderr,"SGMPASK :: Received response for a variable not requested :: %s\n",string);
 p = p->var_next;                   /* the next variable in the list */
     continue;                         /* fetch the next variable */
   }
 sprintf((message + i),"%s\t",string); /* variable name */
  for( ;message[i] != '\t'; i++)       /* find the delimiter */
             ;
  i++;

  switch(p->var_value.type)
    {
    case  INTEGER:
         sprintf((message +i),"%d\n",(p->var_value.value.intgr));
            break;

       case PRIM_STR:
          sprintf((message +i),"%s\n",p->var_value.value.str->str);
            break;

    }          
 p = p->var_next;                      /* the next variable in the list */
 /* the message is constructed, open the appropriate log */
 if((fp = fopen(fv->file_name,"a")) == NULL)
    fprintf(stderr,"SGMPASK :: Cannot open %s\n",fv->file_name);

 else
 { fprintf(fp,"%s",message);    /* log in the message */
   fclose(fp);                  /* close the file pointer */
   var_index++;                 /* next variable in the config file */

  }
 }      
}
 

interrupt_handler()
{
 signal(SIGALRM,interrupt_handler);
 longjmp(sjbuf,-1);
}
