/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/
/**********************************************************************
**
**                            tbl_util.c
**
**  This contains functions to manupilate the the database(currently flat
** files) of SGMPASK daemon.
**
************************************************************************/

#include "sgmp.h"               /* general include file */
#include "sgmpask.h"            /* application specific file */

/* new_table - sorts the data variable wise, size being given in 'size'*/

new_table(size,data)
int size;                       /* size of the table */
struct file_var **data;         /* data to be put in */

{ int i,j;                      /* counters */
  struct file_var temp;          /* temporary buffer */

  /*allocate memory space */
  if((temp.variable_name = (char *)malloc(128 * sizeof(char))) == NULL)
  { fprintf(stderr,"new_table: cannot allocate space for var. name\n");
    return(-1);
  }
   if((temp.file_name = (char *)malloc(128 * sizeof(char))) == NULL)
 { fprintf(stderr,"new_table : cannot allocate space for file name \n");
    return(-1);
 } 

 /* sort the data and fill in the table - bubble sort */
  for(i = 0; i < size - 1; i++)
   for(j = size - 1; j > i;j--)
    if(strcmp((*data)[j].variable_name,(*data)[j-1].variable_name) < 0) 
 {   strcpy(temp.variable_name, (*data)[j-1].variable_name);             
     strcpy(temp.file_name, (*data)[j-1].file_name);    
     strcpy((*data)[j-1].variable_name,"");             /*clear */
     strcpy((*data)[j-1].file_name,"");                 /* clear */
     strcpy((*data)[j-1].variable_name,(*data)[j].variable_name);
     strcpy((*data)[j-1].file_name,(*data)[j].file_name);
     strcpy((*data)[j].variable_name,"");                /* clear */
     strcpy((*data)[j].file_name,"");                    /* clear */
     strcpy((*data)[j].variable_name,temp.variable_name); 
     strcpy((*data)[j].file_name,temp.file_name);       
     strcpy(temp.variable_name,"");                     /* clear */    
     strcpy(temp.file_name,"");                         /* clear */
  }

 /* free allocated memory space */
 free(temp.variable_name);
 free(temp.file_name);
 return(0);
 }

 /* find entry - find an entry in the table given a variable name */
 struct file_var *
 find_entry(tab,size,string)
 struct file_var **tab;
 int size;
 char *string;

{ int index;                  /* index into the table */
  int upper,lower;            /* the current upper and lower bounds */
/* check for special case of first element */
  if(strncmp((*tab)[0].variable_name,string,strlen((*tab)[0].variable_name)) == 0)     /* if same */
     return(*tab);
/* initialize the search */
  lower = 0;                  /* beginning of table */
  upper = size;               /* end of table */
  do{
    index = (lower + upper)/2;
  if(strncmp((*tab)[index].variable_name,string,strlen((*tab)[index].variable_name)) == 0)     /* if same */
     return(&(*tab)[index]);    /* return the pointer to the structure */
  if(strncmp((*tab)[index].variable_name,string,strlen((*tab)[index].variable_name)) >  0)     
   upper = index;
 else
    lower = index;
  }while (upper > (lower+1));
  return((struct file_var *)NULL);
}
    
