/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/
/***********************************************************************
**                       
**                       table_util.c
**
**      This file contains the various functions to enter and read
** data from the table. For the present a link list  is used . Each
** node in the list is a structure identified by it's request id
** field.
**      The type of table management is expected to change in the
** future revisions of the library.
**
***********************************************************************/

# include "sgmp.h"

typedef struct sockaddr_in remote_data;
static remote_data;
typedef remote_data *fpointer;
typedef struct table_node
            {  int req_id;                   /* the request id */
               int sock ;                    /* the socket file descriptor */
               int local_port ;              /* the local port number */
               fpointer fhost;               /* remote host information */
               struct table_node *next_node; /* pointer to next node */
	     };

static struct table_node *p;                  /* pointer to linked list */


/************************************************************************
**        
**                    sgmp_fill_verify_data()
**
**     This function fills or verifies the request id. In case of the former
** the remote host peer structure (sockaddr_in is also filled in .
**
************************************************************************/
sgmp_fill_verify_data(request_id,fdata,flag) /* fills in the peer structure */
int request_id;
struct sockaddr_in *fdata;
int flag;

{
struct table_node *temp;            /* a temporary pointer to a node */

   switch(flag)                     /* check what needs to be done */
{
 case REQ_ANY:                      /* the req_id is non-existent */


 if (request_id == REQ_ANY) 
   {                                /* is table already filled in ? */
    if(p != NULL)                   /* if yes, do nothing */
     return(0);
  }
 
 if(p == NULL)                      /* need to allocate memory if true */
  {
  if ((p = (struct table_node *)malloc(sizeof(struct table_node))) == NULL)
   { fprintf(stderr,"Could not allocate memory in table_util.c,exiting...\n");
      exit(1);
   }     
   temp = p;                      
  }
 else/*it is a NEW_ID in case of a client, already filled in case of server */
        
     { temp= p;
 /* first search for the id, if not there fill it in  (in case of client)*/
 /* in case of the server (the gateway) it is filled in after receiveng the
    message */

      for(;;)                                     /* search the list */
	 {  if(temp->req_id != request_id)
	      {if(temp->next_node == NULL)
		goto create;            /* request id not known,create node */
                  temp = temp->next_node;                 
                   continue;           /* the next node on the list*/ 
	     }
         else
	   {
               /* fill in the remote host data */
 if((temp->fhost = (struct sockaddr_in *)malloc(sizeof(struct sockaddr_in))) == NULL)
    { fprintf("Could not allocate memory in table_util,exiting ...\n");
             exit(0);
    }
    bcopy(fdata,temp->fhost,sizeof(*fdata));
               return(0);
        }
	  }

create: temp = p;
       while(temp->next_node != NULL) /* get to the end of the list */
        temp = temp->next_node;

   /* allocate memory for the next structure */ 
   if((temp->next_node = (struct table_node *)malloc(sizeof(struct table_node))) == NULL)
   { fprintf(stderr,"Could not allocate memory in table_util.c,exiting...\n");
      exit(1);
   }    
   temp =  temp->next_node;
  /* Now fill in the req_id and and the remote host data */

    temp->req_id = request_id;               /* the request id */
                                             /* fill in the remote host data */
 if((temp->fhost = (struct sockaddr_in *)malloc(sizeof(struct sockaddr_in))) == NULL)
    { fprintf("Could not allocate memory in table_util,exiting ...\n");
             exit(0);
    }
    bcopy(fdata,temp->fhost,sizeof(*fdata));
    temp->next_node = NULL;    
       break;
     }

 case VERIFY_ID:                             /* check for id in table */
     if(p == NULL)
      return(REQID_UNKNOWN);
      temp = p;
      for(;;)                                     /* search the list */
	 {  if(temp->req_id != request_id)
	      {if(temp->next_node == NULL)
		 return(REQID_UNKNOWN);     /* request id not known :-(*/
                  temp = temp->next_node;                 
                   continue;                /* the next node on the list*/ 
	     }

              else                           /* request id found :-)*/
                return(0);
	  }
    }
}


/***********************************************************************
**
**                   sgmp_fill_sd_lport()
**
**    This function fills in the socket file descriptor as well as the
** local port on which communication is taking place for the provide
** request id.
**
***********************************************************************/

sgmp_fill_sd_lport(request_id,socket,lport)
int request_id;
int socket;
int lport;

{
 struct table_node *temp;


 if(p == NULL)                   /* need to allocate memory if true */
{  if ((p = ( struct table_node *)malloc(sizeof(struct table_node))) == NULL)
   { fprintf(stderr,"Could not allocate memory in table_util.c,exiting...\n");
      exit(1);
   }     
/* initialize */
 p->req_id = request_id;
 p->sock = socket;
 p->local_port = lport;
 p->fhost = NULL;
 p->next_node =  NULL;
 return(0);
 }
 temp = p;                                        /* the first member */

 /* first, check if the request id is already listed */

      for(;;)                                     /* search the list */
	 {  if(temp->req_id != request_id)
	      {if(temp->next_node == NULL)       /*Ok, request id unlisted*/
		 {  /* allocate memory for the next structure */  
   if((temp->next_node = (struct table_node *)malloc(sizeof(struct table_node))) == NULL)
   { fprintf(stderr,"Could not allocate memory in table_util.c,exiting...\n");
      exit(1);
   }                   
    /* Now list the request id,local port and the socket file descriptor */
      temp = temp->next_node;
      temp->req_id = request_id;               /* the request id */
      temp->sock   = socket;                   /* socket file descriptor */
      temp->local_port = lport;                /* the local port number */
      temp->fhost = NULL;
      return(0);                               /* the data is filled in*/    

                 }

          else                                 /* get the next node */
              temp = temp->next_node;                 
              continue;                       /* the next one on the list*/
	     }
	  
                                              /* request id exists */
         temp->sock = socket;                 /* fill in the socket */
         temp->local_port;                    /* the local port number */
        return(0);                            /* data filled in */
	  }

}



/****************************************************************************
**
**                        sgmp_get_sock()
**
**      This function is called by term_sgmp_comm. It returns the socket
** which needs to be closed, after looking up into the table.
**
***************************************************************************/

sgmp_get_sock(request_id)
int request_id;

{
struct table_node *temp;                 /* a temporary pointer */

temp = p;

/* start searching the list for the given request id */

for(;;)
  { if(temp->req_id != request_id)
      {
       if(temp->next_node == NULL)
          return(REQID_UNKNOWN);
       temp = temp->next_node;           /* get the next node */
      continue;
     }

  return(temp->sock);                   /* return the socket */
  }
}






/****************************************************************************
**
**                        sgmp_get_fport()
**
**      This function is used to for retrieving the remote port.
**
***************************************************************************/


sgmp_get_fport(request_id)
int request_id;

{
struct table_node *temp;                 /* a temporary pointer */

temp = p;

/* start searching the list for the given request id */

for(;;)
  { if(temp->req_id != request_id)
      {
       if(temp->next_node == NULL)
          return(REQID_UNKNOWN);
       temp = temp->next_node;           /* get the next node */
      continue;
     }

  return(temp->fhost->sin_port);         /* return the remote port */
  }
}
