%{
/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/
#include "sgmp.h"
#include "sgmpask.h"
int var_file_flag; /*distinguishes between a variable and a file name */
extern int line_count;/* To keep track of the line no. being parsed */
extern int default_freq, default_interval;
line_count = 1; /* initialization */
print_warning1 = 0,print_warning2 = 0;/*check the printing of warning message */
%} 
%start options
%token GATEWAY NET_NUMB NTIMES INTERVAL LOG LOG_NAME FOREVER ERROR
%token VARIABLE NLINE ONCE SESSION SESSION_NAME

%% /* the rules section */

options		:	options option_types NLINE
			{if((!default_freq) && (!print_warning1)) {
                 how_many_times = (int *)malloc(sizeof(int));
                         *how_many_times = 0;
printf("*** SGMPASK : Warning :: Gateway will be queried FOREVER ***\n");
                          print_warning1 = 1; }
			if((!default_interval) && (!print_warning2)) {
                  interval = (int *)malloc(sizeof(int));
                   *interval = 1;
printf("*** SGMPASK : Warning :: The query interval is set to 1 second ***\n");
                          print_warning2 = 1; }
        }

	        |       options NLINE
			{line_count++;}
                |
		;

option_types	:	option1
		|	option2
                |       option3
		;

option1		:	default/* FOREVER is assumed and INTERVAL=1sec*/
		|	default ONCE 
		|	default NTIMES INTERVAL
		|	default FOREVER INTERVAL
                ;

option2		:	LOG
			   { var_file_flag = 1; }/* get file name */
			 LOG_NAME
			 { 
			  var_file_flag = 0; }/* get variable name */
         		 VARIABLE
		;

option3         :      SESSION SESSION_NAME

default		:	 gate NET_NUMB
		;       

gate		:	GATEWAY
		;
%%
yyerror(){
	
extern int line_count;
extern char yytext[];

fprintf(stderr,"\nSGMPASK CONFIGURATION : Error at line %d :: ' %s '\n",line_count,yytext);
 exit(1);
 }
