
%{

/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/
/******************************************************************
 *   This parses the configuration file for the SMPASK application.The
 *  parser stops if more than one 'GATEWAY' option is given
 *  in a configuration file. 
 *   The number of times the network is to be queried is returned in 
 * '*how_many_times',which is assigned the values 0 and 1 for the FOREVER
 * option and ONCE option respectively. The defalut value is FOREVER.
 * The intervals between each query is returned in '*interval'.
 * The default value of the this is 1 sec. The variable
 * '*smpask_net_number' contains the net number in 4 bytes.
 *    The following structure returns pointers to the filename and
 * the variable that need to be recorded in that file.
 *
                     struct file_var{
     				char *file_name;
				char *variable_name;
				};
 * The number of variables requested in a configuration file is
 * kept in the variable *smpask_count;
 ******************************************************************/

#include "sgmp.h"
#include "sgmpask.h"
#include "y.tab.h"

extern int var_file_flag;
long *how_many_times;      /* determines the number of times the NW is
	       		     * to be queried.
			     * The FOREVER option value is the default.
			     */
int *interval;             /* Interval between each query
			    * default is 1 sec
			    */
int *smpask_net_number;    /* the net number */
int *smpask_count ;        /* Keep count of the number of variables */
char *s_id;                /* The session id */
struct file_var **smpask_file_var; /* pointer where the data will be stored */

/*switches to test wether allocation of memory has been done */
static int malloc_smpask_file_var = 0; 
static int malloc_how_many_times = 0;
static int malloc_interval = 0;
static int malloc_smpask_count = 0;

 int gateway = 0; /* Keeps track of the number of GATEWAY options */ 
 int gadd = 0;	/* expecting gateway address immediately? */
 int default_freq = 0;/* Flag to set default frequency of 'FOREVER'*/
 int default_interval = 0;/* Flag to set default interval of 1 sec */
 int net_numb_flag = 0;/*flag to test the presence of a net number */
 static int session_flag = 0; /* flag to test if session is specified */
 void get_numb();
%}
%%
^#(.)*		{ /* Do nothing, it is a comment */ }

#(.)		{fprintf(stderr,"***** Wrong usage of comment indicator '#' *****\n");

			return(ERROR); }

SESSION      {         /* session name */
                 session_flag = 1;
       
              return(SESSION);

                }

GATEWAY		{
			gateway++;
			gadd=1;
			if (gateway == 1)
			return(GATEWAY);
			else{
	fprintf(stderr,"***** Attempt to set GATEWAY option twice *****\n");
			gadd=0;
			return(ERROR);
		}
	}

LOG		{
			return(LOG);
			}

ONCE|once		{
        if(!malloc_how_many_times){ /*if no memory allocated, do it */
            if((how_many_times = (long *)malloc(sizeof(long))) == NULL){
          fprintf(stderr,"Error in malloc, in config. file parser");
            exit(1);
          }
        malloc_how_many_times = 1; /* set the flag */
          }
			default_freq = 1; /*Set flag*/
			default_interval = 1; /*set flag*/
			*how_many_times = 1;
			return(ONCE);
		}

[0-9]+TIMES|[0-9]+times	{
        if(!malloc_how_many_times){ /*if no memory allocated, do it */
            if((how_many_times = (long *)malloc(sizeof(long))) == NULL){
          fprintf(stderr,"SGMPASK :: Error in malloc, in config. file parser\n");
            exit(1);
          }
        malloc_how_many_times = 1; /* set the flag */
          }
		  *how_many_times = get_frequency();/*how often the NW is
						     * to be queried */
			default_freq = 1; /*Set Flag*/
  			return(NTIMES);

			}

FOREVER|forever		{
        if(!malloc_how_many_times){ /*if no memory allocated, do it */
            if((how_many_times = (long *)malloc(sizeof(long))) == NULL){
          fprintf(stderr,"Error in malloc, in config.  parser\n");
            exit(1);
          }
        malloc_how_many_times = 1; /* set the flag */
          }
			*how_many_times = 0; /* a zero indicates  FOREVER */
			default_freq = 1; /*set flag*/
			return(FOREVER);
			}

[\n]		{
			return(NLINE);
		   	}
[0-9]?[0-9][0-9]"."([0-9]?[0-9])?[0-9]"."([0-9]?[0-9])?[0-9]"."([0-9]?[0-9])?[0-9]  {

	if(!gateway){
    fprintf("***** Attempt to set Gateway Number without specifying option *****\n");
		    
	 return(ERROR);
      }	
	if(!gadd) {
    fprintf("**** Not expecting gateway address *************************\n");
	 return(ERROR);
      }
         smpask_net_number = (int *)malloc(sizeof(int));
         *smpask_net_number = 0; /*initialize */
	 get_numb(smpask_net_number);/* routine to get number and store it*/
	    net_numb_flag = 1;/* indicates net number has been given*/
	gadd=0;			/* not expecting gateway address anymore */
		    return(NET_NUMB);
 		}

[0-9]+"."?[0-9]+?"."?[0-9]+?"."?[0-9]+? {
	if(!gateway){
fprintf(stderr,"***** Check syntax of Gateway number and specify option *****\n");
        gadd=0;

               return (ERROR);
  }
     else if(!net_numb_flag){
  fprintf(stderr,"***** Check syntax of Gateway number[XXX.XXX.XXX.XXX] *****\n");
		return(ERROR);
  }

           else {
 if(!malloc_interval){ /* if memory has not been allocated, do it ! */
   if((interval = (int *)malloc(sizeof(int))) == NULL) {
      fprintf(stderr,"Error in malloc,in config parser \n");
     exit(1);
      }
    malloc_interval = 1; /* set the flag */
   }
		*interval = atoi(yytext);
		default_interval = 1;/*set flag*/
		return(INTERVAL);
		}

   }
[/_A-Za-z][A-Za-z0-9_./]*   {
       if(session_flag == 1)   /* it is a session name */
        {       s_id = (char *)malloc(sizeof(char *) * MAX_SID_LEN);
                s_id = strcpy(s_id,yytext);
              session_flag = 0;    /* reset the flag */
                return(SESSION_NAME);
         }
	if(gadd == 1)
	{
         smpask_net_number = (int *)malloc(sizeof(int));
         *smpask_net_number = 0; /*initialize */
	 get_numb(smpask_net_number);
 	if(*smpask_net_number == -1)
	{ gadd=0; return(ERROR); }
	    net_numb_flag = 1;/* indicates net number has been given*/
	gadd=0;			/* not expecting gateway address anymore */
		    return(NET_NUMB);
	}
      
	  switch(var_file_flag){

		case 0 : /* It is a variable*/
	if(!gateway){
    fprintf(stderr,"***** Improper Syntax *****\n");
	 return(ERROR);
      }	
  (*smpask_file_var)[*smpask_count].variable_name = (char*)malloc(MAX_VAR_SIZE);
		strcpy((*smpask_file_var)[(*smpask_count)++].variable_name,yytext);
				return(VARIABLE);

		case 1 : /* It is a file name */

  if(!malloc_smpask_file_var){         /*allocate memory if not done */
 smpask_file_var = (struct file_var **)malloc(sizeof(struct file_var *));    
if((*smpask_file_var = (struct file_var *)malloc(sizeof(struct file_var)*MAX_VAR)) == NULL){
  fprintf(stderr,"Error in malloc,in SGMPASK config file parser\n");
   exit(1);
    }
      malloc_smpask_file_var = 1; /*set the flag,memory allocation done! */
  }

if(!malloc_smpask_count) { /*allocate memory to smpask_count,if needed*/
 smpask_count = (int *)malloc(MAX_VAR);
   malloc_smpask_count = 1; /* set the flag */
  }

(*smpask_file_var)[*smpask_count].file_name = (char*)malloc(MAX_NAME_SIZE);
		strcpy((*smpask_file_var)[*smpask_count].file_name,yytext);
				return(LOG_NAME);
        }
       }

[a-z;!@#$%&*+?<>,.:-]+	{
  fprintf(stderr,"***** Illegal File/Variable name *****\n");
      return(ERROR);
    }
%% /* The program section */

int get_frequency() { /* returns the interval at which the
		       * gateway is to be queried        */

int i;
char number[15];/* temporary buffer */

    for(i = 0;isdigit(yytext[i]);i++)
      number[i] = yytext[i];
      number[++i] = '\0';/* Indicate end of string */
      return(atoi(number));
  }


 void get_numb(smpask_net_number)
  int *smpask_net_number;
 {

 /* this segment of the program returns the network number
		       concatenated to form a 32 bit integer */
  int count = 0 ;       /* Keeps track of the total length of of the string */
  int count_temp = 0;
  int numb_char;
  char *temp1,temp2[2]; /* temporary buffer to handle strings */
    temp2[1] = '\0';     /* end the string with '\0' */
  temp1 = (char*)malloc(sizeof(char) * 4);  
 if (!isalpha(yytext[0])) {	/* if an address was given.. */
     while(count < yyleng){

 for(numb_char = 0; (yytext[count] != '.') && (count <= yyleng - 1) ;  count++ ) {
      temp2[0] = yytext[count];
      strcat(temp1,temp2);
  }

*smpask_net_number = (*smpask_net_number << 8) | atoi(temp1);

    count++; /*skip the dot*/
    strcpy(temp1,"");  /* clear the buffer to fetch the next byte */
  }
  }			/* end if an address was given.. */
 else {
   char hostname[128];
   struct hostent *hp;
   strncpy(hostname,yytext,yyleng);
   hostname[yyleng] = '\0';
   if((hp = gethostbyname(hostname)) == NULL)
    { fprintf(stderr,"********Couldn't get address for %s*********\n",hostname);
	*smpask_net_number = -1;
	return;
    }
   else
    bcopy(hp->h_addr,(char *)smpask_net_number,hp->h_length);
  }
 }
